#! /usr/bin/ruby
# -*- coding: euc-jp -*-

# Ʊž׻襹ץ
# == 
# * ΥץȤƱž¸η̤οޤΤǤ.
# * ΥץȤǤ, gpview, fig_heatflux-lat-dependence.rb ʤɤ
#   ץȤȤ.
# * Ѥˤ, fig_heatflux-lat-dependence.rb ʤɤǼ
#   ǥ쥯ȥꤹɬפ.
#   Τ, script_dir Ŭ񤭴ͤФʤʤ.
#
# == ץ
# --time_start ϻ
# --time_end   λ
# --wsn        . ps ä --wsn=2
# --prefix     եդƬ
#
# == USAGE
#   % fig_SyncRot.rb --saturation_scheme=nha --time_start=731 --time_end=1095 --wsn=2 --prefix=EXPNAME_
#
# == 
# * 2013-6-19  


require "getoptlong"        # for option_parse
require "numru/ggraph"
include NumRu

script_dir = "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script"

## ץ
parser = GetoptLong.new
parser.set_options(
   ###    global option   ###
   ['--saturation_scheme',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--time_start',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--time_end',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--range_stream',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--cint_stream',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--range_q',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--cint_q',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--wsn',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--prefix',                      GetoptLong::REQUIRED_ARGUMENT]
                   )
parser.each_option do |name, arg|
    eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

saturation_scheme = ($OPT_saturation_scheme||nha)

## Ʊž
minval_u = -70
maxval_u = 110
cint_u = 15
minval_v = -50
maxval_v = 50
cint_v = 10
#minval_q = 1e-19
#maxval_q = 1e-1
#cint_q = 5e-3


# Gray_MCA 
#minval_u = -10
#maxval_u = 40
#cint_u = 5
#minval_v = -20
#maxval_v = 20
#cint_v = 2
#minval_q = 1e-19
#maxval_q = 2e-2
#cint_q = 5e-4

wsn = ($OPT_wsn||1)

range_stream = ($OPT_range_stream||'-9e10:9e10')
minval_stream = range_stream.split(':')[0].to_f
maxval_stream = range_stream.split(':')[1].to_f
cint_stream = ($OPT_cint_stream||1.5e10).to_f

range_q = ($OPT_range_q||'1e-19:1e-1')
minval_q = range_q.split(':')[0].to_f
maxval_q = range_q.split(':')[1].to_f
cint_q = ($OPT_cint_q||5e-3).to_f

 
time_start = ($OPT_time_start||1).to_s
time_end = ($OPT_time_end||9999).to_s

timespan = time_start + ':' + time_end

# dennou-h ǥ꤬­ʤʤ, Ǹ 300 ˤ.

#p time_end.class

value_time_start_newdata = time_end.to_i - 299
time_start_newdata = value_time_start_newdata.to_s


if File.exist?($OPT_prefix + 'SurfTemp_lonmean-timeseries_Ecolor.png') then
  puts("MESSAGE: #{$OPT_prefix}SurfTemp_lonmean-timeseries_Ecolor.png exists. process skipped.")
else
  system("gpview SurfTemp.nc@SurfTemp,time=#{timespan} --mean lon --levels 999,210,220,230,240,250,260,270,280,290,300,999 --pattern 23999,30999,40999,45999,47999,50999,60999,70999,75999,80999,95999 --exch --wsn=#{wsn} --noannotate --nocont && #{script_dir}/conv_image.rb #{$OPT_prefix}SurfTemp_lonmean-timeseries_Ecolor.png")
end

# Ψ ϥѹƽϤΤΤϤ.
#system("{script_dir}/fig_CoolRate.rb --time_start=#{time_start} --time_end=#{time_end} --wsn=#{wsn} --prefix=#{$OPT_prefix}")

# м
if File.exist?('RelHumid.nc') then
  puts("MESSAGE: RelHumid.nc exists. process skipped.")
else
  system("#{script_dir}/make_RH_v2.rb --saturation_scheme=#{saturation_scheme} --time_start=#{time_start} --time_end=#{time_end}") unless File.exist?('RelHumid.nc')
end
if File.exist?("#{$OPT_prefix}RelHumid_mean0-360.png") then
  puts("MESSAGE: #{$OPT_prefix}RelHumid_mean0-360.png exists. process skipped.")
else
  if File.exist?("RelHumid.nc") then
    system("gpview RelHumid.nc@RelHumid,sig=1.0:0.0,time=#{timespan} --mean lon,time --wsn=#{wsn} --noannotate --range=0:1.0 && #{script_dir}/conv_image.rb #{$OPT_prefix}RelHumid_mean0-360.png") 
  end
end

if File.exist?($OPT_prefix + 'SurfTemp_lonmean-timeseries.png') then
  puts("MESSAGE: #{$OPT_prefix}SurfTemp_lonmean-timeseries.png exists. process skipped.")
else
  system("gpview SurfTemp.nc@SurfTemp,time=0:#{time_end}:3 --mean lon --range=190:350 --cint=20 --exch --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb  #{$OPT_prefix}SurfTemp_lonmean-timeseries.png")
end

if File.exist?($OPT_prefix + 'OLRA_lonmean-timeseries.png') then
  puts("MESSAGE: #{$OPT_prefix}OLRA_lonmean-timeseries.png exists. process skipped.")
else
  system("gpview OLRA.nc@OLRA,time=0:#{time_end}:3 --mean lon --range=50:400 --cint=20 --nocont --exch --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb  #{$OPT_prefix}OLRA_lonmean-timeseries.png")
end

if File.exist?($OPT_prefix + 'OSRA_lonmean-timeseries.png') then
  puts("MESSAGE: #{$OPT_prefix}OSRA_lonmean-timeseries.png exists. process skipped.")
else
  system("gpview OSRA.nc@OSRA,time=0:#{time_end}:3 --mean lon --range=0:1200 --cint=60 --exch --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}OSRA_lonmean-timeseries.png")
end

#  ʿ
if File.exist?("#{$OPT_prefix}Temp_mean0-360_itr1.png") then
  puts("MESSAGE: #{$OPT_prefix}Temp_mean0-360_itr1.png exists. process skipped.")
else
  system("gpview Temp.nc@Temp,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=1 --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_mean0-360_itr1.png")
end

if File.exist?("#{$OPT_prefix}Temp_mean0-360_itr1_Ecolor.png") then
  puts("MESSAGE: #{$OPT_prefix}Temp_mean0-360_itr1_Ecolor.png exists. process skipped.")
else
  system("gpview Temp.nc@Temp,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=1 --noannotate --levels 999,170,180,190,200,210,220,230,240,250,260,270,280,290,300,999 --pattern 10999,15999,20999,23999,26999,30999,40999,45999,50999,60999,70999,75999,80999,90999,95999 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_mean0-360_itr1_Ecolor.png")
end

if File.exist?("#{$OPT_prefix}Temp_mean0-360_itr2.png") then
  puts("MESSAGE: #{$OPT_prefix}Temp_mean0-360_itr2.png exists. process skipped.")
else
  system("gpview Temp.nc@Temp,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_mean0-360_itr2.png")
end

if File.exist?("#{$OPT_prefix}Temp_mean0-360_itr2_Ecolor.png") then
  puts("MESSAGE: #{$OPT_prefix}Temp_mean0-360_itr2_Ecolor.png exists. process skipped.")
else
  system("gpview Temp.nc@Temp,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --levels 999,170,180,190,200,210,220,230,240,250,260,270,280,290,300,999 --pattern 10999,15999,20999,23999,26999,30999,40999,45999,50999,60999,70999,75999,80999,90999,95999 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_mean0-360_itr2_Ecolor.png")
end

#  ʿ
if File.exist?("#{$OPT_prefix}U_mean0-360_itr1.png") then
  puts("MESSAGE: #{$OPT_prefix}U_mean0-360_itr1.png exists. process skipped.")
else
  system("gpview U.nc@U,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=1 --noannotate --cint=#{cint_u} --range=#{minval_u}:#{maxval_u} && #{script_dir}/conv_image.rb #{$OPT_prefix}U_mean0-360_itr1.png")
end

if File.exist?("#{$OPT_prefix}U_mean0-360_itr1_Ecolor.png") then
  puts("MESSAGE: #{$OPT_prefix}U_mean0-360_itr1_Ecolor.png exists. process skipped.")
else
  system("#{script_dir}/gpview_xy U.nc@U,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=1 --noannotate --clrmap 14 --sint 5 --cint 5 --range=-50:50 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_mean0-360_itr1_Ecolor.png")
end

if File.exist?("#{$OPT_prefix}U_mean0-360_itr2.png") then
  puts("MESSAGE: #{$OPT_prefix}U_mean0-360_itr2.png exists. process skipped.")
else
  system("gpview U.nc@U,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --cint=#{cint_u} --range=#{minval_u}:#{maxval_u} && #{script_dir}/conv_image.rb #{$OPT_prefix}U_mean0-360_itr2.png")
end

if File.exist?("#{$OPT_prefix}U_mean0-360_itr2_Ecolor.png") then
  puts("MESSAGE: #{$OPT_prefix}U_mean0-360_itr2_Ecolor.png exists. process skipped.")
else
  system("#{script_dir}/gpview_xy U.nc@U,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate  --clrmap 14 --sint 5 --cint 5 --range=-50:50 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_mean0-360_itr2_Ecolor.png")
end



#  ʿ
if File.exist?("#{$OPT_prefix}V_mean0-360_itr1.png") then
  puts("MESSAGE: #{$OPT_prefix}V_mean0-360_itr1.png exists. process skipped.")
else
  system("gpview V.nc@V,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=1 --noannotate --sint=#{cint_v} --range=#{minval_v}:#{maxval_v} && #{script_dir}/conv_image.rb #{$OPT_prefix}V_mean0-360_itr1.png")
end

if File.exist?("#{$OPT_prefix}V_mean0-360_itr1_Ecolor.png") then
  puts("MESSAGE: #{$OPT_prefix}V_mean0-360_itr1_Ecolor.png exists. process skipped.")
else
  system("#{script_dir}/gpview_xy V.nc@V,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=1 --noannotate --clrmap 14 --sint 0.5 --cint 0.55 --range=-5:5 && #{script_dir}/conv_image.rb #{$OPT_prefix}V_mean0-360_itr1_Ecolor.png")
end

if File.exist?("#{$OPT_prefix}V_mean0-360_itr2.png") then
  puts("MESSAGE: #{$OPT_prefix}V_mean0-360_itr2.png exists. process skipped.")
else
  system("gpview V.nc@V,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --clrmap 14 --sint=#{cint_v} --range=#{minval_v}:#{maxval_v} && #{script_dir}/conv_image.rb #{$OPT_prefix}V_mean0-360_itr2.png")
end

if File.exist?("#{$OPT_prefix}V_mean0-360_itr2_Ecolor.png") then
  puts("MESSAGE: #{$OPT_prefix}V_mean0-360_itr2_Ecolor.png exists. process skipped.")
else
  system("gpview V.nc@V,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --clrmap 14 --sint=#{cint_v} --range=#{minval_v}:#{maxval_v} && #{script_dir}/conv_image.rb #{$OPT_prefix}V_mean0-360_itr2_Ecolor.png")
end


# 徺ή, ʿ
if File.exist?("#{$OPT_prefix}SigDot_mean0-360_itr1.png") then
  puts("MESSAGE: #{$OPT_prefix}SigDot_mean0-360_itr1.png exists. process skipped.")
else
  system("gpview SigDot.nc@SigDot,time=#{timespan},sigm=1:0.0118 --mean lon,time --wsn=#{wsn} --itr=1 --noannotate --range=-2e-6:2e-6 --cint=1e-7 --clrmap 14 && #{script_dir}/conv_image.rb #{$OPT_prefix}SigDot_mean0-360_itr1.png")
end

if File.exist?("#{$OPT_prefix}SigDot_mean0-360_itr2.png") then
  puts("MESSAGE: #{$OPT_prefix}SigDot_mean0-360_itr2.png exists. process skipped.")
else
  system("gpview SigDot.nc@SigDot,time=#{timespan},sigm=1:0.0118 --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --clrmap 14 --range=-2e-6:2e-6 && #{script_dir}/conv_image.rb #{$OPT_prefix}SigDot_mean0-360_itr2.png")
end


# 漾, ʿ 
if File.exist?("#{$OPT_prefix}QVap_mean0-360_itr1.png") then
  puts("MESSAGE: #{$OPT_prefix}QVap_mean0-360_itr1.png exists. process skipped.")
else
  system("gpview QVap.nc@QVap,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=1 --noannotate --cint=#{cint_q} --range=#{minval_q}:#{maxval_q} && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_mean0-360_itr1.png")
end

if File.exist?("#{$OPT_prefix}QVap_mean0-360_itr1_Ecolor.png") then
  puts("MESSAGE: #{$OPT_prefix}QVap_mean0-360_itr1_Ecolor.png exists. process skipped.")
else
  system("gpview QVap.nc@QVap,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=1 --noannotate --levels 999,1e-4,0.002,0.004,0.006,0.008,0.01,0.012,0.014,0.016,0.018,0.02,999 --pattern 99999,10999,20999,32999,45999,50999,55999,60999,70999,80999,88999,95999 && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_mean0-360_itr1_Ecolor.png")
end


if File.exist?("#{$OPT_prefix}QVap_mean0-360_itr2.png") then
  puts("MESSAGE: #{$OPT_prefix}QVap_mean0-360_itr2.png exists. process skipped.")
else
  system("gpview QVap.nc@QVap,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --cint=#{cint_q} --range=#{minval_q}:#{maxval_q} & #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_mean0-360_itr2.png")
end

if File.exist?("#{$OPT_prefix}QVap_mean0-360_itr2_Ecolor.png") then
  puts("MESSAGE: #{$OPT_prefix}QVap_mean0-360_itr2_Ecolor.png exists. process skipped.")
else
  system("gpview QVap.nc@QVap,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --levels 999,1e-4,0.002,0.004,0.006,0.008,0.01,0.012,0.014,0.016,0.018,0.02,999 --pattern 99999,10999,20999,32999,45999,50999,55999,60999,70999,80999,88999,95999 & #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_mean0-360_itr2_Ecolor.png")
end


# ʿʿѱľʬ

# This is bad!!!
# latmean is incorrect.


if File.exist?($OPT_prefix + 'Temp_lonmean-latmean.png') then
  puts("MESSAGE: #{$OPT_prefix}Temp_lonmean-latmean.png exists. process skipped.")
else
  system("#{script_dir}/fig_Temp-vertical.rb --time_start=#{time_start} --time_end=#{time_end} --range=140:320 --lon=mean --lat=mean --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_lonmean-latmean.png")
end

#if File.exist?($OPT_prefix + 'Temp_lonmean-latmean_Ecolor.png') then
#  puts("MESSAGE: #{$OPT_prefix}Temp_lonmean-latmean_Ecolor.png exists. process skipped.")
#else
#  system("#{script_dir}/fig_Temp-vertical.rb --time_start=#{time_start} --time_end=#{time_end} --levels 999,170,180,190,200,210,220,230,240,250,260,270,280,290,300,999 --pattern 10999,15999,20999,23999,26999,30999,40999,45999,50999,60999,70999,75999,80999,90999,95999 --lon=mean --lat=mean --wsn=#{wsn} && dclpsrot dcl.ps > #{$OPT_prefix}Temp_lonmean-latmean_Ecolor.ps && convert #{$OPT_prefix}Temp_lonmean-latmean_Ecolor.ps #{$OPT_prefix}Temp_lonmean-latmean_Ecolor.png")
#end



if File.exist?($OPT_prefix + 'QVap_lonmean-latmean.png') then
  puts("MESSAGE: #{$OPT_prefix}QVap_lonmean-latmean.png exists. process skipped.")
else
  system("#{script_dir}/fig_q-vertical.rb --time_start=#{time_start} --time_end=#{time_end} --range=1e-9:1e-2 --lon=mean --lat=mean --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_lonmean-latmean.png")
end

#if File.exist?($OPT_prefix + 'QVap_lonmean-latmean_Ecolor.png') then
#  puts("MESSAGE: #{$OPT_prefix}QVap_lonmean-latmean_Ecolor.png exists. process skipped.")
#else
#  system("#{script_dir}/fig_q-vertical.rb --time_start=#{time_start} --time_end=#{time_end} --levels 999,1e-4,0.002,0.004,0.006,0.008,0.01,0.012,0.014,0.016,0.018,0.02,999 --pattern 99999,10999,20999,32999,45999,50999,55999,60999,70999,80999,88999,95999 --lon=mean --lat=mean --wsn=#{wsn} && dclpsrot dcl.ps > #{$OPT_prefix}QVap_lonmean-latmean_Ecolor.ps && convert #{$OPT_prefix}QVap_lonmean-latmean_Ecolor.ps #{$OPT_prefix}QVap_lonmean-latmean_Ecolor.png")
#end


# ʿ, ʿ
if File.exist?($OPT_prefix + 'SurfTemp_lonmean-timemean.png') then
  puts("MESSAGE: #{$OPT_prefix}SurfTemp_lonmean-timemean.png exists. process skipped.")
else
  system("gpview SurfTemp.nc@SurfTemp,time=#{timespan} --mean lon,time --range=180:350 --noannotate --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}SurfTemp_lonmean-timemean.png")
end

if File.exist?($OPT_prefix + 'Ps_lonmean-timemean.png') then
  puts("MESSAGE: #{$OPT_prefix}Ps_lonmean-timemean.png exists. process skipped.")
else
  system("gpview Ps.nc@Ps,time=#{timespan} --mean lon,time --range=9e4:1.2e5 --noannotate --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}Ps_lonmean-timemean.png")
end


# ʿѻѲ
if File.exist?($OPT_prefix + 'QVap_lonmean-lat0-timeseries.png') then
  puts("MESSAGE: #{$OPT_prefix}QVap_lonmean-lat0-timeseries.png exists. process skipped.")
else
  system("gpview QVap.nc@QVap,time=0:#{time_end}:3,lat=0,sig=0.1:0 --mean lon --exch --range=1e-9:1e-5 --noannotate --wsn=#{wsn} && #{script_dir}/conv_image.rb  #{$OPT_prefix}QVap_lonmean-lat0-timeseries.png")
end

if File.exist?($OPT_prefix + 'QVap_lonmean-lat0-timeseries_Ecolor.png') then
  puts("MESSAGE: #{$OPT_prefix}QVap_lonmean-lat0-timeseries_Ecolor.png exists. process skipped.")
else
  system("gpview QVap.nc@QVap,time=0:#{time_end}:3,lat=0,sig=0.1:0 --mean lon --exch --levels 999,1e-4,0.002,0.004,0.006,0.008,0.01,0.012,0.014,0.016,0.018,0.02,999 --pattern 99999,10999,20999,32999,45999,50999,55999,60999,70999,80999,88999,95999 --noannotate --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_lonmean-lat0-timeseries_Ecolor.png")
end

if File.exist?($OPT_prefix + 'U_lonmean-lat0-timeseries.png') then
  puts("MESSAGE: #{$OPT_prefix}U_lonmean-lat0-timeseries.png exists. process skipped.")
else
  system("gpview U.nc@U,time=0:#{time_end}:3,lat=0,sig=0.1:0 --mean lon --exch  --nocont --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}U_lonmean-lat0-timeseries.png")
end

if File.exist?($OPT_prefix + 'Ps_lonmean-timeseries.png') then
  puts("MESSAGE: #{$OPT_prefix}Ps_lonmean-timeseries.png exists. process skipped.")
else
  system("gpview Ps.nc@Ps,time=0:#{time_end}:3 --mean lon --cint=1000 --range=0.9e5:1.05e5 --exch --wsn=#{wsn} --noannotate --nocont && #{script_dir}/conv_image.rb #{$OPT_prefix}Ps_lonmean-timeseries.png")
end

# ʿѻʿ
if File.exist?($OPT_prefix + 'Rain_lonmean-timeseries.png') then
  puts("MESSAGE: #{$OPT_prefix}Rain_lonmean-timeseries.png exists. process skipped.")
else
  system("gpview Rain.nc@Rain,time=0:#{time_end}:3 --mean lon --range=0:1e-3 --levels=1e-10,1e-9,1e-8,1e-7,1e-6,1e-5,1e-4.1e-3 --nocont --exch --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}Rain_lonmean-timeseries.png")
end

if File.exist?("#{$OPT_prefix}PRCP_lonmean-timeseries.png") then
  puts("MESSAGE: #{$OPT_prefix}PRCP_lonmean-timeseries.png exists. process skipped.")
else
  system("gpview PRCP.nc@PRCP,time=0:#{time_end}:3 --mean lon --range=0:1e-4 --nocont --exch --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}PRCP_lonmean-timeseries.png")
end

if File.exist?("#{$OPT_prefix}SurfH2OVapFluxU_lonmean-timeseries.png") then
  puts("MESSAGE: #{$OPT_prefix}SurfH2OVapFluxU_lonmean-timeseries.png exists. process skipped.")
else
  system("gpview SurfH2OVapFluxU.nc@SurfH2OVapFluxU,time=0:#{time_end}:3 --mean lon --range=0:1e-4 --nocont --exch --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SurfH2OVapFluxU_lonmean-timeseries.png")
end

if File.exist?("#{$OPT_prefix}SoliMoist_lonmean-timeseries.png") then
  puts("MESSAGE: #{$OPT_prefix}SoilMoist_lonmean-timeseries.png exists. process skipped.")
else
  system("gpview SoilMoist.nc@SoilMoist,time=0:#{time_end}:3 --mean lon --range=0:1e-4 --nocont --exch --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SoliMoist_lonmean-timeseries.png")
end


# եå (ʬ)
if File.exist?("#{$OPT_prefix}fluxesA_lonmean.png") then
  puts("MESSAGE: #{$OPT_prefix}fluxesA_lonmean.png exists. process skipped.")
else
  system("#{script_dir}/fig_heatfluxA-lat-dependence.rb --time_start=#{time_start} --time_end=#{time_end} --range=0:800 --lon=mean --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}fluxesA_lonmean.png")
end

if File.exist?("#{$OPT_prefix}fluxes_lonmean.png") then
  puts("MESSAGE: #{$OPT_prefix}fluxes_lonmean.png exists. process skipped.")
else
  system("#{script_dir}/fig_heatflux-lat-dependence.rb --time_start=#{time_start} --time_end=#{time_end} --range=0:800 --lon=mean --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}fluxes_lonmean.png")
end

# landplanet Ǥ, 
# --range=1e-15:5e-6 ɤ.

# ήؿ
if File.exist?('MSF.nc') then
  puts("MESSAGE: file exists. process skipped.")
else
  exec("ruby #{script_dir}/calc_msf.rb")
end
if File.exist?("#{$OPT_prefix}MSF0-360.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  exec("gpview MSF.nc@MSF,time=#{timespan} --mean lon,time --wsn=#{wsn} --noannotate --range=#{minval_stream}:#{maxval_stream} --cint=#{cint_stream} && #{script_dir}/conv_image.rb #{$OPT_prefix}MSF0-360.png")
end

#if File.exist?($OPT_prefix + 'StreamFunc0-360.png') then
#  puts("MESSAGE: file exists. process skipped.")
#else
#  exec("ruby #{script_dir}/mass_stream_func.rb V.nc V Ps.nc Ps --time_start=#{time_start} --time_end=#{time_end} --lon_start=0 --lon_end=360 --wsn=#{wsn} --range=#{minval_stream}:#{maxval_stream} --cint=#{cint_stream} && #{script_dir}/conv_image.rb #{$OPT_prefix}StreamFunc0-360.png")
#end

#  exec("ruby #{script_dir}/mass_stream_func.rb V.nc V Ps.nc Ps --time_start=#{time_start} --time_end=#{time_end} --lon_start=0 --lon_end=360 --wsn=#{wsn} --range=#{minval_stream}:#{maxval_stream} --cint=#{cint_stream} && dclpsrot dcl.ps > #{$OPT_prefix}StreamFunc0-360.ps && convert #{$OPT_prefix}StreamFunc0-360.ps #{$OPT_prefix}StreamFunc0-360.png")

# ήؿ

# 2015-03-10 
# Making MSF.nc fails first time.
# But, in second time, it succeeds. 
# The reason is not resoloved.

#if File.exist?('MSF.nc') then
#  puts("MESSAGE: MSF.nc exists. process skipped.")
#else
#  exec("ruby #{script_dir}/calc_msf_with_timerange.rb --time_start=#{time_start} --time_end=#{time_end}")
#end

#if File.exist?('#{$OPT_prefix}MSF.png') then
#  puts("MESSAGE: #{$OPT_prefix}MSF.png exists. process skipped.")
#else
#  exec("gpview MSF.nc@MSF,time=#{timespan} --mean lon,time --wsn=#{wsn} --noannotate --range=#{minval_stream}:#{maxval_stream} --cint=#{cint_stream} --clrmap 14 && dclpsrot dcl.ps > #{$OPT_prefix}MSF.ps && convert #{$OPT_prefix}MSF.ps #{$OPT_prefix}MSF.png")
#end

