#! /usr/bin/ruby
# -*- coding: euc-jp -*-

# Ʊž׻襹ץ
# == 
# * ΥץȤƱž¸η̤οޤΤǤ.
# * ΥץȤǤ, gpview, fig_heatflux-lat-dependence.rb ʤɤ
#   ץȤȤ.
# * Ѥˤ, fig_heatflux-lat-dependence.rb ʤɤǼ
#   ǥ쥯ȥꤹɬפ.
#   Τ, script_dir Ŭ񤭴ͤФʤʤ.
#
# == ץ
# --time_start ϻ
# --time_end   λ
# --wsn        . ps ä --wsn=2
# --prefix     եդƬ
#
# == USAGE
#   % fig_SyncRot.rb --time_start=731 --time_end=1095 --wsn=2 --prefix=EXPNAME_
#
# == 
# * 2013-6-19  


require "getoptlong"        # for option_parse
require "numru/ggraph"
include NumRu

script_dir = "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script"
## ץ
parser = GetoptLong.new
parser.set_options(
        ###    global option   ###
       ['--time_start',              GetoptLong::REQUIRED_ARGUMENT],
       ['--time_end',                GetoptLong::REQUIRED_ARGUMENT],
       ['--qvap_name',     GetoptLong::REQUIRED_ARGUMENT],
       ['--cint_cloud',              GetoptLong::REQUIRED_ARGUMENT],
       ['--range_cloud',             GetoptLong::REQUIRED_ARGUMENT],
       ['--cint_surfh2ovapflux',              GetoptLong::REQUIRED_ARGUMENT],
       ['--range_surfh2ovapflux',             GetoptLong::REQUIRED_ARGUMENT],
       ['--cint_prcp',              GetoptLong::REQUIRED_ARGUMENT],
       ['--range_prcp',             GetoptLong::REQUIRED_ARGUMENT],
       ['--cint_slr',              GetoptLong::REQUIRED_ARGUMENT],
       ['--range_slr',             GetoptLong::REQUIRED_ARGUMENT],
       ['--fact_qvaptrnsprt',        GetoptLong::REQUIRED_ARGUMENT],
       ['--vecunit_qvaptrnsprt',     GetoptLong::REQUIRED_ARGUMENT],
       ['--wsn',                     GetoptLong::REQUIRED_ARGUMENT],
       ['--prefix',                  GetoptLong::REQUIRED_ARGUMENT]
                   )
parser.each_option do |name, arg|
    eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

default_prefix = ''
default_prefix = Dir.pwd.split('/')[-1] + '_'

prefix = ($OPT_prefix||default_prefix)

wsn = ($OPT_wsn||4)

fact_qvaptrnsprt = ($OPT_fact_qvaptrnsprt||'0.3')
vecunit_qvaptrnsprt = ($OPT_vecunit_qvaptrnsprt||'0.2')

range_stream = ($OPT_range_stream||'-100:100')
minval_stream = range_stream.split(':')[0].to_f
maxval_stream = range_stream.split(':')[1].to_f

cint_cloud = ($OPT_cint_cloud||0.05).to_s
range_cloud = ($OPT_range_cloud||'0:2').to_s
 
cint_surfh2ovapflux = ($OPT_cint_surfh2ovapflux||1.0e-5).to_s
range_surfh2ovapflux = ($OPT_range_surfh2ovapflux||'0:1e-4').to_s

cint_prcp = ($OPT_cint_prcp||5.0e-6).to_s
range_prcp = ($OPT_range_prcp||'1e-6:1e-4').to_s

cint_slr = ($OPT_cint_slr||10).to_s
range_slr = ($OPT_range_slr||'100:420').to_s


time_start = ($OPT_time_start||1).to_s
time_end = ($OPT_time_end||9999).to_s

timespan = time_start + ':' + time_end

qvap_name = ($OPT_qvap_name||'QH2OVap')

# dennou-h ǥ꤬­ʤʤ, Ǹ 300 ˤ.

#p time_end.class

# äޤǤ 289 Ƥ.
value_time_start_newdata = time_end.to_i - 200
time_start_newdata = value_time_start_newdata.to_s

# Ψ ϥѹƽϤΤΤϤ.
#system("{script_dir}/fig_CoolRate.rb --time_start=#{time_start} --time_end=#{time_end} --wsn=#{wsn} --prefix=#{$OPT_prefix}")




# 0 ̤λѲ

# ɽ̲٤οʿʿ 
if File.exist?(prefix + 'SurfTemp_horimean_timeseries.png') then
  puts("MESSAGE: #{prefix}SurfTemp_horimean_timeseries.png exists. process skipped.")
else
  system("#{script_dir}/fig_horimean-timeseries.rb --var=SurfTemp --range=200:500 --wsn=#{wsn} && #{script_dir}/conv_image.rb #{prefix}SurfTemp_horimean_timeseries.png")
end


# OSRοʿʿ 
if File.exist?(prefix + 'OSRA_horimean_timeseries.png') then
  puts("MESSAGE: #{prefix}OSRA_horimean_timeseries.png exists. process skipped.")
else
  system("#{script_dir}/fig_horimean-timeseries.rb --var=OSRA --wsn=#{wsn} && #{script_dir}/conv_image.rb #{prefix}OSRA_horimean_timeseries.png")
end


# Ǯեå
if File.exist?(prefix + 'HeatFlux-all_timeseries.png') then
  puts("MESSAGE: #{prefix}HeatFlux-all_timeseries.png exists. process skipped.")
else
  system("#{script_dir}/fig_timeseries-heat.rb --region=all --wsn=#{wsn} && #{script_dir}/conv_image.rb #{prefix}HeatFlux-all_timeseries.png")
end


# OSR & OLR
if File.exist?(prefix + 'OSR-OLR_timeseries.png') then
  puts("MESSAGE: #{prefix}OSR-OLR_timeseries.png exists. process skipped.")
else
  system("#{script_dir}/fig_absorb.rb --wsn=#{wsn} && #{script_dir}/conv_image.rb #{prefix}OSR-OLR_timeseries.png")
end


# ѻ
if File.exist?('VertIntH2OLiq.nc') then
  puts("MESSAGE: VertIntH2OLiq.nc exists. process skipped.")
else
  system("#{script_dir}/make_vertinteg.rb --var=QH2OLiq") unless File.exist?('VerIntH2OLiq.nc')
end
if File.exist?(prefix + 'H2OLiq_globalinteg_timeseries.png') then
  puts("MESSAGE: #{prefix}H2OLiq_globalinteg_timeseries.png exists. process skipped.")
else
  system("#{script_dir}/fig_horimean-timeseries.rb --var=VertIntQH2OLiq --time_start=#{time_start} --time_end=#{time_end} --range=0:0.2 --wsn=#{wsn} && #{script_dir}/conv_image.rb #{prefix}H2OLiq_globalinteg_timeseries.png")
end

#  Ⱦѻ
if File.exist?('VertIntH2OLiq.nc') then
  puts("MESSAGE: VertIntH2OLiq.nc exists. process skipped.")
else
  system("#{script_dir}/make_vertinteg.rb --var=H2OLiq") unless File.exist?('VerIntH2OLiq.nc')
end
if File.exist?(prefix + 'H2OLiq_westinteg_timeseries.png') then
  puts("MESSAGE: #{prefix}H2OLiq_westinteg_timeseries.png exists. process skipped.")
else
  system("#{script_dir}/fig_horimean-timeseries.rb --var=VertIntH2OLiq --lon_start=0 --lon_end=180 --time_start=#{time_start} --time_end=#{time_end} --range=0:0.2 --wsn=#{wsn} && #{script_dir}/conv_image.rb #{prefix}H2OLiq_westinteg_timeseries.png")
end

#  Ⱦѻ
if File.exist?('VertIntH2OLiq.nc') then
  puts("MESSAGE: VertIntH2OLiq.nc exists. process skipped.")
else
  system("#{script_dir}/make_vertinteg.rb --var=H2OLiq") unless File.exist?('VerIntH2OLiq.nc')
end

if File.exist?(prefix + 'H2OLiq_eastinteg_timeseries.png') then
  puts("MESSAGE: #{prefix}H2OLiq_eastinteg_timeseries.png exists. process skipped.")
else
  system("#{script_dir}/fig_horimean-timeseries.rb --var=VertIntH2OLiq --lon_start=180 --lon_end=359 --time_start=#{time_start} --time_end=#{time_end} --range=0:0.2 --wsn=#{wsn} && #{script_dir}/conv_image.rb #{prefix}H2OLiq_eastinteg_timeseries.png")
end



# Tg-OLR ۿ
if File.exist?(prefix + 'scatter_Tg-OLR_180x180.png') then
  puts("MESSAGE: #{prefix}scatter_Tg-OLR_180x180.png exists. process skipped.")
else
  system("#{script_dir}/scatter_Tg-OLR.rb --time_start=#{time_start} --time_end=#{time_end} --area=180 --wsn=#{wsn} && #{script_dir}/conv_image.rb #{prefix}scatter_Tg-OLR_180x180.png") 
end



if File.exist?(prefix + 'scatter_Tg-OLR_120x120.png') then
  puts("MESSAGE: #{prefix}scatter_Tg-OLR_120x120.png exists. process skipped.")
else
  system("#{script_dir}/scatter_Tg-OLR.rb --time_start=#{time_start} --time_end=#{time_end} --area=120 --wsn=#{wsn} && #{script_dir}/conv_image.rb #{prefix}scatter_Tg-OLR_120x120.png") 
end

if File.exist?(prefix + 'scatter_Tg-OLR_90x90.png') then
  puts("MESSAGE: #{prefix}scatter_Tg-OLR_90x90.png exists. process skipped.")
else
  system("#{script_dir}/scatter_Tg-OLR.rb --time_start=#{time_start} --time_end=#{time_end} --area=90 --wsn=#{wsn} && #{script_dir}/conv_image.rb #{prefix}scatter_Tg-OLR_90x90.png") 
end



# ȥ٥ȥ
if File.exist?(prefix + 'qvap-column_trnsprt_q_all.png') then
  puts("MESSAGE: #{prefix}qvap-column_trnsprt_q_all.png exists. process skipped.")
else
  system("#{script_dir}/qvap-column_trnsprt_qh2ovap.rb --qvap_name #{qvap_name} --range_time #{time_start_newdata}:#{time_end} --xfact1 #{fact_qvaptrnsprt} --yfact1 #{fact_qvaptrnsprt} --uxunit #{vecunit_qvaptrnsprt} --uyunit #{vecunit_qvaptrnsprt} --type 1 --wsn #{wsn} && #{script_dir}/conv_image.rb #{prefix}qvap-column_trnsprt_q_all.png") 
end


# Ūͥ륮͢ (ץå)
if File.exist?(prefix + 'trnsprt_s_all.png') then
  puts("MESSAGE: #{prefix}trnsprt_s_all.png exists. process skipped.")
else
  system("#{script_dir}/trnsprt_s_v2.rb --range_time #{time_start}:#{time_end} --xfact1 2e-8 --yfact1 2e-8 --uxunit 3e6 --uyunit 3e6 --type 1 --wsn #{wsn} && #{script_dir}/conv_image.rb #{prefix}trnsprt_s_all.png") 
#  system("#{script_dir}/trnsprt_s.rb --range_time #{time_start_newdata}:#{time_end} --xfact1 2e-8 --yfact1 2e-8 --uxunit 3e6 --uyunit 3e6 --type 1 --wsn #{wsn} && dclpsrot dcl.ps > #{prefix}trnsprt_s_all.ps && convert #{prefix}trnsprt_s_all.ps #{prefix}trnsprt_s_all.png") 
end


# Ǯͥ륮͢ (ץå)
if File.exist?(prefix + 'trnsprt_lq_all.png') then
  puts("MESSAGE: #{prefix}trnsprt_lq_all.png exists. process skipped.")
else
  system("#{script_dir}/trnsprt_lq_v2.rb --range_time #{time_start}:#{time_end} --xfact1 2e-7 --yfact1 2e-7 --uxunit 3e5 --uyunit 3e5 --type 1 --wsn #{wsn} && #{script_dir}/conv_image.rb #{prefix}trnsprt_lq_all.png") 
end


# ھǡ
if File.exist?("#{prefix}SoilTemp.png") then
  puts("MESSAGE: #{prefix}SoilTemp.png exists. process skipped.")
else
  system("gpview SoilTemp.nc@SoilTemp,time=#{timespan} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{prefix}SoilTemp.png")
end

if File.exist?("#{prefix}SoilMoist.png") then
  puts("MESSAGE: #{prefix}SoilMoist.png exists. process skipped.")
else
  system("gpview SoilMoist.nc@SoilMoist,time=#{timespan} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{prefix}SoilMoist.png")
end


# ľѻ ʿʬ
if File.exist?('VertIntQVap.nc') then
  puts("MESSAGE: VertIntQVap.nc exists. process skipped.")
else
  system("#{script_dir}/make_vertinteg.rb --var=#{qvap_name}") unless File.exist?('VerInt#{qvap_name}.nc')
end
if File.exist?(prefix + 'IntegratedQVap.png') then
  puts("MESSAGE: #{prefix}IntegratedQVap.png exists. process skipped.")
else
  system("gpview VertInt#{qvap_name}.nc@VertInt#{qvap_name},time=#{timespan} --mean time --noannotate --cint=5 --range=0:120 --wsn=#{wsn} && #{script_dir}/conv_image.rb #{prefix}IntegratedQVap.png")
end

if File.exist?('VertIntH2OLiq.nc') then
  puts("MESSAGE: VertIntH2OLiq.nc exists. process skipped.")
else
  system("#{script_dir}/make_vertinteg.rb --var=H2OLiq") unless File.exist?('VerIntH2OLiq.nc')
end
if File.exist?(prefix + 'IntegratedH2OLiq.png') then
  puts("MESSAGE: #{prefix}IntegratedH2OLiq.png exists. process skipped.")
else
  system("gpview VertIntH2OLiq.nc@VertIntH2OLiq,time=#{timespan} --mean time --noannotate --int=#{cint_cloud} --range=#{range_cloud} --wsn=#{wsn} && #{script_dir}/conv_image.rb #{prefix}IntegratedH2OLiq.png")
end


# 2 ǡ ʿʬ
if File.exist?("#{prefix}SurfTemp.png") then
  puts("MESSAGE: #{prefix}SurfTemp.png exists. process skipped.")
else
  # for SyncRot with increased S
  system("gpview SurfTemp.nc@SurfTemp,time=#{timespan} --mean time --range=160:340 --wsn=#{wsn} --int=5 --noannotate && #{script_dir}/conv_image.rb #{prefix}SurfTemp.png")
  # old version
  system("gpview SurfTemp.nc@SurfTemp,time=#{timespan} --mean time --range=160:340 --wsn=#{wsn} --int=5 --noannotate && #{script_dir}/conv_image.rb #{prefix}SurfTemp.png")
# for standard of S=1366
#  system("gpview SurfTemp.nc@SurfTemp,time=#{timespan} --mean time --range=180:330 --wsn=#{wsn} --cint=5 --noannotate && dclpsrot dcl.ps > #{prefix}SurfTemp.ps && convert #{prefix}SurfTemp.ps #{prefix}SurfTemp.png")
end

if File.exist?("#{prefix}SurfTemp_Ecolor.png") then
  puts("MESSAGE: #{prefix}SurfTemp_Ecolor.png exists. process skipped.")
else
  system("gpview SurfTemp.nc@SurfTemp,time=#{timespan} --mean time --wsn=#{wsn} --noannotate --levels 999,210,220,230,240,250,260,270,280,290,300,999 --pattern 20999,29999,40999,45999,50999,55999,60999,70999,80999,85999,90999 && #{script_dir}/conv_image.rb #{prefix}SurfTemp_Ecolor.png")
end

if File.exist?("#{prefix}OLR.png") then
  puts("MESSAGE: #{prefix}OLR.png exists. process skipped.")
else
#  system("gpview OLR.nc@OLR,time=#{timespan} --mean time --wsn=#{wsn} --noannotate --sint=10 --range=130:440 && dclpsrot dcl.ps > #{prefix}OLR.ps && convert #{prefix}OLR.ps #{prefix}OLR.png")
  system("gpview OLR.nc@OLR,time=#{timespan} --mean time --wsn=#{wsn} --noannotate --sint=10 --range=130:440 && #{script_dir}/conv_image.rb #{prefix}OLR.png")
end

if File.exist?("#{prefix}OLRA.png") then
  puts("MESSAGE: #{prefix}OLRA.png exists. process skipped.")
else
  system("gpview OLRA.nc@OLRA,time=#{timespan} --mean time --wsn=#{wsn} --noannotate --cint=10 --range=100:420 && #{script_dir}/conv_image.rb #{prefix}OLRA.png")
end

if File.exist?("#{prefix}OLRA_Ecolor.png") then
  puts("MESSAGE: #{prefix}OLRA_Ecolor.png exists. process skipped.")
else
  system("gpview OLRA.nc@OLRA,time=#{timespan} --mean time --wsn=#{wsn} --noannotate --levels 999,100,120,140,160,180,200,220,240,260,280,300,999 --pattern 10999,16999,20999,24999,29999,35999,40999,45999,55999,70999,80999,90999 && #{script_dir}/conv_image.rb #{prefix}OLRA_Ecolor.png")
end

if File.exist?("#{prefix}SLRA.png") then
  puts("MESSAGE: #{prefix}SLRA.png exists. process skipped.")
else
  system("gpview SLRA.nc@SLRA,time=#{timespan} --mean time --wsn=#{wsn} --noannotate --cint=#{cint_slr} --range=#{range_slr} && #{script_dir}/conv_image.rb #{prefix}SLRA.png")
end

if File.exist?("#{prefix}Rain.png") then
  puts("MESSAGE: #{prefix}Rain.png exists. process skipped.")
else
  system("gpview Rain.nc@Rain,time=#{timespan} --mean time --range=0:1e-4 --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{prefix}Rain.png")
end

if File.exist?("#{prefix}PRCP.png") then
  puts("MESSAGE: #{prefix}PRCP.png exists. process skipped.")
else
  system("gpview PRCP.nc@PRCP,time=#{timespan} --mean time --range=#{range_prcp} --cint=#{cint_prcp} --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{prefix}PRCP.png")
end

if File.exist?("#{prefix}PRCP_Ecolor.png") then
  puts("MESSAGE: #{prefix}PRCP_Ecolor.png exists. process skipped.")
else
  system("gpview PRCP.nc@PRCP,time=#{timespan} --mean time --range=0:1e-3 --cint=5e-5 --wsn=#{wsn} --noannotate --levels 999,0,1e-5,2e-5,4e-5,8e-5,1.2e-4,1.6e-4,2.0e-4,2.4e-4,2.8e-4,3.2e-4,999 --pattern 99999,20999,29999,35999,40999,45999,55999,65999,70999,75999,80999,90999 && #{script_dir}/conv_image.rb #{prefix}PRCP_Ecolor.png")
end

if File.exist?("#{prefix}SurfH2OVapFluxU.png") then
  puts("MESSAGE: #{prefix}SurfH2OVapFluxU.png exists. process skipped.")
else
  system("gpview SurfH2OVapFluxU.nc@SurfH2OVapFluxU,time=#{timespan} --mean time --cint=#{cint_surfh2ovapflux} --range=#{range_surfh2ovapflux} --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{prefix}SurfH2OVapFluxU.png")
end

if File.exist?("#{prefix}Evap.png") then
  puts("MESSAGE: #{prefix}Evap.png exists. process skipped.")
else
  system("gpview Evap.nc@Evap,time=#{timespan} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{prefix}Evap.png")
end

if File.exist?("#{prefix}EvapU.png") then
  puts("MESSAGE: #{prefix}EvapU.png exists. process skipped.")
else
  system("gpview EvapU.nc@EvapU,time=#{timespan} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{prefix}EvapU.png")
end

if File.exist?("#{prefix}Sens.png") then
  puts("MESSAGE: #{prefix}Sens.png exists. process skipped.")
else
  system("gpview Sens.nc@Sens,time=#{timespan} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{prefix}Sens.png")
end

if File.exist?("#{prefix}SensA.png") then
  puts("MESSAGE: #{prefix}SensA.png exists. process skipped.")
else
  system("gpview SensA.nc@SensA,time=#{timespan} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{prefix}SensA.png")
end

if File.exist?("#{prefix}OSR.png") then
  puts("MESSAGE: #{prefix}OSR.png exists. process skipped.")
else
  system("gpview OSR.nc@OSR,time=#{timespan} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{prefix}OSR.png")
end

if File.exist?("#{prefix}OSRA.png") then
  puts("MESSAGE: #{prefix}OSRA.png exists. process skipped.")
else
  system("gpview OSRA.nc@OSRA,time=#{timespan} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{prefix}OSRA.png")
end

if File.exist?("#{prefix}SSR.png") then
  puts("MESSAGE: #{prefix}SSR.png exists. process skipped.")
else
  system("gpview SSR.nc@SSR,time=#{timespan} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{prefix}SSR.png")
end

if File.exist?("#{prefix}SSRA.png") then
  puts("MESSAGE: #{prefix}SSRA.png exists. process skipped.")
else
  system("gpview SSRA.nc@SSRA,time=#{timespan} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{prefix}SSRA.png")
end

if File.exist?("#{prefix}SurfAlbedo.png") then
  puts("MESSAGE: #{prefix}SurfAlbedo.png exists. process skipped.")
else
  system("gpview SurfAlbedo.nc@SurfAlbedo,time=#{timespan} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{prefix}SurfAlbedo.png")
end

if File.exist?("#{prefix}Ps.png") then
  puts("MESSAGE: #{prefix}Ps.png exists. process skipped.")
else
  system("gpview Ps.nc@Ps,time=#{timespan} --mean time --cint=1000 --range=86000:105000 --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{prefix}Ps.png")
end

if File.exist?("#{prefix}SurfSnow.png") then
  puts("MESSAGE: #{prefix}SurfSnow.png exists. process skipped.")
else
  system("gpview SurfSnow.nc@SurfSnow,time=#{timespan} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{prefix}SurfSnow.png")
end

if File.exist?("#{prefix}SeaIceConc.png") then
  puts("MESSAGE: #{prefix}SeaIceConc.png exists. process skipped.")
else
  system("gpview SeaIceConc.nc@SeaIceConc,time=#{timespan} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{prefix}SeaIceConc.png")
end


# 2 ǡ ʿʬ (noshade)
if File.exist?("#{prefix}SurfTemp-noshade.png") then
  puts("MESSAGE: #{prefix}SurfTemp-noshade.png exists. process skipped.")
else
  system("gpview SurfTemp.nc@SurfTemp,time=#{timespan} --mean time --noshade --wsn=#{wsn} --cint=5 --range=200:320 --noannotate && #{script_dir}/conv_image.rb #{prefix}SurfTemp-noshade.png")
end

if File.exist?("#{prefix}OLRA-noshade.png") then
  puts("MESSAGE: #{prefix}OLRA-noshade.png exists. process skipped.")
else
  system("gpview OLRA.nc@OLRA,time=#{timespan} --mean time --wsn=#{wsn} --noannotate --cint=10 --range=100:350 --noshade && #{script_dir}/conv_image.rb #{prefix}OLRA-noshade.png")
end

#  ʿʬ
if File.exist?("#{prefix}Temp_sig0.1.png") then
  puts("MESSAGE: #{prefix}Temp_sig0.1.png exists. process skipped.")
else
  system("gpview Temp.nc@Temp,sig=0.1,time=#{timespan} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{prefix}Temp_sig0.1.png")
end

if File.exist?("#{prefix}Temp_sig0.077.png") then
  puts("MESSAGE: #{prefix}Temp_sig0.077.png exists. process skipped.")
else
  system("gpview Temp.nc@Temp,sig=0.077,time=#{timespan} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{prefix}Temp_sig0.077.png")
end

#  ƻ (itr=2)
if File.exist?("#{prefix}Temp_lat0_itr2.png") then
  puts("MESSAGE: #{prefix}Temp_lat0_itr2.png exists. process skipped.")
else
  system("gpview Temp.nc@Temp,lat=0,time=#{timespan} --mean time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb  #{prefix}Temp_lat0_itr2.png")
end

#  ƻ
if File.exist?("#{prefix}Temp_lat0_itr1.png") then
  puts("MESSAGE: #{prefix}Temp_lat0_itr1.png exists. process skipped.")
else
  system("gpview Temp.nc@Temp,lat=0,time=#{timespan} --mean time --wsn=#{wsn} --itr=1 --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{prefix}Temp_lat0_itr1.png")
end

#  ƻ
if File.exist?("#{prefix}U_lat0_itr1.png") then
  puts("MESSAGE: #{prefix}U_lat0_itr1.png exists. process skipped.")
else
  system("gpview U.nc@U,lat=0,time=#{timespan} --mean time --wsn=#{wsn} --itr=1 --noannotate --cint=15 --range=-70:110 && #{script_dir}/conv_image.rb #{prefix}U_lat0_itr1.png")
end

#  ʿʬ(sigma=0.077)
if File.exist?("#{prefix}U_sig0.077.png") then
  puts("MESSAGE: #{prefix}U_sig0.077.png exists. process skipped.")
else
  system("gpview U.nc@U,sig=0.077,time=#{timespan} --mean time --wsn=#{wsn}  --noannotate --cint=20 --range=-70:150 && #{script_dir}/conv_image.rb #{prefix}U_sig0.077.png")
end


#  (ʿʬ)
if File.exist?("#{prefix}V_sig0.1.png") then
  puts("MESSAGE: #{prefix}V_sig0.1.png exists. process skipped.")
else
  system("gpview V.nc@V,sig=0.1,time=#{timespan} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=-50:50 && #{script_dir}/conv_image.rb #{prefix}V_sig0.1.png")
end

if File.exist?("#{prefix}V_sig0.077.png") then
  puts("MESSAGE: #{prefix}V_sig0.077.png exists. process skipped.")
else
  system("gpview V.nc@V,sig=0.077,time=#{timespan} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=-50:50 && #{script_dir}/conv_image.rb #{prefix}V_sig0.077.png")
end

# ľ ʿʬ
if File.exist?("#{prefix}SigDot_sig0.1.png") then
  puts("MESSAGE: #{prefix}SigDot_sig0.1.png exists. process skipped.")
else
  system("gpview SigDot.nc@SigDot,sigm=0.1,time=#{timespan} --mean time --wsn=#{wsn}  --noannotate --range=-2e-6:2e-6 --cint=1e-7 --clrmap 14 && #{script_dir}/conv_image.rb #{prefix}SigDot_sig0.1.png")
end

if File.exist?("#{prefix}SigDot_sig0.077.png") then
  puts("MESSAGE: #{prefix}SigDot_sig0.077.png exists. process skipped.")
else
  system("gpview SigDot.nc@SigDot,sigm=0.077,time=#{timespan} --mean time --wsn=#{wsn}  --noannotate --range=-2e-6:2e-6 --cint=1e-7 --clrmap 14 && #{script_dir}/conv_image.rb #{prefix}SigDot_sig0.077.png")
end

if File.exist?("#{prefix}SigDot_sig0.5.png") then
  puts("MESSAGE: #{prefix}SigDot_sig0.5.png exists. process skipped.")
else
  system("gpview SigDot.nc@SigDot,sigm=0.5,time=#{timespan} --mean time --wsn=#{wsn}  --noannotate --range=-2e-6:2e-6 --cint=1e-7 --clrmap 14 && #{script_dir}/conv_image.rb #{prefix}SigDot_sig0.5.png")
end


# 漾 ʿʬ
if File.exist?("#{prefix}QVap_sig0.1.png") then
  puts("MESSAGE: #{prefix}QVap_sig0.1.png exists. process skipped.")
else
  system("gpview #{qvap_name}.nc@#{qvap_name},sig=0.1,time=#{timespan} --mean time --wsn=#{wsn}  --noannotate && #{script_dir}/conv_image.rb #{prefix}QVap_sig0.1.png")
end

if File.exist?("#{prefix}QVap_sig0.077.png") then
  puts("MESSAGE: #{prefix}QVap_sig0.077.png exists. process skipped.")
else
  system("gpview #{qvap_name}.nc@#{qvap_name},sig=0.077,time=#{timespan} --mean time --wsn=#{wsn}  --noannotate && #{script_dir}/conv_image.rb #{prefix}QVap_sig0.077.png")
end


# ѱư
if File.exist?('AngMom.nc') then
  puts("MESSAGE: AngMom.nc exists. process skipped.")
else
  system("#{script_dir}/make_AngMom.rb") unless File.exist?('AngMom.nc')
end

if File.exist?("#{prefix}AngularMomentum.png") then
  puts("MESSAGE: #{prefix}AngularMomentum.png exists. process skipped.")
else
  system("gpview AngMom.nc@AngMom,time=#{timespan} --range 1e7:4e9 --cint 2e8 --mean lon,time --wsn #{wsn} && #{script_dir}/conv_image.rb #{prefix}AngularMomentum.png")
end

# 
if File.exist?("PotTemp.nc") then
  puts("MESSAGE: PotTemp.nc exists. process skipped.")
else
  system("#{script_dir}/make_PotTemp.rb --range_time #{timespan}") unless File.exist?('PotTemp.nc')
end

if File.exist?("#{prefix}PotTemp.png") then
  puts("MESSAGE: #{prefix}PotTemp.png exists. process skipped.")
else
#  system("#{script_dir}/potential-temperature.rb --range_time #{timespan} --range_val 200:800 --cint 40.0 --wsn #{wsn} && dclpsrot dcl.ps > #{prefix}PotTemp.ps && convert #{prefix}PotTemp.ps #{prefix}PotTemp.png")
#  system("#{script_dir}/potential-temperature.rb --range_time 995:1095 --range_val 200:800 --cint 40.0 --wsn #{wsn} && dclpsrot dcl.ps > #{prefix}PotTemp.ps && convert #{prefix}PotTemp.ps #{prefix}PotTemp.png")
  system("gpview  PotTemp.nc@theta,time=#{timespan} --range 200:800 --cint 40.0 --wsn #{wsn} && #{script_dir}/conv_image.rb #{prefix}PotTemp.png")
end


# ƻ
if File.exist?("#{prefix}QVap_lat0_itr1.png") then
  puts("MESSAGE: #{prefix}QVap_lat0_itr1.png exists. process skipped.")
else
  system("gpview #{qvap_name}.nc@#{qvap_name},lat=0,time=#{timespan} --mean time --wsn=#{wsn} --itr=1 --noannotate --cint=1e-3 --range=1e-19:1e-2 && #{script_dir}/conv_image.rb #{prefix}QVap_lat0_itr1.png")
end

if File.exist?("#{prefix}QVap_lat0_itr1_Ecolor.png") then
  puts("MESSAGE: #{prefix}QVap_lat0_itr1_Ecolor.png exists. process skipped.")
else
  system("gpview #{qvap_name}.nc@#{qvap_name},lat=0,time=#{timespan} --mean time --wsn=#{wsn} --itr=1 --noannotate --levels 999,1e-4,0.002,0.004,0.006,0.008,0.01,0.012,0.014,0.016,0.018,0.02,999 --pattern 99999,10999,20999,32999,45999,50999,55999,60999,70999,80999,88999,95999  && #{script_dir}/conv_image.rb #{prefix}QVap_lat0_itr1_Ecolor.png")
end

# (u,v)
if File.exist?("#{prefix}wind-vector_sigma0.2_geopot_t#{time_start}-#{time_end}.png") then
  puts("MESSAGE: #{prefix}wind-vector_sigma0.2_geopot_t#{time_start}-#{time_end}.png exists. process skipped.")
else
  system("#{script_dir}/wind-vector_geopot.rb --time_start #{time_start} --time_end #{time_end} --xintv 8 --yintv 6 --int 2000 --range 108000:178000 --wsn #{wsn} --sigma 0.2 --prefix #{prefix}") 
end

if File.exist?("#{prefix}wind-vector-eddy_sigma0.2_geopot_t#{time_start}-#{time_end}.png") then
  puts("MESSAGE: #{prefix}wind-vector-eddy_sigma0.2_geopot_t#{time_start}-#{time_end}.png exists. process skipped.")
else
  system("#{script_dir}/wind-vector_geopot.rb --time_start #{time_start} --time_end #{time_end} --xintv 8 --yintv 6 --wsn #{wsn} --sigma 0.2 --eddy  --prefix #{prefix}") 
end


if File.exist?("#{prefix}wind-vector_sigma0.17_geopot_t#{time_start}-#{time_end}.png") then
  puts("MESSAGE: #{prefix}wind-vector_sigma0.17_geopot_t#{time_start}-#{time_end}.png exists. process skipped.")
else
  system("#{script_dir}/wind-vector_geopot.rb --time_start #{time_start} --time_end #{time_end} --xintv 8 --yintv 6 --int 2000 --range 108000:178000 --wsn #{wsn} --sigma 0.17  --prefix #{prefix}") 
end

if File.exist?("#{prefix}wind-vector-eddy_sigma0.17_geopot_t#{time_start}-#{time_end}.png") then
  puts("MESSAGE: #{prefix}wind-vector-eddy_sigma0.17_geopot_t#{time_start}-#{time_end}.png exists. process skipped.")
else
  system("#{script_dir}/wind-vector_geopot.rb --time_start #{time_start} --time_end #{time_end} --xintv 8 --yintv 6 --wsn #{wsn} --sigma 0.17 --eddy  --prefix #{prefix}") 
end


if File.exist?("#{prefix}wind-vector-eddy_sigma0.1_geopot_t#{time_start}-#{time_end}.png") then
  puts("MESSAGE: #{prefix}wind-vector-eddy_sigma0.1_geopot_t#{time_start}-#{time_end}.png exists. process skipped.")
else
  system("#{script_dir}/wind-vector_geopot.rb --time_start #{time_start} --time_end #{time_end} --wsn #{wsn} --sigma 0.1 --eddy  --prefix #{prefix}") 
end

if File.exist?("#{prefix}wind-vector_sigma0.1_geopot_t#{time_start}-#{time_end}.png") then
  puts("MESSAGE: #{prefix}wind-vector_sigma0.1_geopot_t#{time_start}-#{time_end}.png exists. process skipped.")
else
  system("#{script_dir}/wind-vector_geopot.rb --time_start #{time_start} --time_end #{time_end} --xintv 8 --yintv 5 --wsn #{wsn} --sigma 0.1 --prefix #{prefix}") 
end

# ʿ®پ
# system("#{script_dir}/fig_olr-uv.rb --xfact1 0.001 --yfact1 0.001 --uxunit 1 --uyunit 1 --loncnt 0 --wsn 2 && dclpsrot dcl.ps > #{prefix}OLR-UV.ps && convert #{prefix}OLR-UV.ps #{prefix}OLR-UV_from0.png")


# Ǯեå (ʬ)
if File.exist?("#{prefix}fluxesA_latmean.png") then
  puts("MESSAGE: #{prefix}fluxesA_latmean.png exists. process skipped.")
else
  system("#{script_dir}/fig_heatfluxA-lon-dependence.rb \
    --time_start=#{time_start} --time_end=#{time_end} \
    --range=0:400 --lat=mean --wsn=#{wsn} \
    && #{script_dir}/conv_image.rb #{prefix}fluxesA_latmean.png")
end

if File.exist?("#{prefix}fluxes_lat0.png") then
  puts("MESSAGE: #{prefix}fluxes_lat0.png exists. process skipped.")
else
  system("#{script_dir}/fig_heatfluxA-lon-dependence.rb --time_start=#{time_start} --time_end=#{time_end} --range=0:400 --lat=0 --wsn=#{wsn} && #{script_dir}/conv_image.rb #{prefix}fluxesA_lat0.png")
end

if File.exist?("#{prefix}fluxes_latmean.png") then
  puts("MESSAGE: #{prefix}fluxes_latmean.png exists. process skipped.")
else
  system("#{script_dir}/fig_heatflux-lon-dependence.rb --time_start=#{time_start} --time_end=#{time_end} --range=0:400 --lat=mean --wsn=#{wsn} && #{script_dir}/conv_image.rb #{prefix}fluxes_latmean.png")
end

if File.exist?("#{prefix}fluxes_lat0.png") then
  puts("MESSAGE: #{prefix}fluxes_lat0.png exists. process skipped.")
else
  system("#{script_dir}/fig_heatflux-lon-dependence.rb --time_start=#{time_start} --time_end=#{time_end} --range=0:400 --lat=0 --wsn=#{wsn} && #{script_dir}/conv_image.rb #{prefix}fluxes_lat0.png")
end

