#!/usr/bin/ruby
# -*- coding: utf-8 -*-




# (2013-6-14 石渡)
# 球面プロットでカラーバーを書くとベクトルが表示されない!
# 矢印が太すぎるような気がする.

# わからん!!!


DATA_HOME = "/GFD_Dennou_Work3/momoko/SyncRotEarthRad"

require "numru/ggraph"
include NumRu
require "pp"

wsn = 4

RPlanet = 6.371 * 10 ** 6  # [m]
#Ps = 1e5  # [Pa]
Grav = 9.8   # [m/s2]

title = ""

# olr の描画範囲
val_min = 120
val_max = 310
val_interval = (val_max - val_min) / 30.0
#YUNIT_vapor = 'kg m-2'
#epsfn = "qvap_area_column_mass.eps"

# ベクトルの描画間隔 (単位は格子点数)
#xintv = 8
#yintv = 6
xintv = 4
yintv = 3
#xintv = 2
#yintv = 1

# 球面プロットと平面プロットの切り替えは
# この部分と下の設定部分を変更する.

ITR=30   # 球
#ITR=1   # 平面プロット

lon_cont = 125 # 球のときに使用

#xfact1 = 0.01
#yfact1 = 0.01
xfact1 = 1.0
yfact1 = 1.0

# 凡例の単位ベクトルの長さ (デフォルト値)
uxunit = 0.03
uyunit = 0.03

time_start = 731
time_end   = 1096

#omegas = [0.0, 0.15, 0.5, 1.0]
#omegas = [1.0]
#omegas = [0.0]

omega = 1.0

dir = nil

# 簡易
while ARGV.size > 0
  case ARGV[0]
  when '--dir' then
    ARGV.shift
    dir = ARGV[0]
    ARGV.shift
  when '--omega' then
    ARGV.shift
    omega = ARGV[0]
    ARGV.shift
  when '--wsn' then
    ARGV.shift
    wsn = ARGV[0]
    ARGV.shift
  when '--xintv' then
    ARGV.shift
    xintv = ARGV[0]
    ARGV.shift
  when '--yintv' then
    ARGV.shift
    yintv = ARGV[0]
    ARGV.shift
  when '--xfact1' then
    ARGV.shift
    xfact1 = ARGV[0]
    ARGV.shift
  when '--yfact1' then
    ARGV.shift
    yfact1 = ARGV[0]
    ARGV.shift
  when '--uxunit' then
    ARGV.shift
    uxunit = ARGV[0]
    ARGV.shift
  when '--uyunit' then
    ARGV.shift
    uyunit = ARGV[0]
    ARGV.shift
  when '--loncnt' then
    ARGV.shift
    lon_cnt = ARGV[0]
    ARGV.shift
  when '--range_time' then
    ARGV.shift
    tmp = ARGV[0].split(':')
    time_start = tmp[0].to_f
    time_end   = tmp[1].to_f
    ARGV.shift
  when '--range_val' then
    ARGV.shift
    tmp = ARGV[0].split(':')
    val_min = tmp[0].to_f
    val_max = tmp[1].to_f
    ARGV.shift
    val_interval = (val_max - val_min) / 30.0
  else
    raise "ERROR: invalid option: #{ARGV[0]}"
  end
end





if dir == nil then
#  dir = File.join(DATA_HOME, 
#                  "101220_diff-DryAir-Vapor_T21L16_sr_Omega" + omega.to_s + "_dt20m")
  dir = File.join(DATA_HOME,"ExpOcean")
end


# input
var = 'U'
path = var+'.nc'
gp_u = GPhys::IO.open(path, var).cut('time'=>time_start..time_end, 'sig'=>0.2)

var = 'V'
path = var+'.nc'
gp_v = GPhys::IO.open(path, var).cut('time'=>time_start..time_end, 'sig'=>0.2)

#var = 'OLR'
var = 'SurfTemp'
path = var+'.nc'
gp_olr = GPhys::IO.open(path, var).cut('time'=>time_start..time_end)

# 時間平均
gp_u = gp_u.mean('time')
gp_v = gp_v.mean('time')
gp_olr = gp_olr.mean('time')

DCL.gropn(wsn)

DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)

GGraph.set_axes('xtickint'=>10, 'xlabelint'=>30)
GGraph.set_axes('ytickint'=>10, 'ylabelint'=>30)

# 球の時 (平面プロットの時は 下の 2 行をコメントアウトするだけ)
GGraph.set_fig 'itr'=>ITR, 'viewport'=>[0.15,0.95,0.2,0.8], 'map_axis'=>[lon_cnt, 0, 0]
GGraph.set_fig 'viewport'=>[0.15,0.95,0.2,0.8]

# same as gpview
#vx0,vx1,vy0,vy1 = 0.15,0.85,0.2,0.55
vx0,vx1,vy0,vy1 = 0.15,0.95,0.2,0.8
GGraph.set_fig 'itr'=>ITR, 'viewport'=>[vx0,vx1,vy0,vy1], 'map_axis'=>[lon_cnt, 0, 0]

DCL.uscset('cyspos', 'B' )              # move unit y axis

DCL.udlset('LMSG', false)

DCL.ugpset('XFACT1', xfact1)
DCL.ugpset('YFACT1', yfact1)
DCL.ugpset('UXUNIT', uxunit) # size of unit vector by dimentional value
DCL.ugpset('UYUNIT', uyunit)
DCL::ugrset('VXUNIT', 0.1)  # size of unit vector
DCL::ugrset('VYUNIT', 0.1)

DCL::uxmttl('T', '', 0.0)  # title (large character)

DCL.ugpset('LNRMAL', false)  # scale vector automatically
DCL.ugpset('LUMSG', false)   # no message

DCL.ugpset('INDEX', 955)

opt_vector = {
  'xintv'=>xintv, 'yintv'=>yintv,
#  'flow_vect'=>false, 'annotate'=>false, 'unit_vect'=>true
  'flow_vect'=>true, 'annotate'=>false, 'unit_vect'=>false
}

opt_contour = {
  'min'=>val_min, 'max'=>val_max, 'interval'=>val_interval,
  'title'=>title, 'annotate'=>false
}

opt_tone = {
   'min'=>val_min, 'max'=>val_max,  
   'annotate'=>false
}


# トーンのカラーマップ
# OLR 用
#DCL.sgscmn(2)   # colormap: black-red-yellow-white
# SurfTemp 用
DCL.sgscmn(8)   # colormap: black-red-yellow-white

#GGraph.tone_and_contour( gp_olr, true, opt_contour)
GGraph.tone( gp_olr, true, opt_tone)

# ベクトルのプロット
#DCL.sgscmn(7)   # colormap: 
DCL.sgscmn(77)   # colormap: 

GGraph.vector( gp_u, gp_v, false, opt_vector)

# (2013-6-27 石渡) 仕方ないのでカラーバーは最後に出力
DCL.sgscmn(2)   # colormap: black-red-yellow-white
GGraph.color_bar('landscape'=>true, 'voff'=>0.03)

DCL.grcls

exit

# label of vector
# Ref.:
# * definition of unit_vect in dclext.rb
# * http://ruby.gfd-dennou.org/products/ruby-dcl/ruby-dcl-doc/grph1/node62.html

space = 0.0
vxuloc = vx1 + space
vyuloc = vy0 + space
rsizet = 0.017
index = 1

p xunit = (uxunit.to_f * 1e7).round / 1e7
p yunit = (uyunit.to_f * 1e7).round / 1e7

# mean
sfxunit = [xunit.to_s, "m s-1"].join(' ')
sfyunit = [yunit.to_s, "m s-1"].join(' ')

DCL.sgtxzv(vxuloc, vyuloc-1.2*rsizet,
           sfxunit, rsizet, 0, -1, index)

DCL.sgtxzv(vxuloc+2.5*rsizet, vyuloc+0.5*rsizet,
           sfyunit, rsizet, 90, -1, index)

DCL.grcls
