#! /usr/bin/ruby
# -*- coding: euc-jp -*-
#
# 2007/09/28 
# 2013/05/26 
#
# = fig_heatflux-lat-dependence.rb
# * ʿǮեåο
#
# == USAGE
#   % fig_heatflux-lat-dependence.rb --time_start=931 --time_end=1096 --range=0:400 lon=mean --wsn=2
#   % fig_heatflux-lat-dependence.rb --time_start=931 --time_end=1096 --range=0:400 lon=90 --wsn=2
#   % fig_heatflux-lat-dependence.rb --time_start=931 --time_end=1096 --range=0:400 lon=0:180 --wsn=2

require 'getoptlong'
require "numru/ggraph"
include NumRu

## 
latent_heat = 2.5e6

## ץ
parser = GetoptLong.new
parser.set_options(
                   ###    global option   ###
                   ['--lon',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--time_start',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--time_end',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--range',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--wsn',                      GetoptLong::REQUIRED_ARGUMENT]
                   )
parser.each_option do |name, arg|
  eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

wsn = ($OPT_wsn||4)

lon = ($OPT_lon||0).to_s

time_start = ($OPT_time_start||1).to_f
time_end = ($OPT_time_end||9999).to_f

range = ($OPT_range||'0:400')
min = range.split(':')[0].to_f
max = range.split(':')[1].to_f

## ǡɤ߹, ù
olr = GPhys::IO.open('OLR.nc', 'OLR')
slr = GPhys::IO.open('SLR.nc', 'SLR')
rain = GPhys::IO.open('Rain.nc', 'Rain')
evap = GPhys::IO.open('Evap.nc', 'Evap')
sens = GPhys::IO.open('Sens.nc', 'Sens')

if lon == 'mean' then
  olr = olr.cut('time'=>time_start..time_end).mean('time').mean('lon')
  slr = slr.cut('time'=>time_start..time_end).mean('time').mean('lon')

  rain = rain.cut('time'=>time_start..time_end).mean('time').mean('lon')
  rain = rain * latent_heat

  evap = evap.cut('time'=>time_start..time_end).mean('time').mean('lon')
  sens = sens.cut('time'=>time_start..time_end).mean('time').mean('lon')
elsif lon.include?(':') 
  lon_start = lon.split(':')[0].to_f
  lon_end = lon.split(':')[1].to_f

  olr = olr.cut('time'=>time_start..time_end, 'lon'=>lon_start..lon_end).mean('time').mean('lon')
  slr = slr.cut('time'=>time_start..time_end, 'lon'=>lon_start..lon_end).mean('time').mean('lon')

  rain = rain.cut('time'=>time_start..time_end, 'lon'=>lon_start..lon_end).mean('time').mean('lon')
  rain = rain * latent_heat

  evap = evap.cut('time'=>time_start..time_end, 'lon'=>lon_start..lon_end).mean('time').mean('lon')
  sens = sens.cut('time'=>time_start..time_end, 'lon'=>lon_start..lon_end).mean('time').mean('lon')

  p olr
  p evap



else
  lon = lon.to_f

  olr = olr.cut('time'=>time_start..time_end, 'lon'=>lon).mean('time')
  slr = slr.cut('time'=>time_start..time_end, 'lon'=>lon).mean('time')

  rain = rain.cut('time'=>time_start..time_end, 'lon'=>lon).mean('time')
  rain = rain * latent_heat

  evap = evap.cut('time'=>time_start..time_end, 'lon'=>lon).mean('time')
  sens = sens.cut('time'=>time_start..time_end, 'lon'=>lon).mean('time')
end

## 
DCL.gropn($OPT_wsn||4)

DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)

GGraph.set_fig( 'itr'=> 1, 'viewport'=>[0.2,0.8,0.3,0.6] )

GGraph.line( olr, true, "min"=>min, "max"=>max, "index"=>855, "annotate"=>false, "exchange"=>false, "title"=>"Heat flux")

GGraph.line( slr, false, "index"=>745 )
GGraph.line( rain, false, "index"=>255 )
GGraph.line( evap, false, "index"=>555 )
GGraph.line( sens, false, "index"=>405 )

DCL.grcls
