#! /usr/bin/ruby
# -*- coding: euc-jp -*-
#
# 2013/05/26 
#
# = fig_heatfluxA-lon-dependence.rb
# == 
#   ʿǮեåοޤ.
#   OLRA, SLRA, SSRA, SensA, EvapU, SurfH2OVapFluxU
#   .
#   OSRA Ƥʤ.
#
# == ץ
# --lat        ٤λ. ٤ͤ, mean ꤹ.
# --time_start ϻ
# --time_end   λ
# --range      ץåȤͤϰ. min:max Ȥǻꤹ.
# --wsn        . ps ä --wsn=2
#
# == USAGE
#   % fig_heatfluxA-lon-dependence.rb --time_start=731 --time_end=1096 --ragne=0:400 lat=mean --wsn=2
#   % fig_heatfluxA-lon-dependence.rb --time_start=731 --time_end=1096 --ragne=0:400 lat=0 --wsn=2

require 'getoptlong'
require "numru/ggraph"
include NumRu

## 
latent_heat = 2.5e6

## ץ
parser = GetoptLong.new
parser.set_options(
                   ###    global option   ###
                   ['--lat',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--time_start',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--time_end',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--range',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--wsn',                      GetoptLong::REQUIRED_ARGUMENT]
                   )
parser.each_option do |name, arg|
  eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

wsn = ($OPT_wsn||4)

lat = ($OPT_lat||0)

time_start = ($OPT_time_start||1).to_f
time_end = ($OPT_time_end||9999).to_f

range = ($OPT_range||'0:400')
min = range.split(':')[0].to_f
max = range.split(':')[1].to_f

## ǡɤ߹, ù
lat_weight = GPhys::IO.open('OLRA.nc', 'lat_weight').val
nlat = lat_weight.size

olr = GPhys::IO.open('OLRA.nc', 'OLRA')
slr = GPhys::IO.open('SLRA.nc', 'SLRA')
rain = GPhys::IO.open('Rain.nc', 'Rain')
h2oflux = GPhys::IO.open('SurfH2OVapFluxU.nc', 'SurfH2OVapFluxU')
evap = GPhys::IO.open('EvapU.nc', 'EvapU')
sens = GPhys::IO.open('SensA.nc', 'SensA')

olr = olr.cut('time'=>time_start..time_end).mean('time')
slr = slr.cut('time'=>time_start..time_end).mean('time')
rain = rain.cut('time'=>time_start..time_end).mean('time')
h2oflux = h2oflux.cut('time'=>time_start..time_end).mean('time')
evap = evap.cut('time'=>time_start..time_end).mean('time')
sens = sens.cut('time'=>time_start..time_end).mean('time')

p lat
if lat == 'mean' then
  olr = 0.5 * (olr*lat_weight.reshape(1, nlat)).sum('lat')
  slr = 0.5 * (slr*lat_weight.reshape(1, nlat)).sum('lat')
  rain = latent_heat * 0.5 * (rain*lat_weight.reshape(1, nlat)).sum('lat')
  h2oflux = latent_heat * 0.5 * (h2oflux*lat_weight.reshape(1, nlat)).sum('lat')
  evap = 0.5 * (evap*lat_weight.reshape(1, nlat)).sum('lat')
  sens = 0.5 * (sens*lat_weight.reshape(1, nlat)).sum('lat')
else
  lat = lat.to_f

  olr = olr.cut('lat'=>lat)
  slr = slr.cut('lat'=>lat)
  rain = latent_heat * rain.cut('lat'=>lat)
  h2oflux = latent_heat * h2oflux.cut('lat'=>lat)
  evap = evap.cut('lat'=>lat)
  sens = sens.cut('lat'=>lat)
end

## 
DCL.gropn($OPT_wsn||4)

DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)

GGraph.set_fig( 'itr'=> 1, 'viewport'=>[0.2,0.8,0.3,0.6] )

GGraph.line( olr, true, "min"=>min, "max"=>max, "index"=>855, "annotate"=>false, "exchange"=>false, "title"=>"Heat flux")

GGraph.line( slr, false, "index"=>745 )
GGraph.line( h2oflux, false, "index"=>265 )
GGraph.line( evap, false, "index"=>555 )
GGraph.line( sens, false, "index"=>405 )
GGraph.line( rain, false, "index"=>195 )

DCL.grcls

