#! /usr/bin/ruby
# -*- coding: utf-8 -*-
#
# 2015-11-21 石渡 ファイルの読みこみは
#
# 2015-07-09 石渡 緯度方向も領域切り出しができると良いのかもしれない.
#                 
# 2015-03-16 石渡 鉛直積算は全て make_vertinteg.rb でやるようにする.
#                 鉛直積算の計算を外して, 2 次元データの緯度平均を
#                 して図を描くこと
#                 だけやるようにする.
#                 ファイル名も fig_latmean.rb とする.
# 2015/02/19 石渡正樹 allocate memory error が出ないように改変.
#                     ファイルを出力してしまっているが, 
#                     ファイルを出力せずに図を描くようにしたい.
# 2014/10/03 石渡正樹
#
# = fig_horimean-timeseries.rb
# * 2 次元データの水平平均値を求める.
#
# == USAGE
#   % fig_horimean-timeseries.rb --var=SurfTemp --time_start=731 --time_end=1095 --wsn=2

# このスクリプトで描くもの
# 3次元データ 鉛直積算, lat mean, lon mean : t-phys
# 3次元データ σ指定,   lat mean, lon mean : t-phys
# 2次元データ lat mean, lon mean : t-phys

# 以下は別スクリプトで！(fig_lonmean-timeseries.rb)
# 3次元データ 鉛直積算, lon mean : t-y
# 3次元データ σ指定,   lon mean : t-y
# 2次元データ lon mean : t-y


require "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script/dcpam.rb"

require 'getoptlong'
require "numru/ggraph"
include NumRu

ITR=1

## 定数設定
Grav = 9.8
RPlanet = 6.371e6
Pi = 3.1415926535897932
GasRUniv = 8.3144621
MolWtDry = 28.9644e-3

GasRDry = GasRUniv / MolWtDry

## オプション解析
parser = GetoptLong.new
parser.set_options(
        ###    global option   ###
        ['--var',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--time_start',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--time_end',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--lon_start',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--lon_end',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--sig',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--range',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--wsn',                      GetoptLong::REQUIRED_ARGUMENT]
        )
parser.each_option do |name, arg|
  eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

if $OPT_var == nil then
  p '--var must be specified.'
  exit
end
variable = $OPT_var
ncfile = $OPT_var + '.nc'

wsn = ($OPT_wsn||4)

range = ($OPT_range||'0:100')
minval = range.split(':')[0].to_f
maxval = range.split(':')[1].to_f

time_start = ($OPT_time_start||1).to_f
time_end = ($OPT_time_end||9999).to_f

lon_start = ($OPT_lon_start||0).to_f
lon_end = ($OPT_lon_end||359).to_f

siglevel = ($OPT_sig||999).to_f


# ファイルの読み込みは open_gturl を使うようにしたい.
#gturl_var = "#{ncfile}@#{$OPT_var},time=#{time_start}:#{time_end}:#{time_intv}"
#gqv = GPhys::IO.open_gturl(gturl_var)


# データ入力
dir = "./"

gqv = gpopen dir + ncfile

sig = gpopen dir + ncfile,"sig"
lat = gpopen dir + ncfile,"lat"
lon = gpopen dir + ncfile,"lon"
sigm = gpopen dir + ncfile,"sigm"

sig_weight = gpopen dir + ncfile,"sig_weight"
lat_weight = gpopen dir + ncfile,"lat_weight"

return if gqv.nil?

# 座標値の格納
na_sig = sig.val
na_lon = lon.val
na_lat = lat.val

na_sig_weight = sig_weight.val
na_lat_weight = lat_weight.val

nsig = na_sig.size
nlon = na_lon.size
nlat = na_lat.size

gp_fig = gqv.cut('time'=>time_start..time_end)

p gp_fig

# 水平平均の計算
gp_fig = gp_fig * na_lat_weight.reshape(1, nlat) / na_lat_weight.sum
gp_fig = gp_fig.cut('lon'=>lon_start..lon_end).mean('lon').sum('lat')

# 描画
DCL.gropn(wsn)

vx0,vx1,vy0,vy1 = 0.15,0.85,0.2,0.55
GGraph.set_fig 'itr'=>ITR, 'viewport'=>[vx0,vx1,vy0,vy1]
DCL.ugpset('LUMSG', false)   # no message

#  DCL.sgpset('lfull', true)     # 全画面表示
#  DCL.sgpset('lcntl', true)

# オプションのデフォルト値の設定
opt = {
  'index'=>885,'max'=>maxval, 'min'=>minval, 'annotate'=>false, 'legend'=>false
  }

GGraph.line(gp_fig,true,opt)

DCL.grcls



