#! /usr/bin/ruby
# -*- coding: utf-8 -*-

# 陸惑星実験用描画スクリプト
# == 説明
# * このスクリプトは水平平均した物理量の時系列をかくものである.
# * 下にある omegas に描画する Omega の値のリストを設定する.
#
# == オプション
# --lon_start   経度の開始点
# --lon_end   経度の開始点
# --range      プロットする値の範囲. min:max という形式で指定する.
# --inclination      雲の消滅時間
# --wsn        出力先. pdf だったら --wsn=2
#
# == USAGE
#   % fig_lonmean_timeseries.rb --var SoilMoist --range=0:1000 --wsn 2
#
# == 履歴
# * 2013-6-19 石渡正樹 作成
# * 2014-04-22 石渡正樹 論文用の図の作成

require "./load_config.rb"

require "getoptlong"        # for option_parse
require "numru/ggraph"
include NumRu

DATA_HOME = "./"

TMPFILE = "dcl.pdf"

latent_heat = 2.5e6


## オプション解析
parser = GetoptLong.new
parser.set_options(
   ###    global option   ###
   ['--var',                    GetoptLong::REQUIRED_ARGUMENT],
   ['--var2',                    GetoptLong::REQUIRED_ARGUMENT],
   ['--time_start',               GetoptLong::REQUIRED_ARGUMENT],
   ['--time_end',                 GetoptLong::REQUIRED_ARGUMENT],
   ['--clrmap',                 GetoptLong::REQUIRED_ARGUMENT],
   ['--nlev',                 GetoptLong::REQUIRED_ARGUMENT],
   ['--interval',                 GetoptLong::REQUIRED_ARGUMENT],
   ['--lon_start',                   GetoptLong::REQUIRED_ARGUMENT],
   ['--lon_end',                   GetoptLong::REQUIRED_ARGUMENT],
   ['--lat_start',                   GetoptLong::REQUIRED_ARGUMENT],
   ['--lat_end',                   GetoptLong::REQUIRED_ARGUMENT],
   ['--inclination',                   GetoptLong::REQUIRED_ARGUMENT],
   ['--xtick',                   GetoptLong::REQUIRED_ARGUMENT],
   ['--ytick',                   GetoptLong::REQUIRED_ARGUMENT],
   ['--range',                    GetoptLong::REQUIRED_ARGUMENT],
   ['--factor',                    GetoptLong::REQUIRED_ARGUMENT],
   ['--factor2',                    GetoptLong::REQUIRED_ARGUMENT],
   ['--index',                    GetoptLong::REQUIRED_ARGUMENT],
   ['--index2',                    GetoptLong::REQUIRED_ARGUMENT],
   ['--exp_header',                    GetoptLong::REQUIRED_ARGUMENT],
   ['--image_header',                    GetoptLong::REQUIRED_ARGUMENT],
   ['--wsn',                      GetoptLong::REQUIRED_ARGUMENT]
)
parser.each_option do |name, arg|
  eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

wsn = ($OPT_wsn||1)

exp_header = ($OPT_exp_header||'LP_16p_Omg1.0_I23.5_S1800_W20cm')
image_header = ($OPT_image_header||'LP_16p_Omg1.0_I23.5_S1800_W20cm')
var = ($OPT_var||'SoilMoist')
var2 = ($OPT_var2||'')

time_start = ($OPT_time_start||0).to_f
time_end = ($OPT_time_end||800).to_f

time_interval = ($OPT_interval||40).to_f


lon_start = ($OPT_lon_start||0).to_f
lon_end = ($OPT_lon_end||364).to_f

clrmap = ($OPT_clrmap||9).to_f
nlev = ($OPT_nlev||30).to_f

xtick=($OPT_xtick||730).to_f
ytick=($OPT_ytick||5).to_f

factor=($OPT_factor||1).to_f
factor2=($OPT_factor2||1).to_f

index=($OPT_index||229).to_f
index2=($OPT_index2||889).to_f

title = ''

range = ($OPT_range||'0:10000')
VAL_MIN =  range.split(':')[0].to_f
VAL_MAX =  range.split(':')[1].to_f

# 出力ファイル名
#epsfn = "#{header}_#{var}_lonmean_lon#{lon_start}-#{lon_end}_timeseries#{time_start}-#{time_end}.eps"
if var2 == ''
  pngfn = "#{image_header}_#{var}_horimean_time#{time_start}-#{time_end}.png"
else  
  pngfn = "#{image_header}_#{var}-#{var2}_horimean_time#{time_start}-#{time_end}.png"
end

#time_interval = 40

file = var + '.nc'

gturls=[]
gturls2=[]

nexpnum = EXPNUMS.size

for i in 0..EXPNUMS.size-1
  p i
  gturls.push( GPhys::IO.open_gturl("#{exp_header}_#{EXPNUMS[i]}/#{var}.nc@#{var},time=#{DATA_TIME_RANGE[i]}:#{time_interval}") )
  p gturls
end

unless var2 == ''
  for i in 0..EXPNUMS.size-1
    gturls2.push( GPhys::IO.open_gturl("#{exp_header}_#{EXPNUMS[i]}/#{var2}.nc@#{var2},time=#{DATA_TIME_RANGE[i]}:#{time_interval}") )
  end
end


# 緯度平均用 lat 軸用意
lat = GPhys::IO.open("#{exp_header}_#{EXPNUMS[0]}/#{var}.nc", 'lat')
lat_weight = GPhys::IO.open("#{exp_header}_#{EXPNUMS[0]}/#{var}.nc", 'lat_weight')
na_lat = lat.val
na_lat_weight = lat_weight.val
nlat = na_lat.size

gp_result = GPhys.join(gturls)
unless var2 == ''
  gp_result2 = GPhys.join(gturls2)
end

p gp_result

#if var == 'EvapU' then
#  gphys = gphys / latent_heat
#end

# データの切り出し
gphys = gp_result.cut('time'=>time_start..time_end).cut('lon'=>lon_start..lon_end)
gphys = gphys * na_lat_weight.reshape(1, nlat) / na_lat_weight.sum
all = gphys.mean('lon').sum('lat')*factor

unless var2 == ''
  gphys2 = gp_result2.cut('time'=>time_start..time_end).cut('lon'=>lon_start..lon_end)
  gphys2 = gphys2 * na_lat_weight.reshape(1, nlat) / na_lat_weight.sum
  all2 = gphys2.mean('lon').sum('lat')*factor2
end

#p all

# トーンのカラーマップ
DCL.sgscmn(clrmap)   # colormap
#DCL.sgscmn(9)   # colormap: white-blue-black
#DCL.sgscmn(8)   # colormap: white-yellow-red-black
#DCL.sgscmn(2)   # colormap: black-red-yellow-white
#DCL.sgscmn(6)   # colormap: pastel_rainbow 薄すぎてダメ
#DCL.sgscmn(62)   # NCL:BlGrYeOrReVi200
#DCL.sgscmn(53)   # NCL:ncview_default
#DCL.sgscmn(55)   # NCL:rainbow
#DCL.sgscmn(54)   #   NCL:rainbow+white+gray


# 描画
DCL.gropn(wsn)
    
DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)

#GGraph.set_axes('xtickint'=>730, 'xlabelint'=>3650)
GGraph.set_axes('xtickint'=>xtick, 'xlabelint'=>xtick*5)
GGraph.set_axes('ytickint'=>ytick, 'ylabelint'=>ytick*10)
vx0,vx1,vy0,vy1 = 0.15,0.85,0.2,0.55
GGraph.set_fig 'viewport'=>[vx0,vx1,vy0,vy1]
DCL.uscset('cyspos', 'B' )              # move unit y axis
DCL.udlset('LMSG', false)
#DCL::uxmttl('T', '', 0.0)  # title (large character)
#DCL.ugpset('LUMSG', false)   # no message

opt_line = {
   'min'=>VAL_MIN, 'max'=>VAL_MAX,  
   'annotate'=>false,
   'title'=>title,
   'index'=>index
#   'xintv'=>200,
#   'yintv'=>1
}

opt_line2 = {
   'min'=>VAL_MIN, 'max'=>VAL_MAX,  
   'annotate'=>false,
   'title'=>title,
   'index'=>index2
#   'xintv'=>200,
#   'yintv'=>1
}

GGraph.line(all , true , opt_line)
unless var2 == ''
  GGraph.line(all2 , false , opt_line2)
end  

DCL.grcls

# 画像ファイルの変換
if wsn == '2' then
  if File.exist?(TMPFILE) then
    puts("MESSAGE: post processing ... #{pngfn} will be generate.")
    `#{SCRIPT_DIR}/conv_image.rb #{pngfn}`
  end
end

