#! /usr/bin/ruby
# -*- coding: euc-jp -*-

# Φ׻襹ץ
# == 
# * ΥץȤΦ¸η̤οޤΤǤ.
# * ΥץȤǤ, gpview, fig_heatflux-lat-dependence.rb ʤɤ
#   ץȤȤ.
# * Ѥˤ, fig_heatflux-lat-dependence.rb ʤɤǼ
#   ǥ쥯ȥꤹɬפ.
#   Τ, script_dir Ŭ񤭴ͤФʤʤ.
#
# == ץ
# --time_start ϻ
# --time_end   λ
# --wsn        . ps ä --wsn=2
# --prefix     եդƬ
#
# == USAGE
#   % fig_LandPlanet.rb --time_start=731 --time_end=1095 --wsn=2 --prefix=EXPNAME_
#
# == 
# * 2013-06-19  
# * 2015-12-03  


require "getoptlong"        # for option_parse
require "numru/ggraph"
include NumRu

script_dir = "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script"

## ץ
parser = GetoptLong.new
parser.set_options(
   ###    global option   ###
   ['--saturation_scheme',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--soilmoist_name',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--time_start',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--time_end',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--range_stream',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--range_soilmoist',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--cint_stream',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--range_q',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--cint_q',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--wsn',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--prefix',                      GetoptLong::REQUIRED_ARGUMENT]
                   )
parser.each_option do |name, arg|
    eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end


## Ʊž
minval_u = -70
maxval_u = 110
cint_u = 15
minval_v = -50
maxval_v = 50
cint_v = 10
#minval_q = 1e-19
#maxval_q = 1e-1
#cint_q = 5e-3


# Gray_MCA 
#minval_u = -10
#maxval_u = 40
#cint_u = 5
#minval_v = -20
#maxval_v = 20
#cint_v = 2
#minval_q = 1e-19
#maxval_q = 2e-2
#cint_q = 5e-4

wsn = ($OPT_wsn||1)

range_soilmoist = ($OPT_range_soilmoist||'0:20')

range_q = ($OPT_range_q||'1e-19:1e-1')
minval_q = range_q.split(':')[0].to_f
maxval_q = range_q.split(':')[1].to_f
cint_q = ($OPT_cint_q||5e-3).to_f

time_start = ($OPT_time_start||1).to_s
time_end = ($OPT_time_end||9999).to_s

timespan = time_start + ':' + time_end


# 


if File.exist?("#{$OPT_prefix}SoilMoist_lonmean-timemean#{time_start}-#{time_end}.png") then
  puts("MESSAGE: #{$OPT_prefix}SoilMoist_lonmean-timemean#{time_start}-#{time_end}.png exists. process skipped.")
else
  system("gpview SoilMoist.nc@SoilMoist,time=#{time_start}:#{time_end} --mean lon,time --range=#{range_soilmoist} --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb  #{$OPT_prefix}SoilMoist_lonmean-timemean#{time_start}-#{time_end}.png")
end

if File.exist?("#{$OPT_prefix}SoilMoist_lonmean-timeseries#{time_start}-#{time_end}.png") then
  puts("MESSAGE: #{$OPT_prefix}SoilMoist_lonmean-timeseries#{time_start}-#{time_end}.png exists. process skipped.")
else
  system("gpview SoilMoist.nc@SoilMoist,time=#{time_start}:#{time_end} --mean lon --range=#{range_soilmoist} --wsn=#{wsn} --noannotate --exch && #{script_dir}/conv_image.rb  #{$OPT_prefix}SoilMoist_lonmean-timeseries#{time_start}-#{time_end}.png")
end

if File.exist?("#{$OPT_prefix}SurfTemp_lonmean-timeseries#{time_start}-#{time_end}.png") then
  puts("MESSAGE: #{$OPT_prefix}SurfTemp_lonmean-timeseries#{time_start}-#{time_end}.png exists. process skipped.")
else
  system("gpview SurfTemp.nc@SurfTemp,time=#{time_start}:#{time_end} --mean lon --range=140:340 --sint=5.0 --exch --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb  #{$OPT_prefix}SurfTemp_lonmean-timeseries#{time_start}-#{time_end}.png")
end

if File.exist?("#{$OPT_prefix}PRCP_lonmean-timeseries#{time_start}-#{time_end}.png") then
  puts("MESSAGE: #{$OPT_prefix}PRCP_lonmean-timeseries#{time_start}-#{time_end}.png exists. process skipped.")
else
  system("gpview PRCP.nc@PRCP,time=#{time_start}:#{time_end} --mean lon --range=0:5e-5 --sint=1e-6 --exch --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb  #{$OPT_prefix}PRCP_lonmean-timeseries#{time_start}-#{time_end}.png")
end

if File.exist?("#{$OPT_prefix}RainEvap#{time_start}-#{time_end}.png") then
  puts("MESSAGE: #{$OPT_prefix}RainEvap#{time_start}-#{time_end}.png exists. process skipped.")
else
  system("/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script/fig_RainEvap-lat-dependence.rb --time_start=#{time_start} --time_end=#{time_end} --lon=mean --wsn=#{wsn} --range=0:40 && #{script_dir}/conv_image.rb  #{$OPT_prefix}RainEvap#{time_start}-#{time_end}.png")
end


exit

#L_Omega1.0_I23.44_10m_5_PRCP_lonmean-timeseries3286-3650.png:
#	gpview PRCP.nc@PRCP,time=3286:3650 --mean lon --wsn 2 --range=0:5e-5 --sint=1e-6 --exch --noannotate --nocont && convert -rotate 90 dcl.pdf L_Omega1.0_I23.44_10m_5_PRCP_lonmean-timeseries3286-3650.png

#L_Omega1.0_I23.44_10m_5_RainEvap3286-3650.png:
#	/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script/fig_RainEvap-lat-dependence.rb --time_start=3286 --time_end=3650 --lon=mean --wsn=1 --range=0:40 --wsn=2 && convert -rotate 90 dcl.pdf L_Omega1.0_I23.44_10m_5_RainEvap3286-3650.png
