#! /usr/bin/ruby
# -*- coding: utf-8 -*-

# For ONE physical quantity
# 2015-03-10
# 3d data vertical mean, lat mean, lon mean : t-phys
# 2d data lat mean, lon mean : t-phys
# 3d data vertical mean, lon mean : t-y
# 2d data lat mean : t-y


# 日射吸収量の計算
# == 説明
# * このスクリプトは同期回転惑星設定実験の結果の図を作成するものである.
# * このスクリプトでは, gpview, fig_heatflux-lat-dependence.rb などの
#   スクリプトが使われる.
# * 使用する場合には, fig_heatflux-lat-dependence.rb などを格納した
#   ディレクトリを指定する必要がある.
#   そのために, script_dir を適宜書き換えねばならない.
#
# == オプション
# --time_start 開始時刻
# --time_end   終了時刻
# --wsn        出力先. ps だったら --wsn=2
# --prefix     生成する画像ファイルに付ける接頭詞
#
# == USAGE
#   % fig_SyncRot.rb --time_start=731 --time_end=1095 --wsn=2 --prefix=EXPNAME_
#
# == 履歴
# * 2013-6-19 石渡正樹 作成


require "getoptlong"        # for option_parse
require "numru/ggraph"
include NumRu

script_dir = "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script"

## オプション解析
parser = GetoptLong.new
parser.set_options(
       ###    global option   ###
       ['--var',                      GetoptLong::REQUIRED_ARGUMENT],
       ['--lat_start',                      GetoptLong::REQUIRED_ARGUMENT],
       ['--lat_end',                      GetoptLong::REQUIRED_ARGUMENT],
       ['--time_start',                      GetoptLong::REQUIRED_ARGUMENT],
       ['--time_end',                      GetoptLong::REQUIRED_ARGUMENT],
       ['--wsn',                      GetoptLong::REQUIRED_ARGUMENT],
       ['--prefix',                      GetoptLong::REQUIRED_ARGUMENT]
                   )
parser.each_option do |name, arg|
    eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

VAL_MAX =  400
VAL_MIN =    0

wsn = ($OPT_wsn||4)

LatentHeat = 2.5e6
SBcoeff = 5.67e-8



flux = Hash.new

flux_all = Hash.new


wsn = ($OPT_wsn||4)


time_start = ($OPT_time_start||1)
time_end = ($OPT_time_end||9999)

lat_start = ($OPT_lat_start||1).to_f
lat_end = ($OPT_lat_end||9999).to_f

var = ($OPT_var||'OLRA')

nomega = 1



## データ読み込み, 加工
file = var + '.nc'
gp_olr = GPhys::IO.open(file, var).cut('time'=>time_start..time_end)

gp_olr_cut = gp_olr.cut('lat'=>lat_start..lat_end)


  # 重みデータの読み込み
  na_lat = GPhys::IO.open(file, 'lat').val
  lat_weight = GPhys::IO.open(file, 'lat_weight')

  lat_weight_cut= lat_weight.cut('lat'=>lat_start..lat_end)

  na_lat_weight_cut = lat_weight_cut.val

  
  nlat_cut = na_lat_weight_cut.size




  # 空間平均の計算 (OLR)
#  gp_olr_mean = gp_olr * na_lat_weight.reshape(1, nlat) / na_lat_weight.sum
  gp_olr_mean = gp_olr_cut * na_lat_weight_cut.reshape(1, nlat_cut) / na_lat_weight_cut.sum
  gp_olr_mean = gp_olr_mean.mean('lon').sum('lat')



# 描画
## 描画準備

DCL.gropn(wsn)
    
DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)
GGraph.set_fig( 'itr'=> 1, 'viewport'=>[0.2,0.8,0.3,0.6] )


GGraph.line( gp_olr_mean , true , 'index'=>285, 'max'=>VAL_MAX, 'min'=>VAL_MIN, 'annotate'=>false, 'title'=>'Heat flux')



DCL.grcls

