﻿#!/bin/bash

# 履歴
# (2013-9-21 石渡)
# オリジナルは draw_olr-horizontal_v.sh 
#
# 使い方
#   % fig_olr-horizontal_v.sh

# gif animation は, このスクリプトの実行後に
#   % convert -delay 50 -loop 0 Omega*_crop.gif anim.gif
# として作成した.



RUBY=ruby
SRC=olr-horizontal_v.rb
#SRC=trnsprt_t.rb
CONVERT="convert -rotate 90"

SCRIPT_DIR = "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script"

OUTFILE_FOOT=`basename ${SRC} .rb`

WSN=2

FACT_MEAN=0.0001      # (u,v)
#FACT_MEAN=0.1      # Qu
#FACT_MEAN=0.000005   # Tu

#UNIT_MEAN=0.03    # Qu
UNIT_MEAN=100    # Qu
#UNIT_MEAN=1e4   # Tu


#omegas="0.0 0.05 0.1 0.15 0.2 0.25 0.33 0.4 0.5 0.6 0.67 0.8 1.0"
#omegas="0.0 0.15 0.5 1.0"
omegas="0.15"

lon_cnts="000 010 020 030 040 050 060 070 080 090 100 110 120 130 140 150 160 170 180 190 200 210 220 230 240 250 260 270 280 290 300 310 320 330 340 350 360"
#lon_cnts="090"

### mean
for omega in ${omegas}; do
  for lon_cnt in ${lon_cnts}; do
#    ${RUBY} ${SCRIPT_DIR}/${SRC} \
    ${RUBY} /GFD_Dennou_Work3/momoko/SyncRotEarthRad/script/${SRC} \
	--omega ${omega} \
	--xfact1 ${FACT_MEAN} --yfact1 ${FACT_MEAN} \
	--uxunit ${UNIT_MEAN} --uyunit ${UNIT_MEAN} \
        --loncnt ${lon_cnt} \
	--wsn ${WSN}
    if [ -e dcl.ps ]; then
	name=Omega${omega}_${OUTFILE_FOOT}_${lon_cnt}all

# unit vector も書いた場合の処理
#       mv dcl.ps ${name}.ps
        # png ファイル作成
#	ps2png.rb ${name}.ps
        
        # gif ファイル作成 (動画用)
#        dclpsrot ${name}.ps > ${name}_rot.ps
        # そのまま gif に変換する場合
#        convert ${name}_rot.ps ${name}.gif
        # 中心部分だけ切りだし
#        convert -crop 250x250+255+210 ${name}_rot.ps ${name}_crop.gif
#        mogrify -format gif -crop 250x250+255+210 ${name}_rot.ps 


# unit vector を書かない場合の処理
        mv dcl.ps spherical-plot/${name}.ps

# 次だと背景が真っ黒になってしまう.
#	dclpsrmcm dcl.ps | dclpsrot | dclpsmargin > ${name}.eps
# 次だとまわりの部分が残ってしまう. かつ背景が真っ暗.
#	dclpsrmcm dcl.ps | dclpsrot > ${name}.eps
# 次だと本当の外側しかカットしてくれない. しかも, まわりは黒い.
#	dclpsrot ${name}.ps | dclpsmargin > ${name}.eps
#        convert ${name}.eps ${name}.gif

# 次の 3 行はなかなかうまくいったけど惑星が微妙に
# 動いてしまう.
#	dclpsrmcm  ${name}.ps | dclpsrot | dclpsmargin > ${name}_rot.ps
#        convert ${name}_rot.ps ${name}_rot.eps
#        convert ${name}_rot.eps ${name}_rot.gif

# 次の方法を採用
        dclpsrot spherical-plot/${name}.ps \
	| sed 's/%%BoundingBox: -1 -1 751 531/%%BoundingBox: 260 50 500 350/' \
        > spherical-plot/${name}_rot.ps
        convert spherical-plot/${name}_rot.ps spherical-plot/${name}_rot.gif

    fi
    rm -f dcl.ps
  done
done

rm -f dcl.ps
