#!/usr/bin/ruby
# -*- coding: utf-8 -*-


# v はartificial に 2 倍した.


# (2013-6-14 石渡)
# 球面プロットでカラーバーを書くとベクトルが表示されない!
# 矢印が太すぎるような気がする.

# わからん!!!


# /GFD_Dennou_Work3/momoko/SyncRotEarthRad/script/fig_ts-uv_for-display_flow-vect.rb --loncnt 45 --range_val 150:250 --wsn 2


DATA_HOME = "/GFD_Dennou_Work3/momoko/SyncRotEarthRad"

require "numru/ggraph"
include NumRu
require "pp"

wsn = 1

RPlanet = 6.371 * 10 ** 6  # [m]
#Ps = 1e5  # [Pa]
Grav = 9.8   # [m/s2]

title = ""

# SurfTempの描画範囲
# 絶対温度
#val_min = 225
#val_max = 315
# 摂氏
val_min = -58
val_max = 42
val_interval = (val_max - val_min) / 5.0
#YUNIT_vapor = 'kg m-2'
#epsfn = "qvap_area_column_mass.eps"

# 降水量の等値線間隔
cint_prcp = 1.0

# ベクトルの描画間隔 (単位は格子点数)
#xintv = 8
#yintv = 6
#xintv = 1
#yintv = 1
xintv = 4
yintv = 3

# 球面プロットと平面プロットの切り替えは
# この部分と下の設定部分を変更する.

ITR=30   # 球
#ITR=1   # 平面プロット

itr=30 # 球

lon_cont = 125 # 球のときに使用

#xfact1 = 0.01
#yfact1 = 0.01
xfact1 = 1.0
yfact1 = 1.0

time_start = 731
time_end   = 1095

dir = nil


# 簡易
while ARGV.size > 0
  case ARGV[0]
  when '--dir' then
    ARGV.shift
    dir = ARGV[0]
    ARGV.shift
  when '--wsn' then
    ARGV.shift
    wsn = ARGV[0]
    ARGV.shift
  when '--itr' then
    ARGV.shift
    itr = ARGV[0]
    ARGV.shift
  when '--xintv' then
    ARGV.shift
    xintv = ARGV[0]
    ARGV.shift
  when '--yintv' then
    ARGV.shift
    yintv = ARGV[0]
    ARGV.shift
  when '--xfact1' then
    ARGV.shift
    xfact1 = ARGV[0]
    ARGV.shift
  when '--yfact1' then
    ARGV.shift
    yfact1 = ARGV[0]
    ARGV.shift
  when '--uxunit' then
    ARGV.shift
    uxunit = ARGV[0]
    ARGV.shift
  when '--uyunit' then
    ARGV.shift
    uyunit = ARGV[0]
    ARGV.shift
  when '--loncnt' then
    ARGV.shift
    lon_cnt = ARGV[0]
    ARGV.shift
  when '--nomap' then
    ARGV.shift
    nomap = true
  when '--nomark' then
    ARGV.shift
    nomark = true
  when '--cint_prcp' then
    ARGV.shift
    cint_prcp = ARGV[0].to_f
    ARGV.shift
  when '--range_time' then
    ARGV.shift
    tmp = ARGV[0].split(':')
    time_start = tmp[0].to_f
    time_end   = tmp[1].to_f
    ARGV.shift
  when '--range_val' then
    ARGV.shift
    tmp = ARGV[0].split(':')
    val_min = tmp[0].to_f
    val_max = tmp[1].to_f
    ARGV.shift
    val_interval = (val_max - val_min) / 30.0
  else
    raise "ERROR: invalid option: #{ARGV[0]}"
  end
end





if dir == nil then
  dir = File.join(DATA_HOME,"ExpOcean")
end


# input
var = 'OLR'
#var = 'SurfTemp'
path = var+'.nc'
gp_olr = GPhys::IO.open(path, var).cut('time'=>time_start..time_end)

# 時間平均
gp_olr = gp_olr.mean('time')



# トーンのカラーマップ
#DCL.sgscmn(9)   # colormap: white-blue-black
#DCL.sgscmn(8)   # colormap: white-yellow-red-black
#DCL.sgscmn(2)   # colormap: black-red-yellow-white
#DCL.sgscmn(6)   # colormap: pastel_rainbow 薄すぎてダメ
#DCL.sgscmn(62)   # NCL:BlGrYeOrReVi200
#DCL.sgscmn(53)   # NCL:ncview_default	
#DCL.sgscmn(55)   # NCL:rainbow
#DCL.sgscmn(54)   #   NCL:rainbow+white+gray

#DCL.sgscmn(28)   # IDV:Basic->Bright38
#DCL.sgscmn(34)   # 
DCL.sgscmn(5)   #  グレースケール

# 描画
GGraph.set_map "grid"=>false
DCL.gropn(wsn)


DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)

GGraph.set_axes('xtickint'=>10, 'xlabelint'=>30)
GGraph.set_axes('ytickint'=>10, 'ylabelint'=>30)

if itr == '30' then
  # 球の時 (平面プロットの時は 下の 2 行をコメントアウトするだけ)
  GGraph.set_fig 'itr'=>itr.to_i, 'viewport'=>[0.15,0.95,0.2,0.8], 'map_axis'=>[lon_cnt, 0, 0]
  GGraph.set_fig 'viewport'=>[0.15,0.95,0.2,0.8]
elsif itr == '1' 
  vx0,vx1,vy0,vy1 = 0.1,0.9,0.1,0.9
  GGraph.set_fig 'itr'=>itr.to_i, 'viewport'=>[vx0,vx1,vy0,vy1], 'map_axis'=>[lon_cnt, 0, 0]
end

DCL.uscset('cyspos', 'B' )              # move unit y axis

DCL.udlset('LMSG', false)

DCL.ugpset('XFACT1', xfact1)
DCL.ugpset('YFACT1', yfact1)
DCL.ugpset('UXUNIT', uxunit) # size of unit vector by dimentional value
DCL.ugpset('UYUNIT', uyunit)
DCL::ugrset('VXUNIT', 0.1)  # size of unit vector
DCL::ugrset('VYUNIT', 0.1)

DCL::uxmttl('T', '', 0.0)  # title (large character)

DCL.ugpset('LNRMAL', false)  # scale vector automatically
#DCL.ugpset('LMSG', false)   # no message
DCL.ugpset('LUMSG', false)   # no message

#DCL.ugpset('INDEX', 959)
DCL.ugpset('INDEX', 955)
#DCL.ugpset('INDEX', 5)



opt_tone = {
   'min'=>val_min, 'max'=>val_max,  
   'title'=>'',
   'nlev'=>60,
   'annotate'=>false
}





# 海岸線
unless(nomap) then
  GGraph.set_map "coast_world"=>true
#  GGraph.set_map "grid"=>false
end


GGraph.tone( gp_olr, true, opt_tone)


# 太陽直下点にマーカーを打つ
unless(nomark) then
  xmark = [90.0]
  ymark = [0.0]
  # マークの種類: 5 は×, 10 は●
  #DCL.uusmkt( 5 )
  DCL.uusmkt( 10 )
  # マークの線の太さ
  #DCL.uusmki( 9 )
  DCL.uusmki( 728 )
  # マークの大きさ
  DCL.uusmks( 0.03 )
  # マークのプロット
  if lon_cnt.to_f < 181 then
    DCL.uumrk( xmark, ymark)
  end
end

# (2013-6-27 石渡) 仕方ないのでカラーバーは最後に出力
DCL.sgscmn(34)   # colormap: black-red-yellow-white
GGraph.color_bar('landscape'=>true, 'voff'=>0.03, 'tickintv'=>0)

DCL.grcls

exit

