#! /usr/bin/ruby
# -*- coding: utf-8 -*-

# 同期回転惑星計算用描画スクリプト
# == 説明
# * このスクリプトは同期回転惑星設定実験の結果の図を作成するものである.
# * このスクリプトでは, gpview, fig_heatflux-lat-dependence.rb などの
#   スクリプトが使われる.
# * 使用する場合には, fig_heatflux-lat-dependence.rb などを格納した
#   ディレクトリを指定する必要がある.
#   そのために, script_dir を適宜書き換えねばならない.
#
# == オプション
# --time_start 開始時刻
# --time_end   終了時刻
# --wsn        出力先. ps だったら --wsn=2
# --prefix     生成する画像ファイルに付ける接頭詞
#
# == USAGE
#   % fig_SyncRot.rb --time_start=731 --time_end=1095 --wsn=2 --prefix=EXPNAME_
#
# == 履歴
# * 2013-6-19 石渡正樹 作成


require "getoptlong"        # for option_parse
require "numru/ggraph"
include NumRu

script_dir = "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script"

## オプション解析
parser = GetoptLong.new
parser.set_options(
                   ###    global option   ###
                   ['--time_start',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--time_end',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--region',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--wsn',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--prefix',                      GetoptLong::REQUIRED_ARGUMENT]
                   )
parser.each_option do |name, arg|
    eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

VAL_MAX =  400
VAL_MIN =    0

wsn = ($OPT_wsn||4)

LatentHeat = 2.5e6

flux = Hash.new

flux_all = Hash.new
flux_east = Hash.new
flux_west = Hash.new

vars = [
        {'name'=>'OLRA'},
        {'name'=>'EvapU'},
        {'name'=>'Rain'},
        {'name'=>'SensA'},
        {'name'=>'OSRA'},
        {'name'=>'SLRA'},
        {'name'=>'SurfH2OVapFluxU'}
       ]


wsn = ($OPT_wsn||4)

region = ($OPT_region||all)

time_start = ($OPT_time_start||1)
time_end = ($OPT_time_end||9999)

nomega = 1

# 各変数で回す
for v in vars

  var = v['name']

  ## データ読み込み, 加工
  file = var + '.nc'
  gphys = GPhys::IO.open(file, var)
  if var == 'Rain' then
    gphys = gphys*LatentHeat
  end

  # 重みデータの読み込み
  na_lon = GPhys::IO.open(file, 'lon').val
  na_lat = GPhys::IO.open(file, 'lat').val
  na_lat_weight = GPhys::IO.open(file, 'lat_weight').val
  nlon = na_lon.size
  nlat = na_lat.size

  # 時間方向の切り出し
  gphys = gphys.cut('time'=>time_start..time_end)

  # 空間平均の計算
  gphys = gphys * na_lat_weight.reshape(1, nlat) / na_lat_weight.sum

#  all = gphys.mean('lon').sum('lat').val
#  west = gphys.cut('lon'=>na_lon[0]..na_lon[nlon/2 -1]).mean('lon').sum('lat').val
#  east = gphys.cut('lon'=>na_lon[nlon/2]..na_lon[nlon-1]).mean('lon').sum('lat').val

  all = gphys.mean('lon').sum('lat')
  west = gphys.cut('lon'=>na_lon[0]..na_lon[nlon/2 -1]).mean('lon').sum('lat')
  east = gphys.cut('lon'=>na_lon[nlon/2]..na_lon[nlon-1]).mean('lon').sum('lat')

  p all

## check
#    p all - (west + east)/2.0

    flux_all[var] = all
    flux_east[var] = east
    flux_west[var] = west

  # 領域平均値の計算
#  case var
#  when 'OLRA'
#    flux_all[var] = 1.0 * all
#    flux_east[var] = 1.0 * east
#    flux_west[var] = 1.0 * west
#  when 'OSRA'
#    flux_all[var] = -1.0 * all
#    flux_east[var] = -1.0 * east
#    flux_west[var] = -1.0 * west
#  when 'EvapU'
#    flux_all[var] = 1.0 * all
#    flux_east[var] = 1.0 * east
#    flux_west[var] = 1.0 * west
#  else
#    flux_all[var] = all
#    flux_east[var] = east
#    flux_west[var] = west
#  end

end

# 描画
## 描画準備

#  opt = {
#    'max'=>VAL_MAX, 'min'=>VAL_MIN,
#    'annotate'=>false,
#    'title'=>'Heat flux'
#  }

DCL.gropn(wsn)
    
DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)
GGraph.set_fig( 'itr'=> 1, 'viewport'=>[0.2,0.8,0.3,0.6] )

if region == 'all' then
    GGraph.line( flux_all['OLRA'] , true , 'index'=>885, 'max'=>VAL_MAX, 'min'=>VAL_MIN, 'annotate'=>false, 'title'=>'Heat flux')
#, 'long_name'=>'Heat flux')
    GGraph.line( flux_all['EvapU'], false, "index"=>555 )
    GGraph.line( flux_all['Rain'], false, "index"=>265 )
    GGraph.line( flux_all['SensA'], false, "index"=>405 )
#    GGraph.line( flux_all['OSRA'], false, "index"=>405 )
    GGraph.line( flux_all['SLRA'], false, "index"=>745 )
elsif region == 'east' then
    GGraph.line( flux_east['OLRA'] , true , 'index'=>885, 'max'=>VAL_MAX, 'min'=>VAL_MIN, 'annotate'=>false, 'title'=>'Heat flux')
#, 'long_name'=>'Heat flux')
    GGraph.line( flux_east['EvapU'], false, "index"=>555 )
    GGraph.line( flux_east['Rain'], false, "index"=>265 )
    GGraph.line( flux_east['SensA'], false, "index"=>405 )
#    GGraph.line( flux_east['OSRA'], false, "index"=>405 )
    GGraph.line( flux_east['SLRA'], false, "index"=>745 )
elsif region == 'west' then
    GGraph.line( flux_west['OLRA'] , true , 'index'=>885, 'max'=>VAL_MAX, 'min'=>VAL_MIN, 'annotate'=>false, 'title'=>'Heat flux')
#, 'long_name'=>'Heat flux')
    GGraph.line( flux_west['EvapU'], false, "index"=>555 )
    GGraph.line( flux_west['Rain'], false, "index"=>265 )
    GGraph.line( flux_west['SensA'], false, "index"=>405 )
#    GGraph.line( flux_west['OSRA'], false, "index"=>405 )
    GGraph.line( flux_west['SLRA'], false, "index"=>745 )
else
    p 'region is invalid value!'
end

DCL.grcls

