# -*- coding: utf-8 -*-
############################################################

=begin
=method for class NumRu::GPhys and  NumRu::GphysFunc in libgphys-momoko.rb

==History
* D. Tsukahara
  copied from /GFD_Dennou_Work11/dcchart/atmos_global/bin/libgphys-n.rb

==Index
* ((<class NumRu::GPhys (methods added)>))
  * ((<make_h2oliq_mask(p_gphys,threshold)>))
    引数 p_geophys に与えた鉛直積算雲水量の gphys オブジェクトから,
    self のgphys オブジェクトと同じ配列構造をもつ, 
    3 次元のマスク gphys オブジェクトを作成する.
    閾値 threshold より大きい値を持つ領域を切り出すためにマスクを作成.
  * ((<save(output, global_attr=nil, vname=nil, var_attr=nil, history=$history, new_vname=nil)>))
    GPhys オブジェクトを netCDF ファイルに保存.

* other meshod
  * ((<global_attr(nc_file)>))
    * nc_file で指定した netCDF ファイルの大域属性を返す
=end

require "numru/ggraph"
require "numru/netcdf_miss"
require "date"
include NumRu


class GPhys
#------------------------------------------------------------------------------#

  def make_h2oliq_mask(p_gphys,threshold)

    raise ArgumentError,"Self GPhys rank must have dimentions, longitude, latitu
de, time ." if ! p_gphys.is_a?(GPhys)
    raise ArgumentError,"Arg is not GPhys." if ! p_gphys.is_a?(GPhys)
    raise ArgumentError,"Arg's dimention is not 2nd order" if ! p_gphys.rank==2

    p_data = p_gphys.data.val
    data = self.data.val.dup
    grid = self.grid

    axs = grid.shape[0]
    ays = grid.shape[1]
    ats = grid.shape[2]

#    p threshold
#    p axs
#    p ays
#    p ats

#   全ての変数についてループを回す
#    0.upto(axs-1) do |x|
#      0.upto(ays-1) do |y|
#        0.upto(ats-1) do |t|
#          if p_data[x,y,t] > threshold then
#            data[x,y,t] = 1.0
#          else
#            data[x,y,t] = 0.0
#          end
#        end
#      end
#    end

#   メソッド使ってみる
#    data[true,true,true] = (p_data[true,true,true].ge threshold)
    data = (p_data.ge threshold)

    mask = data
    gtmask = GPhys.new(grid, VArray.new(mask,
                                        {"long_name"=>"vertint h2oliq mask"},
                                        "vertint_h2oliq_mask")
                       )
    return gtmask
  end


#------------------------------------------------------------------------------#

  # gphys オブジェクトを nc ファイルに保存するメソッド
  def save(output, global_attr=nil, vname=nil, var_attr=nil, history=$history, new_vname=nil)

    if !vname
      vname = self.data.name
    end

    if File.exist?(output)
      nc = NetCDF.open(output, 'a+')
    else
      nc = NetCDF.open(output, 'w')
    end
    GPhys::IO.write(nc, self)
    nc.close

    nc = NetCDF.open(output, "a+")
    nc.redef                      # define mode に移行

    # 大域属性付加
    global_attr.to_a.each {|attr| 
      nc.put_att(attr[0], attr[1]) if attr[1]
    } if global_attr
    # 変数名変更
    if new_vname && vname
      nc.var(vname).name=new_vname 
      vname = new_vname
    end
    # 変数属性付加
    if var_attr
      var_attr.to_a.each {|attr|
	nc.var(vname).put_att(attr[0], attr[1])
      }   
    end  
    # history 付加
    now_hist = global_attr["history"]
    if now_hist then
      hist = now_hist + "\n" + history
      nc.put_att("history", hist)
    else
      nc.put_att("history", history)
    end

    nc.close

    return "saved as #{output}"

  end

  # 座標, データ操作ログ記録関数の定義 (Grid.lost_axes 参照.) <やまだ由さんのルーチンを拝借>
  def add_lost_axes( lost )
    GPhys.new( @grid.copy.add_lost_axes( lost.to_a ), @data)
  end
  def set_lost_axes( lost )
    GPhys.new( @grid.copy.set_lost_axes( lost.to_a ), @data)
  end

  # rename 再定義 (gphys class を返す)
  def rename(name)
    GPhys.new(@grid,@data.copy.rename(name))
  end

  # attribute 再定義 (gphys class 返す)
  def set_att(name,val)
    GPhys.new(@grid,@data.copy.set_att(name,val))
  end

end

def global_attr(ncfile)
  global_attr = Hash.new

  nc = NetCDF.open(ncfile, "r")
  nc.att_names.each do |attr| 
    global_attr[attr] = nc.att(attr).get
  end
  return global_attr
end


