#!/usr/bin/env ruby

require "optparse"
require "yaml"
require "numru/ggraph"
include NumRu

CONFIGFILE = "./config.yml"

#DATA_HOME = "/home/noda/data/exps_101220_diff_T21L16_sr_Omega_sweep"
#DIR_HEADER = "101220_diff-DryAir-Vapor_T21L16_sr_Omega"
#DIR_FOOTER = "_dt20m"

DATA_HOME = "/GFD_Dennou_Work10/momoko/SyncRotEarthRad-2"
DIR_HEADER = "SR_CLT1500_Omega1.0_S"
DIR_FOOTER = "_T42L26"


#DATA_HOME_ENS = "/home/noda/data/exps_101220_diff-DryAir-Vapor_T21L16_sr_ensemble"
#DIR_HEADER_ENS = "101220_diff-DryAir-Vapor_T21L16_sr_Omega"
#DIR_FOOTER_ENS = "E_rndTemp_"

CONFIG = YAML.load( File.read(File.join(File.dirname(__FILE__), CONFIGFILE)) )
#CONFIG = YAML.load( File.read( CONFIGFILE ) )

def omegas
  CONFIG["omegas"]
end

def solcons
#  CONFIG["solcons"]
  [1366, 1700, 1800]
end

def nomega
  omegas.size
end

def nsolcon
  solcons.size
end

def exp_dirs
  exp_dirs = Hash.new

#  omegas.each{|omega|
#    exp_dirs[omega] = File.join(DATA_HOME, DIR_HEADER + omega.to_s + DIR_FOOTER)
#  }

  solcons.each{|solcon|
    exp_dirs[solcon] = File.join(DATA_HOME, DIR_HEADER + solcon.to_s + DIR_FOOTER)
  }

  # change to ensemble data
#  exp_dirs[0.7] = File.join(DATA_HOME_ENS, DIR_HEADER_ENS + '0.7' + DIR_FOOTER_ENS + '009')
#  exp_dirs[0.75] = File.join(DATA_HOME_ENS, DIR_HEADER_ENS + '0.75' + DIR_FOOTER_ENS + '009')
#  exp_dirs[0.85] = File.join(DATA_HOME_ENS, DIR_HEADER_ENS + '0.85' + DIR_FOOTER_ENS + '009')
  exp_dirs
end


# gphys
#def axis_omega
#  omega_long_name = DCL::csgi(151)+'|*"'
#  va_omega = VArray.new( NArray.to_na(omegas),
#                         {
#                           "long_name"=>CONFIG["omega_long_name"],
#                           "units"=>""
#                         },
#                         CONFIG["omega_name"] 
#                         )
#  axis_omega = Axis.new.set_pos(va_omega)
#end



# ----- all ---------------------------

def omegas_all
  CONFIG["omegas_all"]
end

def exp_all_dirs
  exp_all_dirs = Hash.new
  omegas.each{|omega|
    exp_all_dirs[omega] = File.join(DATA_HOME, DIR_HEADER + omega.to_s + DIR_FOOTER)
  }
  exp_all_dirs
end
