#!/usr/bin/env ruby

require "optparse"
require "yaml"
require "numru/ggraph"
include NumRu

CONFIGFILE = "./config.yml"

#DATA_HOME = "/home/noda/data/exps_101220_diff_T21L16_sr_Omega_sweep"
#DIR_HEADER = "101220_diff-DryAir-Vapor_T21L16_sr_Omega"
#DIR_FOOTER = "_dt20m"

DATA_HOME = "/GFD_Dennou_Work10/momoko/SyncRotEarthRad-2"
DIR_HEADER = "SR_CLT1500_Omega1.0_S"
DIR_FOOTER = "_T42L26"

CONFIG = YAML.load( File.read(File.join(File.dirname(__FILE__), CONFIGFILE)) )
#CONFIG = YAML.load( File.read( CONFIGFILE ) )

def parms
  [1366, 1700, 1800]
end

#----------------------------------------------------------------

def omegas
  CONFIG["omegas"]
end

def solcons
  [1366, 1700, 1800]
end

def nomega
  omegas.size
end

def nsolcon
  solcons.size
end

def nparm
  parms.size
end

def exp_dirs
  exp_dirs = Hash.new

#  omegas.each{|omega|
#    exp_dirs[omega] = File.join(DATA_HOME, DIR_HEADER + omega.to_s + DIR_FOOTER)
#  }

  parms.each{|parm|
    exp_dirs[parm] = File.join(DATA_HOME, DIR_HEADER + parm.to_s + DIR_FOOTER)
  }

  exp_dirs
end


