#! /usr/bin/ruby
#coding: utf-8

# LP シリーズ用

# 雛型となる thum.txt を読み込んで画像ファイル名の置換を
# おこなう.
# 画像ファイル名は (実験名)_(物理量と説明).[png, gif]
# という形式であるとする.
#
# thum.txt を作成するディレクトリ (thum-src/ ディレクトリ) で実行する.
# ディレクトリ構造として, (実験名)/thum-src/ となっていることを仮定する.
# ファイル名中の最初のアンダースコアの前の部分を 1 つ上のディレクトリ名
# (実験名と同じものになっていることを仮定)
# で置き換える
#
# (実験ディレクトリ)/Mkinclude を読み込む.


#== オプション
#   無し

#== 実行方法
#   % make-thum-txt.rb

#== 参考文献・URL
# * http://d.hatena.ne.jp/jun-yoshida/20060825/1156463224

# 履歴
# * 2013-07-16 石渡 作成

# テンプレートファイル中で指定されいる実験名. 適宜, ここも書き換えること.
#template_exp_name = "SR_CLT1800_Omega1.0_20140630-2"
template_exp_name = "LP_W20cm_I23.5_Omg1.0_S1366"

template_endtime = "25550.0"
template_last_year_start = "25186.0"
template_last_year_end = "25550.0"
template_anim_start = "25531.0"
template_anim_end = "25550.0"


# 出力ファイル名
output_file = "thum.txt"

base_dir = "/GFD_Dennou_Work10/momoko/LandPlanet/2017-12-30_momoko/"
path_to_thum_txt = "/thum-src/thum.txt"

template_file = base_dir + template_exp_name + path_to_thum_txt


# 実験名 (1 つ上のディレクトリ名) の取得
exp_name = Dir::pwd.split("/")[-2]

#p exp_name
#p template_exp_name
#p template_file

exp_dir = "../../../"+exp_name

p exp_dir

mkinclude_file = exp_dir+"/Mkinclude"

open(mkinclude_file){ |l|
  while line = l.gets
    if /ANIM_START/ =~ line.to_s
      ANIM_START = line.gsub(" ","").gsub("\n","").split("=")[1]
    end
    if /ANIM_END/ =~ line.to_s
      ANIM_END = line.gsub(" ","").gsub("\n","").split("=")[1]
    end
    if /ENDTIME/ =~ line.to_s
      ENDTIME = line.gsub(" ","").gsub("\n","").split("=")[1]
    end
    if /LAST_YEAR_START/ =~ line.to_s
      LAST_YEAR_START = line.gsub(" ","").gsub("\n","").split("=")[1]
    end
    if /LAST_YEAR_END/ =~ line.to_s
      LAST_YEAR_END = line.gsub(" ","").gsub("\n","").split("=")[1]
    end
  end
}

#p ANIM_START, ANIM_END, ENDTIME, LAST_YEAR_START, LAST_YEAR_END


if exp_name == template_exp_name then
  print "Here is template directory. Nothing will be done!!\n"
else
  open(template_file){ |f|
    open(output_file,"w"){ |o|
      while line = f.gets
        line.gsub!(template_exp_name,exp_name)
        line.gsub!(template_endtime,ENDTIME)
        line.gsub!(template_last_year_start,LAST_YEAR_START)
        line.gsub!(template_last_year_end,LAST_YEAR_END)
        line.gsub!(template_anim_start,ANIM_START)
        line.gsub!(template_anim_end,ANIM_END)
        o.puts line
        end
    }
  }
end

