#!/usr/bin/ruby
# -*- coding: utf-8 -*-

# 2014/09/14 Ishiwatari

# 温位の計算
# GPhys の PV 計算モジュールを使用


require "numru/ganalysis"
require "numru/ggraph"
include NumRu
require "pp"

wsn = 4

RPlanet = 6.371 * 10 ** 6  # [m]
Grav = 9.8   # [m/s2]

PI=3.141592

title = ""

# vapor の描画範囲
val_min = 0
val_max = 3e9
#val_interval = (val_max - val_min) / 30.0
val_interval = 1e8

#ITR=30   # 球
ITR=1   # 平面プロット

LON_CNT=125  # 球のときに使用

time_start = 0
time_end   = 9999

omega = 7.292106590880652e-5

dir = nil

# 簡易
while ARGV.size > 0
  case ARGV[0]
  when '--omega' then
    ARGV.shift
    omega = ARGV[0]
    ARGV.shift
  when '--wsn' then
    ARGV.shift
    wsn = ARGV[0]
    ARGV.shift
  when '--xintv' then
    ARGV.shift
    xintv = ARGV[0]
    ARGV.shift
  when '--yintv' then
    ARGV.shift
    yintv = ARGV[0]
    ARGV.shift
  when '--range_time' then
    ARGV.shift
    tmp = ARGV[0].split(':')
    time_start = tmp[0].to_f
    time_end   = tmp[1].to_f
    ARGV.shift
  when '--range_val' then
    ARGV.shift
    tmp = ARGV[0].split(':')
    val_min = tmp[0].to_f
    val_max = tmp[1].to_f
    ARGV.shift
  when '--cint' then
    ARGV.shift
    val_interval = ARGV[0]
    ARGV.shift
  else
    raise "ERROR: invalid option: #{ARGV[0]}"
  end
end

dir='.'

# データ読み込み
path = File.join(dir, 'U.nc')

var = 'Temp'
path = File.join(dir, var+'.nc')
gp_temp = GPhys::IO.open(path, var).cut('time'=>time_start..time_end)

lon  = GPhys::IO.open(path, 'lon')
lat  = GPhys::IO.open(path, 'lat')
sig  = GPhys::IO.open(path, 'sig')
time = GPhys::IO.open(path, "time").cut('time'=>time_start..time_end)

nlon  = lon.val.size
nlat  = lat.val.size
nsig  = sig.val.size
ntime = time.val.size

var = 'Ps'
path = File.join(dir, var+'.nc')
gp_ps = GPhys::IO.open(path, var).cut('time'=>time_start..time_end)

na_gp_ps = gp_ps.val
na_sig = sig.val

dir = './'
ofile = NetCDF.create(dir + 'PotTemp.nc')

# 時間ループ
GPhys::NetCDF_IO.each_along_dims_write([gp_ps,gp_temp], ofile, 'time') { 
  |ps,temp|  

  # 気圧の計算
  na_ps = ps.val

  gp_press = temp.copy
  gp_press.val = na_ps.reshape(nlon, nlat ,1, 1) * na_sig.reshape(1, 1 ,nsig, 1)
  gp_press.units = 'Pa'

  pottemp = GAnalysis::Met.temp2theta(temp,prs=gp_press)

  [pottemp]
}
ofile.close


exit

pressure = NArray.sfloat(nlon,nlat,nsig,ntime).fill(0.0)

for i in 0..nlon-1
  for j in 0..nlat-1
    for k in 0..nsig-1
      for t in 0..ntime-1
        pressure[i,j,k,t] = na_gp_ps[i,j,t]*na_sig[k]
      end
    end
  end
end

gp_press = VArray.new( pressure,
                   {"long_name"=>"Pressure", "units"=>"Pa"},
                   "Pressure" )

theta = GAnalysis::Met.temp2theta(gp_temp,prs=gp_press)

gp_theta_mean = theta.mean('time').mean('lon')



# 描画
DCL.gropn(wsn)

DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)

GGraph.set_axes('xtickint'=>10, 'xlabelint'=>30)
GGraph.set_axes('ytickint'=>10, 'ylabelint'=>30)

# same as gpview
vx0,vx1,vy0,vy1 = 0.15,0.85,0.2,0.55
GGraph.set_fig 'itr'=>ITR, 'viewport'=>[vx0,vx1,vy0,vy1], 'map_axis'=>[LON_CNT, 0, 0]

DCL.uscset('cyspos', 'B' )              # move unit y axis

DCL.udlset('LMSG', false)

DCL::uxmttl('T', '', 0.0)  # title (large character)

#DCL.ugpset('LNRMAL', false)  # scale vector automatically
DCL.ugpset('LUMSG', false)   # no message

DCL.ugpset('INDEX', 9)

opt_contour = {
  'min'=>val_min, 'max'=>val_max, 'interval'=>val_interval,
  'title'=>title, 'annotate'=>false
}

GGraph.tone_and_contour( gp_theta_mean, true, opt_contour)
GGraph.color_bar('landscape'=>true)

DCL.grcls
