﻿#!/usr/bin/env ruby
# -*- coding: utf-8 -*-

require 'optparse'
require '../load_config_diff_sr'

#VIEWPORT = [0.15,0.85,0.2,0.55]  # gpview
VIEWPORT = [0.15,0.70,0.3,0.65]

wsn = 2
#configfile = nil

figname = `basename #{$0} .rb`.chomp   # 拡張子は自動付加される

val_min = 200
val_max = 450

# parse commandline options
opt = OptionParser.new
#opt.on('--conf VAL') {|v| configfile = v.to_s}
opt.on('--wsn VAL') {|v| wsn = v.to_i}
#opt.on('--help', '-h') {|v| usage; exit 0}
opt.parse!(ARGV)


def multiline(lines)

  lines.each_with_index{|line, i|
    # set options
    gp = line['gphys']

    # GGraph.line メソッドに渡すオプション
p    opts_ggraph = line['opts_ggraph']
    # このスクリプトで解釈するオプション
p    opts = line['opts']

    # 凡例の内容書き換えなど, GGraph では効かないものの設定

    newframe = false
    if i == 0 then
      newframe = true 
      if opts['itr'] then
        GGraph.set_fig('itr'=>opts['itr'].to_i)
      end
    end


    opts_ggraph['type'] = 1 if (not opts_ggraph['type'])
    opts_ggraph['index'] = 10*i+19 if (not opts_ggraph['index'])

    # draw
    GGraph.line(gp, newframe, opts_ggraph)


    # legend
    legend_str = "data" + i.to_s

    opts = line['opts']
    if opts.class == Hash then
      legend_str = (opts['legend_str'].to_s or "hoge")
    end
    
    opts_legend = Hash.new
#    opts_legend['type'] = (opts_ggraph['type'] or i+1)
    opts_legend['type'] = (opts_ggraph['type'] or 1)
    opts_legend['index'] = (opts_ggraph['index'] or 10*i+15)
    opts_legend['legend_size'] = 0.02
#    opts_legend['legend_vx'] = 0.87
    opts_legend['legend_vx'] = VIEWPORT[1] + 0.02
    opts_legend['legend_dx'] = 0.05
    opts_legend['legend_vy'] = 0.65 - (0.03 * i)

    DCLExt::legend(legend_str, opts_legend['type'],opts_legend['index'],true,
                   opts_legend['legend_size'],opts_legend['legend_vx'],
                   opts_legend['legend_dx'],
                   opts_legend['legend_vy'], true)
  }

end


def conv_eps(name)
  psfile = "./dcl.ps"
  raise "No file: #{psfile}" if ! File.exist?(psfile)
  if File.exist?(psfile) then
    #    ${PS2EPS} ${name}.ps ${name}.eps
    #    dclpsrmcm ${name}.ps | dclpsrot | dclpsmargin > ${name}.eps
    system "dclpsrmcm #{psfile} | dclpsrot | dclpsmargin > #{name}.eps"
#      | sed 's/%%BoundingBox: 17 25 676 421/%%BoundingBox: 0 25 750 421/' \
#      | sed 's/%%BoundingBox: 33 25 675 421/%%BoundingBox: 0 25 750 421/' \
  end
end

def conv_png(name)
  psfile = "./dcl.ps"
  raise "No file: #{psfile}" if ! File.exist?(psfile)
  if File.exist?(psfile) then
    system "convert -rotate 90 #{psfile} #{name}.png"
  end
end



# parse commandline options
opt = OptionParser.new
opt.on('--conf VAL') {|v| configfile = v.to_s}
opt.on('--wsn VAL') {|v| wsn = v.to_i}
#opt.on('--help', '-h') {|v| usage; exit 0}
opt.parse!(ARGV)




lines = Array.new

omegas_here = "0.0 0.15 0.5 1.0".split(" ").map{|s| s.to_f}
var = "OLR"

#time_start = 1000
#time_end = 2000

NETCDF_2D = "../common/diff_sr_Omega-S_2Dvar_mean-t.nc"

path = NETCDF_2D
#na_lat_weight = GPhys::IO.open(path, 'lat_weight').val

# 暴走しない最大の太陽定数
maxinsols = Hash.new
maxinsols[0.0]  = 1640
maxinsols[0.15] = 1570
maxinsols[0.5]  = 1560
maxinsols[1.0]  = 1560


omegas_here.each_with_index{|omega, im|
  [ 1380, maxinsols[omega] ].each_with_index{|insol, is|

    line = Hash.new

    gp = GPhys::IO.open(path, var)
    gp = gp.cut('omega'=>omega).cut('s'=>insol)
# 昼半球帯状平均
#  gp = gp.cut('lon'=>0..180).cut('time'=>time_start..time_end).mean('lon').mean('time')

# 南北平均
    gp = 0.5 * (gp * na_lat_weight.reshape(1, nlat)).sum('lat')

    line['gphys'] = gp

    opts_ggraph = {'annotate'=>false}
    if is == 0 then
      opts_ggraph['type'] = 2
    else
      opts_ggraph['type'] = 1
    end
p    opts_ggraph['index'] = 10*im + 19
    line['opts_ggraph'] = opts_ggraph

    opts = {'legend_str'=>"Omg" + omega.to_s + "S" + insol.to_s}
    line['opts'] = opts

    lines.push(line)
  }
}

p lines

v = lines[0]['gphys'].val
val_min = v.min if (not val_min)
val_max = v.max if (not val_max)
lines.each{|line|
  v = line['gphys'].val
  tmp = v.max
  val_max = tmp if tmp > val_max
  tmp = v.min
  val_min = tmp if tmp < val_min
}

lines[0]['opts_ggraph']['max'] = val_max
lines[0]['opts_ggraph']['min'] = val_min



# draw
DCL.gropn(wsn)
DCL.sgpset('lcntl', false)

# viewport size
GGraph.set_fig('viewport'=>VIEWPORT)

GGraph.set_axes('xtickint'=>10, 'xlabelint'=>30)

multiline(lines)
DCL.grcls

conv_eps(figname)
conv_png(figname)

`rm -f dcl.ps`

__END__
