#! /usr/bin/ruby
# -*- coding: utf-8 -*-
#
# 2015-07-09 石渡 
# 2015-03-16 石渡 鉛直積算は全て make_vertinteg.rb でやるようにする.
#                 鉛直積算の計算を外して, 2 次元データの緯度平均を
#                 して図を描くこと
#                 だけやるようにする.
#                 ファイル名も fig_latmean.rb とする.
# 2015/02/19 石渡正樹 allocate memory error が出ないように改変.
#                     ファイルを出力してしまっているが, 
#                     ファイルを出力せずに図を描くようにしたい.
# 2014/10/03 石渡正樹
#
# = fig_horimean-timeseries.rb
# * 2 次元データの水平平均・時間平均値を出力する.
#
# == USAGE
#   % print_cloud-region-value.rb --var=OLRA --time_start=731 --time_end=1095

# このスクリプトで描くもの
# 3次元データ 鉛直積算, lat mean, lon mean : t-phys
# 3次元データ σ指定,   lat mean, lon mean : t-phys
# 2次元データ lat mean, lon mean : t-phys

# 以下は別スクリプトで！(fig_lonmean-timeseries.rb)
# 3次元データ 鉛直積算, lon mean : t-y
# 3次元データ σ指定,   lon mean : t-y
# 2次元データ lon mean : t-y


require "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script/dcpam.rb"
require "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script/libgphys-momoko.rb"

require 'getoptlong'
require "numru/ggraph"
include NumRu

ITR=1

## 定数設定
Grav = 9.8
RPlanet = 6.371e6
Pi = 3.1415926535897932
GasRUniv = 8.3144621
MolWtDry = 28.9644e-3

GasRDry = GasRUniv / MolWtDry

## オプション解析
parser = GetoptLong.new
parser.set_options(
        ###    global option   ###
        ['--var',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--time_start',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--time_end',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--lon_start',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--lon_end',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--sig',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--threshold',                      GetoptLong::REQUIRED_ARGUMENT]
        )
parser.each_option do |name, arg|
  eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

if $OPT_var == nil then
  p '--var must be specified.'
  exit
end
ncfile = $OPT_var + '.nc'

vertint_h2oliq_file = 'VertIntH2OLiq.nc'


time_start = ($OPT_time_start||1).to_f
time_end = ($OPT_time_end||9999).to_f

lon_start = ($OPT_lon_start||0).to_f
lon_end = ($OPT_lon_end||359).to_f

threshold = ($OPT_threshold||1.0e-3).to_f

siglevel = ($OPT_sig||999).to_f

# データ入力
dir = "./"

gp_data = gpopen dir + ncfile
gp_vertint_h2oliq = gpopen dir + vertint_h2oliq_file

sig = gpopen dir + ncfile,"sig"
lat = gpopen dir + ncfile,"lat"
lon = gpopen dir + ncfile,"lon"

sig_weight = gpopen dir + ncfile,"sig_weight"
lat_weight = gpopen dir + ncfile,"lat_weight"

return if gp_data.nil?

# 座標値の格納
na_sig = sig.val
na_lon = lon.val
na_lat = lat.val

na_sig_weight = sig_weight.val
na_lat_weight = lat_weight.val

nsig = na_sig.size
nlon = na_lon.size
nlat = na_lat.size

# 時間方向に切り出したデータを gphys オブジェクトに格納
gp_val = gp_data.cut('time'=>time_start..time_end)
gp_vertint_h2oliq = gp_vertint_h2oliq.cut('time'=>time_start..time_end)

gp_mask_cloud = gp_val.make_h2oliq_mask(gp_vertint_h2oliq,threshold)

# nc ファイルに保存 (libgphys-momoko.rb のメソッドを使用)
$global_attr = {
  "title"  => "H2OLiqMask",
  "source" => "NCEP/NCAR Re-analysys (downloaded at 2003-12-21T00:00:00+09:00)",

  "institution" => "GFD-Dennou Club dcmodel project",
  "Conventions" => "http://www.gfd-dennou.org/arch/gtool4/conventions/",
  "gt_version"  => "4.2"
}
#$history = time+" "+user+"> "+"print_cloud-region-value.rb"
#output = 'H2OLiqMask'
#gp_mask_cloud.save(output, $global_attr, gp_mask_cloud.name, nil, $history)

# netCDF ファイルに書き込み
outfn = 'H2OLiqMask.nc'
outfile = NetCDF.create(outfn)
GPhys::NetCDF_IO.write( outfile, gp_mask_cloud )
outfile.close

# 逆マスクの作成
gp_mask_noncloud = 1.0 - gp_mask_cloud

# netCDF ファイルに書き込み
outfn = 'H2OLiqInverseMask.nc'
outfile = NetCDF.create(outfn)
GPhys::NetCDF_IO.write( outfile, gp_mask_noncloud )
outfile.close
 
# 閾値より高い領域の取り出し
gp_cloud_area_data = gp_mask_cloud*gp_val
gp_noncloud_area_data = gp_mask_noncloud*gp_val


# 時間平均
gp_val =gp_val.mean('time')

gp_mask_cloud = gp_mask_cloud.mean('time')
gp_mask_noncloud = gp_mask_noncloud.mean('time')
gp_cloud_area_data = gp_cloud_area_data.mean('time')
gp_noncloud_area_data = gp_noncloud_area_data.mean('time')


# 水平平均の計算
gp_val = gp_val * na_lat_weight.reshape(1, nlat) / na_lat_weight.sum
gp_val = gp_val.cut('lon'=>lon_start..lon_end).mean('lon').sum('lat')

gp_mask_cloud = gp_mask_cloud * na_lat_weight.reshape(1, nlat) / na_lat_weight.sum
gp_mask_cloud = gp_mask_cloud.cut('lon'=>lon_start..lon_end).mean('lon').sum('lat')

gp_mask_noncloud = gp_mask_noncloud * na_lat_weight.reshape(1, nlat) / na_lat_weight.sum
gp_mask_noncloud =gp_mask_noncloud.cut('lon'=>lon_start..lon_end).mean('lon').sum('lat')

gp_cloud_area_data = gp_cloud_area_data * na_lat_weight.reshape(1, nlat) / na_lat_weight.sum
gp_cloud_area_data = gp_cloud_area_data.cut('lon'=>lon_start..lon_end).mean('lon').sum('lat')

gp_noncloud_area_data = gp_noncloud_area_data* na_lat_weight.reshape(1, nlat) / na_lat_weight.sum
gp_noncloud_area_data = gp_noncloud_area_data.cut('lon'=>lon_start..lon_end).mean('lon').sum('lat')

p "#{$OPT_var}(global mean): #{gp_val}"
p "dense cloud area fraction: #{gp_mask_cloud}"
#p "gp_mask_noncloud: #{gp_mask_noncloud}"
#p "gp_cloud_area_data(/global): #{gp_cloud_area_data}"
#p "gp_noncloud_area_data(/global): #{gp_noncloud_area_data}"
p "#{$OPT_var}(dense cloud area mean): #{gp_cloud_area_data.val/gp_mask_cloud.val}"
p "#{$OPT_var}(nondense cloud area mean): #{gp_noncloud_area_data.val/gp_mask_noncloud.val}"

# 描画

