#! /usr/bin/ruby
# -*- coding: euc-jp -*-


# 2016-06-07  
#
# = score_ER-SR_readdata.rb
# * ϵ¸Ʊž¸οʿʿͤΤޤȤץå
#
# == USAGE
#   % score_ER-SR_readdata.rb --var=SurfTemp --time_start=731 --time_end=1095

require 'getoptlong'
require "numru/ggraph"
include NumRu

include Math

DATA_HOME = ["/GFD_Dennou_Work10/momoko/LandPlanet/"]
#DATA_FOOTER = "T42L26"

## ץ
parser = GetoptLong.new
parser.set_options(
        ###    global option   ###
        ['--var',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--time_start',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--time_end',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--lon_start',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--lon_end',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--sig',                      GetoptLong::REQUIRED_ARGUMENT]
        )
parser.each_option do |name, arg|
  eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

#TIME_START = ($OPT_time_start||1).to_f
#TIME_END = ($OPT_time_end||9999).to_f

LON_START = ($OPT_lon_start||0).to_f
LON_END = ($OPT_lon_end||359).to_f

var_water = ($OPT_var||'SoilMoist')
var_absorb = 'OSRA'

#include NMath

# ΰʿ. 
def meanvalue(path, var, time_start, time_end)
  gphys = GPhys::IO.open(path, var)

  return if gphys.nil?

  na_lon = GPhys::IO.open(path, 'lon').val
  na_lat = GPhys::IO.open(path, 'lat').val
  na_sig = GPhys::IO.open(path, 'sig').val
  na_lon_weight = GPhys::IO.open(path, 'lon_weight').val
  na_lat_weight = GPhys::IO.open(path, 'lat_weight').val

  nsig = na_sig.size
  nlon = na_lon.size
  nlat = na_lat.size

  gp_val = gphys.cut('time'=>time_start..time_end).mean('time')

  # ʿʿѤη׻
  gp_val = gp_val * na_lat_weight.reshape(1, nlat) / na_lat_weight.sum
  gp_val = gp_val.cut('lon'=>LON_START..LON_END).mean('lon').sum('lat')

  return gp_val.val
end

data_all = Hash.new

exp_list =[
#    W=20cm
#{'head'=>'LP', 'W'=>'20', 'I'=>0.0,'Omg'=>'1.0', 'S'=>2200, 'ProcessNo'=>'32p','ExpNo'=>'03','flg_eq'=>true},  
  {'head'=>'LP', 'W'=>'20', 'I'=>0.0,'Omg'=>'1.0', 'S'=>2400, 'ProcessNo'=>'32p','ExpNo'=>'09','time_start'=>840, 'time_end'=>890,  'flg_eq'=>true},
  
{'head'=>'LP', 'W'=>'20', 'I'=>0.0,'Omg'=>'1.0', 'S'=>2600, 'ProcessNo'=>'32p','ExpNo'=>'16','time_start'=>2790, 'time_end'=>2840,'flg_eq'=>true},
#
#     W=40cm
{'head'=>'LP', 'W'=>'40', 'I'=>0.0,'Omg'=>'1.0', 'S'=>1366, 'ProcessNo'=>'04p','ExpNo'=>'03','time_start'=>1045, 'time_end'=>1095,'flg_eq'=>true},

{'head'=>'LP', 'W'=>'40', 'I'=>0.0,'Omg'=>'1.0', 'S'=>2400, 'ProcessNo'=>'32p','ExpNo'=>'14','time_start'=>1010, 'time_end'=>1060,'flg_eq'=>true},

{'head'=>'LP', 'W'=>'40', 'I'=>0.0,'Omg'=>'1.0', 'S'=>2600, 'ProcessNo'=>'32p','ExpNo'=>'39','time_start'=>3550, 'time_end'=>3600,'flg_eq'=>true},
#
#     W=60cm
{'head'=>'LP', 'W'=>'60', 'I'=>0.0,'Omg'=>'1.0', 'S'=>2200, 'ProcessNo'=>'32p','ExpNo'=>'18','time_start'=>1100, 'time_end'=>1150,'flg_eq'=>true}
  ] 


water_sr_w20_eq=[]
water_sr_w20_runaway=[]

water_sr_w40_eq=[]
water_sr_w40_runaway=[]

water_sr_w60_eq=[]
water_sr_w60_runaway=[]

absorb_sr_w20_eq=[]
absorb_sr_w20_runaway=[]

absorb_sr_w40_eq=[]
absorb_sr_w40_runaway=[]

absorb_sr_w60_eq=[]
absorb_sr_w60_runaway=[]


for i in exp_list
  dir= "#{i['head']}_W#{i['W']}cm_I#{i['I']}_Omg#{i['Omg']}_S#{i['S']}/#{i['head']}_#{i['ProcessNo']}_Omg#{i['Omg']}_I#{i['I']}_S#{i['S']}_W#{i['W']}cm_#{i['ExpNo']}"

  ncfile_water = var_water + ".nc"
  ncfile_absorb = var_absorb + ".nc"

  if i['head']=='LP'
    path_water = File.join(DATA_HOME[0], dir, ncfile_water)
    path_absorb = File.join(DATA_HOME[0], dir, ncfile_absorb)

    if i['W']=='20'

      if i['flg_eq']
        water_sr_w20_eq.push(meanvalue(path_water,var_water,i['time_start'], i['time_end']))
        absorb_sr_w20_eq.push(meanvalue(path_absorb,var_absorb,i['time_start'], i['time_end']))
      else
        water_sr_w20_runaway.push(meanvalue(path, var,i['time_start'], i['time_end']))
        absorb_sr_w20_eq.push(meanvalue(path_absorb,var_absorb,i['time_start'], i['time_end']))
      end

    elsif i['W']=='40'

      if i['flg_eq']
        water_sr_w40_eq.push(meanvalue(path_water,var_water,i['time_start'], i['time_end']))
        absorb_sr_w40_eq.push(meanvalue(path_absorb,var_absorb,i['time_start'], i['time_end']))
      else
        water_sr_w40_runaway.push(meanvalue(path, var,i['time_start'], i['time_end']))
        absorb_sr_w40_eq.push(meanvalue(path_absorb,var_absorb,i['time_start'], i['time_end']))
      end

    elsif i['W']=='60'

      if i['flg_eq']
        water_sr_w60_eq.push(meanvalue(path_water,var_water,i['time_start'], i['time_end']))
        absorb_sr_w60_eq.push(meanvalue(path_absorb,var_absorb,i['time_start'], i['time_end']))
      else
        water_sr_w60_runaway.push(meanvalue(path, var,i['time_start'], i['time_end']))
        absorb_sr_w60_eq.push(meanvalue(path_absorb,var_absorb,i['time_start'], i['time_end']))
      end

    end

  else  # EarthRad
    p "header is something wrong!\n"
  end

end

water_sr_w20_eq = NArray.to_na(water_sr_w20_eq)
absorb_sr_w20_eq = NArray.to_na(absorb_sr_w20_eq)

water_sr_w20_runaway = NArray.to_na(water_sr_w20_runaway)
absorb_sr_w20_runaway = NArray.to_na(absorb_sr_w20_runaway)

water_sr_w40_eq = NArray.to_na(water_sr_w40_eq)
absorb_sr_w40_eq = NArray.to_na(absorb_sr_w40_eq)

water_sr_w40_runaway = NArray.to_na(water_sr_w40_runaway)
absorb_sr_w40_runaway = NArray.to_na(absorb_sr_w40_runaway)

water_sr_w60_eq = NArray.to_na(water_sr_w60_eq)
absorb_sr_w60_eq = NArray.to_na(absorb_sr_w60_eq)

water_sr_w60_runaway = NArray.to_na(water_sr_w60_runaway)
absorb_sr_w60_runaway = NArray.to_na(absorb_sr_w60_runaway)




# 
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws
DCL::grfrm

DCL.sgpset('lclip', true)

DCL::grstrn( 1 )

DCL::usspnt(absorb_sr_w20_eq, water_sr_w20_eq)
DCL::uspfit
DCL::grstrf

#
# ɸϰ
#
# ͤϰ
#DCL::grswnd( '0.0', '1000.0', '0.0', '1.0')
DCL::grswnd( '200.0', '550.0', '0.0', '0.5')

#  tick mark
DCL::uxaxdv('T', 10.0, 50.0)
DCL::uxaxdv('B', 10.0, 50.0)

DCL::uyaxdv('L', 0.05, 0.1)
DCL::uyaxdv('R', 0.05, 0.1)

# Υȥ
DCL::uxsttl( 'B','Absorption', 0.0 )
DCL::uysttl( 'L', var_water, 0.0 )

# ޡ
DCL::uusmks('0.02')  # ޡ礭

# W=20cm, ʿ
DCL::uusmkt(12)    # ޡ 
DCL::uusmki(205)     # 
#DCL::uumrk(-1.0*absorb_sr_w20_eq, 0.001*water_sr_w20_eq)

# W=20cm, ʿ
DCL::uusmkt(11)    # ޡ 
DCL::uusmki(145)   # ο
DCL::uumrk(-1.0*absorb_sr_w40_eq, 0.001*water_sr_w40_eq)

# W=60cm , ʿ
DCL::uusmkt(10)    # ޡ 
DCL::uusmki(885)   # 
#DCL::uumrk(-1.0*absorb_sr_w60_eq, 0.001*water_sr_w60_eq)

# Ʊž, W1500, ʿ
#DCL::uusmkt(10)    # ޡ
#DCL::uusmki(885)     # 


## ϵ, W1500, ˽
#DCL::uusmkt(5)    # ޡ

## ϵ, ʤ, ˽
#DCL::uusmkt(5)    # ޡ
#DCL::uusmki(555)     # 

# Ʊž, W0, ˽
#DCL::uusmkt(5)    # ޡ

## Ʊž, W1500, ˽
#DCL::uusmkt(5)    # ޡ
#DCL::uusmki(885)     # 

DCL::grcls


