#!/usr/bin/ruby
# -*- coding: utf-8 -*-

#require "../load_config.rb"
require "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script/load_config.rb"

#DATA_HOME = "/home/noda/data"

# default
#omega = 1.0
#sigma = 0.8
lat_cut = 0.0
xintv = 4
#yintv = 3
yintv = 1
wsn=2
time_start = 1000
time_end   = 2000
factor = 0.001    # for sigma=0.2
#factor = 0.0025   # for sigma=0.8

#expnum=006


p Dir.pwd.split('/')[-1]

prefix = Dir.pwd.split('/')[-1] + '_'


#UXUNIT = 1.0
#UYUNIT = 1.0
UXUNIT = 50.0   # 単位ベクトルの大きさ [m/s]
UYUNIT = UXUNIT


# Omega0.0 はこれで鉛直流がでかすぎる. けどこれより小さくすると水平風見えない
# Omega0.05 も
#factor_z = -3e6   # SigDot を鉛直流の方向にするため -1 をかける

# Omega0.5 だとこれが良い Omega0.75 も?
factor_z = -4e7   # SigDot を鉛直流の方向にするため -1 をかける

# Omega0.15, 1.0 だとこれが良い
#factor_z = -2e7   # SigDot を鉛直流の方向にするため -1 をかける



title = ""

temp_min = 200
temp_max = 330
temp_interval = 3

# 簡易
while ARGV.size > 0
  case ARGV[0]
  when '--omega' then
    ARGV.shift
    omega = ARGV[0]
    ARGV.shift
  when '--expnum' then
    ARGV.shift
    expnum = ARGV[0]
    ARGV.shift
  when '--lat' then
    ARGV.shift
    lat_cut = ARGV[0].to_f
    ARGV.shift
  when '--xintv' then
    ARGV.shift
    xintv = ARGV[0]
    ARGV.shift
  when '--yintv' then
    ARGV.shift
    yintv = ARGV[0]
    ARGV.shift
  when '--factor' then
    ARGV.shift
    factor = ARGV[0]
    ARGV.shift
  when '--range_time' then
    ARGV.shift
    tmp = ARGV[0].split(':')
    time_start = tmp[0].to_f
    time_end   = tmp[1].to_f
    ARGV.shift
  when '--wsn' then
    ARGV.shift
    wsn = ARGV[0].to_i
    ARGV.shift
  when '--prefix' then
    ARGV.shift
    prefix = ARGV[0]
    ARGV.shift
  else
    raise "ERROR: invalid option: #{ARGV[0]}"
  end
end

#dir = File.join(DATA_HOME_ENS, "101220_diff-DryAir-Vapor_T21L16_sr_Omega#{omega}E_rndTemp_#{expnum}")
#p "omega: " + omega.to_s
#p "lat_cut: " + lat_cut.to_s

p "prefix: " + prefix


XFACT1 = factor
YFACT1 = factor



omega = omega.to_f
sigma = sigma.to_f
xintv = xintv.to_i
yintv = yintv.to_i

#ITR=30   # 球
ITR=1

LON_CNT=125  # 球のときに使用
tg_min=230
tg_max=335

#lon_start = LON_CNT - 90
#lon_end = LON_CNT + 90
#
#lat_start = -70
#lat_end = 70

require "numru/ggraph"
include NumRu

#u = GPhys::IO.open(File.join(dir, 'U.nc'), 'U')
u = GPhys::IO.open('U.nc', 'U')
u = u.cut('lat'=>lat_cut).cut('time'=>time_start..time_end).mean('time')

#sigdot = GPhys::IO.open(File.join(dir, 'SigDot.nc'), 'SigDot')
sigdot = GPhys::IO.open('SigDot.nc', 'SigDot')
# 鉛直方向の格子の個数を揃えるための操作
#na_sigm = GPhys::IO.open(File.join(dir, 'SigDot.nc'), 'sigm').val
na_sigm = GPhys::IO.open('SigDot.nc', 'sigm').val
sigdot = sigdot.cut('sigm'=>na_sigm[-2]..1)
sigdot = sigdot.cut('lat'=>lat_cut).cut('time'=>time_start..time_end).mean('time')

#temp = GPhys::IO.open(File.join(dir, 'Temp.nc'), 'Temp')
temp = GPhys::IO.open('Temp.nc', 'Temp')
temp = temp.cut('lat'=>lat_cut).cut('time'=>time_start..time_end).mean('time')

puts "temp: max=#{temp.max}, min=#{temp.min}"


DCL.gropn(wsn)
DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)

GGraph.set_axes('xtickint'=>10, 'xlabelint'=>30)
#GGraph.set_axes('ytickint'=>10, 'ylabelint'=>30)
GGraph.set_axes('ytickint'=>0.05, 'ylabelint'=>0.2)

#GGraph.set_fig 'itr'=>ITR, 'viewport'=>[0.15,0.85,0.1,0.6], 'map_axis'=>[LON_CNT, 0, 0]
#GGraph.set_fig 'itr'=>ITR, 'viewport'=>[0.15,0.95,0.2,0.8], 'map_axis'=>[LON_CNT, 0, 0]

# same as gpview
vx0,vx1,vy0,vy1 = 0.15,0.85,0.2,0.55
GGraph.set_fig 'itr'=>ITR, 'viewport'=>[vx0,vx1,vy0,vy1], 'map_axis'=>[LON_CNT, 0, 0]

DCL.uscset('cyspos', 'B' )              # move unit y axis

DCL.udlset('LMSG', false)

DCL.ugpset('XFACT1', XFACT1)
DCL.ugpset('YFACT1', YFACT1)
DCL.ugpset('UXUNIT', UXUNIT)
DCL.ugpset('UYUNIT', UYUNIT)
DCL.ugpset('LNRMAL', false)
#DCL.ugpset('LMSG', false)   # no message
DCL.ugpset('LUMSG', false)   # no message
DCL.ugpset('INDEX', 9)

#DCL.ugsut('X','U')
#DCL.ugsut('Y','V')


### tone and contour of SurfTemp
#GGraph.tone( surftemp, true, 'title'=>'', 'interval'=>5, 'min'=>tg_min, 'max'=>tg_max)
#GGraph.contour( surftemp, false, 'interval'=>5, 'min'=>tg_min, 'max'=>tg_max)

#GGraph.vector( u, v, false, 'unit_vect'=>true, 'flow_vect'=>false, 'xintv'=>3, 'yintv'=>3, 'factor'=>1.0 )
#GGraph.vector( u, v, false, 'xintv'=>3, 'yintv'=>3 )

opt_contour = {
  'annotate'=>false,
  'max'=>temp_max, 'min'=>temp_min,
  'interval'=>temp_interval,
  'title'=>title
}

opt_vector = {
  'xintv'=>xintv, 
  'yintv'=>yintv,
  'flow_vect'=>false, 
  'annotate'=>false,
  'unit_vect'=>true,
  'max_unit_vect'=>true
}




GGraph.tone_and_contour( temp, true, opt_contour )
#GGraph.color_bar('landscape'=>true,'top'=>true, 'vlength'=>0.5, 'voff'=>0.03)
GGraph.color_bar('landscape'=>true)
GGraph.vector( u, (factor_z * sigdot), false, opt_vector )

# label of vector
# Ref.:
# * definition of unit_vect in dclext.rb
# * http://ruby.gfd-dennou.org/products/ruby-dcl/ruby-dcl-doc/grph1/node62.html

space = 0.0
vxuloc = vx1 + space
vyuloc = vy0 + space
rsizet = 0.017
index = 1

xunit = (UXUNIT * 100.0).round / 100.0
yunit = (UYUNIT / factor_z * 1e7).round / 1e7
#sfxunit = [xunit.to_s, u.data.units.to_s].join(' ')
#sfyunit = [yunit.to_s, sigdot.data.units.to_s].join(' ')
sfxunit = [xunit.to_s, 'm s-1'].join(' ')
sfyunit = [yunit.to_s, 's-1'].join(' ')
DCL.sgtxzv(vxuloc, vyuloc-1.2*rsizet,
           sfxunit, rsizet, 0, -1, index)
#DCL.sgtxzv(vxuloc+1.2*rsizet, vyuloc+0.5*rsizet,
#           sfyunit, rsizet, 90, -1, index)
DCL.sgtxzv(vxuloc+2.5*rsizet, vyuloc+0.5*rsizet,
           sfyunit, rsizet, 90, -1, index)

DCL.grcls

name="#{prefix}wind_u_sigdot_temp_lat0_t#{time_start}-#{time_end}"

# 画像ファイルの処理
if wsn == 2 then
  if File.exist?("dcl.pdf") then
    p name
    system("mv dcl.pdf #{name}.pdf")
    system("convert -rotate 90 #{name}.pdf #{name}.eps")
    system("convert -rotate 90 #{name}.pdf #{name}.png")
  end
end
