#!/usr/bin/ruby
# -*- coding: utf-8 -*-

# SyncRotEarthRad シリーズ用
# (2014-11-11 石渡) この時点では, Phi はプロットしてない.
# (2016-02-29 石渡) Phi をプロットするよう変更


require "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script/load_config.rb"
require "optparse"

SCRIPT_DIR = "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script"


# default
#omega = 1.0
sigma = 0.8
xintv = 4
yintv = 3
wsn=2
time_start = 1000
time_end   = 2000
factor = 0.001    # for sigma=0.2
#factor = 0.0025   # for sigma=0.8
#UXUNIT = 1.0
#UYUNIT = 1.0
UXUNIT = 50.0   # 単位ベクトルの大きさ [m/s]
yfact = 1.0
#UYUNIT = UXUNIT

prefix = Dir.pwd.split('/')[-1] + '_'

TITLE = ''

phi_min = 128000
phi_max = 148000
phi_interval = 500

eddy = false

# parse commandline options
opt = OptionParser.new

opt.on('--range VAL') {|v| phi_min, phi_max = v.split(":")}
opt.on('--wsn VAL') {|v| wsn = v.to_i}
opt.on('--time_start VAL') {|v| time_start = v.to_f}
opt.on('--time_end VAL') {|v| time_end = v.to_f}
opt.on('--int VAL') {|v| phi_interval = v.to_f}
#opt.on('--omega VAL') {|v| omega = v}
opt.on('--sigma VAL') {|v| sigma = v}
opt.on('--xintv VAL') {|v| xintv = v}
opt.on('--yintv VAL') {|v| yintv = v}
opt.on('--factor VAL') {|v| factor = v}
opt.on('--eddy') {|v| eddy = true}
opt.on('--prefix VAL') {|v| prefix = v}
opt.on('--yfact VAL') {|v| yfact = v.to_f}

opt.parse!(ARGV)


# check
if ARGV.size > 0
  raise "ERROR: invalid option: #{ARGV[0]}"
end

#dir = File.join(DATA_HOME, "101220_diff-DryAir-Vapor_T21L16_sr_Omega#{omega}_dt20m")

sigma = sigma.to_f
xintv = xintv.to_i
yintv = yintv.to_i

#UYUNIT = UXUNIT*yfact
UYUNIT = UXUNIT/yfact


#ITR=30   # 球
ITR=1

LON_CNT=125  # 球のときに使用
tg_min=230
tg_max=335

XFACT1 = factor
YFACT1 = factor*yfact

lon_start = LON_CNT - 90
lon_end = LON_CNT + 90

#lat_start = -70
#lat_end = 70

require "numru/ggraph"
include NumRu

#u = GPhys::IO.open(File.join(dir, 'U.nc'), 'U')
u = GPhys::IO.open( 'U.nc', 'U')
u = u.cut('sig'=>sigma).cut('time'=>time_start..time_end).mean('time')
#u = u.cut('sig'=>sigma).cut('lon'=>lon_start..lon_end).cut('lat'=>lat_start..lat_end).cut('time'=>time_start..time_end).mean('time')

#v = GPhys::IO.open(File.join(dir, 'V.nc'), 'V')
v = GPhys::IO.open('V.nc', 'V')
v = v.cut('sig'=>sigma).cut('time'=>time_start..time_end).mean('time')
#v = v.cut('sig'=>sigma).cut('lon'=>lon_start..lon_end).cut('lat'=>lat_start..lat_end).cut('time'=>time_start..time_end).mean('time')

unless File.exist?('./Phi.nc') then
  system("ruby #{SCRIPT_DIR}/geopotential_time.rb --var Temp.nc@Temp")
end

phi = GPhys::IO.open('./Phi.nc', 'Phi')
phi = phi.cut('sig'=>sigma).cut('time'=>time_start..time_end).mean('time')


if eddy then
  puts "eddy"

  u   = u.eddy('lon')
  v   = v.eddy('lon')
  phi = phi.eddy('lon')
end


puts "U  : max=#{u.max}, min=#{u.min}"
puts "V  : max=#{v.max}, min=#{v.min}"
puts "Phi: max=#{phi.max}, min=#{phi.min}"


DCL.gropn(wsn)
DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)

GGraph.set_axes('xtickint'=>10, 'xlabelint'=>30)
GGraph.set_axes('ytickint'=>10, 'ylabelint'=>30)

#GGraph.set_fig 'itr'=>ITR, 'viewport'=>[0.15,0.85,0.1,0.6], 'map_axis'=>[LON_CNT, 0, 0]
#GGraph.set_fig 'itr'=>ITR, 'viewport'=>[0.15,0.95,0.2,0.8], 'map_axis'=>[LON_CNT, 0, 0]

# same as gpview
vx0,vx1,vy0,vy1 = 0.15,0.85,0.2,0.55
GGraph.set_fig 'itr'=>ITR, 'viewport'=>[vx0,vx1,vy0,vy1], 'map_axis'=>[LON_CNT, 0, 0]

DCL.uscset('cyspos', 'B' )              # move unit y axis

DCL.udlset('LMSG', false)

DCL.ugpset('XFACT1', XFACT1)
DCL.ugpset('YFACT1', YFACT1)
DCL.ugpset('UXUNIT', UXUNIT)
DCL.ugpset('UYUNIT', UYUNIT)
DCL.ugpset('LNRMAL', false)
#DCL.ugpset('LMSG', false)   # no message
DCL.ugpset('LUMSG', false)   # no message
DCL.ugpset('INDEX', 9)

#DCL.ugsut('X','U')
#DCL.ugsut('Y','V')

#OPT = {
#  #  'index'=>7,
#  'xintv'=>xintv, 
#  'yintv'=>yintv,
#  'flow_vect'=>false, 
#  'annotate'=>false,
#  'unit_vect'=>true
#}

GGraph.tone_and_contour( phi, true, 'annotate'=>false,
  'max'=>phi_max, 'min'=>phi_min, 'interval'=>phi_interval, 'title'=>TITLE)
GGraph.color_bar('landscape'=>true, 'labelintv'=>14)
GGraph.vector( u, v, false, 'xintv'=>xintv, 'yintv'=>yintv,
  'flow_vect'=>false, 'annotate'=>false, 'unit_vect'=>true
               )

# label of vector
# Ref.:
# * definition of unit_vect in dclext.rb
# * http://ruby.gfd-dennou.org/products/ruby-dcl/ruby-dcl-doc/grph1/node62.html

space = 0.0
vxuloc = vx1 + space
vyuloc = vy0 + space
rsizet = 0.017
index = 1

xunit = (UXUNIT * 100.0).round / 100.0
yunit = (UYUNIT * 100.0).round / 100.0
sfxunit = [xunit.to_s, u.data.units.to_s].join(' ')
sfyunit = [yunit.to_s, v.data.units.to_s].join(' ')
#sfxunit = [xunit.to_s, 'm s-1'].join(' ')
#sfyunit = [yunit.to_s, 'm s-1'].join(' ')
DCL.sgtxzv(vxuloc, vyuloc-1.2*rsizet,
           sfxunit, rsizet, 0, -1, index)
#DCL.sgtxzv(vxuloc+1.2*rsizet, vyuloc+0.5*rsizet,
#           sfyunit, rsizet, 90, -1, index)
DCL.sgtxzv(vxuloc+2.5*rsizet, vyuloc+0.5*rsizet,
           sfyunit, rsizet, 90, -1, index)

DCL.grcls

if eddy then
  name="#{prefix}wind-vector-eddy_sigma#{sigma}_geopot_t#{time_start}-#{time_end}"
else
  name="#{prefix}wind-vector_sigma#{sigma}_geopot_t#{time_start}-#{time_end}"
end

# 画像ファイルの処理
if wsn == 2 then
  if File.exist?("dcl.pdf") then
    p name
    system("mv dcl.pdf #{name}.pdf")
    system("convert -rotate 90 #{name}.pdf #{name}.eps")
    system("convert -rotate 90 #{name}.pdf #{name}.png")
  end
end

