#! /usr/bin/ruby
# -*- coding: utf-8 -*-

require "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script/load_config.rb"
require 'optparse'

# load_config.rb を使用
#DATA_HOME = "/home/noda/data"

# default
omega = 1.0
sigma = 0.8
xintv = 4
yintv = 3
wsn=2
time_start = 1000
time_end   = 2000
#factor = 0.001    # for sigma=0.2
factor = 0.003    # for sigma=0.2
UXUNIT = 20.0   # 単位ベクトルの大きさ [m/s]
UYUNIT = UXUNIT

prefix = Dir.pwd.split('/')[-1] + '_'

TITLE = ''

ps_min = 93000
ps_max = 107000
ps_interval = 500

expnum = 006

eddy = false

# parse commandline options
opt = OptionParser.new

opt.on('--range VAL') {|v| ps_min, ps_max = v.split(":")}
opt.on('--wsn VAL') {|v| wsn = v.to_i}
opt.on('--int VAL') {|v| int = v.to_f}
opt.on('--omega VAL') {|v| omega = v}
opt.on('--time_start VAL') {|v| time_start = v.to_f}
opt.on('--time_end VAL') {|v| time_end = v.to_f}
opt.on('--sigma VAL') {|v| sigma = v}
opt.on('--expnum VAL') {|v| expnum = v}
opt.on('--xintv VAL') {|v| xintv = v}
opt.on('--yintv VAL') {|v| yintv = v}
opt.on('--factor VAL') {|v| factor = v}
opt.on('--eddy') {|v| eddy = true}
opt.on('--prefix VAL') {|v| prefix = v}

opt.parse!(ARGV)

# check
if ARGV.size > 0
  raise "ERROR: invalid option: #{ARGV[0]}"
end

p expnum

#dir = File.join(DATA_HOME_ENS, "101220_diff-DryAir-Vapor_T21L16_sr_Omega#{omega}E_rndTemp_#{expnum}")
dir = "./"
p "omega: " + omega.to_s
p "sigma: " + sigma.to_s

omega = omega.to_f
sigma = sigma.to_f
xintv = xintv.to_i
yintv = yintv.to_i

#ITR=30   # 球
ITR=1

LON_CNT=125  # 球のときに使用
tg_min=230
tg_max=335

XFACT1 = factor
YFACT1 = factor

p dir

lon_start = LON_CNT - 90
lon_end = LON_CNT + 90

lat_start = -70
lat_end = 70

require "numru/ggraph"
include NumRu

TIME_START= time_start
TIME_END= time_end

p time_start
p time_end

p TIME_START
p TIME_END

u = GPhys::IO.open(File.join(dir, 'U.nc'), 'U')
u = u.cut('sig'=>sigma).cut('time'=>TIME_START..TIME_END).mean('time')

v = GPhys::IO.open(File.join(dir, 'V.nc'), 'V')
v = v.cut('sig'=>sigma).cut('time'=>TIME_START..TIME_END).mean('time')

ps = GPhys::IO.open(File.join(dir, 'Ps.nc'), 'Ps')
ps = ps.cut('time'=>TIME_START..TIME_END).mean('time')
#ps = GPhys::IO.open('./Ps.nc', 'Ps')
#ps = ps.cut('sig'=>sigma)


if eddy then
  puts "eddy"

  u   = u.eddy('lon')
  v   = v.eddy('lon')
  ps = ps.eddy('lon')
end


puts "U  : max=#{u.max}, min=#{u.min}"
puts "V  : max=#{v.max}, min=#{v.min}"
puts "Ps: max=#{ps.max}, min=#{ps.min}"


DCL.sgscmn(14)  # colormap
DCL.gropn(wsn)
DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)

GGraph.set_axes('xtickint'=>10, 'xlabelint'=>30)
GGraph.set_axes('ytickint'=>10, 'ylabelint'=>30)

#GGraph.set_fig 'itr'=>ITR, 'viewport'=>[0.15,0.85,0.1,0.6], 'map_axis'=>[LON_CNT, 0, 0]
#GGraph.set_fig 'itr'=>ITR, 'viewport'=>[0.15,0.95,0.2,0.8], 'map_axis'=>[LON_CNT, 0, 0]

# same as gpview
vx0,vx1,vy0,vy1 = 0.15,0.85,0.2,0.55
GGraph.set_fig 'itr'=>ITR, 'viewport'=>[vx0,vx1,vy0,vy1], 'map_axis'=>[LON_CNT, 0, 0]

DCL.uscset('cyspos', 'B' )              # move unit y axis

DCL.udlset('LMSG', false)

DCL.ugpset('XFACT1', XFACT1)
DCL.ugpset('YFACT1', YFACT1)
DCL.ugpset('UXUNIT', UXUNIT)
DCL.ugpset('UYUNIT', UYUNIT)
DCL.ugpset('LNRMAL', false)
DCL.ugpset('LUMSG', false)   # no message
DCL.ugpset('INDEX', 9)


#GGraph.vector( u, v, false, 'unit_vect'=>true, 'flow_vect'=>false, 'xintv'=>3, 'yintv'=>3, 'factor'=>1.0 )
#GGraph.vector( u, v, false, 'xintv'=>3, 'yintv'=>3 )

#OPT = {
#  #  'index'=>7,
#  'xintv'=>xintv, 
#  'yintv'=>yintv,
#  'flow_vect'=>false, 
#  'annotate'=>false,
#  'unit_vect'=>true
#}

GGraph.tone_and_contour( ps, true, 'annotate'=>false,
  'max'=>ps_max, 'min'=>ps_min, 'interval'=>ps_interval, 'title'=>TITLE)
#GGraph.color_bar('landscape'=>true,'top'=>true, 'vlength'=>0.5, 'voff'=>0.04)
GGraph.color_bar('landscape'=>true, 'labelintv'=>14)
GGraph.vector( u, v, false, 'xintv'=>xintv, 'yintv'=>yintv,
  'flow_vect'=>false, 'annotate'=>false, 'unit_vect'=>true
               )

# label of vector
# Ref.:
# * definition of unit_vect in dclext.rb
# * http://ruby.gfd-dennou.org/products/ruby-dcl/ruby-dcl-doc/grph1/node62.html

space = 0.0
vxuloc = vx1 + space
vyuloc = vy0 + space
rsizet = 0.017
index = 1

xunit = (UXUNIT * 100.0).round / 100.0
yunit = (UYUNIT * 100.0).round / 100.0
sfxunit = [xunit.to_s, u.data.units.to_s].join(' ')
sfyunit = [yunit.to_s, v.data.units.to_s].join(' ')
DCL.sgtxzv(vxuloc, vyuloc-1.2*rsizet,
           sfxunit, rsizet, 0, -1, index)
#DCL.sgtxzv(vxuloc+1.2*rsizet, vyuloc+0.5*rsizet,
#           sfyunit, rsizet, 90, -1, index)
DCL.sgtxzv(vxuloc+2.5*rsizet, vyuloc+0.5*rsizet,
           sfyunit, rsizet, 90, -1, index)

DCL.grcls

name="#{prefix}wind-vector_sigma#{sigma}_ps_t#{time_start}-#{time_end}"

# 画像ファイルの処理
if wsn == 2 then
  if File.exist?("dcl.pdf") then
    p name
    system("mv dcl.pdf #{name}.pdf")
    system("convert -rotate 90 #{name}.pdf #{name}.eps")
    system("convert -rotate 90 #{name}.pdf #{name}.png")
  end
end

