=begin JA

= 実験条件の変更

# * 森川 靖大 (morikawa), 納多 哲史 (noda), 高橋 芳幸 (yot), 竹広 真一(takepiro)
#   * $Id: changesetup.rd,v 1.11 2012/02/24 08:20:44 takepiro Exp $

=end JA
=begin EN

= Change experimental setup

# * Yasuhiro MORIKAWA (morikawa), Satoshi NODA (noda), Yoshiyuki O. Takahashi (yot), Shin-ichi Takehiro (takepiro)
#   * $Id: changesetup.rd,v 1.11 2012/02/24 08:20:44 takepiro Exp $

=end EN


=begin JA

ここでは, 実験条件のいくつかについて変更方法を説明します. 

計算設定を変更するには設定ファイル(NAMELIST ファイル)を編集し, 
これを実行時の -N= オプションに指定します. 
ここでは, ((<Held and Suarez (1994) による乾燥大気の力学コア計算|URL:./exp-hs94.htm>)) で
使用した ((<dcpam_hs94_T21L20.conf|URL:../../exp_setup_files/dcpam_hs94_T21L20.conf>))
を例として用いて説明します.

設定ファイル内の "&xxxxxx_nml" という NAMELIST 変数群名は, それぞれモジュール xxxxxx で
管理される設定値です. dcpam5 で管理される NAMELIST 変数群名のリストおよび
各設定値の詳細については
((<dcpam5 NAMELIST|URL:../code_reference/htm/classes/NAMELIST.html>))
から参照可能です.

=end JA
=begin EN

A method how to change several experimental setup is explained. 

In order to change the settings of experiments, 
edit a configuration file (NAMELIST file), and specify the file to "-N" option of an execution.
Here, it is explained by using a configuration file (NAMELIST file), 
((<dcpam_hs94_T21L20.conf|URL:../../exp_setup_files/dcpam_hs94_T21L20.conf>)) which 
is used in ((<Dry atmosphere dynamical core experiment by Held and Suarez (1994)|URL:./exp-hs94.htm.en>)).

A NAMELIST group name "&xxxxxx_nml" is managed by "xxxxxx" module.
List of NAMELIST group names managed in dcpam5 is 
((<dcpam5 NAMELIST|URL:../../code_reference/htm/classes/NAMELIST.html>)). 
See this manual for details.

=end EN


=begin JA
== 解像度の変更

解像度は, 設定ファイル (NAMELIST ファイル) に ((*&gridset_nml*)) を用いて設定します. 

((<dcpam_hs94_T21L20.conf|URL:../../exp_setup_files//dcpam_hs94_T21L20.conf>)) には, 
下のように設定されています. 

    &gridset_nml
      nmax = 21,                  ! 最大全波数. 
                                  ! Maximum truncated wavenumber
      imax = 64,                  ! 経度格子点数. 
                                  ! Number of grid points in longitude
      jmax = 32,                  ! 緯度格子点数. 
                                  ! Number of grid points in latitude
      kmax = 20                   ! 鉛直層数. 
                                  ! Number of vertical level
    /

これは, T21L20 の解像度 (経度, 緯度, 鉛直方向の格子点数はそれぞれ 64, 32, 20) の
設定です. 
これを T42L20 の解像度にするためには下のように設定します. 

    &gridset_nml
      nmax =  42,                 ! 最大全波数. 
                                  ! Maximum truncated wavenumber
      imax = 128,                 ! 経度格子点数. 
                                  ! Number of grid points in longitude
      jmax =  64,                 ! 緯度格子点数. 
                                  ! Number of grid points in latitude
      kmax =  20                  ! 鉛直層数. 
                                  ! Number of vertical level
    /

なお, 鉛直解像度 (層数) を変更する場合には, ((*&axesset_nml*)) の ((*Sigma*)) の値を
編集し, 各層の配置も指定する必要があります.

編集が終わったら, 以下のように
オプション -N (または --namelist) に設定ファイル (NAMELIST ファイル) を指定しつつ, 
実行コマンドを入力してください. 

  $ ./bin/dcpam_main -N=./conf/dcpam_hs94_T21L20.conf | tee hs94-T21L20.log


=end JA

=begin EN

== Change resolution


Resolution can be changed by using ((*&gridset_nml*)) 
in the configuration file (NAMELIST file).

In ((<dcpam_hs94_T21L20.conf|URL:../../exp_setup_files//dcpam_hs94_T21L20.conf>)),
it is set in the following way. 

    &gridset_nml
      nmax = 21,                  ! 最大全波数. 
                                  ! Maximum truncated wavenumber
      imax = 64,                  ! 経度格子点数. 
                                  ! Number of grid points in longitude
      jmax = 32,                  ! 緯度格子点数. 
                                  ! Number of grid points in latitude
      kmax = 20                   ! 鉛直層数. 
                                  ! Number of vertical level
    /

They are for the resolution of T21L20 
(the grid points are 64, 32, 20 in longitude, latitude and vertical, respectively). 
In order to change them into the resolution of T42L20, 
they are set as follows.

    &gridset_nml
      nmax =  42,                 ! 最大全波数. 
                                  ! Maximum truncated wavenumber
      imax = 128,                 ! 経度格子点数. 
                                  ! Number of grid points in longitude
      jmax =  64,                 ! 緯度格子点数. 
                                  ! Number of grid points in latitude
      kmax =  20                  ! 鉛直層数. 
                                  ! Number of vertical level
    /

When the vertical resolution (the number of grid point) is changed, 
the values of ((*Sigma*)) in ((*&axesset_nml*)) should be edited 
to set the levels of sigma coordinate. 
After edit, execute with '-N' (or '--namelist') option as follows.

  $ ./bin/dcpam_main -N=./conf/dcpam_hs94_T21L20.conf | tee hs94-T21L20.log

=end EN


=begin JA

== 積分期間の変更

積分期間は, 設定ファイル (NAMELIST ファイル) に ((*&timeset_nml*)) を用いて設定します. 
dcpam では 2 つの方法のどちらかで積分期間を設定します. ひとつは積分する時間を設定する
方法, もうひとつは積分開始と終了の時刻を指定する方法です. 

((<dcpam_hs94_T21L20.conf|URL:../../exp_setup_files/dcpam_hs94_T21L20.conf>)) では, 
積分する時間を設定しており, 下のように設定されています. 

  &timeset_nml
              : 
    IntegPeriodValue    = 10.0, 
                                ! 計算終了時刻. 
                                ! End time of calculation
    IntegPeriodUnit     = 'day', 
                                ! 計算開始時刻の単位. 
                                ! Unit of end time of calculation
              : 
  /

これは 10 日間積分することを表しています. 
積分時間を 20 日間にするためには下のように設定します. 

  &timeset_nml
              : 
    IntegPeriodValue    = 20.0, 
                                ! 計算終了時刻. 
                                ! End time of calculation
    IntegPeriodUnit     = 'day', 
                                ! 計算開始時刻の単位. 
                                ! Unit of end time of calculation
              : 
  /


一方, もうひとつは積分開始と終了の時刻を使って積分期間を設定するためには
下のように指定します. 

  &timeset_nml
              : 
    cal_type          = 'noleap',
    InitialYear       =     1,
    InitialMonth      =     1,
    InitialDay        =     1,
    InitialHour       =     0,
    InitialMin        =     0,
    InitialSec        =     0.0d0,
    EndYear           =     1,
    EndMonth          =     1,
    EndDay            =     3,
    EndHour           =     0,
    EndMin            =     0,
    EndSec            =     0.0d0,
              : 
  /

cal_type は暦の種類を指定し, 上記で指定している noleap はうるう年のない暦を
表します. 
InitialYear, InitialMonth, ... は開始年, 月, ... を表し, 
EndYear, EndMonth, ... は終了年, 月, ... を表します.
その他の指定については, 
((<gtool5 チュートリアル, DCCalCreate の項目|URL:http://www.gfd-dennou.org/library/gtool/gtool5/gtool5_current/doc/tutorial/dc_calendar1.htm>)) を参照してください.



編集が終わったら, 以下のように
オプション -N (または --namelist) に設定ファイル (NAMELIST ファイル) を指定しつつ, 
実行コマンドを入力してください. 

  $ ./bin/dcpam_main -N=./conf/dcpam_hs94_T21L20.nml | tee hs94-T21L20.log

=end JA

=begin EN

== Change integration period



The integration period is configured using ((*&timeset_nml*)) 
in the configuration file (NAMELIST file). 
Two kinds of methods for set up of the integration period are prepared in dcpam.
One is to set the integration time, 
another is to specify the starting time and ending time. 

In ((<dcpam_hs94_T21L20.conf|URL:../../exp_setup_files/dcpam_hs94_T21L20.conf>)),
the integration time is specified as below. 

  &timeset_nml
              : 
    IntegPeriodValue    = 10.0, 
                                ! 計算終了時刻. 
                                ! End time of calculation
    IntegPeriodUnit     = 'day', 
                                ! 計算開始時刻の単位. 
                                ! Unit of end time of calculation
              : 
  /

This means that integration is performed for 10 days. 
The configuration for 20 days integration period is as follows:

  &timeset_nml
              : 
    IntegPeriodValue    = 20.0, 
                                ! 計算終了時刻. 
                                ! End time of calculation
    IntegPeriodUnit     = 'day', 
                                ! 計算開始時刻の単位. 
                                ! Unit of end time of calculation
              : 
  /


On the other hand, configuration for integration period 
using the starting time and ending time is as follows:

  &timeset_nml
              : 
    cal_type          = 'noleap',
    InitialYear       =     1,
    InitialMonth      =     1,
    InitialDay        =     1,
    InitialHour       =     0,
    InitialMin        =     0,
    InitialSec        =     0.0d0,
    EndYear           =     1,
    EndMonth          =     1,
    EndDay            =     3,
    EndHour           =     0,
    EndMin            =     0,
    EndSec            =     0.0d0,
              : 
  /

"cal_type" specifies a type of calendar, and "noleap means the calendar
without a bissextile year. 
"InitialYear", "InitialMonth", ... mean the starting year, month, ...
and "EndYea"r, "EndMonth", ... mean the end year, month, ...
Please refer to 
((<gtool5 Tutorial,DCCalCreate|URL:http://www.gfd-dennou.org/library/gtool/gtool5/gtool5_current/doc/tutorial/dc_calendar1.htm>))
for other items. 

After edit, execute with '-N' (or '--namelist') option as follows.

  $ ./bin/dcpam_main -N=./conf/dcpam_hs94_T21L20.nml | tee hs94-T21L20.log

=end EN


=begin JA

== 惑星の定数の変更

惑星に関する定数は, 設定ファイル (NAMELIST ファイル) に ((*&constants_nml*)) を用いて設定します. 

((<dcpam_hs94_T21L20.conf|URL:../../exp_setup_files/dcpam_hs94_T21L20.conf>)) には, 
下のように設定されています. 

  &constants_nml
    RPlanet    = 6.371e6,
                              ! $ a $ [m].
                              ! 惑星半径.
                              ! Radius of planet
    Omega      = 7.292e-5,
                              ! $ \Omega $ [s-1].
                              ! 回転角速度.
                              ! Angular velocity
    Grav       = 9.8,
                              ! $ g $ [m s-2].
                              ! 重力加速度.
                              ! Gravitational acceleration
    CpDry      = 1004.0,
                              ! $ C_p $ [J kg-1 K-1].
                              ! 乾燥大気の定圧比熱.
                              ! Specific heat of air at constant pressure
    GasRDry    = 286.85714285
                              ! $ R $ [J kg-1 K-1].
                              ! 乾燥大気の気体定数.
                              ! Gas constant of air
  /

これら上から順に, 惑星半径, 自転角速度, 重力加速度, 大気の定圧比熱, 大気の
気体定数を指定しています. 
これらの指定を変更することで, 値を変更することができます. 


編集が終わったら, 以下のように
オプション -N (または --namelist) に NAMELIST ファイルを指定しつつ, 
実行コマンドを入力してください. 

  $ ./bin/dcpam_main -N=./conf/dcpam_hs94_T21L20.nml | tee hs94-T21L20.log

=end JA

=begin EN

== Change constants of planet and planetary atmosphere

Constants for a planet and a planetary atmosphere are set using
((*&constants_nml*)) in the configuration file (NAMELIST file). 

In ((<dcpam_hs94_T21L20.conf|URL:../../exp_setup_files/dcpam_hs94_T21L20.conf>)),
they are set as follows:

  &constants_nml
    RPlanet    = 6.371e6,
                              ! $ a $ [m].
                              ! 惑星半径.
                              ! Radius of planet
    Omega      = 7.292e-5,
                              ! $ \Omega $ [s-1].
                              ! 回転角速度.
                              ! Angular velocity
    Grav       = 9.8,
                              ! $ g $ [m s-2].
                              ! 重力加速度.
                              ! Gravitational acceleration
    CpDry      = 1004.0,
                              ! $ C_p $ [J kg-1 K-1].
                              ! 乾燥大気の定圧比熱.
                              ! Specific heat of air at constant pressure
    GasRDry    = 286.85714285
                              ! $ R $ [J kg-1 K-1].
                              ! 乾燥大気の気体定数.
                              ! Gas constant of air
  /

From the top to the bottom, 
the radius of the planet, 
angular velocity, gravitational acceleration, 
specific heat of air at constant pressure
gas constant of air are specified. 
The vaules can be changed by modifying these items. 

After edit, execute with '-N' (or '--namelist') option as follows.

  $ ./bin/dcpam_main -N=./conf/dcpam_hs94_T21L20.nml | tee hs94-T21L20.log

=end EN


=begin JA
== 出力設定の変更

解析用のヒストリデータの出力に関する設定は
((*&gtool_historyauto_nml*)) を編集することで変更します.

((<dcpam_hs94_T21L20.conf|URL:../../exp_setup_files/dcpam_hs94_T21L20.conf>)) には, 
下のように設定されています. 

  ! ヒストリデータ出力の全体設定
  ! Global settings about history data output
  !
  &gtool_historyauto_nml
    IntValue = 1.0,
                                ! ヒストリデータの出力間隔の数値. 
                                ! 負の値を与えると, 出力を抑止します. 
                                !
                                ! Numerical value for interval of history data output
                                ! Negative values suppress output.
    IntUnit = 'day',
                                ! ヒストリデータの出力間隔の単位. 
                                ! Unit for interval of history data output
    Precision = 'float',     ! 単精度
                                ! ヒストリデータの精度. 
                                ! Precision of history data
    FilePrefix = '',
                                ! ヒストリデータのファイル名の接頭詞. 
                                ! Prefixes of history data filenames
  /
  !
  ! ヒストリデータ出力の個別設定
  ! Individual settings about history data output
  !
  &gtool_historyauto_nml
    Name = 'U, V, Temp, Ps, QVap, Vor, Div, SigDot, DPiDt'
  /
  &gtool_historyauto_nml
    Name = 'Mass, KinEngy, IntEngy, PotEngy, LatEngy, TotEngy, Enstro', 
    SpaceAverage = .true., .true., .true., .true., .true.
  /

それぞれの設定項目について以下に記します.

: IntValue
  (実数型) 出力間隔の数値

: IntUnit
  (文字型) 出力間隔の単位. "sec", "min", "hour", "day", "month", "year" などが
  使用可能です.
  使用可能な単位の詳細については, 
  ((<gtool5 ライブラリ: dc_date_types モジュール|URL:http://www.gfd-dennou.org/library/gtool/gtool5/gtool5_current/doc/code_reference/classes/dc_date_types.html>)) の
  "Characters list for unit" を参照ください. 
  
: Precision
  (文字型) データの精度. "float" (単精度実数型), "double" (倍精度実数型), "int" (整数型) を指定可能
  
: SpaceAverage
  (論理型配列) 空間平均のフラグ. 
  配列の 1 番目, 2 番目, 3 番目が, 経度, 緯度, 高度(σ) に対応します.
  
((*Name*)) を指定しない, もしくは空文字を与えた場合,
それは全ての変数に対するデフォルト設定となります.
その場合にのみ有効な項目として以下のものがあります. 

: FilePrefix
  (文字型) データのファイル名の接頭詞.
  例えば "exp1-" と指定すれば, 変数 "U" の出力ファイル名は "exp1-U.nc" となります.
  また, "data01/" のようにスラッシュを含む文字列を指定することで,
  カレントディレクトリ以外の場所に出力するよう設定することも可能です. 


出力時間間隔などは, これらの値を編集することで変更することができます. 

より詳しい説明については,
((<gtool5 チュートリアル: 多数のファイル出力を行うモデルでのデータ出力 -- 設定可能な項目|URL:http://www.gfd-dennou.org/library/gtool/gtool5/gtool5_current/doc/tutorial/gtauto_first.htm#label-7>))
を参照ください. 


また, さらに出力する変数を追加する場合には, 

  &gtool_historyauto_nml
    Name = 'U, V, Temp, Ps, QVap, Vor, Div, SigDot, DPiDt'
  /

の ((*Name*)) の行に変数名を追加すか, 新たに下のように行を追加します. 

  &gtool_historyauto_nml
    Name = 'XXX'
  /

編集が終わったら, 以下のように
オプション -N (または --namelist) に NAMELIST ファイルを指定しつつ, 
実行コマンドを入力してください. 

  $ ./bin/dcpam_main -N=./conf/dcpam_hs94_T21L20.nml | tee hs94-T21L20.log


=end JA
=begin EN
== Change output settings

Configuration for output of history data can be changed 
by editing ((*&gtool_historyauto_nml*)). 
In the configuration file of
((<dcpam_hs94_T21L20.conf|URL:../../exp_setup_files/dcpam_hs94_T21L20.conf>)),
it is set in the following way. 

  ! ヒストリデータ出力の全体設定
  ! Global settings about history data output
  !
  &gtool_historyauto_nml
    IntValue = 1.0,
                                ! ヒストリデータの出力間隔の数値. 
                                ! 負の値を与えると, 出力を抑止します. 
                                !
                                ! Numerical value for interval of history data output
                                ! Negative values suppress output.
    IntUnit = 'day',
                                ! ヒストリデータの出力間隔の単位. 
                                ! Unit for interval of history data output
    Precision = 'float',     ! 単精度
                                ! ヒストリデータの精度. 
                                ! Precision of history data
    FilePrefix = '',
                                ! ヒストリデータのファイル名の接頭詞. 
                                ! Prefixes of history data filenames
  /
  !
  ! ヒストリデータ出力の個別設定
  ! Individual settings about history data output
  !
  &gtool_historyauto_nml
    Name = 'U, V, Temp, Ps, QVap, Vor, Div, SigDot, DPiDt'
  /
  &gtool_historyauto_nml
    Name = 'Mass, KinEngy, IntEngy, PotEngy, LatEngy, TotEngy, Enstro', 
    SpaceAverage = .true., .true., .true., .true., .true.
  /

Each configuration item is described below. 

: IntValue
  (real) Value of the output interval

: IntUnit
  (string) Unit of the output interval. 
  "sec", "min", "hour", "day", "month" , "year" and so on can be used.
  Detail of available units is described at "Characters list for unit" in
  ((<gtool5 library: dc_date_types module|URL:http://www.gfd-dennou.org/library/gtool/gtool5/gtool5_current/doc/code_reference/classes/dc_date_types.html>))
  
: Precision
  (string) Accuracy of data. "float" (real with single precision), 
  "double" (real with double precision), "int" (integer) can be used. 
  
: SpaceAverage
  (logical array) Flags for spartial average. 
  The 1st, 2nd and 3rd components of the array corresponds to 
  longitude, latitude and height (sigma) coordinates.
  
When ((*Name*)) is not configured or set a null string, 
it becomes a default configuration for all variables. 
The following items become effective only in this case. 

: FilePrefix
  (string) Prefix of data file names. 
  When "exp1-" is specified for exapmle, 
  the output file name of "U" variable becomes "exp1-U.nc".
  You can also output data in a different place from the current directory
  by specifying strings with "/", such as "data01/". 

=end EN



##################################################################
#
#=begin JA
#== 初期値データファイルの作成
#
#上記の実験では, 初期値データは実行プログラムによって内部で作成されていました. 
#以下では, 初期値データをファイルに出力する方法を記します.
#
#初期値データファイル生成プログラムのサンプルとして
#((<init_data.F90|URL:../../code_reference/htm/files/main/init_data_F90.html>))
#が用意されており, これは
#((<dcpam5 のビルド>)) にてコンパイルされ実行ファイル "init_data" として
#作業ディレクトリに用意されているはずです. 
#
#また, NAMELIST ファイルのサンプルとして,
#((<init_data_T21L20.nml|URL:../../src/sample_nml/init_data_T21L20.nml>))
#などを用意しています.
#この NAMELIST ファイルを編集したした後, 
#以下のように実行してください. 
##コマンドラインオプションとして "-h" や "--help" を指定することで, 
##解像度や出力されるファイル名の一覧が表示されます. 
#
#  $ ./init_data -N=init_data_T21L20.nml
#
#この例の場合には, "init_T21L20.nc" という名前のファイルが出力されます. 
#このファイルを初期値データとして入力する方法に関しては,
#((<初期値データ・リスタートデータファイルの入力>)) を参照してください. 
#
#=end JA
#
#=begin EN
#== Generate initial data file
#
#In the case of above experiment, initial data is generated internally by
#execution program. A way to output initial data to a file is described
#below.
#
#First, as above, move "practice" directory, and create a directory
#for a experiment by "make" command. Then move the directory.
#
#Executive file "init_data" and NAMELIST file
#((<init_data_T21L20.nml|URL:../../src/sample_nml/init_data_T21L20.nml>))
#are prepared for generation of initial data file. 
#At first, edit "init_data_T21L20.nml", and 
#execute as follows.
##If "-h" or "--help" are specified as command line options, 
##the resolution or output files are displayed. 
#
#  $ ./init_data -N=init_data_T21L20.nml
#
#By default, a file named "init_T21L20.nc" is output. 
#In order to use this file as initial data or restart data, 
#See ((<Input initial data or restart data file>)).
#
#=end EN
#
##################################################################


=begin JA
== 初期値 (リスタート) データファイル名の変更

ファイルから初期値データ, もしくはリスタートデータを読み込む際には,
実行時に読み込まれる NAMELIST ファイルの以下の項目を変更してください. 

  &restart_file_io_nml
    InputFile = 'init_T21L20.nc',    ! 入力する初期値/リスタートデータのファイル名
                                    ! filename of input initial/restart data
              :
  /

"InputFile" の部分に初期値データもしくはリスタートデータのファイル名を
指定します.

NAMELIST ファイルを変更後, 以下のようにその NAMELIST ファイルを -N
もしくは --namelist オプションに指定して実験を始めてください.

  $ ./bin/dcpam_main -N=./conf/dcpam_hs94_T21L20.nml | tee hs94.log

実験が開始されると, 以下のようなデータ入力のメッセージが表示されます. 

  |*** MESSAGE [restart_file_io] ***  ----- Initialization Messages -----
  |*** MESSAGE [restart_file_io] ***  Input::
  |*** MESSAGE [restart_file_io] ***    InputFile  = init_T21L20.nc
  |*** MESSAGE [restart_file_io] ***  Output::
  |*** MESSAGE [restart_file_io] ***    OutputFile = restart.nc
  |*** MESSAGE [restart_file_io] ***    IntTime    = 100. [day]
  |*** MESSAGE [restart_file_io] ***  -- version = ... rikawa Exp $
  |*** MESSAGE [HistoryGetDouble3] ***  Input init_T21L20.nc@U,time=0.
  |*** MESSAGE [HistoryGetDouble3] ***  Input init_T21L20.nc@V,time=0.
  |*** MESSAGE [HistoryGetDouble3] ***  Input init_T21L20.nc@Temp,time=0.
  |*** MESSAGE [HistoryGetDouble3] ***  Input init_T21L20.nc@QVap,time=0.
  |*** MESSAGE [HistoryGetDouble2] ***  Input init_T21L20.nc@Ps,time=0.
  |*** MESSAGE [restart_file_io] ***  Initial data (not restart data) is input from a data file "init_T21L20.nc". *B | (t-dt) and *N (t) are same.


=end JA

=begin EN
== Change initial (restart) data file name

In order to input initial data or restart data from a file, 
edit NAMELIST file as follows. 

  &restart_file_io_nml
    InputFile = 'init_T21L20.nc',    ! filename of input initial/restart data
              :
  /

Specify a filename of initial data or restart data to "InputFile". 

After change of NAMELIST file, start an experiment with -N 
or --namelist option and the NAMELIST file as follows. 

  $ ./bin/dcpam_main -N=./conf/dcpam_hs94_T21L20.conf | tee hs94.log

Starting an experiments, following data input messages may be 
displayed. Confirm them.

  |*** MESSAGE [restart_file_io] ***  ----- Initialization Messages -----
  |*** MESSAGE [restart_file_io] ***  Input::
  |*** MESSAGE [restart_file_io] ***    InputFile  = init_T21L20.nc
  |*** MESSAGE [restart_file_io] ***  Output::
  |*** MESSAGE [restart_file_io] ***    OutputFile = restart.nc
  |*** MESSAGE [restart_file_io] ***    IntTime    = 100. [day]
  |*** MESSAGE [restart_file_io] ***  -- version = ...
r |ikawa Exp $
  |*** MESSAGE [HistoryGetDouble3] ***  Input init_T21L20.nc@U,time=0.
  |*** MESSAGE [HistoryGetDouble3] ***  Input init_T21L20.nc@V,time=0.
  |*** MESSAGE [HistoryGetDouble3] ***  Input init_T21L20.nc@Temp,time=0.
  |*** MESSAGE [HistoryGetDouble3] ***  Input init_T21L20.nc@QVap,time=0.
  |*** MESSAGE [HistoryGetDouble2] ***  Input init_T21L20.nc@Ps,time=0.
  |*** MESSAGE [restart_file_io] ***  Initial data (not restart data) is input from a data file "init_T21L20.nc". *
B | (t-dt) and *N (t) are same.

=end EN


=begin JA
== 惑星表面を「沼条件 (swamp condition)」で計算する

実行用の設定ファイル (NAMELIST ファイル) において下のように設定.

* 惑星表面において 1 層モデルを選択

    &dcpam_main_nml
      ...
      PhysImpMode             = '1LayModel',
      ...
    /

* 惑星表面温度をモデル内で計算するように設定

    &surface_properties_nml
      ...
      SurfCondSetting = 'generate_internally'
      ...
    /
    &surface_data_nml
      ...
      SurfCond = 1
      ...
    /

上記設定は, 例えば, サンプルとして同梱されている設定ファイル, 
dcpam_ape_T21L16.conf を変更する場合には, 

    &surface_data_nml
      SurfCond = 1
    /

のみ追記することで実現できます (その他の設定はデフォルト値).


=end JA
=begin EN
== Set 'swamp condition'

You can set up 'swamp condition' by specifying 
the configuration file (NAMELIST file) as follows:

* Choose one-layer model at the surface

    &dcpam_main_nml
      ...
      PhysImpMode             = '1LayModel',
      ...
    /

* Surface temerature is calculated in the model

    &surface_properties_nml
      ...
      SurfCondSetting = 'generate_internally'
      ...
    /
    &surface_data_nml
      ...
      SurfCond = 1
      ...
    /

For example, when a sample configuration file "dcpam_ape_T21L16.conf" is
modified, the above configuration can be realized by adding the following item
(the other items are the default vaules).

    &surface_data_nml
      SurfCond = 1
    /

=end EN



#=begin JA
#== 飽和水蒸気圧計算スキームの変更
#
#※ 作成中 ※
#=end JA
#=begin EN
#== Change scheme of saturation water vapor
#
#!!! Under construction !!!
#=end EN
#
#
#=begin JA
#== モジュール間の依存関係ファイルの自動生成
#
#※ 作成中 ※
#=end JA
#=begin EN
#== Auto generation of dependency files between modules
#
#!!! Under construction !!!
#=end EN



#=begin JA
#== 実行プログラムの更新
#
#src ディレクトリ以下の編集を行った場合, 以下のようにすることで
#practice 以下の実験用ディレクトリの内容を簡単に更新することが
#可能です. なお, src 以下の Fortran 90/95 プログラムの変更を
#行う際には ((<らくらく dcpam5 (製作中)|URL:../rakuraku>))
#を参照してください. 
#
#まず, practice 以下の実験用ディレクトリへ移動します.
#
#  $ cd practice/testXX
#
#以下のコマンドを入力します. 更新するか問われるので, "Y" を
#入力します. 
#
#  $ make update
#
#   Update directory "testXX" ? [y/N]: Y
#
#src ディレクトリ内で更新されたファイルが practice/testXX に
#コピーされます. 古いファイルは ".bak.XX" というサフィックスが付加
#されたファイル名に変更されます. 
#
#=end JA
#
#=begin EN
#== Update execution programs
#
#After editing files under "src" directory, update of contents in 
#a directory for a experiment under "practice" is performed easily
#as follows. If you edit Fortran 90/95 programs under "src", see
#((<RAKURAKU (easier) dcpam5 (under construction)|URL:../rakuraku/index.htm.en>))
#for detail. 
#
#Forst, move a directory for a experiment under "practice".
#
#  $ cd practice/testXX
#
#Input a following command. A question whether update them may be
#displayed, then input "Y". 
#
#  $ make update
#
#   Update directory "testXX" ? [y/N]: Y
#
#Updated files under "src" directory are copied into "practice/testXX".
#Old files are renamed to filenames with suffixes ".bak.XX".
#
#=end EN




=begin JA
== 参考文献
=end JA

=begin EN
== References
=end EN

=begin
* Held, I. M., and M. J. Suarez, 1994: 
  A proposal for the intercomparison of the dynamical cores of
  atmospheric general circuation models,
  ((|Bull. Am. Meteor. Soc.|)), ((*75*)), 1825--1830.
=end

=begin HTML
<hr />
<small>
  $Id: changesetup.rd,v 1.11 2012/02/24 08:20:44 takepiro Exp $
</small>
=end HTML

