=begin JA

= 地球実験

# * 高橋 芳幸 (yot), 竹広 真一(takepiro)
#   * $Id: exp-Earth.rd,v 1.18 2015/02/11 14:59:26 yot Exp $

=end JA
=begin EN

= Experiment for the Earth

# * Yoshiyuki O. Takahashi (yot), Shin-ichi Takehiro (takepiro)
#   * $Id: exp-Earth.rd,v 1.18 2015/02/11 14:59:26 yot Exp $

=end EN


=begin JA

地球の実験を行う方法を説明します. 

この計算には以下の物理過程を用いています. 

  * 放射 (地球大気用放射)
  * 鉛直拡散 (Mellor and Yamada, 1982, レベル 2.5) 
  * 積雲パラメタリゼーション: Relaxed Arakawa-Schubert スキーム (Moorthi and Suarez, 1992) 
  * 診断型大規模凝結
  * 乾燥対流調節
  * バケツモデル

=end JA
=begin EN

A method to perform an experiment for the Earth is described. 

Following physical processes are used in this experiment.

  * Radiation (model for the Earth's atmosphere) 
  * Vertical diffusion (Mellor and Yamada, 1982, level 2.5) 
  * Cumulus parameterization: Relaxed Arakawa-Schubert scheme (Moorthi and Suarez, 1992) 
  * Large scale condensation
  * Dry convective adjustment
  * Bucket model

=end EN


=begin JA
== 概要

本実験では, 海表面温度, 地面特性, 海表面密度, オゾン分布のデータが必要です. したがって, 
実験の実行は以下の 4 つのステップで行います.

  * 実験ディレクトリの準備
  * 初期値の準備
  * 実験用データの準備
  * 実験の実行

=end JA
=begin EN
== Overview

This experiment requires data of distribution of sea surface temperature, surface properties, sea ice density, and ozone. 
So, the experiment is performed with the following 4 steps:

  * Preparation of directory for experiments
  * Preparation of initial condition
  * Preparation of additional data for experiments
  * Execution of experiments

=end EN

=begin JA

== 実験用ディレクトリ準備

DCPAM5 の数値実験はソースツリー内部では行わず
ソースツリーとは別の外部ディレクトリにて行うことを推奨いたします. 

まず DCPAM5 ソースのトップディレクトリ(以下の例では dcpam5-YYYYMMDD とする)に移動してください. 
以下では DCPAM5 ソースディレクトリの隣に ../dcpma5-exp/Earth-exp ディレクトリを作成し, そこで実験を行うことにします. 
次のように  ../dcpam5-exp/Earth-exp ディレクトリを作成し, 
移動してください. 

  $ mkdir -p ../dcpam5-exp/Earth-exp
  $ cd ../dcpam5-exp/Earth-exp

次に, このディレクトリに実行ファイルと設定ファイル置き場を作成します. 

  $ mkdir bin
  $ mkdir conf

最後に作成したディレクトリに実行ファイルと設定ファイルをコピーします. 

  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_main bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data  bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data_surface  bin
  $ cp ../../dcpam5-YYYYMMDD/exp_setup_files/*.conf conf

なお, 実行ファイルと設定ファイル (NAMELIST ファイル) があれば, どのディレクトリにおいても計算を行うことができます. 

== 初期値データファイルの作成

dcpam_init_data と init_data_E_T21L26.conf, 
および dcpam_init_data_surface と surface_data_E_T21.conf 
を用いて初期値ファイル init_T21L26.nc と surface_T21.nc を作成します. 

まず dcpam_init_data で大気中の変数の初期値を作成します. 

  $ ./bin/dcpam_init_data -N=./conf/init_data_E_T21L26.conf

   *** MESSAGE [init_data] ***  Run: Initial data generation
   *** MESSAGE [init_data] ***  -- version = $Name:  $$Id: exp-Earth.rd,v 1.18 2015/02/11 14:59:26 yot Exp $
   *** MESSAGE [namelist_util] ***  ----- Initialization Messages -----
   *** MESSAGE [namelist_util] ***    MaxNmlArySize = 256
   *** MESSAGE [namelist_util] ***  -- version = $Name:  $$Id: exp-Earth.rd,v 1.18 2015/02/11 14:59:26 yot Exp $
   *** MESSAGE [timeset] ***  NAMELIST group "timeset_nml" is loaded from "./conf/init_data_E_T21L26.conf".
                         : 
   *** MESSAGE [initial_data] ***    Ueq     = 0.
   *** MESSAGE [initial_data] ***
   *** MESSAGE [initial_data] ***  -- version = $Name:  $$Id: exp-Earth.rd,v 1.18 2015/02/11 14:59:26 yot Exp $
   *** MESSAGE [HistoryClose] ***  "init_T21L26.nc" is closed
  
   ############## CPU TIME SUMMARY ################
   others                 0.120000E-01
   ------------------------------------------------
          TOTAL TIME =    0.120000E-01

次に dcpam_init_data_surface で惑星表面の変数の初期値を作成します. 

  $ ./bin/dcpam_init_data_surface -N=./conf/surface_data_E_T21.conf

   *** MESSAGE [sst_data] ***  Run: SST data generation
   *** MESSAGE [sst_data] ***  -- version = $Name:  $$Id: exp-Earth.rd,v 1.18 2015/02/11 14:59:26 yot Exp $
   *** MESSAGE [namelist_util] ***  ----- Initialization Messages -----
   *** MESSAGE [namelist_util] ***    MaxNmlArySize = 256
   *** MESSAGE [namelist_util] ***  -- version = $Name:  $$Id: exp-Earth.rd,v 1.18 2015/02/11 14:59:26 yot Exp $
   *** MESSAGE [timeset] ***  NAMELIST group "timeset_nml" is loaded from "surface_data_E_T21.conf".
   &TIMESET_NML CAL_TYPE=noleap                          ,MONTH_IN_YEAR=-1,DAY_IN_MONTH=-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
                         : 
   *** MESSAGE [HistoryCreate1] ***  "surface_T21.nc" is created (origin=0. [day])
   *** MESSAGE [HistoryClose] ***  "surface_T21.nc" is closed

   ############## CPU TIME SUMMARY ################
   others                 0.800000E-02
   ------------------------------------------------
          TOTAL TIME =    0.800000E-02


== 実験用データの準備

実験用データとして, 海表面温度, 地面特性, 海表面密度, オゾン分布のデータを
以下に用意してあります. 

  * ((<サンプルデータ|URL:http://www.gfd-dennou.org/library/dcpam/sample/2015-02-11_tutorial/Earth/>))

上記のページから "sst_amipII_bc_clim_T021.nc", "sp_for_Earth_T021.nc", "sic_amipII_bc_clim_T021.nc", "O3_CMIP5_climatology_zonalmean_T021.nc" をダウンロードして, 実験を行うディレクトリに置いてください. 

== 実験の実行

最後に dcpam_main, dcpam_E_T21L26.nml を用いて実験を実施します. 
解像度 T21L26 で 2 日分計算を行います. 
リスタートデータ, 地表面リスタートデータといくつかのヒストリデータ
ファイルが出力されます. 

  $ ./bin/dcpam_main -N=./conf/dcpam_E_T21L26.conf | tee Earth.log

初期値データ, 地表面データ, 実験設定を変更する場合には,
上記の実行に際して conf ディレクトリ内の init_data_E_T21L26.conf, 
dcpam_E_T21L26.conf を変更してください. 

== 結果の可視化

2 日後における温度の東西平均分布は以下の図のようになります.
ただし, コードのバージョンの違いによって, 図は必ずしも下の図と全く同じにはならないかもしれません.

((:<img src="images/earth_irb_temp_meanlon_time02day.png">:))

この図は, ((<Gphys|URL:http://www.gfd-dennou.org/library/ruby/products/gphys/>)) を
用いて,  下の処理によって描画しています. 

  まず irb を起動. 

  $ irb

  以下のような irb のプロンプトが表示されます.

  irb(main):001:0>

  このプロンプトに, 以下のようにコマンドを打ちます.
  左端の数字は行番号で, 打つ必要はありません.

  1: require "numru/ggraph"
  2: include NumRu
  3: gphys = GPhys::IO.open('Temp.nc', 'Temp')
  4: DCL.gropn(1)
  5: DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)
  6: GGraph.set_fig( 'itr'=> 2 )
  7: GGraph.tone( gphys.mean('lon').cut('time'=>2) )
  8: GGraph.color_bar
  9: DCL.grcls

  irb のプロンプトにおいて quit と打つと irb を終了することができます. 

この計算で用いている初期値は等温静止大気です. 
地球大気は, 2 日間では準定常状態には達しませんので, 上記の図はスピンアップ中の状態を表しています. 

また, 解析・可視化のもう少し詳しい方法については((<こちら|URL:./visualization.htm>))を参照してください. 

== 実験の実行 その 2

例えば, 1 年間の積分を実施するには, dcpam_E_T21L26.conf 内の

 &timeset_nml
   ...
   EndYear           =     1,
   EndMonth          =     1,
   EndDay            =     3,
   ...
 /

を

 &timeset_nml
   ...
   EndYear           =     2,
   EndMonth          =     1,
   EndDay            =     1,
   ...
 /

のように書き換えて実行します.
なお, 積分期間の変更の詳細は, ((<こちら|URL:http://www.gfd-dennou.org/library/dcpam/dcpam5/dcpam5_latest/doc/rakuraku/pub/rakuraku.pdf>))を参照してください.

この計算は, 比較的時間がかかります.
例えば, Intel(R) Core(TM) i7-4770K CPU @ 3.50GHz のある計算機では,
7 時間程度かかります. 

この計算の終了時点での温度分布を, 上に述べた GPhys スクリプトで描いてみると,
下のようになるでしょう.
ただし, コードのバージョンの違いによって, 図は必ずしも下の図と全く同じにはならないかもしれません.

((:<img src="images/earth_irb_temp_meanlon_time365day.png">:))

=end JA

=begin EN

== Preparation of a directory for an experiment

Let us move to the top directory of DCPAM5 src tree
(assuming dcpam5-YYYYMMDD in the following example). 
Here, we perform an experiment in ../dcpam5-exp/Earth-exp directory. 
Please create the directory and enter there as follows: 

  $ mkdir -p ../dcpam5-exp/Earth-exp
  $ cd ../dcpam5-exp/Earth-exp

Then, pleaase create the directories for executable files and configuration
files as follows:

  $ mkdir bin
  $ mkdir conf

Finally, executable files and configuration files are copied as follows: 

  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_main bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data  bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data_surface  bin
  $ cp ../../dcpam5-YYYYMMDD/exp_setup_files/*.conf conf

Here, we perform an experiment in practice/Earth-exp directory. 
Please create the directory and enter there as follows: 

  $ cd practice
  $ mkdir Earth-exp
  $ cd Earth-exp

Note that you can perform an experiment in any directory by using executable files and configuration (NAMELIST) files.

== Preparation of initial data

Create initial data file "init_T21L26.nc"
using "bin/dcpam_init_data", "conf/init_data_E_T21L26.conf" 
and "bin/dcpam_init_data_surface", "conf/surface_data_E_T21.conf"

  $ ./bin/dcpam_init_data -N=./conf/init_data_E_T21L26.conf

   *** MESSAGE [init_data] ***  Run: Initial data generation
   *** MESSAGE [init_data] ***  -- version = $Name:  $$Id: exp-Earth.rd,v 1.18 2015/02/11 14:59:26 yot Exp $
   *** MESSAGE [namelist_util] ***  ----- Initialization Messages -----
   *** MESSAGE [namelist_util] ***    MaxNmlArySize = 256
   *** MESSAGE [namelist_util] ***  -- version = $Name:  $$Id: exp-Earth.rd,v 1.18 2015/02/11 14:59:26 yot Exp $
   *** MESSAGE [timeset] ***  NAMELIST group "timeset_nml" is loaded from "./connf/init_data_E_T21L26.conf".
                         : 
   *** MESSAGE [initial_data] ***    Ueq     = 0.
   *** MESSAGE [initial_data] ***
   *** MESSAGE [initial_data] ***  -- version = $Name:  $$Id: exp-Earth.rd,v 1.18 2015/02/11 14:59:26 yot Exp $
   *** MESSAGE [HistoryClose] ***  "init_T21L26.nc" is closed
  
   ############## CPU TIME SUMMARY ################
   others                 0.120000E-01
   ------------------------------------------------
          TOTAL TIME =    0.120000E-01


  $ ./bin/dcpam_init_data_surface -N=./conf/surface_data_E_T21.conf

 *** MESSAGE [sst_data] ***  Run: SST data generation
 *** MESSAGE [sst_data] ***  -- version = $Name:  $$Id: exp-Earth.rd,v 1.18 2015/02/11 14:59:26 yot Exp $
 *** MESSAGE [namelist_util] ***  ----- Initialization Messages -----
 *** MESSAGE [namelist_util] ***    MaxNmlArySize = 256
 *** MESSAGE [namelist_util] ***  -- version = $Name:  $$Id: exp-Earth.rd,v 1.18 2015/02/11 14:59:26 yot Exp $
 *** MESSAGE [timeset] ***  NAMELIST group "timeset_nml" is loaded from "surface_data_E_T21.conf".
 &TIMESET_NML CAL_TYPE=noleap                          ,MONTH_IN_YEAR=-1,DAY_IN_MONTH=-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
                         : 
 *** MESSAGE [HistoryCreate1] ***  "surface_T21.nc" is created (origin=0. [day])
 *** MESSAGE [HistoryClose] ***  "surface_T21.nc" is closed

 ############## CPU TIME SUMMARY ################
 others                 0.800000E-02
 ------------------------------------------------
        TOTAL TIME =    0.800000E-02

== Preparation of additional data

This experiment requires additional data, sea surface temperature, surface properties, sea ice density, and ozone distribution. 
Those data are prepared at following site.

  * ((<sample data|URL:http://www.gfd-dennou.org/library/dcpam/sample/2011-02-19_tutorial/Earth/>))

Please download "sst_amipII_bc_clim_T021.nc", "sp_for_Earth_T021.nc", "sic_amipII_bc_clim_T021.nc", and "O3_CMIP5_climatology_zonalmean_T021.nc" from above site, and place those files at experimental directory. 


== Run the experiment

At the last, run a experiment using 
"dcpam_main" and "dcpam_E_T21L26.conf". 
Resolution is T21L26. 
Integration time is 2 days. 
A restart data file, a restart data file of surface data,
and some history data files are output. 

  $ ./bin/dcpam_main -N=./conf/dcpam_E_T21L26.conf | tee Earth.log

If initial data, surface data, settings of experiments want to be
changed, edit "init_data_T21L26.conf", 
"dcpam_E_T21L26.conf" in "conf" directory. 


== Visualization of result

Zonal mean temperature distribution after integration for 2 days is shown below. 
It should be noted that the figure you draw may not be the same as that shown here because of difference in model version. 

((:<img src="images/earth_irb_temp_meanlon_time02day.png">:))

This figure is drawn by using ((<Gphys|URL:http://www.gfd-dennou.org/library/ruby/products/gphys/>)), as follows: 

  Please type irb. 

  $ irb

  Following prompt of irb is shown. 

  irb(main):001:0>

  Type following lines. Please note that the left-most number is line number, and it has not been typed. 

  1: require "numru/ggraph"
  2: include NumRu
  3: gphys = GPhys::IO.open('Temp.nc', 'Temp')
  4: DCL.gropn(1)
  5: DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)
  6: GGraph.set_fig( 'itr'=> 2 )
  7: GGraph.tone( gphys.mean('lon').cut('time'=>2) )
  8: GGraph.color_bar
  9: DCL.grcls

  Type quit to exit irb. 

Above figure shows spin-up phase of the atmosphere, because the Earth's atmosphere 
does not reach quasi-equilibrium in 2 days. 


=end EN

#=begin JA
#== 最後に
#実験ディレクトリに作成された計算結果を保存しておきたい場合には
#データ用ディレクトリ(例えば data01)を作成し, 
#ファイルを移動させて整理しておきましょう. 
#
#  $ mkdir data01
#  $ mv *.nc *.log data01/
#
#なお, 計算結果を計算実行時にサブディレクトリへ出力することも可能です. 
#((<実験設定の変更|URL:./changesetup.htm>))の出力設定の変更を参照し, 
#NAMELIST "&gtool_historyauto_nml" の変数 "FilePrefix" による設定を試してみて下さい. 
#=end JA
#
#=begin EN
#== Final remark
#If you would like to keep the results of the numerical experiment, 
#please create a sub directory ("data01" for example), move the files, 
#and keep the current directory neatly. 
#
#  $ mkdir data01
#  $ mv *.nc *.log data01/
#
#You can output the results of the numerical experimet concurrently with the
#execution. Please refer to "Change output settings" 
#in ((<Change experimental setup|URL:./changesetup.htm.en>)) 
#and try to configure "FilePrefix" variable in NAMELIST "&gtool_historyauto_nml". 
#
#=end EN

=begin JA
== 参考文献
=end JA

=begin EN
== References
=end EN

=begin

#* Manabe, S., J. Smagorinsky, and R. F. Strickler, 1965: 
#  Simulated climatology of a general circulation model with a
#  hydrologic cycle,
#  ((|Mon. Wea. Rev.|)), ((*93*)), 769--798.

* ((<Mellor, G. L., and T. Yamada, 1974: 
  A hierarchy of turbulence closure models for planetary
  boundary layers,
  ((|J. Atmos. Sci.|)), ((*31*)), 1791--1806.
  |URL:http://journals.ametsoc.org/doi/abs/10.1175/1520-0469%281974%29031%3C1791%3AAHOTCM%3E2.0.CO%3B2>))

* ((<Moorthi, S., and M. J. Suarez, 1992:
  Relaxed Arakawa-Schubert: A parameterization of moist convection for 
  general circulation models, 
  ((|Mon. Wea. Rev.|)), ((*120*)), 978--1002.
  |URL:http://journals.ametsoc.org/doi/abs/10.1175/1520-0493%281992%29120%3C0978%3ARASAPO%3E2.0.CO%3B2>))
=end

=begin HTML
<hr />
<small>
  $Id: exp-Earth.rd,v 1.18 2015/02/11 14:59:26 yot Exp $
</small>
=end HTML

