require "numru/ggraph"
include NumRu

script_name = 'js_loop_chktime.rb'
outfilename = 'js_loop_chktime.restart_time'

if ARGV.size == 0 then
  print script_name, ": ", "Argument is required.\n"
  exit
end

ncfn  = ARGV[0]
vname = "PsN"

begin
  url = ncfn + "@" + vname
  gphys = GPhys::IO.open_gturl( url )
  print script_name, ": ", "Read PsN successfully.\n"
rescue => error
  print script_name, ": ", "Unable to find PsN.\n"
  print script_name, ": ", "Try to read Ps.\n"
  begin
    vname = "Ps"
    url = ncfn + "@" + vname
    gphys = GPhys::IO.open_gturl( url )
    print script_name, ": ", "Read Ps successfully.\n"
  rescue => error
    print script_name, ": ", "Unable to find PsN nor Ps.\n"
    exit
  end
end

print script_name, ": ", "read time = ", gphys.coord('time').val[-1], "\n"

File.open( outfilename, mode = "w" ){|f|
  f.write( gphys.coord('time').val[-1].to_s )
}
print script_name, ": ", "  This time is written in ", outfilename, ".\n"
