#!/bin/bash

id='Earth_AMIPII_T042L26'
mailaddr='yot@people.kobe-u.ac.jp'
fn_current="js_loop_current"
fn_limit="js_loop_limit"
fn_integ_time="js_loop_integ_time"
fn_dcpam_conf="dcpam_E_T42L26.conf"
fn_dcpam_conf_template="template_"$fn_dcpam_conf
fn_qsub="js_vizfront_dcpam.sh"
fn_chk_restart_time="./js_loop_chktime_dir/js_loop_chktime"

#fn_chkfile="stdout.log"
fn_chkfile="stderr.log"


while :
do

    # current
    if [ ! -e $fn_current ] ; then
	echo "ERROR: File" $fn_current "does not exist."
	if [ -n $mailaddr ] ; then
	    echo "ERROR: File" $fn_current "does not exist." \
		| mail -s $id $mailaddr
	fi
	exit
    fi
    list=(`cat ${fn_current}`)
    iloop=${list[0]}
    iloop_prev=$(( $iloop-1 ))
    restart_year=${list[1]}
    restart_mon=${list[2]}
    # integration time
    if [ ! -e $fn_integ_time ] ; then
        echo "ERROR: File" $fn_integ_time "does not exist."
        if [ ! $mailaddr = '' ] ; then
            echo "ERROR: File" $fn_integ_time "does not exist." \
                | mail -s $id $mailaddr
        fi
        exit
    fi
    list=(`cat ${fn_integ_time}`)
    integ_year=${list[0]}
    integ_mon=${list[1]}
    #
    end_year=$(( $restart_year+$integ_year ))
    end_mon=$(( $restart_mon+$integ_mon ))
    if [ $end_mon -gt 12 ] ; then
        end_year=$(( $end_year+1 ))
        end_mon=1
    fi

    if [ $iloop -lt 10 ] ; then
        cdirname="000"$iloop
    elif [ $iloop -lt 100 ] ; then
        cdirname="00"$iloop
    elif [ $iloop -lt 1000 ] ; then
        cdirname="0"$iloop
    else
        cdirname=$iloop
    fi
    if [ $iloop_prev -lt 10 ] ; then
        cdirname_prev="000"$iloop_prev
    elif [ $iloop_prev -lt 100 ] ; then
        cdirname_prev="00"$iloop_prev
    elif [ $iloop_prev -lt 1000 ] ; then
        cdirname_prev="0"$iloop_prev
    else
        cdirname_prev=$iloop_prev
    fi


    cat template_js_loop_chktime.nml \
	| sed -e s#RESTARTFILENAME#${cdirname_prev}/rst_rank000000.nc#g \
	> js_loop_chktime.nml
    ./$fn_chk_restart_time > js_loop_chktime.restart_time
    list=(`cat js_loop_chktime.restart_time`)
    restart_time=${list[0]}


    # limit
    if [ ! -e $fn_limit ] ; then
        echo "ERROR: File" $fn_limit "does not exist."
        if [ ! $mailaddr = '' ] ; then
            echo "ERROR: File" $fn_limit "does not exist." \
                | mail -s $id $mailaddr
        fi
        exit
    fi
    iloope=`cat ${fn_limit}`


    echo "LOOP:" $iloop


    if [ $iloop -le $iloope ] ; then

	if [ ! -e $fn_dcpam_template ] ; then
	    echo "ERROR: File" $fn_dcpam_template "does not exist."
	    if [ -n $mailaddr ] ; then
		echo "ERROR: File" $fn_dcpam_template "does not exist." \
		    | mail -s $id $mailaddr
	    fi
	    exit
	fi
        cat $fn_dcpam_conf_template \
            | sed -e s/RESTARTTIME/$restart_time/g \
            | sed -e s/RESTARTFILEDIR/$cdirname_prev/g \
            | sed -e s/ENDYEAR/$end_year/g \
            | sed -e s/ENDMON/$end_mon/g \
            > $fn_dcpam_conf

        echo "     CALCULATION: " $iloop
        echo "                  " "From" $restart_time "sec"
        echo "                  " "From" $restart_year"/"$restart_mon "to" $end_year"/"$end_mon
        if [ ! $mailaddr = '' ] ; then
            echo -e "     CALCULATION: " $iloop "\n" \
                    "                  " "From" $restart_time "sec" "\n" \
                    "                  " "From" $restart_year"/"$restart_mon "to" $end_year"/"$end_mon \
                | mail -s $id $mailaddr
        fi


	qsub $fn_qsub
	#nohup mpiexec -n 8 ./dcpam_main -N=./dcpam_V_T10L50.conf


	# Loop for waiting until DCPAM finishes
	while :
	do

	    if [ -e $fn_chkfile ] ; then

		if [ -s $fn_chkfile ] ; then
		    echo "ERROR: File", $fn_chkfile "is not empty."
		    if [ -n $mailaddr ] ; then
			echo "ERROR: File", $fn_chkfile "is not empty." \
			    | mail -s $id $mailaddr
		    fi
		    exit
		fi

		mkdir $cdirname
		mv $fn_dcpam *.nc stdout.log $fn_chkfile $cdirname

		iloop_next=$(( $iloop+1 ))

		echo $iloop_next        >  $fn_current
		echo $end_year $end_mon >> $fn_current
#		echo "NEXT" $fn_current
#		echo "----------------------------"
#		cat $fn_current
#		echo "----------------------------"

		break
	    else
		sleep 600
	    fi

	done


    else

	break

    fi

done

echo "Finish"
if [ -n $mailaddr ] ; then
    echo "Finish" \
	| mail -s $id $mailaddr
fi
