module sltt_const
  !
  != セミラグランジュ法 で用いる定数
  !
  != Constants for Semi-Lagrangian method
  !

  ! 種別型パラメタ
  ! Kind type parameter
  !
  use dc_types, only: DP    ! 倍精度実数型. Double precision.

  ! メッセージ出力
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! 格子点設定
  ! Grid points settings
  !
  use gridset, only:       &
    &                imax, & ! 経度格子点数.
                             ! Number of grid points in longitude
    &                jmax, & ! 緯度格子点数.
                             ! Number of grid points in latitude
    &                kmax, & ! 鉛直層数.
                             ! Number of vertical level
    &                jmax_global

  ! 宣言文 ; Declaration statements
  !
  implicit none
  private

  ! 公開手続き
  ! Public procedure
  !
  public :: SLTTConstInit


  ! 公開変数
  ! Public variables
  !
!!$  public :: jew !, dtjw
  public :: dtjw
  public :: iexmin
  public :: iexmax
  public :: jexmin
  public :: jexmax
  public :: jmaxh
  public :: jexglobalmin
  public :: jexglobalmax
  public :: Pix2, PIH
  public :: nloop_dp_h, nloop_dp_v


  !
  ! local variables
  !
  ! Set minimum and maximu indices for south-north separate extended arrays
  !
  integer, save :: iexmin
  integer, save :: iexmax
  integer, save :: jexmin
  integer, save :: jexmax
  integer, save :: jmaxh
  integer, save :: jexglobalmin
  integer, save :: jexglobalmax

  !
  ! jew : latitudinal edge width
  !     : jew >= 4 and dtjw (dtjw is defined below)
  !     : In the current version of implimented semi-Lagrangian scheme, 
  !     : the lower limit of jew is 4, which is restricted by the number of
  !     : latitudinal grids needed to estimate values at poles. 
  !
!!$  integer, parameter         :: jew = 3
  !
  ! dtiw : data transfer longitudinal grid width
  ! dtjw : data transfer latitudinal grid width
!!$  !      : int( C * 2 ) + 3 <= mpjwidth <= jmax and jew
!!$  !      : The mpjwidth must be less than jmax and jew, which is defined 
!!$  !      : above.
!!$  !      : The lower limit of mpjwidth is 3, if the Courant number is
!!$  !      :                      less than 0.5. 
!!$  !      : The lower limit of mpjwidth is 4, if the Courant number is
!!$  !      : greater than 0.5 and less than 1. 
!!$  !      : The lower limit of mpjwidth is 5, if the Courant number is
!!$  !      : greater than 1   and less than 1.5. 
!!$  !      : (But now, if the Courant number is greater than 0.5, this 
!!$  !      : routine would stop in sltt_dp_h and sltt_hiq routines.)
!!$  !
!!$  integer, parameter         :: dtiw = 2
!!$  integer, parameter         :: dtjw = 2
!!$  integer, parameter         :: dtiw = 3
!!$  integer, parameter         :: dtjw = 3
  integer, save         :: dtiw
  integer, save         :: dtjw

  real(DP), save             :: PIx2, PIH


  integer, save              :: nloop_dp_h = 4
  integer, save              :: nloop_dp_v = 4


  ! 非公開変数
  ! Private variables
  !
  logical, save :: sltt_const_inited = .false.
                              ! 初期設定フラグ.
                              ! Initialization flag



  character(*), parameter:: module_name = 'sltt_const'
                              ! モジュールの名称.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: sltt_const.f90,v 1.2 2013/01/27 11:26:14 yot Exp $'
                              ! モジュールのバージョン
                              ! Module version


  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine SLTTConstInit

    ! 種別型パラメタ
    ! Kind type parameter
    !
    use dc_types, only: &
      & STDOUT              ! 標準出力の装置番号. Unit number of standard output

    ! NAMELIST ファイル入力に関するユーティリティ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ファイル入出力補助
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    use gridset    , only : jmax
    use constants0 , only : PI

    !
    ! local variables
    !

    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
                              ! IOSTAT of NAMELIST read

    ! NAMELIST 変数群
    ! NAMELIST group name
    !
    namelist /sltt_const_nml/ &
      & dtiw, &
      & dtjw
          !
          ! デフォルト値については初期化手続 "sltt_const#SLTTConstInit"
          ! のソースコードを参照のこと.
          !
          ! Refer to source codes in the initialization procedure
          ! "sltt_const#SLTTConstInit" for the default values.
          !


    ! 実行文 ; Executable statement
    !

    if ( sltt_const_inited ) return


    ! デフォルト値の設定
    ! Default values settings
    !
    dtiw = 2
    dtjw = 2


    ! NAMELIST の読み込み
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &            ! (in)
        & nml = sltt_const_nml, &  ! (out)
        & iostat = iostat_nml )    ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = sltt_const_nml )
    end if


    PIx2 = PI + PI
    PIH  = PI / 2.0_DP

!!$    if( jew > jmax/2 ) then
!!$      write( 6, * ) "SLTT ERROR : MYRANK = ", myrank, &
!!$        " JEW = ", jew, " JMAX/2 = ", jmax/2
!!$      write( 6, * ) "SLTT ERROR : JEW MUST BE LESS THAN JMAX."
!!$      stop
!!$    end if

!!$    if( nprocs > 1 ) then
!!$      if( jmax/2 < dtjw ) then
!!$        write( 6, * ) "SLTT ERROR : MYRANK = ", myrank, &
!!$          " JMAX/2 = ", jmax/2, " TRANSFERED J WIDTH = ", dtjw
!!$        write( 6, * ) "SLTT ERROR : JMAX MUST BE GREATER THAN TRANSFERED J WIDTH."
!!$        stop
!!$      end if
!!$    end if


    ! Set minimum and maximu indices for south-north separate extended arrays
!!$    iexmin = -2          ! width of halo region of dtjw
!!$    iexmax = imax-1+1+2  ! 1 for 360 longitude and width of halo region of dtjw
!!$    if ( myrank == (nprocs-1) ) then
!!$      jexmins = -dtjw          ! minimum j of southern array
!!$      jexmaxs = jmax/2+dtjw    ! maximum j of southern array
!!$      jexminn = -dtjw+1        ! maximum j of northern array
!!$      jexmaxn = jmax/2+1+dtjw  ! maximum j of northern array
!!$    else
!!$      jexmins = -dtjw+1        ! minimum j of southern array
!!$      jexmaxs = jmax/2+dtjw    ! maximum j of southern array
!!$      jexminn = -dtjw+1        ! maximum j of northern array
!!$      jexmaxn = jmax/2+dtjw    ! maximum j of northern array
!!$    end if

    jmaxh = jmax/2

    iexmin = 0-dtiw         ! width of halo region of dtiw
    iexmax = imax-1+dtiw    ! 1 for 360 longitude and width of halo region of dtiw
    jexmin = -dtjw+1        ! minimum j of southern array
    jexmax = jmaxh+dtjw     ! maximum j of southern array

    jexglobalmin = -dtjw+1
    jexglobalmax = jmax_global+dtjw


    ! 印字 ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  dtiw = %d', i = (/ dtiw /) )
    call MessageNotify( 'M', module_name, '  dtjw = %d', i = (/ dtjw /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    sltt_const_inited = .true.

  end subroutine SLTTConstInit

  !--------------------------------------------------------------------------------------

end module sltt_const
