# draw vertically averaged zonal spectra of the eddy variance of zonal wind
# 
# 更新履歴
# 
# 2009/03/29  納多 哲史   新規作成
# 

def help()
  print "Usage: ruby ",$0," file varname\n"
end

require "numru/ggraph"
include NumRu

# 引数のチェック
if ARGV[0] == "-h" or ARGV[0] == "--help" then
  help()
  exit 0
elsif ARGV.length != 2 then
  puts "ERROR: The number of argument is invalid."
  help()
  exit 1
end

file = ARGV[0]
varname = ARGV[1]

if !FileTest.file?(file) then
  puts "ERROR: No such file."
  exit 2
end

gphys = GPhys::IO.open(file, varname)
lon_length = gphys.coord('lon').length
gphys = gphys.cut('time'=>200..1200)

# for debug
# gphys = gphys.cut('sig'=>0.3..0.5)

gphys = (gphys - gphys.mean('lon'))
gphys = gphys.fft(nil, 0) / lon_length
gphys = gphys.abs**2
gphys = gphys.rawspect2powerspect(0)
gphys = gphys.spect_zero_centering(0)
gphys = gphys.cut('lon'=>0..15)
gphys = gphys.mean('sig', 'time')

DCL.gropn(2)

GGraph.set_fig('viewport'=>[0.15,0.80,0.15,0.6])

DCL.sgpset('lfull',true)     # 全画面表示
DCL.sgpset('lcntl', false) ; DCL.uzfact(0.6)

#GGraph.set_linear_contour_options( 'interval'=>0.5 ) # 'max'=>10 )

GGraph.contour(gphys) 

DCL.grcls
