= README
== 準備
* 依存ライブラリ
  * Ruby1.9 以上
  * GPhys1.3.1 以上

* 資源の取得
 $ wget https://www.gfd-dennou.org/arch/dcpam/related-program/2014-03-14_shokichi/script_draw-2014-03-14.tgz

* 解凍
 $ tar xvzf script_draw-2014-03-14.tgz

== 使い方
* Rakefile.dcpamを作業をおこなうディレクトリに移動
 $ cp Rakefile.dcpam /hogehoge/work/Rakefile

* Rakefile内のrequireの行を自分の環境に合わせて編集
 require "path/script_draw-2014-03-14/lib/dcpam.rb"

* list_fileにリストファイルを指定
  * リストファイルについては下記の[複数の実験データを扱う場合]を参照
 list_file = "/tako/ika.list"

* list_fileを指定しない場合
  * Rakefile と同じディレクトリ(ここでは/hogehoge/work/)に解析したい NetCDF ファイルを置く
 $ ls 
 EvapA.nc   OLRA.nc   Rakefile ...


* 実行
 $ rake all

質量流線関数,  相対湿度, 可降水量の計算と
図の作成がおこなわれる. 


=== 描画をおこなう場合(物理量の計算はおこなわない)
 $ rake all_draw
緯度分布, 子午面分布, 水平分布, 全球平均の時間変化
の図が作成される. これらを個別に作成したい場合には
以下のコマンドを用いる. 

* 各図の設定
hoge_conf によって各図の体裁を整えることができる. 

:例
 lat_conf = {
   "OSRA"        =>{"min"=>-400, "max"=>0},   #<= ここにGGraphのオプションを指定する
   "OLRA"        =>{"min"=>0, "max"=>400},
 }


==== 緯度分布の図
 $ rake lat

* 時間平均経度平均
* 高さ方向にデータがある場合は大気最下層

==== 子午面分布の図
 $ rake latsig

* 時間平均経度平均

==== 水平分布の図
 $ rake lonlat

* 時間平均
* 高さ方向にデータがある場合は大気最下層

==== 全球平均の時間変化
 $ rake time

* 高さ方向にデータがある場合は大気最下層

=== 図の保存
現在, 図のフォーマットは以下のものが選択できる. 
* ps
* eps
* png

ただし, epsを使うには
((<pstoeps.rb|URL:http://davis.gfd-dennou.org/rubygadgets/ja/?cmd=view&p=%28Application%29PS%A5%D5%A5%A1%A5%A4%A5%EB%A4%F2EPS%A5%D5%A5%A1%A5%A4%A5%EB%A4%CB%CA%D1%B4%B9&key=psto>))
が必要である. 
(pstoeps.rbがない場合はpsファイルが作られる)

=== 物理量の計算をおこなう場合(図を作成しない), 
 $ rake all_anly
質量流線関数(MSF.nc), 相対湿度(RH.nc), 可降水量(PrcWtr.nc)の
ファイルが作られる. 
これらを個別に作成したい場合は以下のコマンドを用いる.  

==== 質量流線関数
 $ rake msf

==== 相対湿度
 $ rake rh

==== 可降水量
 $ rake prcwtr


=== 複数の実験データを扱う場合
リストファイルを使うと複数の実験データを一括して解析することができる. 

リストファイルはRakefile 内の list_file で指定する. 
:例 リストファイル /tako/ika.listを指定する場合
 list_file =  "/tako/ika.list"

* 拡張子は list にする


ika.listには以下のようにデータの置いてあるディレクトリを書いておく
 [データの凡例],[ディレクトリ]

* 行の先頭に# を付けるとその行はコメントアウトされる
* 行の先頭に! を付けると標準実験として認識される
 
:例 ika.listの中身
 Test1,/home/foo/dcpam-exp/test1/data/
 Test2,/home/foo/dcpam-exp/test2/data/
 !Test3,/work1/foo/dcpam-exp/test3/data/ #<=標準実験
 #Tes4,/mnt/hdd1/foo/dcpam-exp/test4/data/ #<=コメントアウトされる

=== 時間の切り出し
データのある特定の期間だけを切り出して
描画したい場合は Rakefile 内の time_range を設定すると
 gphys = gphys.cut("time"=>time_range)
の処理がおこなわれる. 

: 例 1440日目から1800日目までを切り出す場合
 time_range = 1440..1800

* time_range の単位は NetCDF ファイル内の time: units に従う 
 
=== 時間平均の計算
時間平均・経度平均の処理は描画スクリプトでも行われる.  
しかし扱うデータのサイズが大きい場合, 処理に時間がかかる or 
メモリーリークを起こしてしまうため, 
事前に平均化処理をおこなっておくことをおすすめする. 

 $ rake time_mean

と実行すると MT_[変数名].nc ファイルが生成される


=== MPI計算をおこなった場合の分割ファイル
MPI計算によって分割して出力されたファイル(例: Temp_rank001.nc, 
Temp_rank001.nc,...)は事前に結合しておかなくても
内部でひとつのファイルとして扱われる(GPhys1.3.1以上が必要). 

