    !**************************************************************************

    subroutine logintp2p_real( im, jm, km, gp1, garr1, km2, gp2, garr2, fillvalue )

      use vtype_module

      implicit none

      integer(i4b), intent(in)  :: im, jm, km
      real(sp)    , intent(in)  :: gp1( im, jm, km ), garr1( im, jm, km )
      integer(i4b), intent(in)  :: km2
      real(sp)    , intent(in)  :: gp2( km2 )
      real(sp)    , intent(out) :: garr2( im, jm, km2 )
      real(sp)    , intent(in ) :: fillvalue


      ! Local variables
      !
      real(sp)     :: gp2_3d( im, jm, km2 )
      integer(i4b) :: k

      do k = 1, km2
         gp2_3d( :, :, k ) = gp2( k )
      end do

      call logintp2p3d_real( im, jm, km, gp1, garr1, km2, gp2_3d, garr2, fillvalue )


    end subroutine logintp2p_real

    !**************************************************************************

    subroutine logintp2p3d_real( im, jm, km, gp1, garr1, km2, gp2, garr2, fillvalue )

      use vtype_module

      implicit none

      integer(i4b), intent(in)  :: im, jm, km
      real(sp)    , intent(in)  :: gp1( im, jm, km ), garr1( im, jm, km )
      integer(i4b), intent(in)  :: km2
      real(sp)    , intent(in)  :: gp2( im, jm, km2 )
      real(sp)    , intent(out) :: garr2( im, jm, km2 )
      real(sp)    , intent(in ) :: fillvalue


      ! Local variables
      !
      real(sp)     :: wkgp1( km ), wkgarr1( km )
      integer(i4b) :: i, j, k, l


      do j = 1, jm
         do i = 1, im

            if( gp1( i, j, 1 ) .le. gp1( i, j, 2 ) ) then
               do k = 1, km
                  wkgp1( k )   = gp1( i, j, k )
                  wkgarr1( k ) = garr1( i, j, k )
               end do
            else
               do k = 1, km
                  wkgp1( k )   = gp1( i, j, km-(k-1) )
                  wkgarr1( k ) = garr1( i, j, km-(k-1) )
               end do
            end if

            do k = 1, km2

#ifdef WITHMISSINGVALUE
               if( wkgp1( 1 ) .gt. gp2( i, j, k ) ) then
                  garr2( i, j, k ) = fillvalue
               else
                  search_index: do l = 2, km
                     if( wkgp1( l ) .ge. gp2( i, j, k ) ) exit search_index
                  end do search_index

                  if( l .eq. km+1 ) then
                     garr2( i, j, k) = fillvalue
                  else
                     garr2( i, j, k ) = ( wkgarr1( l ) - wkgarr1( l-1 ) ) &
                          / ( log( wkgp1( l )/wkgp1( l-1 ) ) ) &
                          *( log( gp2( i, j, k ) / wkgp1( l-1 ) ) ) &
                          + wkgarr1( l-1 )
                  end if
               end if
#else
               search_index: do l = 2, km
                 if( wkgp1( l ) .ge. gp2( i, j, k ) ) exit search_index
               end do search_index

               l = min( l, km )

               garr2( i, j, k ) = ( wkgarr1( l ) - wkgarr1( l-1 ) ) &
                 / ( log( wkgp1( l )/wkgp1( l-1 ) ) ) &
                 *( log( gp2( i, j, k ) / wkgp1( l-1 ) ) ) &
                 + wkgarr1( l-1 )
#endif


            end do
         end do
      end do


    end subroutine logintp2p3d_real

    !**************************************************************************

    subroutine logintp2p( im, jm, km, gp1, garr1, km2, gp2, garr2, fillvalue )

      use vtype_module

      implicit none

      integer(i4b), intent(in)  :: im, jm, km
      real(dp)    , intent(in)  :: gp1( im, jm, km ), garr1( im, jm, km )
      integer(i4b), intent(in)  :: km2
      real(dp)    , intent(in)  :: gp2( km2 )
      real(dp)    , intent(out) :: garr2( im, jm, km2 )
      real(dp)    , intent(in ) :: fillvalue


      ! Local variables
      !
      real(dp)     :: gp2_3d( im, jm, km2 )
      integer(i4b) :: k

      do k = 1, km2
         gp2_3d( :, :, k ) = gp2( k )
      end do

      call logintp2p3d( im, jm, km, gp1, garr1, km2, gp2_3d, garr2, fillvalue )


    end subroutine logintp2p

    !**************************************************************************

    subroutine logintp2p3d( im, jm, km, gp1, garr1, km2, gp2, garr2, fillvalue )

      use vtype_module

      implicit none

      integer(i4b), intent(in)  :: im, jm, km
      real(dp)    , intent(in)  :: gp1( im, jm, km ), garr1( im, jm, km )
      integer(i4b), intent(in)  :: km2
      real(dp)    , intent(in)  :: gp2( im, jm, km2 )
      real(dp)    , intent(out) :: garr2( im, jm, km2 )
      real(dp)    , intent(in ) :: fillvalue


      ! Local variables
      !
      real(dp)     :: wkgp1( km ), wkgarr1( km )
      integer(i4b) :: i, j, k, l


      do j = 1, jm
         do i = 1, im

            if( gp1( i, j, 1 ) .le. gp1( i, j, 2 ) ) then
               do k = 1, km
                  wkgp1( k )   = gp1( i, j, k )
                  wkgarr1( k ) = garr1( i, j, k )
               end do
            else
               do k = 1, km
                  wkgp1( k )   = gp1( i, j, km-(k-1) )
                  wkgarr1( k ) = garr1( i, j, km-(k-1) )
               end do
            end if

            do k = 1, km2

#ifdef WITHMISSINGVALUE
               if( wkgp1( 1 ) .gt. gp2( i, j, k ) ) then
                  garr2( i, j, k ) = fillvalue
               else
                  search_index: do l = 2, km
                     if( wkgp1( l ) .ge. gp2( i, j, k ) ) exit search_index
                  end do search_index

                  if( l .eq. km+1 ) then
                     garr2( i, j, k) = fillvalue
                  else
                     garr2( i, j, k ) = ( wkgarr1( l ) - wkgarr1( l-1 ) ) &
                          / ( log( wkgp1( l )/wkgp1( l-1 ) ) ) &
                          *( log( gp2( i, j, k ) / wkgp1( l-1 ) ) ) &
                          + wkgarr1( l-1 )
                  end if
               end if
#else
               search_index: do l = 2, km
                 if( wkgp1( l ) .ge. gp2( i, j, k ) ) exit search_index
               end do search_index

               l = min( l, km )

               garr2( i, j, k ) = ( wkgarr1( l ) - wkgarr1( l-1 ) ) &
                 / ( log( wkgp1( l )/wkgp1( l-1 ) ) ) &
                 *( log( gp2( i, j, k ) / wkgp1( l-1 ) ) ) &
                 + wkgarr1( l-1 )
#endif


            end do
         end do
      end do


    end subroutine logintp2p3d

    !**************************************************************************

    subroutine logintp2p_ES( im, jm, km, gp1, garr1, km2, gp2, garr2, fillvalue )

      use vtype_module

      implicit none

      integer(i4b), intent(in)  :: im, jm, km
      real(dp)    , intent(in)  :: gp1( im, jm, km ), garr1( im, jm, km )
      integer(i4b), intent(in)  :: km2
      real(dp)    , intent(in)  :: gp2( km2 )
      real(dp)    , intent(out) :: garr2( im, jm, km2 )
      real(dp)    , intent(in ) :: fillvalue


      ! Local variables
      !
      real(dp)     :: gp2_3d( im, jm, km2 )
      integer(i4b) :: k

      do k = 1, km2
         gp2_3d( :, :, k ) = gp2( k )
      end do

      call logintp2p3d_ES( im, jm, km, gp1, garr1, km2, gp2_3d, garr2, fillvalue )


    end subroutine logintp2p_ES

    !**************************************************************************

    subroutine logintp2p3d_ES( im, jm, km, gp1, garr1, km2, gp2, garr2, fillvalue )

      use vtype_module

      implicit none

      integer(i4b), intent(in)  :: im, jm, km
      real(dp)    , intent(in)  :: gp1  ( im, jm, km  ), garr1( im, jm, km )
      integer(i4b), intent(in)  :: km2
      real(dp)    , intent(in)  :: gp2  ( im, jm, km2 )
      real(dp)    , intent(out) :: garr2( im, jm, km2 )
      real(dp)    , intent(in ) :: fillvalue


      !
      ! local variables
      !
      real(dp)     :: wkgp1( im, jm, km  ), wkgarr1( im, jm, km )
      integer      :: kk   ( im, jm, km2 )
      logical      :: sw   ( im, jm, km2 )
      integer(i4b) :: i, j, k, l


      if( gp1( 1, 1, 1 ) .le. gp1( 1, 1, 2 ) ) then
         do k = 1, km
            do j = 1, jm
               do i = 1, im
                  wkgp1  ( i, j, k ) = gp1  ( i, j, k )
                  wkgarr1( i, j, k ) = garr1( i, j, k )
               end do
            end do
         end do
      else
         do k = 1, km
            do j = 1, jm
               do i = 1, im
                  wkgp1  ( i, j, k )   = gp1( i, j, km-(k-1) )
                  wkgarr1( i, j, k ) = garr1( i, j, km-(k-1) )
               end do
            end do
         end do
      end if


      do k = 1, km2
         do j = 1, jm
            do i = 1, im
               if(  ( gp2( i, j, k ) .lt. wkgp1( i, j, 1  ) ) &
                    .or. &
                    ( gp2( i, j, k ) .gt. wkgp1( i, j, km ) ) ) then
                  sw( i, j, k ) = .false. 
               else
                  sw( i, j, k ) = .true.
               end if
            end do
         end do
      end do
      do k = 1, km2
         do j = 1, jm
            do i = 1, im
               kk( i, j, k ) = 2
            end do
         end do
      end do
      do l = 1, km-1
         do k = 1, km2
            do j = 1, jm
               do i = 1, im
                  if( wkgp1( i, j, l ) .lt. gp2( i, j, k ) ) kk( i, j, k ) = l+1
               end do
            end do
         end do
      end do

      do k = 1, km2
         do j = 1, jm
            do i = 1, im
               if( sw( i, j, k ) ) then
                  garr2( i, j, k ) &
                       = ( wkgarr1( i, j, kk(i,j,k) ) - wkgarr1( i, j, kk(i,j,k)-1 ) ) &
                       / ( log( wkgp1( i, j, kk(i,j,k) ) / wkgp1( i, j, kk(i,j,k)-1 ) ) ) &
                       *( log( gp2( i, j, k ) / wkgp1( i, j, kk(i,j,k)-1 ) ) ) &
                       + wkgarr1( i, j, kk(i,j,k)-1 )
               else
                  garr2( i, j, k ) = fillvalue
               end if
            end do
         end do
      end do


    end subroutine logintp2p3d_ES

    !**************************************************************************
