!= ˡˤʬ
!
!= Time integration with implicit scheme
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: phy_implicit.f90,v 1.21 2012-09-08 15:20:57 yot Exp $
! Tag Name::  $Name: dcpam5-20130302 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module phy_implicit
  !
  != ˡˤʬ
  !
  != Time integration with implicit scheme
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !== Procedures List
  !
  ! PhyImplTendency      :: ѲΨη׻
  ! PhyImplEvalRadLFluxA :: Ĺȥեå
  ! ------------         :: ------------
  ! PhyImplTendency      :: Calculate tendency
  ! PhyImplEvalRadLFluxA :: Longwave flux correction
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#phy_implicit_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ˴ؤ
  ! Settings of array for atmospheric composition
  !
  use composition, only: ncmax, IndexH2OVap

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: PhyImplTendency
  public :: PhyImplInit

  ! ѿ
  ! Public variables
  !

  ! ѿ
  ! Private variables
  !
  logical, save :: FlagBucketModel
  logical, save :: FlagSnow
  logical, save :: phy_implicit_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  character(*), parameter:: module_name = 'phy_implicit'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20130302 $' // &
    & '$Id: phy_implicit.f90,v 1.21 2012-09-08 15:20:57 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine PhyImplTendency(                                  &
    & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux, & ! (in)
    & xyr_RadSFlux, xyr_RadLFlux,                              & ! (in)
    & xy_GroundTempFlux,                                       & ! (in)
    & xy_SurfTemp, xy_SurfHumidCoef, xy_SurfCond,              & ! (in)
    & xy_SurfHeatCapacity,                                     & ! (in)
    & xyra_DelRadLFlux,                                        & ! (in)
    & xyr_Press, xyz_Exner, xyr_Exner,                         & ! (in)
    & xyr_VelTransCoef, xyr_TempTransCoef,                     & ! (in)
    & xyr_QMixTransCoef,                                       & ! (in)
    & xy_SurfVelTransCoef, xy_SurfTempTransCoef,               & ! (in)
    & xy_SurfQVapTransCoef,                                    & ! (in)
    & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyzf_DQMixDt,           & ! (out)
    & xy_DSurfTempDt                                           & ! (out)
    & )
    !
    ! ѲΨη׻Ԥޤ. 
    !
    ! Calculate tendencies. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, &               ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & LatentHeat, &
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation
      & GasRDry
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $ [s]
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ˰漾λ
    ! Evaluate saturation specific humidity
    !
    use saturate, only: xy_CalcQVapSat, xy_CalcDQVapSatDTemp

    ! ˡˤʬΤΥ롼
    ! Routines for time integration with implicit scheme
    !
    use phy_implicit_utils, only : PhyImplLUDecomp3, PhyImplLUSolve3

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyr_MomFluxX (0:imax-1, 1:jmax, 0:kmax)
                              ! ư̥եå. 
                              ! Eastward momentum flux
    real(DP), intent(in):: xyr_MomFluxY (0:imax-1, 1:jmax, 0:kmax)
                              ! ư̥եå. 
                              ! Northward momentum flux
    real(DP), intent(in):: xyr_HeatFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ǯեå. 
                              ! Heat flux
    real(DP), intent(in):: xyrf_QMixFlux (0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
                              ! ̥եå. 
                              ! Mass flux of constituents

    real(DP), intent(in):: xyr_RadSFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! û () եå. 
                              ! Shortwave (insolation) flux
    real(DP), intent(in):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Longwave flux

    real(DP), intent(in):: xy_GroundTempFlux (0:imax-1, 1:jmax)
                              ! Ǯեå. 
                              ! Ground temperature flux
    real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in):: xy_SurfHumidCoef (0:imax-1, 1:jmax)
                              ! ɽ. 
                              ! Surface humidity coefficient
    integer, intent(in):: xy_SurfCond (0:imax-1, 1:jmax)
                              ! ɽ. 
                              ! Surface condition
    real(DP), intent(in):: xy_SurfHeatCapacity (0:imax-1, 1:jmax)
                              ! ɽǮ. 
                              ! Surface heat capacity

    real(DP), intent(in):: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with longwave

    real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
                              ! Exner ؿ (٥). 
                              ! Exner function (full level)
    real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
                              ! Exner ؿ (Ⱦ٥). 
                              ! Exner function (half level)

    real(DP), intent(in):: xyr_VelTransCoef (0:imax-1, 1:jmax, 0:kmax)
                              ! ͢ư. 
                              ! Transfer coefficient: velocity
    real(DP), intent(in):: xyr_TempTransCoef (0:imax-1, 1:jmax, 0:kmax)
                              ! ͢. 
                              ! Transfer coefficient: temperature
    real(DP), intent(in):: xyr_QMixTransCoef (0:imax-1, 1:jmax, 0:kmax)
                              ! ͢. 
                              ! Transfer coefficient: mass of constituents

    real(DP), intent(in):: xy_SurfVelTransCoef (0:imax-1, 1:jmax)
                              ! ͢ư. 
                              ! Diffusion coefficient: velocity
    real(DP), intent(in):: xy_SurfTempTransCoef (0:imax-1, 1:jmax)
                              ! ͢. 
                              ! Transfer coefficient: temperature
    real(DP), intent(in):: xy_SurfQVapTransCoef (0:imax-1, 1:jmax)
                              ! ͢漾. 
                              ! Transfer coefficient: specific humidity

    real(DP), intent(out):: xyz_DUDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{u}{t} $ . ®Ѳ. 
                              ! Eastward wind tendency
    real(DP), intent(out):: xyz_DVDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{v}{t} $ . ®Ѳ. 
                              ! Northward wind tendency
    real(DP), intent(out):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{T}{t} $ . Ѳ. 
                              ! Temperature tendency
    real(DP), intent(out):: xyzf_DQMixDt(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ \DP{q}{t} $ . 漾Ѳ. 
                              ! Temperature tendency
    real(DP), intent(out):: xy_DSurfTempDt (0:imax-1, 1:jmax)
                              ! ɽ̲ѲΨ. 
                              ! Surface temperature tendency

    ! ѿ
    ! Work variables
    !
    real(DP):: xyza_UVMtx (0:imax-1, 1:jmax, 1:kmax, -1:1)
                              ! ®ٱ. 
                              ! Implicit matrix about velocity 
    real(DP):: xyra_TempMtx (0:imax-1, 1:jmax, 0:kmax, -1:1)
                              ! ٱ. 
                              ! Implicit matrix about temperature
    real(DP):: xyza_QVapMtx (0:imax-1, 1:jmax, 1:kmax, -1:1)
                              ! 漾. 
                              ! Implicit matrix about specific humidity
    real(DP):: xyza_QMixMtx (0:imax-1, 1:jmax, 1:kmax, -1:1)
                              ! ̺汢. 
                              ! Implicit matrix about mass mixing ratio
    real(DP):: xyaa_SurfMtx (0:imax-1, 1:jmax, 0:0, -1:1)
                              ! ɽ̥ͥ륮ѱ
                              ! Implicit matrix for surface energy balance
    real(DP):: xyz_DelTempQVap (0:imax-1, 1:jmax, -kmax:kmax)
                              ! $ T q $ λѲ. 
                              ! Tendency of $ T q $ 
    real(DP):: xyza_TempQVapLUMtx (0:imax-1, 1:jmax, -kmax:kmax, -1:1)
                              ! LU . 
                              ! LU matrix
    real(DP):: xyza_UVLUMtx (0:imax-1, 1:jmax, 1:kmax,-1:1)
                              ! LU . 
                              ! LU matrix
    real(DP):: xyza_QMixLUMtx(0:imax-1, 1:jmax, 1:kmax,-1:1)
                              ! LU . 
                              ! LU matrix
    real(DP):: xy_SurfQVapSat (0:imax-1, 1:jmax)
                              ! ɽ˰漾. 
                              ! Saturated specific humidity on surface
    real(DP):: xy_SurfDQVapSatDTemp (0:imax-1, 1:jmax)
                              ! ɽ˰漾Ѳ. 
                              ! Saturated specific humidity tendency on surface

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: l               !  DO 롼Ѻѿ
                              ! Work variables for DO loop of matrices
    integer:: n               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituents

    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. phy_implicit_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    ! Хĥǥΰγǧ
    ! Check use of bucket model
    !
    ! Bucket model with this routine is not supported fully, although some 
    ! parts of calculation is implemented. 
    !
    if ( FlagBucketModel ) then
      call MessageNotify( 'E', module_name, 'Bucket model cannot be used with this routine.' )
    end if

    ! ΰγǧ
    ! Check about treatment of snow
    !
    if ( FlagSnow ) then
      call MessageNotify( 'E', module_name, 'Snow melt is not treated in this routine.' )
    end if


    ! ˡΤι
    ! Create matrices for implicit scheme
    !

    ! ľȻ͢鱢η׻ (®)
    ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (velocity)
    !
    k = 1
    xyza_UVMtx  (:,:,k,-1) = 0.0d0
    xyza_UVMtx  (:,:,k, 0) =                                                  &
      & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2. * DelTime ) &
      & + xy_SurfVelTransCoef(:,:)                                            &
      & + xyr_VelTransCoef(:,:,k  )
    xyza_UVMtx  (:,:,k, 1) = &
      & - xyr_VelTransCoef(:,:,k)

    do k = 2, kmax-1
      xyza_UVMtx  (:,:,k,-1) = &
        & - xyr_VelTransCoef(:,:,k-1)
      xyza_UVMtx  (:,:,k, 0) =                                                  &
        & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2. * DelTime ) &
        & + xyr_VelTransCoef(:,:,k-1)                                           &
        & + xyr_VelTransCoef(:,:,k  )
      xyza_UVMtx  (:,:,k, 1) = &
        & - xyr_VelTransCoef(:,:,k)
    end do

    k = kmax
    xyza_UVMtx  (:,:,k,-1) = &
      & - xyr_VelTransCoef(:,:,k-1)
    xyza_UVMtx  (:,:,k, 0) =                                                  &
      & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2. * DelTime ) &
      & + xyr_VelTransCoef(:,:,k-1)
    xyza_UVMtx  (:,:,k, 1) = 0.0d0


    ! ľȻ͢鱢η׻ ()
    ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (temperature)
    !
    k = 1
    xyra_TempMtx(:,:,k,-1) = &
      & - CpDry * xy_SurfTempTransCoef(:,:)
    xyra_TempMtx(:,:,k, 0) =                                                          &
      & - CpDry * ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2. * DelTime ) &
      & + CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k  ) * xy_SurfTempTransCoef(:,:) &
      & + CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k  )
    xyra_TempMtx(:,:,k, 1) = &
      & - CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k+1) * xyr_TempTransCoef(:,:,k  )

    do k = 2, kmax-1
      xyra_TempMtx(:,:,k,-1) = &
        & - CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k-1) * xyr_TempTransCoef(:,:,k-1)
      xyra_TempMtx(:,:,k, 0) =                                                          &
        & - CpDry * ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2. * DelTime ) &
        & + CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k-1)&
        & + CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k  )
      xyra_TempMtx(:,:,k, 1) = &
        & - CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k+1) * xyr_TempTransCoef(:,:,k  )
    end do

    k = kmax
    xyra_TempMtx(:,:,k,-1) = &
      & - CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k-1) * xyr_TempTransCoef(:,:,k-1)
    xyra_TempMtx(:,:,k, 0) =                                                          &
      & - CpDry * ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2. * DelTime ) &
      & + CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k-1)
    xyra_TempMtx(:,:,k, 1) = 0.0d0




    ! ľȻ͢鱢η׻ (漾)
    ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (specific humidity)
    !
    ! ˰漾η׻
    ! Calculate saturated specific humidity
    !
    xy_SurfQVapSat       = &
      & xy_CalcQVapSat      ( xy_SurfTemp, xyr_Press(:,:,0) )
    xy_SurfDQVapSatDTemp = &
      & xy_CalcDQVapSatDTemp( xy_SurfTemp, xy_SurfQVapSat   )

    k = 1
    if ( FlagBucketModel ) then
      xyza_QVapMtx(:,:,k,-1) =                                                  &
        & 0.0d0
      xyza_QVapMtx(:,:,k, 0) =                                                  &
        & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2. * DelTime ) &
        & + xyr_QMixTransCoef(:,:,k  )
    else
      xyza_QVapMtx(:,:,k,-1) =                                                  &
        & - xy_SurfHumidCoef(:,:) * xy_SurfQVapTransCoef(:,:)                   &
        &   * xy_SurfDQVapSatDTemp(:,:)
      xyza_QVapMtx(:,:,k, 0) =                                                  &
        & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2. * DelTime ) &
        & + xy_SurfHumidCoef(:,:) * xy_SurfQVapTransCoef(:,:)                   &
        & + xyr_QMixTransCoef(:,:,k  )
    end if
    xyza_QVapMtx(:,:,k, 1) =                                                  &
      & - xyr_QMixTransCoef(:,:,k  )

    do k = 2, kmax-1
      xyza_QVapMtx(:,:,k,-1) = &
        & - xyr_QMixTransCoef(:,:,k-1)
      xyza_QVapMtx(:,:,k, 0) =                                                  &
        & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2. * DelTime ) &
        & + xyr_QMixTransCoef(:,:,k-1)                                          &
        & + xyr_QMixTransCoef(:,:,k  )
      xyza_QVapMtx(:,:,k, 1) = &
        & - xyr_QMixTransCoef(:,:,k  )
    end do

    k = kmax
    xyza_QVapMtx(:,:,k,-1) = &
      & - xyr_QMixTransCoef(:,:,k-1)
    xyza_QVapMtx(:,:,k, 0) =                                                  &
      & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2. * DelTime ) &
      & + xyr_QMixTransCoef(:,:,k-1)
    xyza_QVapMtx(:,:,k, 1) = 0.0d0


    ! ľȻ͢鱢η׻ (漾)
    ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (mixing ratio except for specific humidity)
    !
    k = 1
    xyza_QMixMtx(:,:,k,-1) =                                                  &
      & 0.0d0
    xyza_QMixMtx(:,:,k, 0) =                                                  &
      & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2. * DelTime ) &
      & + xyr_QMixTransCoef(:,:,k  )
    xyza_QMixMtx(:,:,k, 1) =                                                  &
      & - xyr_QMixTransCoef(:,:,k  )

    do l = -1, 1
      do k = 2, kmax
        xyza_QMixMtx(:,:,k,l) = xyza_QVapMtx(:,:,k,l)
      end do
    end do


    ! ɽ̲͢鱢η׻
    ! Calculate implicit matrices from transfer coefficient of surface process
    !
    do i = 0, imax-1
      do j = 1, jmax
        if ( xy_SurfCond(i,j) >= 1 ) then

          if ( FlagBucketModel ) then
            xyaa_SurfMtx(i,j,0,-1) =                                             &
              & 0.0d0
            xyaa_SurfMtx(i,j,0, 0) =                                             &
              &   xy_SurfHeatCapacity(i,j) / ( 2. * DelTime )                    &
              & + CpDry * xy_SurfTempTransCoef(i,j)                              &
              & + xyra_DelRadLFlux(i,j,0,0)
          else
            xyaa_SurfMtx(i,j,0,-1) =                                             &
              & - LatentHeat * xy_SurfHumidCoef(i,j) * xy_SurfQVapTransCoef(i,j)
            xyaa_SurfMtx(i,j,0, 0) =                                             &
              &   xy_SurfHeatCapacity(i,j) / ( 2. * DelTime )                    &
              & + CpDry * xy_SurfTempTransCoef(i,j)                              &
              & + xyra_DelRadLFlux(i,j,0,0)                                      &
              & + LatentHeat * xy_SurfHumidCoef(i,j) * xy_SurfQVapTransCoef(i,j) &
              &   * xy_SurfDQVapSatDTemp(i,j)
          end if
          xyaa_SurfMtx(i,j,0, 1) =                                             &
            & - CpDry * xyr_Exner(i,j,0) / xyz_Exner(i,j,1)                    &
            &   * xy_SurfTempTransCoef(i,j)                                    &
            & + xyra_DelRadLFlux(i,j,0,1)
        else
          xyaa_SurfMtx(i,j,0,-1) = 0.0d0
          xyaa_SurfMtx(i,j,0, 0) = 1.0d0
          xyaa_SurfMtx(i,j,0, 1) = 0.0d0
        end if
      end do
    end do


    ! ®, ®η׻
    ! Calculate eastward and northward wind
    !
    xyza_UVLUMtx = xyza_UVMtx

    call PhyImplLUDecomp3( &
      & xyza_UVLUMtx, &     ! (inout)
      & imax * jmax, kmax ) ! (in)

    do k = 1, kmax
      xyz_DUDt(:,:,k) = - ( xyr_MomFluxX(:,:,k) - xyr_MomFluxX(:,:,k-1) )
      xyz_DVDt(:,:,k) = - ( xyr_MomFluxY(:,:,k) - xyr_MomFluxY(:,:,k-1) )
    end do

    call PhyImplLUSolve3( &
      & xyz_DUDt, &            ! (inout)
      & xyza_UVLUMtx, &        ! (in)
      & 1, imax * jmax, kmax ) ! (in)

    call PhyImplLUSolve3( &
      & xyz_DVDt, &            ! (inout)
      & xyza_UVLUMtx, &        ! (in)
      & 1, imax * jmax, kmax ) ! (in)

    ! ٤漾η׻
    ! Calculate temperature and specific humidity
    !
    do l = -1, 1

      do k = 1, kmax
        xyza_TempQVapLUMtx(:,:,-k,-l) = xyza_QVapMtx(:,:,k,l)
      end do

      k = 0
      xyza_TempQVapLUMtx(:,:, k, l) = xyaa_SurfMtx(:,:,0,l)

      do k =  1,  kmax
        xyza_TempQVapLUMtx(:,:, k, l) = xyra_TempMtx(:,:,k,l)
      end do

    end do

    call PhyImplLUDecomp3( &
      & xyza_TempQVapLUMtx, &         ! (inout)
      & imax * jmax, (2 * kmax) + 1 ) ! (in)

    do k = 1, kmax
      xyz_DelTempQVap(:,:,-k) = &
        & - ( xyrf_QMixFlux(:,:,k,IndexH2OVap) - xyrf_QMixFlux(:,:,k-1,IndexH2OVap) )
    end do

    k = 0
    do j = 1, jmax
      do i = 0, imax-1
        if ( xy_SurfCond(i,j) >= 1 ) then
          xyz_DelTempQVap(i,j,k) =                            &
            & - xyr_RadSFlux(i,j,0)                           &
            & - xyr_RadLFlux(i,j,0)                           &
            & - xyr_HeatFlux(i,j,0)                           &
            & - LatentHeat * xyrf_QMixFlux(i,j,0,IndexH2OVap) &
            & + xy_GroundTempFlux(i,j)
        else
          xyz_DelTempQVap(i,j,k) = 0.0d0
        end if
      end do
    end do

    do k = 1, kmax
      xyz_DelTempQVap(:,:,k) = - ( xyr_HeatFlux(:,:, k) - xyr_HeatFlux(:,:,  k-1 ) )
    end do

    call PhyImplLUSolve3( &
      & xyz_DelTempQVap, &                ! (inout)
      & xyza_TempQVapLUMtx, &             ! (in)
      & 1, imax * jmax , (2 * kmax) + 1 ) ! (in)

    ! ѲΨη׻
    ! Calculate tendency
    !
    do k = 1, kmax
      xyz_DUDt(:,:,k)                 = xyz_DUDt(:,:,k)         / ( 2. * DelTime )
      xyz_DVDt(:,:,k)                 = xyz_DVDt(:,:,k)         / ( 2. * DelTime )
      xyz_DTempDt(:,:,k)              = xyz_DelTempQVap(:,:, k) / ( 2. * DelTime )
      xyzf_DQMixDt(:,:,k,IndexH2OVap) = xyz_DelTempQVap(:,:,-k) / ( 2. * DelTime )
    end do

    do j = 1, jmax
      do i = 0, imax-1
        if ( xy_SurfCond(i,j) >= 1 ) then
          xy_DSurfTempDt(i,j) = xyz_DelTempQVap(i,j,0) / ( 2. * DelTime )
        else
          xy_DSurfTempDt(i,j) = 0.
        end if
      end do
    end do


    ! 漾̺
    ! Calculate mass mixing ratio except for specific humidity
    !
    xyza_QMixLUMtx = xyza_QMixMtx

    call PhyImplLUDecomp3( &
      & xyza_QMixLUMtx,    & ! (inout)
      & imax * jmax, kmax  & ! (in)
      & )

    do n = 1, ncmax
      if ( n == IndexH2OVap ) cycle

      do k = 1, kmax
        xyzf_DQMixDt(:,:,k,n) = &
          & - ( xyrf_QMixFlux(:,:,k,n) - xyrf_QMixFlux(:,:,k-1,n) )
      end do

      call PhyImplLUSolve3(      &
        & xyzf_DQMixDt(:,:,:,n), & ! (inout)
        & xyza_QMixLUMtx,        & ! (in)
        & 1, imax * jmax, kmax   & ! (in)
        & )
    end do



    !#########################################################
    ! code for debug, this will be removed, (Y. O. Takahashi, 2009/04/07)
!!$    i = 1
!!$    j = jmax / 2
!!$    n = IndexH2OVap
!!$    write( 6, * ) &
!!$      & - xyr_RadSFlux(i,j,0),                                                      &
!!$      & - ( xyr_RadLFlux(i,j,0)                                                     &
!!$      &   + xyra_DelRadLFlux(i,j,0,0) * xy_DSurfTempDt(i,j) * ( 2.0d0 * DelTime )   &
!!$      &   + xyra_DelRadLFlux(i,j,0,1) * xyz_DTempDt(i,j,1) * ( 2.0d0 * DelTime ) ), &
!!$      & - ( xyr_HeatFlux(i,j,0)                                                     &
!!$      &   - CpDry * xyr_Exner(i,j,0) * xy_SurfTempTransCoef(i,j)                    &
!!$      &     * ( xyz_DTempDt(i,j,1) / xyz_Exner(i,j,1)                               &
!!$      &       - xy_DSurfTempDt(i,j) / xyr_Exner(i,j,0) ) * ( 2.0d0 * DelTime ) ),   &
!!$      & - LatentHeat                                                                &
!!$      &   * ( xyrf_QMixFlux(i,j,0,n)                                                &
!!$      &     - xy_SurfQVapTransCoef(i,j)                                             &
!!$      &       * ( xyzf_DQMixDt(i,j,1,n)                                             &
!!$      &         - xy_SurfDQVapSatDTemp(i,j) * xy_DSurfTempDt(i,j) )                 &
!!$      &       * ( 2.0d0 * DelTime ) ) !, &
!!$!      & + xy_GroundTempFlux(i,j)
!!$    write( 6, * ) &
!!$      & - xyr_RadSFlux(i,j,0)                                                       &
!!$      & - ( xyr_RadLFlux(i,j,0)                                                     &
!!$      &   + xyra_DelRadLFlux(i,j,0,0) * xy_DSurfTempDt(i,j) * ( 2.0d0 * DelTime )   &
!!$      &   + xyra_DelRadLFlux(i,j,0,1) * xyz_DTempDt(i,j,1) * ( 2.0d0 * DelTime ) )  &
!!$      & - ( xyr_HeatFlux(i,j,0)                                                     &
!!$      &   - CpDry * xyr_Exner(i,j,0) * xy_SurfTempTransCoef(i,j)                    &
!!$      &     * ( xyz_DTempDt(i,j,1) / xyz_Exner(i,j,1)                               &
!!$      &       - xy_DSurfTempDt(i,j) / xyr_Exner(i,j,0) ) * ( 2.0d0 * DelTime ) )    &
!!$      & - LatentHeat                                                                &
!!$      &   * ( xyrf_QMixFlux(i,j,0,n)                                                &
!!$      &     - xy_SurfQVapTransCoef(i,j)                                             &
!!$      &       * ( xyzf_DQMixDt(i,j,1,n)                                             &
!!$      &         - xy_SurfDQVapSatDTemp(i,j) * xy_DSurfTempDt(i,j) )                 &
!!$      &       * ( 2.0d0 * DelTime ) ) !, &
!!$!      & + xy_GroundTempFlux(i,j)
!!$
!!$    xy_SurfQVapSat(i,j) =                                                           &
!!$      & - xyr_RadSFlux(i,j,0)                                                       &
!!$      & - ( xyr_RadLFlux(i,j,0)                                                     &
!!$      &   + xyra_DelRadLFlux(i,j,0,0) * xy_DSurfTempDt(i,j) * ( 2.0d0 * DelTime )   &
!!$      &   + xyra_DelRadLFlux(i,j,0,1) * xyz_DTempDt(i,j,1) * ( 2.0d0 * DelTime ) )  &
!!$      & - ( xyr_HeatFlux(i,j,0)                                                     &
!!$      &   - CpDry * xyr_Exner(i,j,0) * xy_SurfTempTransCoef(i,j)                    &
!!$      &     * ( xyz_DTempDt(i,j,1) / xyz_Exner(i,j,1)                               &
!!$      &       - xy_DSurfTempDt(i,j) / xyr_Exner(i,j,0) ) * ( 2.0d0 * DelTime ) )    &
!!$      & - LatentHeat                                                                &
!!$!      &   * ( xyr_QVapFlux(i,j,0)                                                   &
!!$!      &     - xy_SurfQVapTransCoef(i,j)                                             &
!!$!      &       * ( xyz_DQVapDt(i,j,1)                                                &
!!$!      &         - xy_SurfDQVapSatDTemp(i,j) * xy_DSurfTempDt(i,j) )                 &
!!$!      &       * ( 2.0d0 * DelTime ) )
!!$      &   * xyrf_QMixFlux(i,j,0,n)
!!$    write( 6, * ) xy_SurfQVapSat(i,j)
    !#########################################################



    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine PhyImplTendency

  !--------------------------------------------------------------------------------------

  subroutine PhyImplInit(              &
    & ArgFlagBucketModel, ArgFlagSnow  & ! (in)
    & )
    !
    ! phy_implicit ⥸塼νԤޤ. 
    ! NAMELIST#phy_implicit_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "phy_implicit" module is initialized. 
    ! "NAMELIST#phy_implicit_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

    logical, intent(in ) :: ArgFlagBucketModel
    logical, intent(in ) :: ArgFlagSnow


    ! ѿ
    ! Work variables
    !
!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /phy_implicit_nml/
!!$          !
!!$          ! ǥեͤˤĤƤϽ³ "phy_implicit#PhyImplInit" 
!!$          ! Υɤ򻲾ȤΤ. 
!!$          !
!!$          ! Refer to source codes in the initialization procedure
!!$          ! "phy_implicit#PhyImplInit" for the default values. 
!!$          !

    ! ¹ʸ ; Executable statement
    !

    if ( phy_implicit_inited ) return


    ! ǥեͤ
    ! Default values settings
    !

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &           ! (in)
!!$        & nml = phy_implicit_nml, &  ! (out)
!!$        & iostat = iostat_nml )   ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if


    FlagBucketModel = ArgFlagBucketModel
    FlagSnow        = ArgFlagSnow

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    phy_implicit_inited = .true.

  end subroutine PhyImplInit

  !--------------------------------------------------------------------------------------

end module phy_implicit
