!= طϥ롼
!
!= Cloud-related routines
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: cloud_utils.f90,v 1.1 2012-09-08 15:16:39 yot Exp $
! Tag Name::  $Name: dcpam5-20130302 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
module cloud_utils
  !
  != طϥ롼
  !
  != Cloud-related routines
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ʬۤ.
  !
  ! In this module, the amount of cloud or cloud optical depth are set.
  ! This module is under development and is still a preliminary version. 
  !
  !== Procedures List
  !
!!$  ! RadiationFluxDennouAGCM :: ͥեåη׻
!!$  ! ------------            :: ------------
!!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
  !
  !== NAMELIST
  !
  ! NAMELIST#cloud_utils_nml
  !

  ! ⥸塼 ; USE statements

  !
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ.
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ.
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ.
                             ! Number of vertical level

  implicit none

  private


  ! ³
  ! Public procedure
  !
  public :: CloudUtilsWatFraction
  public :: CloudUtilsCalcPRCPKeyLLTemp
  public :: CloudUtilsCalcPRCPKeyLLTemp3D
  public :: CloudUtilsCalcOverlapCloudTrans
!!$  public :: CloudUtilsSmearCloudOptDep
  public :: CloudUtilsLocalizeCloud
  public :: CloudUtilsInit


  ! ѿ
  ! Public variables
  !


  ! ѿ
  ! Private variables
  !
  logical , save        :: FlagSnow
                           ! A flag for snow

  integer , save        :: IDCloudOverlapType
  integer , parameter   :: IDCloudOverlapTypeRandom     = 1
  integer , parameter   :: IDCloudOverlapTypeMaxOverlap = 2

  real(DP), save        :: TempWatLim
  real(DP), save        :: TempIceLim


  logical, save :: cloud_utils_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  character(*), parameter:: module_name = 'cloud_utils'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20130302 $' // &
    & '$Id: cloud_utils.f90,v 1.1 2012-09-08 15:16:39 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine CloudUtilsWatFraction(   &
    & xyz_Temp,                       & ! (in )
    & xyz_WatFrac                     & ! (out)
    & )

    ! USE statements
    !

    real(DP), intent(in ) :: xyz_Temp   (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(out) :: xyz_WatFrac(0:imax-1, 1:jmax, 1:kmax)


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. cloud_utils_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    if ( FlagSnow ) then

      xyz_WatFrac = ( 1.0_DP - 0.0_DP ) / ( TempWatLim - TempIceLim ) &
        & * ( xyz_Temp - TempIceLim )
      xyz_WatFrac = min( xyz_WatFrac, 1.0_DP )
      xyz_WatFrac = max( xyz_WatFrac, 0.0_DP )

    else

      xyz_WatFrac = 1.0_DP

    end if


  end subroutine CloudUtilsWatFraction

  !--------------------------------------------------------------------------------------

  subroutine CloudUtilsCalcPRCPKeyLLTemp(  &
    & xyz_Temp, xy_PRCP,                   &  ! (in )
    & xy_SurfRainFlux, xy_SurfSnowFlux     &  ! (out)
    & )


    ! ȳɹ
    ! Setting constants of snow and sea ice
    !
    use constants_snowseaice, only: TempCondWater


    real(DP), intent(in ) :: xyz_Temp       ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in ) :: xy_PRCP        ( 0:imax-1, 1:jmax )
    real(DP), intent(out) :: xy_SurfRainFlux( 0:imax-1, 1:jmax )
    real(DP), intent(out) :: xy_SurfSnowFlux( 0:imax-1, 1:jmax )


    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude


    ! ǧ
    ! Initialization check
    !
    if ( .not. cloud_utils_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    if ( FlagSnow ) then

      do j = 1, jmax
        do i = 0, imax-1
          if ( xyz_Temp(i,j,1) > TempCondWater ) then
            xy_SurfRainFlux(i,j) = xy_PRCP(i,j)
            xy_SurfSnowFlux(i,j) = 0.0_DP
          else
            xy_SurfRainFlux(i,j) = 0.0_DP
            xy_SurfSnowFlux(i,j) = xy_PRCP(i,j)
          end if
        end do
      end do

    else

      xy_SurfRainFlux = xy_PRCP
      xy_SurfSnowFlux = 0.0_DP

    end if


  end subroutine CloudUtilsCalcPRCPKeyLLTemp

  !--------------------------------------------------------------------------------------

  subroutine CloudUtilsCalcPRCPKeyLLTemp3D(  &
    & xyr_Press, xyz_Temp, xyz_DQH2OLiqDt,   &  ! (in )
    & xy_SurfRainFlux, xy_SurfSnowFlux       &  ! (out)
    & )

    ! ʪ
    ! Physical constants settings
    !
    use constants, only:  &
      & Grav
                              ! $ g $ [m s-2].
                              ! ϲ®.
                              ! Gravitational acceleration

    real(DP), intent(in ) :: xyr_Press       ( 0:imax-1, 1:jmax, 0:kmax )
    real(DP), intent(in ) :: xyz_Temp        ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in ) :: xyz_DQH2OLiqDt  ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(out) :: xy_SurfRainFlux ( 0:imax-1, 1:jmax )
    real(DP), intent(out) :: xy_SurfSnowFlux ( 0:imax-1, 1:jmax )


    ! ѿ
    ! Work variables
    !
    real(DP) :: xy_PRCP( 0:imax-1, 1:jmax )

    integer  :: k


    ! ǧ
    ! Initialization check
    !
    if ( .not. cloud_utils_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if



    xy_PRCP = 0.0d0
    do k = kmax, 1, -1
      xy_PRCP = xy_PRCP                                       &
        & + xyz_DQH2OLiqDt(:,:,k)                             &
        & * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
    end do


    call CloudUtilsCalcPRCPKeyLLTemp(      &
      & xyz_Temp, xy_PRCP,                 &  ! (in )
      & xy_SurfRainFlux, xy_SurfSnowFlux   &  ! (out)
      & )


  end subroutine CloudUtilsCalcPRCPKeyLLTemp3D

  !--------------------------------------------------------------------------------------

  subroutine CloudUtilsCalcOverlapCloudTrans(  &
    & xyz_TransCloudOneLayer, xyz_CloudCover,  & ! (in)
    & xyrr_OverlappedCloudTrans                & ! (out)
    & )

    ! USE statements
    !

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ.
                              ! Time of step $ t $.
      & EndTime, &            ! ׻λ.
                              ! End time of calculation
      & TimesetClockStart, TimesetClockStop

!!$    use sort, only : SortQuick

    real(DP), intent(in ) :: xyz_TransCloudOneLayer   (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyz_CloudCover           (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(out) :: xyrr_OverlappedCloudTrans(0:imax-1, 1:jmax, 0:kmax, 0:kmax)


    real(DP) :: xyz_EffCloudCover           (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_CloudCoverSorted        (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_EffCloudCoverSorted     (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_TransCloudOneLayerSorted(0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: CloudCoverSortedCur
    real(DP) :: EffCloudCoverSortedCur
    real(DP) :: TransCloudOneLayerSortedCur
    integer  :: KInsPos
    integer  :: i
    integer  :: j
    integer  :: k
    integer  :: kk
    integer  :: kkk



    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. cloud_utils_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! Cloud optical depth
    !

    select case ( IDCloudOverlapType )
    case ( IDCloudOverlapTypeRandom )

      xyz_EffCloudCover = xyz_CloudCover * ( 1.0_DP - xyz_TransCloudOneLayer )

      do k = 0, kmax
        kk = k
        xyrr_OverlappedCloudTrans(:,:,k,kk) = 1.0_DP
        do kk = k+1, kmax
          xyrr_OverlappedCloudTrans(:,:,k,kk) =        &
            & xyrr_OverlappedCloudTrans(:,:,k,kk-1)    &
            & * ( 1.0_DP - xyz_EffCloudCover(:,:,kk) )
        end do
      end do

      do k = 0, kmax
        do kk = 0, k-1
          xyrr_OverlappedCloudTrans(:,:,k,kk) = xyrr_OverlappedCloudTrans(:,:,kk,k)
        end do
      end do

    case ( IDCloudOverlapTypeMaxOverlap )

      ! see Chou et al. (2001)

      xyz_EffCloudCover = xyz_CloudCover * ( 1.0_DP - xyz_TransCloudOneLayer )


      ! Original method (computationally expensive, probably)
      !
!!$        do k = 0, kmax
!!$          kk = k
!!$          xyrr_OverlappedCloudTrans(:,:,k,kk) = 1.0_DP
!!$          do kk = k+1, kmax
!!$
!!$            xyz_CloudCoverSorted         = xyz_CloudCover
!!$            xyz_EffCloudCoverSorted      = xyz_EffCloudCover
!!$            xyz_TransCloudOneLayerSorted = xyz_TransCloudOneLayer
!!$
!!$            call SortQuick( imax, jmax, kk-k,             &
!!$              & xyz_CloudCoverSorted        (:,:,k+1:kk), &
!!$              & xyz_EffCloudCoverSorted     (:,:,k+1:kk), &
!!$              & xyz_TransCloudOneLayerSorted(:,:,k+1:kk)  &
!!$              & )
!!$
!!$            xyrr_OverlappedCloudTrans(:,:,k,kk) = 0.0_DP
!!$            do kkk = k+1, kk
!!$              xyrr_OverlappedCloudTrans(:,:,k,kk) =         &
!!$                & xyz_EffCloudCoverSorted(:,:,kkk)          &
!!$                & + xyrr_OverlappedCloudTrans(:,:,k,kk)     &
!!$                &   * xyz_TransCloudOneLayerSorted(:,:,kkk)
!!$            end do
!!$            xyrr_OverlappedCloudTrans(:,:,k,kk) = &
!!$              & 1.0_DP - xyrr_OverlappedCloudTrans(:,:,k,kk)
!!$
!!$          end do
!!$        end do


      ! Economical method (probably)
      !
      do k = 0, kmax

!!$          do kkk = 1, kmax
!!$              xyz_CloudCoverSorted(:,:,kkk) = real( kmax-kkk ) / real(kmax)
!!$!              xyz_CloudCoverSorted(:,:,kkk) = abs( 0.55d0 - real( kmax-kkk ) / real(kmax) )
!!$          end do
!!$          ! debug output
!!$          if ( k == 0 ) then
!!$            kk = kmax
!!$            do kkk = k+1, kk
!!$              write( 6, * ) kkk, xyz_CloudCoverSorted(0,jmax/2+1,kkk)
!!$            end do
!!$          end if

        xyz_CloudCoverSorted         = xyz_CloudCover
        xyz_EffCloudCoverSorted      = xyz_EffCloudCover
        xyz_TransCloudOneLayerSorted = xyz_TransCloudOneLayer

        kk = k
        xyrr_OverlappedCloudTrans(:,:,k,kk) = 1.0_DP
        do kk = k+1, kmax


          do j = 1, jmax
            do i = 0, imax-1

              ! xyz_CloudCoverSorted(i,j,kk) is inserved in an appropriate position.
              !
              KInsPos = kk
              loop : do kkk = k+1, kk-1

                if ( xyz_CloudCoverSorted(i,j,kk) < xyz_CloudCoverSorted(i,j,kkk) ) then
                  KInsPos = kkk
                  exit loop
                end if

              end do loop

              ! values are saved
              CloudCoverSortedCur         = xyz_CloudCoverSorted        (i,j,kk)
              EffCloudCoverSortedCur      = xyz_EffCloudCoverSorted     (i,j,kk)
              TransCloudOneLayerSortedCur = xyz_TransCloudOneLayerSorted(i,j,kk)

              ! values are shifted upward to empty an array at insert position
              do kkk = kk, KInsPos+1, -1
                xyz_CloudCoverSorted        (i,j,kkk) = &
                  & xyz_CloudCoverSorted        (i,j,kkk-1)
                xyz_EffCloudCoverSorted     (i,j,kkk) = &
                  & xyz_EffCloudCoverSorted     (i,j,kkk-1)
                xyz_TransCloudOneLayerSorted(i,j,kkk) = &
                  & xyz_TransCloudOneLayerSorted(i,j,kkk-1)
              end do
              kkk = KInsPos
              xyz_CloudCoverSorted        (i,j,kkk) = CloudCoverSortedCur
              xyz_EffCloudCoverSorted     (i,j,kkk) = EffCloudCoverSortedCur
              xyz_TransCloudOneLayerSorted(i,j,kkk) = TransCloudOneLayerSortedCur

            end do
          end do


!!$            xyz_CloudCoverSorted         = xyz_CloudCover
!!$            do kkk = 1, kmax
!!$              xyz_CloudCoverSorted(:,:,kkk) = real( kmax-kkk ) / real(kmax)
!!$            end do
!!$            xyz_EffCloudCoverSorted      = xyz_EffCloudCover
!!$            xyz_TransCloudOneLayerSorted = xyz_TransCloudOneLayer
!!$
!!$            call SortQuick( imax, jmax, kk-k,             &
!!$              & xyz_CloudCoverSorted        (:,:,k+1:kk), &
!!$              & xyz_EffCloudCoverSorted     (:,:,k+1:kk), &
!!$              & xyz_TransCloudOneLayerSorted(:,:,k+1:kk)  &
!!$              & )


!!$            ! debug output
!!$            if ( ( k == 0 ) .and. ( kk == kmax-2 ) ) then
!!$              do kkk = k+1, kk
!!$                write( 6, * ) kkk, xyz_CloudCoverSorted(0,jmax/2+1,kkk)
!!$              end do
!!$              write( 6, * ) '-----'
!!$            end if


          xyrr_OverlappedCloudTrans(:,:,k,kk) = 0.0_DP
          do kkk = k+1, kk
            xyrr_OverlappedCloudTrans(:,:,k,kk) =         &
              & xyz_EffCloudCoverSorted(:,:,kkk)          &
              & + xyrr_OverlappedCloudTrans(:,:,k,kk)     &
              &   * xyz_TransCloudOneLayerSorted(:,:,kkk)
          end do
          xyrr_OverlappedCloudTrans(:,:,k,kk) = &
            & 1.0_DP - xyrr_OverlappedCloudTrans(:,:,k,kk)

        end do
      end do



      do k = 0, kmax
        do kk = 0, k-1
          xyrr_OverlappedCloudTrans(:,:,k,kk) = xyrr_OverlappedCloudTrans(:,:,kk,k)
        end do
      end do


    end select

    ! Output effective cloud cover
    !
!!$    call HistoryAutoPut( TimeN, 'EffCloudCover', &
!!$      & 1.0_DP - xyrr_OverlappedCloudTrans(:,:,0,kmax) )


  end subroutine CloudUtilsCalcOverlapCloudTrans

  !--------------------------------------------------------------------------------------

  subroutine CloudUtilsSmearCloudOptDep(  &
    & xyz_CloudCover,                     & ! (in   )
    & xyz_DelCloudOptDep                  & ! (inout)
    & )

    ! USE statements
    !

    real(DP), intent(in   ) :: xyz_CloudCover    (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(inout) :: xyz_DelCloudOptDep(0:imax-1, 1:jmax, 1:kmax)


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. cloud_utils_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! Cloud optical depth is scaled by the way of Kiehl et al. (1994).

    xyz_DelCloudOptDep = xyz_DelCloudOptDep * xyz_CloudCover**1.5_DP


  end subroutine CloudUtilsSmearCloudOptDep

  !--------------------------------------------------------------------------------------

  subroutine CloudUtilsLocalizeCloud(  &
    & xyz_CloudCover,                  & ! (in   )
    & xyz_DelCloudOptDep               & ! (inout)
    & )

    ! USE statements
    !

    real(DP), intent(in   ) :: xyz_CloudCover    (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(inout) :: xyz_DelCloudOptDep(0:imax-1, 1:jmax, 1:kmax)


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. cloud_utils_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! Cloud optical depth is scaled by considering cloud cover less than 1. 

    xyz_DelCloudOptDep = xyz_DelCloudOptDep / max( xyz_CloudCover, 1.0d-3 )


  end subroutine CloudUtilsLocalizeCloud

  !--------------------------------------------------------------------------------------

  subroutine CloudUtilsInit( &
    & ArgFlagSnow            &
    & )

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! 絬϶ŷ (ήŷ)
    ! Large scale condensation (non-convective condensation)
    !
    use lscond, only : LScaleCondInit


    ! ʸ ; Declaration statements
    !

    logical, intent(in) :: ArgFlagSnow


    character(STRING) :: CloudOverlapType

    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /cloud_utils_nml/ &
      & CloudOverlapType,      &
      & TempWatLim,          &
      & TempIceLim
          !
          ! ǥեͤˤĤƤϽ³ "cloud_utils#CloudUtilsInit"
          ! Υɤ򻲾ȤΤ.
          !
          ! Refer to source codes in the initialization procedure
          ! "cloud_utils#CloudUtilsInit" for the default values.
          !

    ! ¹ʸ ; Executable statement
    !

    if ( cloud_utils_inited ) return


    FlagSnow = ArgFlagSnow


    ! ǥեͤ
    ! Default values settings
    !

    CloudOverlapType    = "Random"
!!$    CloudOverlapType    = "MaxOverlap"

    TempWatLim          = 273.15_DP
    TempIceLim          = 273.15_DP - 40.0_DP


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                     & ! (in)
        & nml = cloud_utils_nml,          & ! (out)
        & iostat = iostat_nml )             ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    select case ( CloudOverlapType )
    case ( 'Random' )
      IDCloudOverlapType = IDCloudOverlapTypeRandom
    case ( 'MaxOverlap' )
      IDCloudOverlapType = IDCloudOverlapTypeMaxOverlap
    case default
      call MessageNotify( 'E', module_name,         &
        & 'CloudOverlapType=<%c> is not supported.', &
        & c1 = trim(CloudOverlapType) )
    end select


    ! Initialization of modules used in this module
    !

    ! 絬϶ŷ (ήŷ) (Manabe, 1965)
    ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
    !
    call LScaleCondInit


    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
!!$    call HistoryAutoAddVariable( 'EffCloudCover', &
!!$      & (/ 'lon ', 'lat ', 'time' /), &
!!$      & 'effective cloud cover', '1' )



    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'CloudOverlapType = %c', c1 = trim(CloudOverlapType) )
    call MessageNotify( 'M', module_name, 'TempWatLim       = %f', d = (/ TempWatLim /) )
    call MessageNotify( 'M', module_name, 'TempIceLim       = %f', d = (/ TempIceLim /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    cloud_utils_inited = .true.

  end subroutine CloudUtilsInit

  !--------------------------------------------------------------------------------------

end module cloud_utils
