!= ̵뤷ã
!
!= Radiative transfer equation without considering scattering
!
! Authors::   Yoshiyuki O. TAKAHASHI
! Version::   $Id: rad_rte_nonscat.f90,v 1.3 2012-02-01 05:19:53 yot Exp $ 
! Tag Name::  $Name: dcpam5-20130302 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module rad_rte_nonscat
  !
  != ̵뤷ã
  !
  != Radiative transfer equation without considering scattering
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 
  !
  ! 
  !
  !== Procedures List
  !
!!$  ! RadDTempDt        :: ͥեåˤ벹Ѳη׻
!!$  ! RadFluxOutput     :: ͥեåν
!!$  ! ------------            :: ------------
!!$  ! RadDTempDt        :: Calculate temperature tendency with radiation flux
!!$  ! RadFluxOutput     :: Output radiation fluxes
  !
  !== NAMELIST
  !
  ! NAMELIST#rad_rte_nonscat_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! ʪ
  ! Physical and mathematical constants settings
  !
  use constants0, only: &
    & PI, &
                            ! $ \pi $ .
                            ! ߼Ψ.  Circular constant
    & StB
                            ! $ \sigma_{SB} $ .
                            ! ƥեܥĥޥ.
                            ! Stefan-Boltzmann constant

  ! ʪ
  ! Physical constants settings
  !
  use constants, only: &
    & Grav, &
                            ! $ g $ [m s-2]. 
                            ! ϲ®. 
                            ! Gravitational acceleration
    & CpDry
                            ! $ C_p $ [J kg-1 K-1]. 
                            ! 絤갵Ǯ. 
                            ! Specific heat of air at constant pressure


  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: RadRTENonScat
  public :: RadRTENonScatWrapper
  public :: RadRTENonScatInit


  ! ѿ
  ! Public variables
  !
  logical, save, public:: rad_rte_nonscat_inited = .false.
                              ! ե饰. 
                              ! Initialization flag


  ! ѿ
  ! Private variables
  !
  real(DP), save :: DiffFact


  character(*), parameter:: module_name = 'rad_rte_nonscat'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20130302 $' // &
    & '$Id: rad_rte_nonscat.f90,v 1.3 2012-02-01 05:19:53 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine RadRTENonScat(                                    &
    & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT,  & ! (in)
    & xyrr_Trans,                                              & ! (in)
    & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
    & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
    & )
    !
    ! ʤξãη׻
    !
    ! Integrate radiative transfer equation without scattering
    !

    ! ⥸塼 ; USE statements
    !


    ! ʸ ; Declaration statements
    !

    real(DP), intent(in ) :: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
                              ! Integrated Planck function
    real(DP), intent(in ) :: xy_SurfIntPF     (0:imax-1, 1:jmax)
                              ! Integrated Planck function with surface temperature
    real(DP), intent(in ) :: xy_IntDPFDT1     (0:imax-1, 1:jmax)
                              ! Integrated temperature derivative of Planck function
    real(DP), intent(in ) :: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
                              ! Integrated temperature derivative of Planck function
                              ! with surface temperature
    real(DP), intent(in ) :: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
                              ! Ʃ᷸. 
                              ! Transmission coefficient
    real(DP), intent(out) :: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Upward longwave flux
    real(DP), intent(out) :: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Downward longwave flux
    real(DP), intent(out) :: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Upward longwave flux derivative
    real(DP), intent(out) :: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Downward longwave flux derivative


    ! ѿ
    ! Work variables
    !
    integer:: k, kk           ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. rad_rte_nonscat_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if



    ! ͥեå׻
    ! Calculate radiation flux
    !

    !   Initialization
    !
    xyr_RadLDwFlux = 0.0_DP
    xyr_RadLUwFlux = 0.0_DP
    !
    !   Downward flux
    !
    do k = kmax, 0, -1

      do kk = kmax, k+1, -1
        xyr_RadLDwFlux(:,:,k) = xyr_RadLDwFlux(:,:,k)          &
          & + xyz_IntPF(:,:,kk)                                &
          & * ( xyrr_Trans(:,:,k,kk-1) - xyrr_Trans(:,:,k,kk) )
      end do

    end do
    !
    !   Upward flux
    !
    !     Set upward flux
    !
    do k = 0, kmax

      xyr_RadLUwFlux(:,:,k) = xy_SurfIntPF * xyrr_Trans(:,:,k,0)

      do kk = 1, k
        xyr_RadLUwFlux(:,:,k) = xyr_RadLUwFlux(:,:,k)          &
          & - xyz_IntPF(:,:,kk)                                &
          & * ( xyrr_Trans(:,:,k,kk-1) - xyrr_Trans(:,:,k,kk) )
      end do

    end do


    ! ͥեåѲΨη׻
    ! Calculate rate of change of radiative flux
    !
    do k = 0, kmax
      xyra_DelRadLUwFlux(:,:,k,0) =                         &
        & xy_SurfIntDPFDT * xyrr_Trans(:,:,k,0)
    end do
    k = 0
    xyra_DelRadLUwFlux(:,:,k,1) = 0.0_DP
    do k = 1, kmax
      xyra_DelRadLUwFlux(:,:,k,1) =                         &
        & - xy_IntDPFDT1(:,:)                               &
        &   * ( xyrr_Trans(:,:,k,0) - xyrr_Trans(:,:,k,1) )
    end do
    do k = 0, kmax
      xyra_DelRadLDwFlux(:,:,k,0) = 0.0_DP
    end do
    k = 0
    xyra_DelRadLDwFlux(:,:,k,1) =                         &
      & + xy_IntDPFDT1(:,:)                               &
      &   * ( xyrr_Trans(:,:,k,0) - xyrr_Trans(:,:,k,1) )
    do k = 1, kmax
      xyra_DelRadLDwFlux(:,:,k,1) = 0.0_DP
    end do


  end subroutine RadRTENonScat

  !--------------------------------------------------------------------------------------

  subroutine RadRTENonScatWrapper(                    &
    & xyz_Temp, xy_SurfTemp, xy_SurfEmis, xyrr_Trans, & ! (in )
    & xyr_RadLUwFlux, xyr_RadLDwFlux,                 & ! (out)
    & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux,         & ! (out)
    & WNs, WNe, NumGaussNode                          & ! (in ) optional
    & )
    !
    ! ʤξãη׻
    !
    ! Integrate radiative transfer equation without scattering
    !

    ! ⥸塼 ; USE statements
    !


    ! ץ󥯴ؿη׻
    ! Calculate Planck function
    !
    use planck_func, only :                            &
      & Integ_PF_GQ_Array3D, Integ_PF_GQ_Array2D, Integ_DPFDT_GQ_Array2D

    ! ʸ ; Declaration statements
    !

    real(DP), intent(in ) :: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(in ) :: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in ) :: xy_SurfEmis (0:imax-1, 1:jmax)
                              ! ɽ̼ͽΨ. 
                              ! Surface emissivity
    real(DP), intent(in ) :: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
                              ! Ʃ᷸. 
                              ! Transmission coefficient
    real(DP), intent(out) :: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Upward longwave flux
    real(DP), intent(out) :: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Downward longwave flux
    real(DP), intent(out) :: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Upward longwave flux derivative
    real(DP), intent(out) :: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Downward longwave flux derivative
    real(DP), intent(in ), optional :: WNs
    real(DP), intent(in ), optional :: WNe
    integer , intent(in ), optional :: NumGaussNode


    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
                              ! Integrated Planck function
    real(DP):: xy_SurfIntPF     (0:imax-1, 1:jmax)
                              ! Integrated Planck function with surface temperature
    real(DP):: xy_IntDPFDT1     (0:imax-1, 1:jmax)
                              ! Integrated temperature derivative of Planck function
    real(DP):: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
                              ! Integrated temperature derivative of Planck function
                              ! with surface temperature


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. rad_rte_nonscat_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! Check arguments
    !
    if ( present( WNs ) .or. present( WNe ) .or. present( NumGaussNode ) ) then
      if ( .not. ( present( WNs ) .and. present( WNe ) .and. present( NumGaussNode ) ) ) then
        call MessageNotify( 'E', module_name, &
          & 'All of WNs, WNe, and NumGaussNode have to be present.' )
      end if
    end if


    if ( present( WNs ) ) then
      ! Case for non-grey atmosphere
      !

      ! Integrate Planck function and temperature derivative of it
      !
      call Integ_PF_GQ_Array3D( &
        & WNs, WNe, NumGaussNode, &
        & 0, imax-1, 1, jmax, 1, kmax, &
        & xyz_Temp, &
        & xyz_IntPF &
        & )
      call Integ_PF_GQ_Array2D( &
        & WNs, WNe, NumGaussNode, &
        & 0, imax-1, 1, jmax, &
        & xy_SurfTemp, &
        & xy_SurfIntPF &
        & )
      call Integ_DPFDT_GQ_Array2D(             &
        & WNs, WNe, NumGaussNode,              & ! (in )
        & 0, imax-1, 1, jmax, xyz_Temp(:,:,1), & ! (in )
        & xy_IntDPFDT1                         & ! (out)
        & )
      call Integ_DPFDT_GQ_Array2D(         &
        & WNs, WNe, NumGaussNode,          & ! (in )
        & 0, imax-1, 1, jmax, xy_SurfTemp, & ! (in )
        & xy_SurfIntDPFDT                  & ! (out)
        & )

      xyz_IntPF       =               PI * xyz_IntPF
      xy_SurfIntPF    = xy_SurfEmis * PI * xy_SurfIntPF
      xy_IntDPFDT1    =               PI * xy_IntDPFDT1
      xy_SurfIntDPFDT = xy_SurfEmis * PI * xy_SurfIntDPFDT

    else

      ! Case for grey atmosphere
      !
      xyz_IntPF       =                        StB * xyz_Temp**4
      xy_SurfIntPF    = xy_SurfEmis          * StB * xy_SurfTemp**4
      xy_IntDPFDT1    =               4.0_DP * StB * xyz_Temp(:,:,1)**3
      xy_SurfIntDPFDT = xy_SurfEmis * 4.0_DP * StB * xy_SurfTemp**3

    end if


    call RadRTENonScat(                                         &
      & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT, & ! (in)
      & xyrr_Trans,                                             & ! (in)
      & xyr_RadLUwFlux, xyr_RadLDwFlux,                         & ! (out)
      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                  & ! (out)
      & )


  end subroutine RadRTENonScatWrapper

  !--------------------------------------------------------------------------------------

  subroutine RadRTENonScatInit
    !
    ! rad_rte_nonscat ⥸塼νԤޤ. 
    ! NAMELIST#rad_rte_nonscat_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "rad_rte_nonscat" module is initialized. 
    ! "NAMELIST#rad_rte_nonscat_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    ! ʸ ; Declaration statements
    !

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read


    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /rad_rte_nonscat_nml/ &
      & DiffFact
          !
          ! ǥեͤˤĤƤϽ³ "rad_rte_nonscat#RadRTENonScatInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "rad_rte_nonscat#RadRTENonScatInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( rad_rte_nonscat_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
    DiffFact = 1.66_DP

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                     & ! (in)
        & nml = rad_rte_nonscat_nml,      & ! (out)
        & iostat = iostat_nml )             ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'DiffFact = %f', d = (/ DiffFact /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    rad_rte_nonscat_inited = .true.

  end subroutine RadRTENonScatInit

  !-------------------------------------------------------------------

end module rad_rte_nonscat
