!= ˰漾λ
!
!= Evaluate saturation specific humidity
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: saturate.F90,v 1.2 2013-02-19 01:37:07 yot Exp $
! Tag Name::  $Name: dcpam5-20130302 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module saturate
  !
  != ˰漾λ
  !
  != Evaluate saturation specific humidity
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ˰漾˰漾βʬͤ򻻽Фޤ. 
  !
  ! Saturation specific humidity and temperature derivative of it are calculated. 
  !
  ! ˰漾η׻ˤϥǥեȤǤ
  ! Tetens (1930) Ѥ (saturate_t1930 ). 
  ! ޤ, Config.mk  CPPFLAGS  -DLIB_SATURATE_NHA1992 ꤹ
  ! Nakajima et al. (1992) Ѥ (saturate_tnha1992 ). 
  !
  ! By default, Tetens (1930) is used for calculation of 
  ! saturation specific humidity (See "saturate_t1930"). 
  ! If "-DLIB_SATURATE_NHA1992" is specified to "CPPFLAGS" in Config.mk, 
  ! Nakajima et al. (1992) is used (See "saturate_nha1992"). 
  !
  !== References
  !
  !== Procedures List
  !
  ! CalcQVapSat            :: ˰漾η׻
  ! CalcDQVapSatDTemp      :: ˰漾βʬη׻
  ! ------------  :: ------------
  ! CalcQVapSat            :: Calculate saturation specific humidity
  ! CalcDQVapSatDTemp      :: Calculate temperature derivative of saturation specific humidity
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#saturate_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

#ifdef LIB_SATURATE_NHA1992
    ! Nakajima et al. (1992) Ѥ˰漾λ
    ! Evaluate saturation specific humidity with Nakajima et al. (1992)
    !
    use saturate_nha1992, only:                             &
#elif LIB_SATURATE_T1930
    ! Tetens (1930) Ѥ˰漾λ
    ! Evaluate saturation specific humidity with Tetens (1930)
    !
    use saturate_t1930, only:                               &
#else
    ! Tetens (1930) Ѥ˰漾λ
    ! Evaluate saturation specific humidity with Tetens (1930)
    !
    use saturate_t1930, only:                               &
#endif
      & xy_CalcQVapSatCore        => xy_CalcQVapSat       , &
      & xy_CalcDQVapSatDTempCore  => xy_CalcDQVapSatDTemp , &
      & xyz_CalcQVapSatCore       => xyz_CalcQVapSat      , &
      & xyz_CalcDQVapSatDTempCore => xyz_CalcDQVapSatDTemp



  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: xy_CalcQVapSat , xy_CalcDQVapSatDTemp
  public:: xyz_CalcQVapSat, xyz_CalcDQVapSatDTemp

  ! ѿ
  ! Public variables
  !
  logical, save, public:: saturate_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  character(*), parameter:: module_name = 'saturate'
                              ! ⥸塼̾. 
                              ! Module name

  character(*), parameter:: saturate_scheme = &
#ifdef LIB_SATURATE_NHA1992
    & 'Nakajima et al. (1992)'
#elif LIB_SATURATE_T1930
    & 'Tetens (1930)'
#else
    & 'Tetens (1930)'
#endif

  character(*), parameter:: version = &
    & '$Name: dcpam5-20130302 $' // &
    & '$Id: saturate.F90,v 1.2 2013-02-19 01:37:07 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version


contains

  function xy_CalcQVapSat( xy_Temp, xy_Press ) result( xy_QVapSat )
    !
    !  *Temp* ȵ *Press* Ѥ, 
    ! ˰漾 *QVapSat* ޤ. 
    !
    ! Calculate saturation specific humidity *QVapSat* using
    ! temperature *Temp* and air pressure *Press*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xy_Temp (0:imax-1, 1:jmax)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xy_Press(0:imax-1, 1:jmax)
                              ! $ p $ . . Air pressure

    real(DP):: xy_QVapSat(0:imax-1, 1:jmax)
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !

    call SaturateInit

    xy_QVapSat = xy_CalcQVapSatCore( 0, imax-1, 1, jmax, xy_Temp, xy_Press )


  end function xy_CalcQVapSat

  !-------------------------------------------------------------------

  function xyz_CalcQVapSat( xyz_Temp, xyz_Press ) result( xyz_QVapSat )
    !
    !  *Temp* ȵ *Press* Ѥ, 
    ! ˰漾 *QVapSat* ޤ. 
    !
    ! Calculate saturation specific humidity *QVapSat* using
    ! temperature *Temp* and air pressure *Press*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyz_Temp (:,:,:)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xyz_Press(:,:,:)
                              ! $ p $ . . Air pressure

    real(DP):: xyz_QVapSat(0:imax-1, 1:jmax, 1:size(xyz_Temp,3))
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !

    call SaturateInit

    xyz_QVapSat = xyz_CalcQVapSatCore( 0, imax-1, 1, jmax, 1, size(xyz_Temp,3), xyz_Temp, xyz_Press )


  end function xyz_CalcQVapSat

  !-------------------------------------------------------------------

  function xy_CalcDQVapSatDTemp( xy_Temp, xy_QVapSat ) result( xy_DQVapSatDTemp )
    !
    !  *Temp* ˰漾 *QVapSat* Ѥ, 
    ! ˰漾βʬ *DQVapSatDTemp* ޤ. 
    !
    ! Calculate temperature derivative of saturation specific humidity 
    ! *DQVapSatDTemp* using
    ! temperature *Temp* and saturation specific humidity *QVapSat*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xy_Temp   (0:imax-1, 1:jmax)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xy_QVapSat(0:imax-1, 1:jmax)
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity
    real(DP):: xy_DQVapSatDTemp(0:imax-1, 1:jmax)
                              ! $ \DP{q^{*}}{T} $ . ˰漾βʬ. 
                              ! Temperature derivative of saturation specific humidity. 

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !

    call SaturateInit

    xy_DQVapSatDTemp = xy_CalcDQVapSatDTempCore( 0, imax-1, 1, jmax, xy_Temp, xy_QVapSat )


  end function xy_CalcDQVapSatDTemp

  !-------------------------------------------------------------------

  function xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QVapSat ) result( xyz_DQVapSatDTemp )
    !
    !  *Temp* ˰漾 *QVapSat* Ѥ, 
    ! ˰漾βʬ *DQVapSatDTemp* ޤ. 
    !
    ! Calculate temperature derivative of saturation specific humidity 
    ! *DQVapSatDTemp* using
    ! temperature *Temp* and saturation specific humidity *QVapSat*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyz_Temp   (:,:,:)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xyz_QVapSat(:,:,:)
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity
    real(DP):: xyz_DQVapSatDTemp(0:imax-1, 1:jmax, 1:size(xyz_Temp,3))
                              ! $ \DP{q^{*}}{T} $ . ˰漾βʬ. 
                              ! Temperature derivative of saturation specific humidity. 

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !

    call SaturateInit

    xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTempCore( 0, imax-1, 1, jmax, 1, size(xyz_Temp,3), xyz_Temp, xyz_QVapSat )

  end function xyz_CalcDQVapSatDTemp

  !-------------------------------------------------------------------

  subroutine SaturateInit
    !
    ! saturate ⥸塼νԤޤ. 
    !--
    ! NAMELIST#saturate_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !++
    !
    ! "saturate" module is initialized. 
    !--
    ! "NAMELIST#saturate_nml" is loaded in this procedure. 
    !++

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /saturate_nml/ 
          !
          ! ǥեͤˤĤƤϽ³ "saturate#SaturateInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "saturate#SaturateInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( saturate_inited ) return

    ! ǥեͤ
    ! Default values settings
    !


!!$    ! NAMELIST ɤ߹
!!$    ! NAMELIST is input
!!$    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &           ! (in)
!!$        & nml = saturate_nml, &  ! (out)
!!$        & iostat = iostat_nml )   ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
    call MessageNotify( 'M', module_name, '  Scheme of saturation = %c', &
      & c1 = saturate_scheme )
    saturate_inited = .true.
  end subroutine SaturateInit

  !-------------------------------------------------------------------

end module saturate
