!= ϲˤǮαľȻ
!
!= Vertical diffusion of heat under the ground
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: subsurface_diffusion_heat.f90,v 1.8 2011-07-08 03:55:19 yot Exp $
! Tag Name::  $Name: dcpam5-20130302 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module subsurface_diffusion_heat
  !
  != ϲαľȻ
  !
  != Vertical diffusion under the ground
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !== Procedures List
  !
  ! SubsurfaceDiffusion     :: ǮƳեåη׻
  ! SubsurfaceDiffusionInit :: ֥롼
  ! ----------------------- :: ------------
  ! SubsurfaceDiffusion     :: Calculate thermal conduction flux
  ! SubsurfaceDiffusionInit :: Initialization
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#subsurface_diffusion_heat_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only:   imax, & ! ٳʻ. 
                               ! Number of grid points in longitude
    &                  jmax, & ! ٳʻ. 
                               ! Number of grid points in latitude
    &                  kmax, & ! ľؿ. 
                               ! Number of vertical level
    &                  kslmax  ! ϲαľؿ. 
                               ! Number of subsurface vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: SubsurfaceDiffusion
  public:: SubsurfaceDiffusionInit

  ! ѿ
  ! Public variables
  !

  ! ѿ
  ! Private variables
  !
  logical, save :: subsurface_diffusion_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  character(*), parameter:: module_name = 'subsurface_diffusion_heat'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20130302 $' // &
    & '$Id: subsurface_diffusion_heat.f90,v 1.8 2011-07-08 03:55:19 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  subroutine SubsurfaceDiffusion(              &
    & xy_DeepSubSurfHeatFlux,                  &          ! (in )
    & xy_SoilHeatCap, xy_SoilHeatDiffCoef,     &          ! (in )
    & xy_SurfTemp, xyz_SoilTemp,               &          ! (in )
    & xyr_SoilTempTransCoef, xyr_SoilHeatFlux  &          ! (out)
    & )
    !
    ! ѲΨη׻Ԥޤ. 
    !
    ! Calculate tendencies. 
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimesetClockStart, TimesetClockStop

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      r_SSDepth, & ! subsurface grid on interface of layer
      z_SSDepth    ! subsurface grid at midpoint of layer

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in ):: xy_DeepSubSurfHeatFlux (0:imax-1, 1:jmax)
                              ! Ǯեå. 
                              ! "Deep subsurface heat flux"
                              ! Heat flux at the bottom of surface/soil layer.
    real(DP), intent(in ):: xy_SoilHeatCap (0:imax-1, 1:jmax)
                              ! ھǮ (J K-1 kg-1)
                              ! Specific heat of soil (J K-1 kg-1)
    real(DP), intent(in ):: xy_SoilHeatDiffCoef (0:imax-1, 1:jmax)
                              ! ھǮƳ (J m-3 K-1)
                              ! Heat conduction coefficient of soil (J m-3 K-1)
    real(DP), intent(in ):: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in ):: xyz_SoilTemp (0:imax-1, 1:jmax, 1:kslmax)
                              ! ھ (K)
                              ! Soil temperature (K)
    real(DP), intent(out):: xyr_SoilTempTransCoef (0:imax-1, 1:jmax, 0:kslmax)
                              ! ͢ھ.
                              ! Transfer coefficient: soil temperature
    real(DP), intent(out):: xyr_SoilHeatFlux (0:imax-1, 1:jmax, 0:kslmax)
                              ! ھǮեå. 
                              ! Heat flux in sub-surface soil



    ! ѿ
    ! Work variables
    !
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. subsurface_diffusion_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )



    ! ھٷ׻Ѥ͢η׻
    ! Calculate transfer coefficient for heat diffusion in the soil
    !
    k = 0
    if ( kslmax == 0 ) then
      ! This line is used when kslmax == 0, because z_SSDepth(k+1) does not exist. 
      xyr_SoilTempTransCoef(:,:,k) = 0.0d0
    else
      xyr_SoilTempTransCoef(:,:,k) = &
        & xy_SoilHeatDiffCoef(:,:) / ( z_SSDepth(k+1) - 0.0d0 )
    end if
    do k = 1, kslmax-1
      xyr_SoilTempTransCoef(:,:,k) = &
        & xy_SoilHeatDiffCoef(:,:) / ( z_SSDepth(k+1) - z_SSDepth(k) )
    end do
    k = kslmax
    xyr_SoilTempTransCoef(:,:,k) = 0.0d0


    ! ھǮեåη׻
    ! Calculate heat flux in sub-surface soil
    !
    k = 0
    if ( kslmax == 0 ) then
      ! This line is used when kslmax == 0, because xyz_SoilTemp(:,:,k+1) does not exist. 
      xyr_SoilHeatFlux(:,:,k) = 0.0d0
    else
      xyr_SoilHeatFlux(:,:,k) = &
        & - xyr_SoilTempTransCoef(:,:,k) * ( xyz_SoilTemp(:,:,1) - xy_SurfTemp(:,:) )
    end if
    do k = 1, kslmax-1
      xyr_SoilHeatFlux(:,:,k) =                               &
        & - xyr_SoilTempTransCoef(:,:,k)                      &
        &   * ( xyz_SoilTemp(:,:,k+1) - xyz_SoilTemp(:,:,k) )
    end do
    k = kslmax
    xyr_SoilHeatFlux(:,:,k) = xy_DeepSubSurfHeatFlux


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine SubsurfaceDiffusion

  !-------------------------------------------------------------------

  subroutine SubsurfaceDiffusionInit
    !
    ! subsurface_diffusion_heat ⥸塼νԤޤ. 
    ! NAMELIST#subsurface_diffusion_heat_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "subsurface_diffusion_heat" module is initialized. 
    ! "NAMELIST#subsurface_diffusion_heat_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !
!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

!!$    real(DP) :: SoilHeatCap
!!$    real(DP) :: SoilHeatDiffCoef

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /subsurface_diffusion_heat_nml/ &
!!$      & SoilHeatCap, SoilHeatDiffCoef
!!$          !
!!$          ! ǥեͤˤĤƤϽ³ "subsurface_diffusion_heat#SubSurfaceDiffusionInit" 
!!$          ! Υɤ򻲾ȤΤ. 
!!$          !
!!$          ! Refer to source codes in the initialization procedure
!!$          ! "subsurface_diffusion_heat#SubsurfaceDiffusionInit" for the default values. 
!!$          !

    ! ¹ʸ ; Executable statement
    !

    if ( subsurface_diffusion_inited ) return

    ! ǥեͤ
    ! Default values settings
    !


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &           ! (in)
!!$        & nml = subsurface_diffusion_heat_nml, &  ! (out)
!!$        & iostat = iostat_nml )   ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    subsurface_diffusion_inited = .true.

  end subroutine SubsurfaceDiffusionInit

  !-------------------------------------------------------------------

end module subsurface_diffusion_heat
