# draw potential temperature distribution
# (for dry atmosphere and flat topography)
# 
# PotTemp = Temp * sigma ** (- R/C_p)
# 
# 
# 
# 2009/03/29  Ǽ¿ ů   
# 

def help()
  print "Usage: ruby ",$0," file varname\n"
end

require "numru/ggraph"
include NumRu

# 
# ε
r = 2.87e+2     # [J K-1 kg-1]
# 갵Ǯ
cp = 1.004e+3   # [J K-1 kg-1]

# Υå
if ARGV[0] == "-h" or ARGV[0] == "--help" then
  help()
  exit 0
elsif ARGV.length != 2 then
  puts "ERROR: The number of argument is invalid."
  help()
  exit 1
end

file = ARGV[0]
varname = ARGV[1]

if !FileTest.file?(file) then
  puts "ERROR: No such file."
  exit 2
end

gphys = GPhys::IO.open(file, varname)

# ʲˡϤʤ湥. äȴñ˽Ťդ򤹤ˡϤ.

nlon = gphys.coord('lon').length
nlat = gphys.coord('lat').length
nsig = gphys.coord('sig').length

weight = NArray.sfloat(nlon, nlat, nsig)
wsig = gphys.coord('sig').to_a

# ٤˳ݤ뷸׻. ̤ʿóǤ뤳Ȥ.
for k in 0...(nsig-1)
  weight[0..(nlon-1), 0..(nlat-1), k] = wsig[k] ** (-r/cp)
end

# ٤鲹̤Ѵ
gphys = gphys * weight

gphys = gphys.mean('lon')

DCL.gropn(2)

GGraph.set_fig('viewport'=>[0.15,0.80,0.15,0.6])

DCL.sgpset('lfull',true)     # ɽ
DCL.sgpset('lcntl', false) ; DCL.uzfact(0.6)

GGraph.set_linear_contour_options('interval'=>5, 'max'=>500)

# Ǿؤϥ󥿡ߤ, DCL ǥ顼ˤʤ뤿ɽʤ
GGraph.contour(gphys.cut('sig'=>0.025..1))

DCL.grcls
