=begin
=mkepf.rb 

  This is a script for calculating EP flux by use of dcpam Mars experiments. 
  The original script was demo_NCEP_2.rb found at http://ruby.gfd-dennou.org/products/gphys/tutorial/ep_flux/.

USAGE
  % mkepf.rb

Note
  This script requires netcdf data on pressure surface. In addition, this 
  script assumes Mars parameters, which can be changed by modifying 
  following lines: 
    GPhys::EP_Flux::scale_height=UNumeric.new(10.0e3,"m")
    GPhys::EP_Flux::radius=UNumeric.new(3396.0e3,"m")
    GPhys::EP_Flux::rot_period=UNumeric.new(88642.663,"s")
    GPhys::EP_Flux::g_forces=UNumeric.new(3.72,"m.s-2")
    GPhys::EP_Flux::p00=UNumeric.new(7.0e2,"Pa")
    GPhys::EP_Flux::cp=UNumeric.new(843.9,"J.K-1.kg-1")
    GPhys::EP_Flux::gas_const=UNumeric.new(8.314 / 43.5e-3,"J.K-1.kg-1")

=end

require 'numru/gphys'
require 'numru/gphys/ep_flux'
include NumRu


#GPhys::EP_Flux::scale_height=UNumeric.new(10.0e3,"m")
#GPhys::EP_Flux::radius=UNumeric.new(3396.0e3,"m")
#GPhys::EP_Flux::rot_period=UNumeric.new(88642.663,"s")
#GPhys::EP_Flux::g_forces=UNumeric.new(3.72,"m.s-2")
#GPhys::EP_Flux::p00=UNumeric.new(7.0e2,"Pa")
#GPhys::EP_Flux::cp=UNumeric.new(843.9,"J.K-1.kg-1")
#GPhys::EP_Flux::gas_const=UNumeric.new(8.314 / 43.5e-3,"J.K-1.kg-1")

#GPhys::EP_Flux::scale_height=UNumeric.new(5.0e3,"m")
GPhys::EP_Flux::scale_height=UNumeric.new(8.0e3,"m")
#GPhys::EP_Flux::scale_height=UNumeric.new(16.0e3,"m")
GPhys::EP_Flux::radius=UNumeric.new(6051.8e3,"m")
GPhys::EP_Flux::rot_period=UNumeric.new(20996928.0,"s")
GPhys::EP_Flux::g_forces=UNumeric.new(8.92,"m.s-2")
GPhys::EP_Flux::p00=UNumeric.new(9.0e6,"Pa")
GPhys::EP_Flux::cp=UNumeric.new(500.0,"J.K-1.kg-1")
#GPhys::EP_Flux::cp=UNumeric.new(837.0,"J.K-1.kg-1")
#GPhys::EP_Flux::cp=UNumeric.new(1200.0,"J.K-1.kg-1")
GPhys::EP_Flux::gas_const=UNumeric.new(8.314 / 43.5e-3,"J.K-1.kg-1")


indir  = "../../util_s2p-2012-09-12/out"
gp_u =     GPhys::IO.open( indir+"/U.nc"   , "U")
gp_v =     GPhys::IO.open( indir+"/V.nc"   , "V")
gp_omega = GPhys::IO.open( indir+"/OMG.nc" , "OMG")
gp_t =     GPhys::IO.open( indir+"/Temp.nc", "Temp")

outdir = "out"
of_epflx_y = NetCDF.create( outdir+"/epflx_y.nc")
of_epflx_z = NetCDF.create( outdir+"/epflx_z.nc")
of_v_rmean = NetCDF.create( outdir+"/v_rmean.nc")
of_w_rmean = NetCDF.create( outdir+"/w_rmean.nc")
of_strm_rmean = NetCDF.create( outdir+"/strm_rmean.nc")
of_epflx_div = NetCDF.create( outdir+"/epflx_div.nc")

nt = gp_u.shape[-1]
i = 0
GPhys::IO.each_along_dims_write([gp_u, gp_v, gp_omega, gp_t], [of_epflx_y, of_epflx_z, of_v_rmean, of_w_rmean, of_strm_rmean, of_epflx_div], -1){
  |u, v, omega, t|
  i += 1
  print "processing #{i} / #{nt} ..\n" if (i % (nt/100+1))==1

  epflx_y, epflx_z, v_rmean, w_rmean, gp_lat, gp_z, u_mean, theta_mean,
        uv_dash, vt_dash, uw_dash, dtheta_dz = ary =
                GPhys::EP_Flux::ep_full_sphere(u, v, omega, t, true)

  ary.each{|gp|                                  #  This part will not
    gp.data.att_names.each{|nm|                  #  be needed in future.
      gp.data.del_att(nm) if /^valid_/ =~ nm     #  (Even now, it is not
    }                                            #  needed if the valid
  }                                              #  range is wide enough)

  epflx_div = GPhys::EP_Flux::div_sphere(epflx_y, epflx_z)
  strm_rmean = GPhys::EP_Flux::strm_rmean(v_rmean)

  if i==1    # time independent => write only once
    gp_lat.rename('phi')
    GPhys::IO.write(of_epflx_y, gp_lat)
    GPhys::IO.write(of_epflx_y, gp_z)
    GPhys::IO.write(of_epflx_z, gp_lat)
    GPhys::IO.write(of_epflx_z, gp_z)
    GPhys::IO.write(of_v_rmean, gp_lat)
    GPhys::IO.write(of_v_rmean, gp_z)
    GPhys::IO.write(of_w_rmean, gp_lat)
    GPhys::IO.write(of_w_rmean, gp_z)
    GPhys::IO.write(of_strm_rmean, gp_lat)
    GPhys::IO.write(of_strm_rmean, gp_z)
    GPhys::IO.write(of_epflx_div, gp_lat)
    GPhys::IO.write(of_epflx_div, gp_z)
  end
#  [ epflx_y, epflx_z, v_rmean, w_rmean, strm_rmean, epflx_div, u_mean, theta_mean,
#    uv_dash, vt_dash, uw_dash, dtheta_dz ]
  [ epflx_y, epflx_z, v_rmean, w_rmean, strm_rmean, epflx_div ]
}

of_epflx_y.close
of_epflx_z.close
of_v_rmean.close
of_w_rmean.close
of_strm_rmean.close
of_epflx_div.close
