!= ήĴ
!
!= Dry convective adjustment
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: dry_conv_adjust.f90,v 1.9 2014/05/07 09:39:17 murashin Exp $ 
! Tag Name::  $Name: dcpam5-20140630-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module dry_conv_adjust
  !
  != ήĴ᥹
  !
  != Dry convective adjustment
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !== Procedures List
  ! 
  ! DryConvAdjust :: ήĴ
  ! ------------  :: ------------
  ! DryConvAdjust :: Dry convective adjustment
  !
  !== NAMELIST
  !
  ! NAMELIST#dry_conv_adjust_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ˴ؤ
  ! Settings of array for atmospheric composition
  !
  use composition, only: &
    &                    ncmax
                              ! ʬο
                              ! Number of composition
  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! NAMELIST եϤ˴ؤ桼ƥƥ
  ! Utilities for NAMELIST file input
  !
  use namelist_util, only: MaxNmlArySize
                              ! NAMELIST ɤ߹κ祵. 
                              ! Maximum size of arrays loaded from NAMELIST

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private


  ! ³
  ! Public procedure
  !
  public:: DryConvAdjust
  public:: DryConvAdjustInit

  ! ѿ
  ! Public variables
  !
  logical, save :: dry_conv_adjust_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  real(DP), save:: CrtlRH
                              ! ׳м. 
                              ! Critical relative humidity
  integer, save:: ItrtMax
                              ! ƥ졼. 
                              ! Number of iteration

  real(DP), save:: AdjustCriterion(1:MaxNmlArySize)
                              ! ĴԤ (Ūͥ륮κβٴ)
                              ! Criterion of adjustment (temperature difference 
                              ! equivalent to difference of dry static energy)

  logical, save :: FlagAdjustMom
                              ! Flag for adjusting momentum
  logical, save :: FlagAdjustMR
                              ! Flag for adjusting mixing ratio

  character(*), parameter:: module_name = 'dry_conv_adjust'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20140630-2 $' // &
    & '$Id: dry_conv_adjust.f90,v 1.9 2014/05/07 09:39:17 murashin Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine DryConvAdjust(                &
    & xyz_Temp, xyz_U, xyz_V, xyzf_QMix,   &  ! (inout)
    & xyz_Press, xyr_Press                 &  ! (in)
    & )
    !
    ! ήĴ᥹ˤ, ٤Ĵ. 
    !
    ! Adjust temperature by dry convective adjustment
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical and mathematical constants settings
    !
    use constants0, only: &
      & GasRUniv
                              ! $ R^{*} $ [J K-1 mol-1]. 
                              ! ׵.  Universal gas constant

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, & 
                              ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & GasRDry, &
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air
      & CpDry
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut


    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(inout):: xyz_U    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ U $ .           Eastward wind velocity
    real(DP), intent(inout):: xyz_V    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ V $ .           Northward wind velocity
    real(DP), intent(inout):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q $ .           Mixing ratio
    real(DP), intent(in   ):: xyz_Press(0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(in   ):: xyr_Press(0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)

    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_DTempDt(0:imax-1, 1:jmax, 1:kmax)
                              ! ѲΨ. 
                              ! Temperature tendency
    real(DP):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
                              ! Ĵβ. 
                              ! Temperature before adjustment
    logical:: xy_Adjust (0:imax-1, 1:jmax)
                              ! Ĵᤵ줿ݤ?. 
                              ! Whether it was adjusted this time or not?
    logical:: xy_AdjustB (0:imax-1, 1:jmax)
                              ! Ĵᤵ줿ݤ?. 
                              ! Whether it was adjusted last time or not?
    real(DP):: xyz_DelPress(0:imax-1, 1:jmax, 1:kmax)
                              ! $ \Delta p $
                              !
    real(DP):: xyz_DelMass (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \Delta p / g $
                              !
    real(DP):: xyr_ConvAdjustFactor(0:imax-1, 1:jmax, 0:kmax)
                              ! $ \frac{1}{2} \frac{ R }{Cp} 
                              !   \frac{ p_{k} - p_{k+1} }{ p_{k+1/2} } $

    real(DP):: TempEquivToExcEne
                              ! Temperature equivalent to the excess dry static energy
                              ! (Dry static energy difference devided by specific heat)

    real(DP):: DelTempUppLev
                              ! k+1 ܤؤˤĴˤ벹٤Ѳ. 
                              ! Temperature variation by adjustment at k+1 level
    real(DP):: DelTempLowLev
                              ! k ܤؤˤĴˤ벹٤Ѳ. 
                              ! Temperature variation by adjustment at k level
    logical:: Adjust
                              ! ΰˤư٤ǤĴᤵ줿ݤ?. 
                              ! Whether it was adjusted even once in global 
                              ! this time or not?

    real(DP):: TempLowLevBefAdj ! Variables for check routine
    real(DP):: TempUppLevBefAdj

    real(DP):: ExchangeMass
                              ! 
                              ! Mass transport
    real(DP):: ExchangeMassDenom
                              ! 
                              ! Variable for mass transport calculation
    real(DP):: ExchangeMassLowLim
                              ! 
                              ! Lower limit of mass transport calculation
    real(DP), parameter :: ExchangeMassLowLimTempDiff = 1.0d-5
                              ! 
                              ! Lower limit of temperature difference 
                              ! between two layers for mass transport 
                              ! calculation
    real(DP):: DelULowLev
                              ! 
                              ! Eastward wind velocity change
    real(DP):: DelUUppLev
                              ! 
                              ! Eastward wind velocity change
    real(DP):: DelVLowLev
                              ! 
                              ! Eastward wind velocity change
    real(DP):: DelVUppLev
                              ! 
                              ! Eastward wind velocity change
    real(DP):: f_DelQMixLowLev(1:ncmax)
                              ! 
                              ! Mixing ratio change
    real(DP):: f_DelQMixUppLev(1:ncmax)
                              ! 
                              ! Mixing ratio change

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: itr             ! ƥ졼˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in iteration direction


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. dry_conv_adjust_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! Ĵ "Temp" ¸
    ! Store "Temp" before adjustment
    !
    xyz_TempB = xyz_Temp

    ! Calculate some values used for dry convective adjustment
    !

    do k = 1, kmax
      xyz_DelPress(:,:,k) = xyr_Press(:,:,k-1) - xyr_Press(:,:,k)
    end do
    xyz_DelMass = xyz_DelPress / Grav

    ! \frac{1}{2} \frac{ R }{Cp} \frac{ p_{k} - p_{k+1} }{ p_{k+1/2} }
    !
    !   The value at k = 0 is not used.
    k = 0
    xyr_ConvAdjustFactor(:,:,k) = 0.0_DP
    !
    do k = 1, kmax-1
      xyr_ConvAdjustFactor(:,:,k) =                     &
        & GasRDry / CpDry                               &
        &   * ( xyz_Press(:,:,k) - xyz_Press(:,:,k+1) ) &
        &   / xyr_Press(:,:,k) / 2.0_DP
    end do
    !   The value at k = kmax is not used.
    k = kmax
    xyr_ConvAdjustFactor(:,:,k) = 0.0d0


    ! Ĵ
    ! Adjustment
    !
    xy_AdjustB = .true.

    ! ֤
    ! Iteration
    !
    do itr = 1, ItrtMax
      xy_Adjust = .false.

      do k = 1, kmax-1
        do j = 1, jmax
          do i = 0, imax-1
            if ( xy_AdjustB(i,j) ) then

              ! Temperature equivalent to the excess dry static energy
              ! (Dry static energy difference devided by specific heat)
              !
              TempEquivToExcEne = &
                &   xyz_Temp(i,j,k) - xyz_Temp(i,j,k+1)                                &
                & - xyr_ConvAdjustFactor(i,j,k) * ( xyz_Temp(i,j,k) + xyz_Temp(i,j,k+1) )

              ! Check vertical gradient of dry static energy
              !
              if ( TempEquivToExcEne > AdjustCriterion(itr) ) then

                DelTempUppLev =                                                       &
                  &   xyz_DelPress(i,j,k) * TempEquivToExcEne                         &
                  & / ( xyr_ConvAdjustFactor(i,j,k)                                   &
                  &       * ( xyz_DelPress(i,j,k  )                                   &
                  &         - xyz_DelPress(i,j,k+1) )                                 &
                  &     + xyz_DelPress(i,j,k) + xyz_DelPress(i,j,k+1) )

                DelTempLowLev =                                                       &
                  & - xyz_DelPress(i,j,k+1) * DelTempUppLev                           &
                  & / xyz_DelPress(i,j,k)


                !=========
                ! save temperature before adjustment
                !---------
                TempLowLevBefAdj = xyz_Temp(i,j,k  )
                TempUppLevBefAdj = xyz_Temp(i,j,k+1)


                ! ٤Ĵ
                ! Adjust temperature
                !
                xyz_Temp(i,j,k  ) = xyz_Temp(i,j,k  ) + DelTempLowLev
                xyz_Temp(i,j,k+1) = xyz_Temp(i,j,k+1) + DelTempUppLev


                !=========
                ! check routine
                !---------
!!$                write( 6, * ) '====='
!!$                write( 6, * ) 'Energy difference before and after adjustment and each energy'
!!$                write( 6, * )                                                        &
!!$                  &   ( CpDry * TempLowLevBefAdj  )                                  &
!!$                  &     * xyz_DelPress(i,j,k  ) / Grav                               &
!!$                  & + ( CpDry * TempUppLevBefAdj  )                                  &
!!$                  &     * xyz_DelPress(i,j,k+1) / Grav                               &
!!$                  & - ( CpDry * xyz_Temp(i,j,k  ) )                                  &
!!$                  &     * xyz_DelPress(i,j,k  ) / Grav                               &
!!$                  & - ( CpDry * xyz_Temp(i,j,k+1) )                                  &
!!$                  &     * xyz_DelPress(i,j,k+1) / Grav,                              &
!!$                  &   ( CpDry * TempLowLevBefAdj  )                                  &
!!$                  &     * xyz_DelPress(i,j,k  ) / Grav,                              &
!!$                  &   ( CpDry * TempUppLevBefAdj  )                                  &
!!$                  &     * xyz_DelPress(i,j,k+1) / Grav,                              &
!!$                  &   ( CpDry * xyz_Temp(i,j,k  ) )                                  &
!!$                  &     * xyz_DelPress(i,j,k  ) / Grav,                              &
!!$                  &   ( CpDry * xyz_Temp(i,j,k+1) )                                  &
!!$                  &     * xyz_DelPress(i,j,k+1) / Grav
!!$                write( 6, * ) 'Difference of dry static energy after adjustment'
!!$                write( 6, * )                                                         &
!!$                  &   ( CpDry * xyz_Temp(i,j,k  ) )                                   &
!!$                  & - ( CpDry * xyz_Temp(i,j,k+1) )                                   &
!!$                  & - CpDry * xyr_ConvAdjustFactor(i,j,k)                             &
!!$                  &   * ( xyz_Temp(i,j,k) + xyz_Temp(i,j,k+1) ),                      &
!!$                  &   ( CpDry * xyz_Temp(i,j,k  ) ),                                  &
!!$                  &   ( CpDry * xyz_Temp(i,j,k+1) ),                                  &
!!$                  & - CpDry * xyr_ConvAdjustFactor(i,j,k)                             &
!!$                  &   * ( xyz_Temp(i,j,k) + xyz_Temp(i,j,k+1) )
                !=========


                ! 
                ! Mass exchange
                !   Denominator
                ExchangeMassDenom =                                      &
                  &   CpDry * ( TempLowLevBefAdj - TempUppLevBefAdj )    &
                  & - GasRDry                                            &
                  &   * ( TempLowLevBefAdj + TempUppLevBefAdj ) / 2.0_DP &
                  &   / xyr_Press(i,j,k)                                 &
                  &   * ( xyz_Press(i,j,k) - xyz_Press(i,j,k+1) )
                ExchangeMassLowLim = CpDry * ExchangeMassLowLimTempDiff
                ! If a static energy difference between two layers is smaller 
                ! than a specified lower limit, momentum and mixing ratio are 
                ! not mixed to ensure numerical stability.
                ! If the lower limit is zero, some calculations are unstable.
                ! (yot, 2013/10/02)
                if ( ExchangeMassDenom > ExchangeMassLowLim ) then
                  ExchangeMass =                                   &
                    & - CpDry * DelTempLowLev / ExchangeMassDenom  &
                    &     * xyz_DelMass(i,j,k)
                else
                  ExchangeMass = 0.0_DP
                end if
                !   Limitation of amount of mass exchange not to 
                !   reverse a gradient
                ExchangeMass = &
                  & min( ExchangeMass,                                      &
                  &      xyz_DelMass(i,j,k) * xyz_DelMass(i,j,k+1)          &
                  &        / ( xyz_DelMass(i,j,k) + xyz_DelMass(i,j,k+1) )  &
                  &    )

                if ( FlagAdjustMom ) then
                  DelULowLev =                            &
                    &   ( xyz_U(i,j,k+1) - xyz_U(i,j,k) ) &
                    & * ExchangeMass                      &
                    & / xyz_DelMass(i,j,k  )
                  DelUUppLev =                            &
                    & - ( xyz_U(i,j,k+1) - xyz_U(i,j,k) ) &
                    & * ExchangeMass                      &
                    & / xyz_DelMass(i,j,k+1)
                  DelVLowLev =                            &
                    &   ( xyz_V(i,j,k+1) - xyz_V(i,j,k) ) &
                    & * ExchangeMass                      &
                    & / xyz_DelMass(i,j,k  )
                  DelVUppLev =                            &
                    & - ( xyz_V(i,j,k+1) - xyz_V(i,j,k) ) &
                    & * ExchangeMass                      &
                    & / xyz_DelMass(i,j,k+1)

                  xyz_U(i,j,k  ) = xyz_U(i,j,k  ) + DelULowLev
                  xyz_U(i,j,k+1) = xyz_U(i,j,k+1) + DelUUppLev
                  xyz_V(i,j,k  ) = xyz_V(i,j,k  ) + DelVLowLev
                  xyz_V(i,j,k+1) = xyz_V(i,j,k+1) + DelVUppLev
                end if

                if ( FlagAdjustMR ) then
                  f_DelQMixLowLev =                                   &
                    &   ( xyzf_QMix(i,j,k+1,:) - xyzf_QMix(i,j,k,:) ) &
                    & * ExchangeMass                                  &
                    & / xyz_DelMass(i,j,k  )
                  f_DelQMixUppLev =                                   &
                    & - ( xyzf_QMix(i,j,k+1,:) - xyzf_QMix(i,j,k,:) ) &
                    & * ExchangeMass                                  &
                    & / xyz_DelMass(i,j,k+1)

                  xyzf_QMix(i,j,k  ,:) = xyzf_QMix(i,j,k  ,:) + f_DelQMixLowLev
                  xyzf_QMix(i,j,k+1,:) = xyzf_QMix(i,j,k+1,:) + f_DelQMixUppLev
                end if

                ! Ĵᤷݤ?
                ! Whether it was adjusted or not?
                !
                xy_Adjust(i,j) = .true.
              end if

            end if

          end do
        end do
      end do

      Adjust = .false.
      do i = 0, imax-1
        do j = 1, jmax
          xy_AdjustB(i,j) = xy_Adjust(i,j)
          Adjust          = Adjust .or. xy_Adjust(i,j)
        end do
      end do

      if ( .not. Adjust ) exit

    end do

    ! ѲΨ
    ! Calculate temperature tendency
    !
    xyz_DTempDt = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )


    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'DTempDtDryConv', xyz_DTempDt )


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine DryConvAdjust

  !--------------------------------------------------------------------------------------

  subroutine DryConvAdjustInit
    !
    ! dry_conv_adjust ⥸塼νԤޤ. 
    ! NAMELIST#dry_conv_adjust_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "dyr_conv_adjust" module is initialized. 
    ! "NAMELIST#dry_conv_adjust_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /dry_conv_adjust_nml/ &
      & CrtlRH, ItrtMax, AdjustCriterion, &
      & FlagAdjustMom, FlagAdjustMR
          ! ǥեͤˤĤƤϽ³ "dry_conv_adjust#DryConvAdjustInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "dry_conv_adjust#DryConvAdjustInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( dry_conv_adjust_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
    ! default values used in AGCM5
!!$    CrtlRH  = 0.990_DP
!!$    ItrtMax = 10
!!$    AdjustCriterion(1:ItrtMax) = &
!!$      & (/ 0.01_DP, 0.02_DP, 0.02_DP, 0.05_DP, 0.05_DP, &
!!$      &    0.10_DP, 0.10_DP, 0.20_DP, 0.20_DP, 0.40_DP  /)
    !
    CrtlRH  = 1.0_DP
    ItrtMax = 10
    AdjustCriterion(1:ItrtMax) = 0.0_DP

    FlagAdjustMom = .false.
    FlagAdjustMR  = .false.


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                &  ! (in)
        & nml = dry_conv_adjust_nml, &  ! (out)
        & iostat = iostat_nml )         ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$      if ( iostat_nml == 0 ) write( STDOUT, nml = cumulus_adjust_nml )
    end if

    ! ƥ졼, ԰εƸΥå
    ! Check number of iteration, admissible error of unstability
    !
    call NmlutilAryValid( module_name, & ! (in)
      & AdjustCriterion, 'AdjustCriterion', &      ! (in)
      & ItrtMax,    'ItrtMax' )          ! (in)


    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'DTempDtDryConv', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /),      &
      & 'dry convective adjustment heating', 'K s-1' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  CrtlRH               = %f', d = (/ CrtlRH /) )
    call MessageNotify( 'M', module_name, '  ItrtMax              = %d', i = (/ ItrtMax /) )
    call MessageNotify( 'M', module_name, '  AdjustCriterion      = (/ %*r /)', &
      & r = real( AdjustCriterion(1:ItrtMax) ), n = (/ ItrtMax /) )
    call MessageNotify( 'M', module_name, '  FlagAdjustMom        = %b', l = (/ FlagAdjustMom /) )
    call MessageNotify( 'M', module_name, '  FlagAdjustMR         = %b', l = (/ FlagAdjustMR  /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    dry_conv_adjust_inited = .true.

  end subroutine DryConvAdjustInit

  !--------------------------------------------------------------------------------------

end module dry_conv_adjust
