!= ñͥǥ
!
!= Simple radiation model
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: rad_simple.f90,v 1.5 2013/05/25 06:47:34 yot Exp $
! Tag Name::  $Name: dcpam5-20140630-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module rad_simple
  !
  != ñͥǥ
  !
  != Simple radiation model
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 
  !
  ! This is a simple radiation model.
  !
  !== References
  !
  !
  !
  !== Procedures List
  !
!!$  ! RadiationFluxDennouAGCM :: ͥեåη׻
!!$  ! RadiationDTempDt        :: ͥեåˤ벹Ѳη׻
!!$  ! RadiationFluxOutput     :: ͥեåν
!!$  ! RadiationFinalize       :: λ (⥸塼ѿγդ)
!!$  ! ------------            :: ------------
!!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
!!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
!!$  ! RadiationFluxOutput     :: Output radiation fluxes
!!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
  !
  !== NAMELIST
  !
  ! NAMELIST#rad_Simple_nml
  !

  ! USE statements
  !

  !
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ.
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ.
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ.
                             ! Number of vertical level

  implicit none

  private


  ! Private variables
  !
!!$  real(DP), save :: SWOptDepAtRefPress
!!$  real(DP), save :: SWRefPress
!!$  real(DP), save :: SWOrd
!!$  real(DP), save :: LWOptDepAtRefPress
!!$  real(DP), save :: LWRefPress
!!$  real(DP), save :: LWOrd


  ! ѿ
  ! Public variables
  !
  logical, save, public:: rad_simple_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  public :: RadSimpleFlux
  public :: RadSimpleInit

  character(*), parameter:: module_name = 'rad_simple'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20140630-2 $' // &
    & '$Id: rad_simple.f90,v 1.5 2013/05/25 06:47:34 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine RadSimpleFlux(                                                    &
    & xy_SurfAlbedo, xy_SurfTemp, xyr_Press, xyz_Press, xyz_Temp, xyz_QH2OVap, &
    & xyr_RadSUwFlux, xyr_RadSDwFlux,                                          &
    & xyr_RadLUwFlux, xyr_RadLDwFlux,                                          &
    & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                                   &
    & )


    ! USE statements
    !

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ʪ
    ! Physical and mathematical constants settings
    !
    use constants0, only: &
      & PI                    ! $ \pi $ .
                              ! ߼Ψ.  Circular constant

    !
    ! Physical constants settings
    !
    use constants, only: Grav     ! $ g $ [m s-2].
                                  !
                                  ! Gravitational acceleration

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only : y_Lat

    ! ͥեå
    ! Set solar constant
    !
    use set_solarconst, only : SetSolarConst

    ! û ()
    ! Short wave (insolation) incoming
    !
    use rad_short_income, only : RadShortIncome

    !
    ! Solve radiative transfer equation in two stream approximation
    !
    use rad_rte_two_stream_app, only: RadRTETwoStreamAppSW

    ! Ĺȥեåη׻
    ! Calculate long wave flux
    !
    use rad_simple_LW, only : RadSimpleLWFlux


    real(DP), intent(in ) :: xy_SurfAlbedo( 0:imax-1, 1:jmax )
    real(DP), intent(in ) :: xy_SurfTemp  ( 0:imax-1, 1:jmax )
    real(DP), intent(in ) :: xyr_Press    ( 0:imax-1, 1:jmax, 0:kmax )
    real(DP), intent(in ) :: xyz_Press    ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in ) :: xyz_Temp     ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in ) :: xyz_QH2OVap  ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(out) :: xyr_RadSUwFlux    ( 0:imax-1, 1:jmax, 0:kmax )
    real(DP), intent(out) :: xyr_RadSDwFlux    ( 0:imax-1, 1:jmax, 0:kmax )
    real(DP), intent(out) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
    real(DP), intent(out) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)


    ! Work variables
    !
    real(DP) :: DistFromStarScld
                               ! Distance between the central star and the planet
    real(DP) :: DiurnalMeanFactor

    real(DP) :: SolarConst
    real(DP) :: SolarFluxTOA
!!$    real(DP) :: QeRatio
    real(DP) :: xyz_SSA       (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_AF        (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xy_InAngle    (0:imax-1, 1:jmax)
    real(DP) :: xyz_DelAtmMass(0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyr_OptDep    (0:imax-1, 1:jmax, 0:kmax)

    real(DP) :: xy_SurfAlbedoLW(0:imax-1, 1:jmax)
    real(DP) :: xy_SurfEmis    (0:imax-1, 1:jmax)

    integer  :: k


    ! 
    ! Initialization
    !
    if ( .not. rad_Simple_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! Short wave radiation
    !

    ! ûͤη׻
    ! Calculate short wave (insolation) incoming radiation
    !
    call RadShortIncome(                       &
      & xy_InAngle        = xy_InAngle,        & ! (out) optional
      & DistFromStarScld  = DistFromStarScld,  & ! (out) optional
      & DiurnalMeanFactor = DiurnalMeanFactor  &
      & )

    ! ͥեå
    ! Set solar constant
    !
    call SetSolarConst( &
      & SolarConst      & ! (out)
      & )
    SolarFluxTOA = SolarConst / DistFromStarScld**2 * DiurnalMeanFactor

    xyz_SSA    = 1.0_DP - 1.0d-10
    xyz_AF     = 0.0_DP
    xyr_OptDep = 0.0_DP

    call RadRTETwoStreamAppSW(            &
      & xyz_SSA, xyz_AF,                  & ! (in)
      & xyr_OptDep,                       & ! (in)
      & xy_SurfAlbedo,                    & ! (in)
      & SolarFluxTOA, xy_InAngle,         & ! (in)
      & xyr_RadSUwFlux, xyr_RadSDwFlux    & ! (out)
      & )

    ! Long wave radiation
    !

    do k = 1, kmax
      xyz_DelAtmMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k ) ) / Grav
    end do

    xy_SurfAlbedoLW = 0.0_DP
    xy_SurfEmis     = 1.0_DP

    call RadSimpleLWFlux(                                         &
      & xy_SurfAlbedoLW, xy_SurfEmis,                             & ! (in)
      & xyr_Press, xyz_Press, xyz_Temp, xy_SurfTemp,              & ! (in)
      & xyz_DelAtmMass, xyz_QH2OVap,                              & ! (in)
      & xyr_RadLUwFlux, xyr_RadLDwFlux,                           & ! (out)
      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                    & ! (out)
      & )


  end subroutine RadSimpleFlux

  !--------------------------------------------------------------------------------------

  subroutine RadSimpleInit

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ͥեå
    ! Set solar constant
    !
    use set_solarconst, only : SetSolarConstInit

    ! û ()
    ! Short wave (insolation) incoming
    !
    use rad_short_income, only : RadShortIncomeInit

    !
    ! Solve radiative transfer equation in two stream approximation
    !
    use rad_rte_two_stream_app, only: RadRTETwoStreamAppInit

    ! ͥեå (ñĹȥХɥǥ)
    ! Radiation flux (simple longwave band model)
    !
    use rad_simple_LW, only : RadSimpleLWInit


    ! ʸ ; Declaration statements
    !

    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /rad_Simple_nml/ &
!!$      & SWOptDepAtRefPress, SWRefPress, SWOrd, &
!!$      & LWOptDepAtRefPress, LWRefPress, LWOrd
          !
          ! ǥեͤˤĤƤϽ³ "rad_Simple#RadSimpleInit"
          ! Υɤ򻲾ȤΤ.
          !
          ! Refer to source codes in the initialization procedure
          ! "rad_Simple#RadSimpleInit" for the default values.
          !

    if ( rad_Simple_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
!!$    SWOptDepAtRefPress =  3.0_DP
!!$    SWRefPress         =  3.0d5
!!$    SWOrd              =  1.0_DP
!!$
!!$    LWOptDepAtRefPress = 80.0_DP
!!$    LWRefPress         =  3.0d5
!!$    LWOrd              =  2.0_DP


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml,                     & ! (in)
!!$        & nml = rad_Simple_nml,           & ! (out)
!!$        & iostat = iostat_nml )             ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if


    ! Initialization of modules used in this module
    !

    ! ͥեå
    ! Set solar constant
    !
    call SetSolarConstInit

    ! û ()
    ! Short wave (insolation) incoming
    !
    call RadShortIncomeInit

    !
    ! Solve radiative transfer equation in two stream approximation
    !
    call RadRTETwoStreamAppInit

    ! ͥեå (ñĹȥХɥǥ)
    ! Radiation flux (simple longwave band model)
    !
    call RadSimpleLWInit


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
!!$    call MessageNotify( 'M', module_name, 'SWOptDepAtRefPress = %f', d = (/ SWOptDepAtRefPress /) )
!!$    call MessageNotify( 'M', module_name, 'SWRefPress         = %f', d = (/ SWRefPress /) )
!!$    call MessageNotify( 'M', module_name, 'SWOrd              = %f', d = (/ SWOrd /) )
!!$    call MessageNotify( 'M', module_name, 'LWOptDepAtRefPress = %f', d = (/ LWOptDepAtRefPress /) )
!!$    call MessageNotify( 'M', module_name, 'LWRefPress         = %f', d = (/ LWRefPress /) )
!!$    call MessageNotify( 'M', module_name, 'LWOrd              = %f', d = (/ LWOrd /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    rad_Simple_inited = .true.

  end subroutine RadSimpleInit

  !--------------------------------------------------------------------------------------

end module rad_simple
