#!/bin/bash
# -*- coding: utf-8 -*-
# Taguchi, Yamaga, and Yoden (2001) の図 1, 2 の再現.
# あるいは田口さん D 論の図 3.1, 3.2 の再現.
# p 座標系に変換したファイルを使うこと.

# p 座標系への変換を行うかどうか. 1 のときは行う.
#convert_sig2p=0
convert_sig2p=1

GPVIEW="gpview --wsn 2"
CONVERT90="convert -rotate 90"

if [ `hostname` = "studia04" ]; then
  DATA_ROOT=${HOME}/Supremacy5/dcpam/studia07/dcpam5-20121128-mod/dcpam5-exp/test_rst
else
#  DATA_ROOT=${HOME}/work/dcpam/dcpam5-20121128-mod/dcpam5-exp/test_rst
#  DATA_ROOT=${HOME}/work/dcpam/dcpam5-20121128-mod/dcpam5-exp3/tyy01
  wd=`pwd -P`
  cd ..
  DATA_ROOT=`pwd -P`
  cd ${wd}
fi
#DATA_SUBDIR=01
#DATA_SUBDIR=01_opt
DATA_SUBDIR=.
#TIMERANGE=310:1310
TIMERANGE=310:1310:4   # メモリ不足のとき
#FHEADER=Taguchi_Dthesis_
FHEADER=TYY01_

cwd=`pwd`

# p 座標系に変換
if [ "${convert_sig2p}" = "1" ]; then
  cd ${DATA_ROOT}
  for v in Temp TempEQ Height U; do
    outfile=${v}_p.nc
    if [ ! -e ${outfile} ]; then
      gpconv_sig2p \
	--var ${DATA_SUBDIR}/${v}.nc@${v},time=${TIMERANGE} \
	--ps ${DATA_SUBDIR}/Ps.nc@Ps,time=${TIMERANGE} \
	--psave 1000 -o ${outfile}
    fi
  done
  cd $cwd
fi

# 図 3.1(a): 標準基本温度場
${GPVIEW} ${DATA_ROOT}/TempEQ_p.nc@TempEQ,p=1000:0.08 --mean lon,time --itr 2 --int 10 --range 170:310
name=${FHEADER}1a
mv dcl.ps ${name}.ps
${CONVERT90} ${name}.ps ${name}.png 

# 図 3.1(b): 時間平均した帯状平均温度場
${GPVIEW} ${DATA_ROOT}/Temp_p.nc@Temp,time=${TIMERANGE},p=1000:0.08 --mean lon,time --itr 2 --int 10 --range 170:310
name=${FHEADER}1b
mv dcl.ps ${name}.ps
${CONVERT90} ${name}.ps ${name}.png 

# 図 3.1(c): 温度場の標準偏差
${GPVIEW} ${DATA_ROOT}/Temp_p.nc@Temp,time=${TIMERANGE},p=1000:0.08 --mean lon --stddev time --itr 2 --int 2.5 --range 0:30
name=${FHEADER}1c
mv dcl.ps ${name}.ps
${CONVERT90} ${name}.ps ${name}.png 

# 図 3.1(d): 時間平均した帯状平均温度場の, 標準基本温度場からの偏差
${GPVIEW} ${DATA_ROOT}/Temp_p.nc@Temp,time=${TIMERANGE},p=1000:0.08 --itr 2 --int 5 --range -40:40 --clrmap 14 --operation " - GPhys::IO.open_gturl(\""${DATA_ROOT}"/TempEQ_p.nc@TempEQ,time="${TIMERANGE}",p=1000:0.08\"); g = g.mean(\'lon\').mean(\'time\')"
name=${FHEADER}1d
mv dcl.ps ${name}.ps
${CONVERT90} ${name}.ps ${name}.png 

# 図 3.1 (e): 平均東西風速場
${GPVIEW} ${DATA_ROOT}/U_p.nc@U,time=${TIMERANGE},p=1000:0.08 --mean lon,time --itr 2 --int 10 --clrmap 14 --range -80:80
name=${FHEADER}1e
mv dcl.ps ${name}.ps
${CONVERT90} ${name}.ps ${name}.png 

# 図 3.1 (f): 東西風速場の標準偏差
${GPVIEW} ${DATA_ROOT}/U_p.nc@U,time=${TIMERANGE},p=1000:0.08 --mean lon --stddev time --itr 2 --int 5 --range 0:40
name=${FHEADER}1f
mv dcl.ps ${name}.ps
${CONVERT90} ${name}.ps ${name}.png 



# 図 3.2(a): 東西波数 1 のジオポテンシャル高度の停滞波の振幅
${GPVIEW} ${DATA_ROOT}/Height_p.nc@Height,p=1000:0.08 --itr 2 \
  --operation " * 1 ; GPhys::fft_ignore_missing; g=g.mean(\'time\').fft(nil, 0).cut(\'lon\'=>1).abs" --int 50 --range 0:1000
name=${FHEADER}2a
mv dcl.ps ${name}.ps
${CONVERT90} ${name}.ps ${name}.png 

# 図 3.2(b): 同, 位相
${GPVIEW} ${DATA_ROOT}/Height_p.nc@Height,p=1000:0.08 --itr 2 \
  --operation " * 1 ; GPhys::fft_ignore_missing; g=g.mean(\'time\').fft(nil, 0).cut(\'lon\'=>1).angle * 180.0 / 3.1415; na=g.val; mask = na.le(0.0); na[mask] += 360.0; g.val = na" --int 45 --range 0:360
name=${FHEADER}2b
mv dcl.ps ${name}.ps
${CONVERT90} ${name}.ps ${name}.png 

# 図 3.2(c): 日々の波数 1 の惑星波振幅の 1000 日平均
# (fft_ignore_missing の replace_val を小さい値に設定しないと，地表付近の欠損値のせいで, range を指定しないと成層圏のコンターが見えなくなる)
${GPVIEW} ${DATA_ROOT}/Height_p.nc@Height,p=1000:0.08 --itr 2 \
  --operation " * 1 ; GPhys::fft_ignore_missing(ignore=true, replace_val=0.0); g=g.fft(nil, 0).cut(\'lon\'=>1).abs.mean(\'time\')" --int 50  --range 0:1400
name=${FHEADER}2c
mv dcl.ps ${name}.ps
${CONVERT90} ${name}.ps ${name}.png 

# 図 3.2(d): 同, 標準偏差
${GPVIEW} ${DATA_ROOT}/Height_p.nc@Height,p=1000:0.08 --itr 2 \
  --operation " * 1 ; GPhys::fft_ignore_missing(ignore=true, replace_val=0.0); g=g.fft(nil, 0).cut(\'lon\'=>1).abs.stddev(\'time\')" --int 50 --range 0:1000
name=${FHEADER}2d
mv dcl.ps ${name}.ps
${CONVERT90} ${name}.ps ${name}.png 


# 図 3.2(e): 波数 2 の場合. (a) に同じ.
${GPVIEW} ${DATA_ROOT}/Height_p.nc@Height,p=1000:0.08 --itr 2 \
  --operation " * 1 ; GPhys::fft_ignore_missing; g=g.mean(\'time\').fft(nil, 0).cut(\'lon\'=>2).abs" --int 25 --range 0:200
name=${FHEADER}2e
mv dcl.ps ${name}.ps
${CONVERT90} ${name}.ps ${name}.png 

# 図 3.2(f): 波数 2 の場合. (b) に同じ.
${GPVIEW} ${DATA_ROOT}/Height_p.nc@Height,p=1000:0.08 --itr 2 \
  --operation " * 1 ; GPhys::fft_ignore_missing; g=g.mean(\'time\').fft(nil, 0).cut(\'lon\'=>2).angle * 180.0 / 3.1415; na=g.val; mask = na.le(0.0); na[mask] += 360.0; g.val = na" --int 45 --range 0:360
name=${FHEADER}2f
mv dcl.ps ${name}.ps
${CONVERT90} ${name}.ps ${name}.png 

# 図 3.2(g): 波数 2 の場合. (c) に同じ.
${GPVIEW} ${DATA_ROOT}/Height_p.nc@Height,p=1000:0.08 --itr 2 \
  --operation " * 1 ; GPhys::fft_ignore_missing(ignore=true, replace_val=0.0); g=g.fft(nil, 0).cut(\'lon\'=>2).abs.mean(\'time\')" --int 25 --range 0:600
name=${FHEADER}2g
mv dcl.ps ${name}.ps
${CONVERT90} ${name}.ps ${name}.png 

# 図 3.2(h): 波数 2 の場合. (d) に同じ.
${GPVIEW} ${DATA_ROOT}/Height_p.nc@Height,p=1000:0.08 --itr 2 \
  --operation " * 1 ; GPhys::fft_ignore_missing(ignore=true, replace_val=0.0); g=g.fft(nil, 0).cut(\'lon\'=>2).abs.stddev(\'time\')" --int 25 --range 0:400
name=${FHEADER}2h
mv dcl.ps ${name}.ps
${CONVERT90} ${name}.ps ${name}.png 
