!c Description: 
!c   2 ϳإǥ
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2003-11-11    ⶶ 
!c   1.1        2003-11-12    ̰ϯ 
!c   1.1        2003-11-17    ̰ϯ 
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved

program arare
  use gtool_history
  use fileset
  use gridset
  use integrt
  use physprm
  use expname
  use prm  
  use grid
  use jacobian
  use basicenv
  use if_heikin
  use if_bibun
  use if_cori_u
  use if_adv_u
  use if_trb_u
  use if_snddiv
  use if_vel_u
  use if_vel_w
  use if_omega
  use if_adv_w
  use if_byc_w
  use if_trb_w
  use if_exner
  use if_bd_cyclic
  use if_bd_asymm
  use if_bd_symm

  !--- ۤηػ
  implicit none

!  !--- 롼פ󤹤Τ˻Ȥѿ
!  integer :: i, k
  integer :: t, tau
  real(8) :: dur

  !--- ѿ
  real(8), allocatable :: pi(:,:)      ! ʡؿ
  real(8), allocatable :: pi_old(:,:)  ! ʡؿ(ݴ)
  real(8), allocatable :: pi_z(:,:)  ! ʡؿ(ݴ)
  real(8), allocatable :: pres(:,:)    ! 
  real(8), allocatable :: temp(:,:)    ! 
!  real(8), allocatable :: vtemp(:,:)   !  
!  real(8), allocatable :: theta(:,:)   ! 
  real(8), allocatable :: vtheta(:,:)  ! 
  real(8), allocatable :: dens(:,:)    ! ̩
  real(8), allocatable :: qv(:,:)      ! 
  real(8), allocatable :: e_sub(:,:)   ! ֥åɱưͥ륮
  real(8), allocatable :: km_sub(:,:)  ! 緸 K_{m}
  real(8), allocatable :: mxrt(:,:)    ! ˰º
  real(8), allocatable :: div(:,:)     ! ȸ

  !--- ®ٴϢѿ
  real(8), allocatable :: u(:,:)       ! x ®
  real(8), allocatable :: u_adv(:,:)   ! ή
  real(8), allocatable :: u_cori(:,:)   ! ꥪ 
  real(8), allocatable :: u_trb(:,:)   ! Ȼ
  real(8), allocatable :: omg(:,:)     ! z* ®
  real(8), allocatable :: w(:,:)       ! z ®
  real(8), allocatable :: w_adv(:,:)   ! ή
!  real(8), allocatable :: w_cori(:,:)   ! ꥪ 
  real(8), allocatable :: w_trb(:,:)   ! Ȼ
!  real(8), allocatable :: w_dif(:,:)   ! ȸ
  real(8), allocatable :: w_byc(:,:)   ! ȸ

  !--- gtool4
  type(gt_history) :: grid_u, grid_w, grid_c
  
  !----------------------------------------------
  !⥸塼ν
  !----------------------------------------------
  call fileset_init
  call gridset_init
  call integrt_init
  call physprm_init
  call expname_init
  call prm_init


  !-------------------------------------------------
  ! ϷϢ
  !-------------------------------------------------
  call grid_init
  call jacobian_init

  !-------------------------------------------------
  ! gtool_history ν
  !-------------------------------------------------
  call output_gtool4_init

  !-------------------------------------------------
  ! ܾ
  !-------------------------------------------------
  call basicenv_init
 
  !-------------------------------------------------
  ! CFL Υå
  !-------------------------------------------------
  call cflchk
  

  !-------------------------------------------------
  ! η׻
  !-------------------------------------------------
  allocate(pi(-bm:im+bm,-bm:km+bm), &
       &   pres(-bm:im+bm,-bm:km+bm), &
       &   pi_old(-bm:im+bm,-bm:km+bm), &
       &   temp(-bm:im+bm,-bm:km+bm), &
!       &   vtemp(-bm:im+bm,-bm:km+bm), &
!       &   theta(-bm:im+bm,-bm:km+bm), &
       &   vtheta(-bm:im+bm,-bm:km+bm), &
       &   dens(-bm:im+bm,-bm:km+bm), &
       &   qv(-bm:im+bm,-bm:km+bm), &
       &   e_sub(-bm:im+bm,-bm:km+bm), &
       &   km_sub(-bm:im+bm,-bm:km+bm), &
       &   mxrt(-bm:im+bm,-bm:km+bm), &
       &   div(-bm:im+bm, -bm:km+bm), &
       &   u(-bm:im+bm, -bm:km+bm), &
       &   w(-bm:im+bm, -bm:km+bm), &
       &   omg(-bm:im+bm, -bm:km+bm))

  
  !--- ܾͤ˹碌. ܾꤷƤʤΤ. 
  pi = pi_bs
!  pi(3,:) = 1.1             ! ʤ
  pi(:,10) = 1.1             ! ʤ
!  pi(10,10) = 1.1             ! ʤ
  pi_old = pi
  pres = pres_bs
  temp = temp_bs
!  vtemp = vtemp_bs
!  theta = theta_bs
  vtheta = vtheta_bs
  dens = dens_bs
  qv = qv_bs
  e_sub = 0.0d0
  km_sub = 0.0d0
  mxrt = 0.0d0
  div = 0.0d0
  u = 0.0d0
  w = 0.0d0
  omg = 0.0d0
  call bibun(312, pi, pi_z)

  !--- ͤݴ
  dur = 0.0d0
  call output_gtool4  


  !-------------------------------------------------
  ! ĹॹƥåפǤη׻
  !-------------------------------------------------
  do t = 1, ntb
     call adv_u(u, w, u_adv)
     call cori_u(u, w, u_cori)
     call trb_u(u, w, u_trb)
     call omega(u, w, omg)
     call adv_w(u, w, omg, w_adv)
     call byc_w(vtheta, qv, w_byc)
     call trb_w(u, w, w_trb)
     
     !-------------------------------------------------
     ! ûॹƥåפǤη׻
     !-------------------------------------------------
     do tau = 1, nts
        dur = dur + dts 
        write(*,*) "в: ", dur
        call snddiv(u, w, div)
        call vel_u(pi, div, u_adv, u_cori, u_trb, u)
        call bd_cyclic(u)
        call bd_asymm(u)
        
        call exner(u, w, w_adv, w_byc, w_trb, div, pi)
        call bd_cyclic(pi)
        call bd_asymm(pi)
        
        call vel_w(pi, pi_old, div, w_adv, w_byc, w_trb, w)         
        call bd_cyclic(w)
        call bd_symm(w)
        
        call omega(u, w, omg)        
        
        !--- 
        call output_gtool4
        
        !--- ͤݴ
        pi_old = pi        
     end do
        
  end do

  call close_gtool4


contains

  !--- gtool4 ϴϢ
  subroutine output_gtool4_init
    ! ҥȥ꡼
    call HistoryCreate(                                    &
         & file = ncfile_u,                                &
         & title = exptitle,                             &
         & source = expsrc,                              &
         & institution = expinst,                        &
         & dims=(/'x','z','t'/),                           &
         & dimsizes=(/im+1, km, 0/),         &
         & longnames=(/'X-coordinate','Z-coordinate',      &
         &             'Time        '/),                   &
         & units=(/'m','m','s'/), origin=0.0,              &
         & interval=0.0, &
         & history = grid_u)
    
    ! ѿ
    call HistoryPut('x', x(0:im), grid_u)
    call HistoryPut('z', zs(0:km-1), grid_u)

    ! ҥȥ꡼
    call HistoryCreate(                                    &
         & file = ncfile_w,                                &
         & title = exptitle,                             &
         & source = expsrc,                              &
         & institution = expinst,                        &
         & dims=(/'x','z','t'/),                           &
         & dimsizes=(/im, km+1, 0/),         &
         & longnames=(/'X-coordinate','Z-coordinate',      &
         &             'Time        '/),                   &
         & units=(/'m','m','s'/), &
         & origin=0.0,              &
         & interval=0.0, &
         & history = grid_w)
    
    ! ѿ
    call HistoryPut('x', xs(0:im-1), grid_w)
    call HistoryPut('z', z(0:km), grid_w)

    ! ҥȥ꡼
    call HistoryCreate(                                  &
         & file = ncfile_c,                              &
         & title = exptitle,                             &
         & source = expsrc,                              &
         & institution = expinst,                        &
         & dims=(/'x','z','t'/),                         &
         & dimsizes=(/im, km, 0/),         &
         & longnames=(/'X-coordinate','Z-coordinate',    &
         &             'Time        '/),                 &
         & units=(/'m','m','s'/), origin=0.0,            &
!         & interval=real(dts,4),                           &
         & interval=0.0,                           &
         & history = grid_c)
    
    ! ѿ
    call HistoryPut('x', xs(0:im-1), grid_c)
    call HistoryPut('z', zs(0:km-1), grid_c)
    
    ! 
    call HistoryAddVariable(                            &
         & varname='pres', dims=(/'x','z','t'/),             &
         & longname='pressure', units='Pa',  &
         & xtype='double',                & 
         & history = grid_c)    
    ! ̵
    call HistoryAddVariable(                            &
         & varname='pi', dims=(/'x','z','t'/),             &
         & longname='nondimensional pressure', units='1',&
         & xtype='double',                & 
         & history = grid_c)    
    ! ̩
    call HistoryAddVariable(                            &
         & varname='dens', dims=(/'x','z','t'/),             &
         & longname='density', units='kg/m3',           &
         & xtype='double',                & 
         & history = grid_c)    
    ! 
    call HistoryAddVariable(                            &
         & varname='qv', dims=(/'x','z','t'/),             &
         & longname='mixing ratio of water vapor',      &
         &  units='g/g', xtype='double',                & 
         & history = grid_c)    
    ! 
    call HistoryAddVariable(                            &
         & varname='temp', dims=(/'x','z','t'/),             &
         & longname='temperature',                      &
         & units='K', xtype='double',                   &
         & history = grid_c)    
    ! 
    call HistoryAddVariable(                            &
         & varname='vtheta', dims=(/'x','z','t'/),             &
         & longname='potential temperature',         &
         & units='K', xtype='double', &
         & history = grid_c)    
    ! ®
    call HistoryAddVariable(                            &
         & varname='u', dims=(/'x','z','t'/),             &
         & longname='zonal velocity',         &
         & units='m/s', xtype='double',                & 
         & history = grid_u)        
    ! ®
    call HistoryAddVariable(                            &
         & varname='w', dims=(/'x','z','t'/),             &
         & longname='vertical velocity',         &
         & units='m/s', xtype='double',                & 
         & history = grid_w)    
    ! ®
    call HistoryAddVariable(                            &
         & varname='omg', dims=(/'x','z','t'/),             &
         & longname='vertical velocity',         &
         & units='m/s', xtype='double',                & 
         & history = grid_w)    
    ! ƥ
    call HistoryAddVariable(                            &
         & varname='pi_z', dims=(/'x','z','t'/),             &
         & longname='zonal velocity',         &
         & units='m/s', xtype='double',                & 
         & history = grid_c)        
!    ! ƥ
!    call HistoryAddVariable(                            &
!         & varname='div', dims=(/'x','z','t'/),             &
!         & longname='zonal velocity',         &
!         & units='m/s', xtype='double',                & 
!         & history = grid_c)        
    
  end subroutine output_gtool4_init


  subroutine output_gtool4
    call HistoryPut('t', dur, grid_c)
    call HistoryPut('t', dur, grid_u)
    call HistoryPut('t', dur, grid_w)
    call HistoryPut('pres', pres(0:im-1,0:km-1), grid_c)
    call HistoryPut('pi', pi(0:im-1,0:km-1), grid_c)
    call HistoryPut('dens', dens(0:im-1,0:km-1), grid_c)
    call HistoryPut('qv', qv(0:im-1,0:km-1), grid_c)
    call HistoryPut('temp', temp(0:im-1,0:km-1), grid_c)
    call HistoryPut('vtheta', vtheta(0:im-1,0:km-1), grid_c)
!    call HistoryPut('div', div(0:im-1,0:km-1), grid_c)
    call HistoryPut('u', u(0:im,0:km-1), grid_u)
    call HistoryPut('w', w(0:im-1,0:km), grid_w)
    call HistoryPut('omg', omg(0:im-1,0:km), grid_w)
    call HistoryPut('pi_z', pi_z(0:im,0:km-1), grid_c)
  end subroutine output_gtool4

  subroutine close_gtool4
    call HistoryClose(grid_c)
    call HistoryClose(grid_u)
    call HistoryClose(grid_w)
  end subroutine close_gtool4
end program arare

