!c Description: 
!c   ʪ̤־ѹ. ʿѲ
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2003-11-19    ̰ϯ 
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved

module if_heikin
  interface heikin

     subroutine heikin_1d(type, var, var_bar)
       use gridset
       integer, intent(in)               :: type
       real(8), intent(in)               :: var(-bm:)
       real(8), intent(out), allocatable :: var_bar(:)
     end subroutine heikin_1d
     
     subroutine heikin_2d(type, var, var_bar)
       use gridset
       integer, intent(in)               :: type
       real(8), intent(in)               :: var(-bm:,-bm:)
       real(8), intent(out), allocatable :: var_bar(:,:)
     end subroutine heikin_2d
     
  end interface
end module if_heikin




subroutine heikin_1d(type, var, var_bar)
  !--- ⥸塼ɤ߹
  use gridset
  
  !--- ۤηػ
  implicit none
  
  !--- ѿ
  integer, intent(in)               :: type
  real(8), intent(in)               :: var(-bm:)
  real(8), intent(out), allocatable :: var_bar(:)

  !--- ʿѷ׻
  select case (type)

  case (12)
     allocate(var_bar(-bm:im+bm))
     var_bar = 0.0d0
     var_bar(-bm:im+bm-1) =          &
          &  (                       &
          &     var(-bm+1:im+bm)     &
          &   + var(-bm:im+bm-1)     &
          &  ) * 5.0d-1
     var_bar(im+bm) = var_bar(im+bm-1) 

  case (13)
     allocate(var_bar(-bm:km+bm))
     var_bar = 0.0d0
     var_bar(-bm:km+bm-1) =          &
          &  (                       &
          &     var(-bm+1:km+bm)     &
          &   + var(-bm:km+bm-1)     &
          &  ) * 5.0d-1
     var_bar(km+bm) = var_bar(km+bm-1) 

  case (21)
     allocate(var_bar(-bm:im+bm))
     var_bar = 0.0d0
     var_bar(-bm+1:im+bm) =          &
          &  (                       &
          &     var(-bm+1:im+bm)     &
          &   + var(-bm:im+bm-1)     &
          &  ) * 5.0d-1
     var_bar(-bm) = var_bar(-bm+1) 

  case (32)
     allocate(var_bar(-bm:km+bm))
     var_bar = 0.0d0
     var_bar(-bm+1:km+bm) =          &
          &  (                       &
          &     var(-bm+1:km+bm)     &
          &   + var(-bm:km+bm-1)     &
          &  ) * 5.0d-1
     var_bar(-bm) = var_bar(-bm+1) 
     
  end select

  if (.not. allocated(var_bar)) then 
     write(*,*) "type is not known ", type, " by heikin.f90"
  end if

end subroutine heikin_1d





subroutine heikin_2d(type, var, var_bar)
  !--- ⥸塼ɤ߹
  use gridset
  
  !--- ۤηػ
  implicit none
  
  !--- ѿ
  integer, intent(in)               :: type
  real(8), intent(in)               :: var(-bm:,-bm:)
  real(8), intent(out), allocatable :: var_bar(:,:)

  !--- ѿ
  allocate(var_bar(-bm:im+bm, -bm:km+bm))
  var_bar = 0.0d0


  !----------------------------------------------------
  !--- ʿѲ
  !----- case1x: ʻǤ
  !------- case11: 顼
  !------- case12: ® u
  !------- case13: ® w
  !------- case14: ޥåץե
  !----- case2x: u Ǥ
  !------- case21: 顼
  !------- case22: ® u
  !------- case23: ® w
  !------- case24: ޥåץե
  !----- case3x: w Ǥ
  !------- case31: 顼
  !------- case32: ® u
  !------- case33: ® w
  !------- case34: ޥåץե
  !----- case4x: ʻǤ
  !------- case41: 顼
  !------- case42: ® u
  !------- case43: ® w
  !------- case44: ޥåץե
  !----------------------------------------------------
  select case (type)

  case (11)
     var_bar = var

  case (12)
     var_bar(-bm:im+bm-1,-bm:km+bm) =          &
          &  (                                 &
          &     var(-bm+1:im+bm,-bm:km+bm)     &
          &   + var(-bm:im+bm-1,-bm:km+bm)     &
          &  ) * 5.0d-1
     var_bar(im+bm, :) = var_bar(im+bm-1,:) 

  case (13)
     var_bar(-bm:im+bm,-bm:km+bm-1) =          &
          &  (                                 &
          &     var(-bm:im+bm,-bm+1:km+bm)     &
          &   + var(-bm:im+bm,-bm:km+bm-1)     &
          &  ) * 5.0d-1
     var_bar(:,km+bm) = var_bar(:,km+bm-1) 

  case (14)
     var_bar(-bm:im+bm-1,-bm:km+bm-1) =       &
          &  (                                &
          &     var(-bm+1:im+bm,-bm+1:km+bm)  &
          &   + var(-bm+1:im+bm,-bm:km+bm-1)  &
          &   + var(-bm:im+bm-1,-bm+1:km+bm)  &
          &   + var(-bm:im+bm-1,-bm:km+bm-1)  &
          &  ) * 2.5d-1
     var_bar(im+bm, :) = var_bar(im+bm-1,:) 
     var_bar(:,km+bm) = var_bar(:,km+bm-1) 

  case (21)
     var_bar(-bm+1:im+bm,-bm:km+bm) =         &
          &  (                                &
          &     var(-bm+1:im+bm,-bm:km+bm)    &
          &   + var(-bm:im+bm-1,-bm:km+bm)    &
          &  ) * 5.0d-1
     var_bar(-bm, :) = var_bar(-bm+1,:) 

  case (22)
     var_bar = var

  case (23) 
     var_bar(-bm+1:im+bm,-bm:km+bm-1) =       &
          &  (                                &
          &     var(-bm+1:im+bm,-bm+1:km+bm)  &
          &   + var(-bm+1:im+bm,-bm:km+bm-1)  &
          &   + var(-bm:im+bm-1,-bm+1:km+bm)  &
          &   + var(-bm:im+bm-1,-bm:km+bm-1)  &
          &  ) * 2.5d-1
     var_bar(-bm,:) = var_bar(-bm+1,:) 
     var_bar(:,km+bm) = var_bar(:,km+bm-1) 
    
  case (24)
     var_bar(-bm:im+bm,-bm:km+bm-1) =         &
          &  (                                &
          &     var(-bm:im+bm,-bm+1:km+bm)    &
          &   + var(-bm:im+bm,-bm:km+bm-1)    &
          &  ) * 5.0d-1
     var_bar(:,km+bm) = var_bar(:,km+bm-1) 
     
  case (31)
     var_bar(-bm:im+bm,-bm+1:km+bm) =         &
          &  (                                &
          &     var(-bm:im+bm,-bm+1:km+bm)    &
          &   + var(-bm:im+bm,-bm:km+bm-1)    &
          &  ) * 5.0d-1
     var_bar(:,-bm) = var_bar(:,-bm+1) 
     
  case (32)
     var_bar(-bm:im+bm-1,-bm+1:km+bm) =       &
          &  (                                &
          &     var(-bm+1:im+bm,-bm+1:km+bm)  &
          &   + var(-bm+1:im+bm,-bm:km+bm-1)  &
          &   + var(-bm:im+bm-1,-bm+1:km+bm)  &
          &   + var(-bm:im+bm-1,-bm:km+bm-1)  &
          &  ) * 2.5d-1
     var_bar(im+bm,:) = var_bar(im+bm-1,:) 
     var_bar(:,-bm) = var_bar(:,-bm+1) 
     
  case (33) 
     var_bar = var
    
  case (34)
     var_bar(-bm:im+bm-1,-bm:km+bm) =         &
          &  (                                &
          &     var(-bm+1:im+bm,-bm:km+bm)    &
          &   + var(-bm:im+bm-1,-bm:km+bm)    &
          &  ) * 5.0d-1
     var_bar(im+bm,:) = var_bar(im+bm-1,:) 

  case (41)
     var_bar(-bm+1:im+bm,-bm+1:km+bm) =       &
          &  (                                &
          &     var(-bm+1:im+bm,-bm+1:km+bm)  &
          &   + var(-bm+1:im+bm,-bm:km+bm-1)  &
          &   + var(-bm:im+bm-1,-bm+1:km+bm)  &
          &   + var(-bm:im+bm-1,-bm:km+bm-1)  &
          &  ) * 2.5d-1
     var_bar(-bm,:) = var_bar(-bm+1,:) 
     var_bar(:,-bm) = var_bar(:,-bm+1) 
     
  case (42)
     var_bar(-bm:im+bm,-bm+1:km+bm) =         &
          &  (                                &
          &     var(-bm:im+bm,-bm+1:km+bm)    &
          &   + var(-bm:im+bm,-bm:km+bm-1)    &
          &  ) * 5.0d-1
     var_bar(:,-bm) = var_bar(:,-bm+1) 

  case (43) 
     var_bar(-bm+1:im+bm,-bm:km+bm) =         &
          &  (                                &
          &     var(-bm+1:im+bm,-bm:km+bm)    &
          &   + var(-bm:im+bm-1,-bm:km+bm)    &
          &  ) * 5.0d-1
     var_bar(-bm, :) = var_bar(-bm+1,:) 
    
  case (44)
     var_bar = var

  end select
     
end subroutine heikin_2d
