!c Description: 
!c   z* ϤǤ® omaga η׻
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2003-12-04    ̰ϯ 
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved

module if_omega
  interface

     subroutine omega(u, w, omg)
       use gridset, only: bm
       real(8), intent(in)               :: u(-bm:,:)
       real(8), intent(in)               :: w(-bm:,:)
       real(8), intent(out), allocatable :: omg(:,:)
     end subroutine omega

  end interface
end module if_omega



subroutine omega(u, w, omg)

  !--- ⥸塼ƽ
  use gridset  
  use physprm
  use jacobian 
  use if_heikin
  
  !--- ۤηػ
  implicit none

  !--- ѿ
  real(8), intent(in)               :: u(-bm:,:)
  real(8), intent(in)               :: w(-bm:,:)
  real(8), intent(out), allocatable :: omg(:,:)
  
  !--- ѿ
  real(8), allocatable              :: u_bxbz(:,:)
  
  !--- Ѱ
  if (allocated(omg)) deallocate(omg)
  allocate(omg(-bm:im+bm, -bm:km+bm))
  omg = 0.0d0
  
  !--- ʿѲ
  call heikin(32, u, u_bxbz)
  
  !--- z* ϤǤαľ®
  omg = u_bxbz * g13_bx + w / jcb_bz

  !--- κ
  deallocate(u_bxbz)
    
end subroutine omega
