!c Description: 
!c   
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2004, All rights reserved

module if_boundary
  interface boundary

     subroutine boundary2d(type, var)
       use gridset 
       character(*), intent(in)   :: type
       real(8), intent(inout)     :: var(DimXMin:DimXMax, DimZMin:DimZMax)
     end subroutine boundary2d
     
  end interface
end module if_boundary



subroutine boundary2d(type, var)
  !--- ⥸塼ɤ߹
  use gridset
  
  !--- ۤηػ
  implicit none
  
  !--- ѿ
  character(*), intent(in)   :: type
  real(8), intent(inout)     :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  
  !--- ѿ
  integer   :: i

  if (type == "CC") then 
     !--- x : 
     do i = 0, Margin
        var(RegXMin - i , RegZMin:RegZMax) &
             & = var(RegXMax - i , RegZMin:RegZMax) 
     end do
     do i = 1, Margin
        var(RegXMax + i , RegZMin:RegZMax) &
             & = var(RegXMin + i , RegZMin:RegZMax) 
     end do
     
     !--- z :      
     do i = 0, Margin
        var(:, RegZMin - i) = var(:, RegZMax - i) 
     end do
     do i = 1, Margin
        var(:, RegZMax + i) = var(:, RegZMin + i) 
     end do

  elseif (type == "CsS") then 
     !--- x : 
     do i = 0, Margin
        var(RegXMin - i , RegZMin:RegZMax) &
             & = var(RegXMax - i , RegZMin:RegZMax) 
     end do
     do i = 1, Margin
        var(RegXMax + i , RegZMin:RegZMax) &
             & = var(RegXMin + i , RegZMin:RegZMax) 
     end do

     !--- z : о
     do i = 0, Margin
        var(:, RegZMin - i) = var(:, RegZMin + 1 + i )
     end do
     do i = 1, Margin
        var(:, RegZMax + i ) = var(:, RegZMax - i - 1 )
     end do
     
  elseif (type == "CfS") then 
     !--- x : 
     do i = 0, Margin
        var(RegXMin - i , RegZMin:RegZMax) &
             & = var(RegXMax - i , RegZMin:RegZMax) 
     end do
     do i = 1, Margin
        var(RegXMax + i , RegZMin:RegZMax) &
             & = var(RegXMin + i , RegZMin:RegZMax) 
     end do

     !--- z : о
     var(:, RegZMin) = 0.0d0
     var(:, RegZMax) = 0.0d0
     do i = 1, Margin
        var(:, RegZMin - i) = var(:, RegZMin + i )
     end do
     do i = 1, Margin
        var(:, RegZMax + i ) = var(:, RegZMax - i )
     end do
     
  elseif (type == "CsA") then 
     !--- x : 
     do i = 0, Margin
        var(RegXMin - i , RegZMin:RegZMax) &
             & = var(RegXMax - i , RegZMin:RegZMax) 
     end do
     do i = 1, Margin
        var(RegXMax + i , RegZMin:RegZMax) &
             & = var(RegXMin + i , RegZMin:RegZMax) 
     end do

     !--- z : ȿо     
     do i = 0, Margin
        var(:, RegZMin - i) = - var(:, RegZMin + 1 + i )
     end do
     do i = 1, Margin
        var(:, RegZMax + i) = - var(:, RegZMax - i - 1)
     end do
     
  elseif (type == "CfA") then 
     !--- x : 
     do i = 0, Margin
        var(RegXMin - i , RegZMin:RegZMax) &
             & = var(RegXMax - i , RegZMin:RegZMax) 
     end do
     do i = 1, Margin
        var(RegXMax + i , RegZMin:RegZMax) &
             & = var(RegXMin + i , RegZMin:RegZMax) 
     end do

     !--- z : ȿо     
     var(:, RegZMin) = 0.0d0
     var(:, RegZMax) = 0.0d0
     do i = 1, Margin
        var(:, RegZMin - i) = - var(:, RegZMin + i )
     end do
     do i = 1, Margin
        var(:, RegZMax + i) = - var(:, RegZMax - i )
     end do
     
  elseif (type == "SC") then 
     !--- x : о
     do i = 0, Margin
        var(RegXMin - i, RegZMin:RegZMax) &
             & = var(RegXMin + 1 + i, RegZMin:RegZMax )
     end do
     do i = 1, Margin
        var(RegXMax + i, RegZMin:RegZMax) &
             & = var(RegXMax - i - 1, RegZMin:RegZMax )
     end do
     
     !--- z :      
     do i = 0, Margin
        var(RegXMin:RegXMax, RegZMin - i) &
             & = var(RegXMin:RegXMax, RegZMax - i) 
     end do
     do i = 1, Margin
        var(RegXMin:RegXMax, RegZMax + i) &
             & = var(RegXMin:RegXMax, RegZMin + i) 
     end do
     
  elseif (type == "AC") then 
     !--- x : ȿо     
     var(RegXMin, RegZMin:RegZMax) = 0.0d0
     var(RegXMax, RegZMin:RegZMax) = 0.0d0
     do i = 0, Margin
        var(RegXMin - i, RegZMin:RegZMax) &
             & = - var(RegXMin + 1 + i, RegZMin:RegZMax)
     end do
     do i = 1, Margin
        var(RegXMax + i, RegZMin:RegZMax) &
             & = - var(RegXMax - i - 1, RegZMin:RegZMax)
     end do

     !--- z :      
     do i = 0, Margin
        var(RegXMin:RegXMax, RegZMin - i) &
             & = var(RegXMin:RegXMax, RegZMax - i) 
     end do
     do i = 1, Margin
        var(RegXMin:RegXMax, RegZMax + i) &
             & = var(RegXMin:RegXMax, RegZMin + i) 
     end do


  elseif (type == "SS") then 
     !--- x : о
     do i = 0, Margin
        var(RegXMin - i, RegZMin:RegZMax) &
             & = var(RegXMin + 1 + i, RegZMin:RegZMax )
     end do
     do i = 1, Margin
        var(RegXMax + i, RegZMin:RegZMax) &
             & = var(RegXMax - i - 1, RegZMin:RegZMax )
     end do
     
     !--- z : о
     do i = 0, Margin
        var(RegXMin:RegXMax, RegZMin - i) &
             & = var(RegXMin:RegXMax, RegZMin + 1 + i )
     end do
     do i = 1, Margin
        var(RegXMin:RegXMax, RegZMax - i + 1) &
             & = var(RegXMin:RegXMax, RegZMax + i )
     end do

     
  elseif (type == "AA") then 
     !--- x : ȿо     
     var(RegXMin, RegZMin:RegZMax) = 0.0d0
     var(RegXMax, RegZMin:RegZMax) = 0.0d0
     do i = 0, Margin
        var(RegXMin - i, RegZMin:RegZMax) &
             & = - var(RegXMin + 1 + i, RegZMin:RegZMax)
     end do
     do i = 1, Margin
        var(RegXMax + i, RegZMin:RegZMax) &
             & = - var(RegXMax - i - 1, RegZMin:RegZMax)
     end do

     !--- z : ȿо     
     var(:, RegZMin) = 0.0d0
     var(:, RegZMax) = 0.0d0
     do i = 0, Margin
        var(:, RegZMin - i) = - var(:, RegZMin + 1 + i )
     end do
     do i = 1, Margin
        var(:, RegZMax + i) = - var(:, RegZMax - i - 1)
     end do

  else
     write(*,*) "boundary.f90: Unknown Boundary Type", type
     stop

  end if

end subroutine boundary2d
