!c Description: 
!c   $B@~7A7W;;%i%$%V%i%j$N%i%C%Q!<(B
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2004, All rights reserved

module linlib
  implicit none
  
  private
  public linlib_init       !$B=i4|2=(B
  public linsolv           !$B<B(B 3 $B9`9TNs$NO"N)(B 1 $B<!J}Dx<0(B($BG\@:EY(B)
  
  character(1)  :: LLib    !$BMQ$$$k%i%$%V%i%j$N%U%i%0(B
  
  save LLib
  
contains
  subroutine linlib_init(N)
    use fileset, only: cfgfile
    use ssl2_linear, only: ssl2_ltx_init

    integer, intent(in)   :: N  !$BG[Ns%5%$%:(B
    
    !--- NAMELIST $B$NDj5A(B
    NAMELIST /linlib/ LLib
    
    !--- $BJQ?t$N<h$j=P$7(B
    open (10, FILE=cfgfile)
    read(10, NML=linlib)
    close(10)

    !--- $BMQ$$$k%i%$%V%i%j$N=i4|2=(B
    if (LLib == 's') then 
       call ssl2_ltx_init(N)

    elseif (LLib == 'l') then 
       write(*,*) "linlib.f90: sorry, LAPACK is not supported. "

    else
       write(*,*) "linlib.f90: unknown LLib ", LLib
       stop
    end if
  end subroutine linlib_init
  

  subroutine LinSolv(A, B, C, D)
    use ssl2_linear, only: ssl2_ltx

    real(8), intent(in)    :: A(:)
    real(8), intent(in)    :: B(:)
    real(8), intent(in)    :: C(:) 
    real(8), intent(inout) :: D(:)

    !--- $BMQ$$$k%i%$%V%i%j$N=i4|2=(B
    if (LLib == 's') then 
       call ssl2_ltx(A, B, C, D)

    elseif (LLib == 'l') then 
       write(*,*) "linlib.f90: sorry, LAPACK is not supported. "
       
    else
       write(*,*) "linlib.f90: unknown LLib ", LLib
       stop
    end if
  end subroutine LinSolv
  
end module linlib
