!c Description: 
!c   ʪѥ⥸塼
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2003-11-12    
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved

module physprm
  implicit none
  save
  real(8), parameter :: pi            = 3.141592d0  !߼Ψ
  real(8), parameter :: GasRUniv      = 8.3143D0    !׵
  real(8), parameter :: MolWt         = 28.9D0      !ʿʬ
  real(8), parameter :: TempRef       = 298.15d0    !ɸಹ
  real(8), parameter :: PressRef      = 1.0d5       !ɸవ
  real(8), parameter :: Grav_jupiter  = 23.2d0      !ν
  real(8), parameter :: Grav_earth    = 9.8d0       !ϵν
  real(8), parameter :: Grav_mars     = 3.724d0     !ν
  real(8), parameter :: Grav_venus    = 8.918d0     !ν
  real(8), parameter :: Grav_saturn   = 9.92d0      !ν
  real(8), parameter :: Grav_uranus   = 8.61d0      !ŷν
  real(8), parameter :: Grav_neptune  = 11.1d0      !ν
  real(8), parameter :: MolWtDry_earth = 28.9d0     !ϵʿʬ
  real(8), parameter :: MolWtWet_earth = 28.9d0     !ϵμʬ
  real(8)            :: GasR
  real(8)            :: Grav            
  real(8)            :: MolWtDry
  real(8)            :: MolWtWet
  character(80)      :: Planet

contains
  subroutine physprm_init
    use fileset, only: cfgfile
    
    !--- NAMELIST 
    NAMELIST /physprm/ Planet
    
    !--- ѿμФ
    open (10, FILE=cfgfile)
    read(10, NML=physprm)
    close(10)
    
    !--- Ϥ
    Grav = 0.0d0
    
    select case(Planet)
    case ("earth")
       Grav = Grav_earth
       MolWtDry = MolWtDry_earth
       MolWtWet = MolWtWet_earth
       GasR = GasRUniv * 1.0d3 / MolWtDry
    case ("mars")
       Grav = Grav_mars
    case ("venus")
       Grav = Grav_venus
    case ("jupiter")
       Grav = Grav_jupiter
    case ("saturn") 
       Grav = Grav_saturn
    case ("uranus") 
       Grav = Grav_uranus
    case ("neptune")
       Grav = Grav_neptune
    end select
    
  end subroutine physprm_init
end module physprm

