C*********************************************************************
C*********************************************************************
C
      SUBROUTINE MONIT
     I   ( U     , V     , W     , PPAI ,
     I     TPOT  , QVAP  , QCLW  , QRAI ,
     I     ICL   , TIME  ,
     O     AXU   , AXV   , AXW   ,
     O     AXTPOT, AXQVAP, AXQCLW, AXQRAI, AXMSE ,
     O     EKINET, ETHERM, ELATNT, EPOTW ,
     M     CTHKIN, CLATHR, CPWKIN,
     M     SETHER, SELATN, SEPOTW,
     M     DEKVIS, DEKNLV, DPWFAL,
     B     DENS0 , TPOT0 , TEMP0 , PPAI0 , QVAP0 , ZGRID,
     C     G     , CPDRY , RMVAP , ALATNT,
     G     DX    , FDZ   , FDZM  ,
     D     NX    , NZ    , NXB   , NZB   ,  NROT   )
C
C*********************************************************************
      IMPLICIT REAL*8 ( A-H, O-Z )
C*********************************************************************
C
      DIMENSION
     \   U    ( -2:NXB, -2:NZB, NROT ),
     \   V    ( -2:NXB, -2:NZB, NROT ),
     \   W    ( -2:NXB, -2:NZB, NROT ),
     \   PPAI ( -2:NXB, -2:NZB, NROT ),
     \   TPOT ( -2:NXB, -2:NZB, NROT ),
     \   QVAP ( -2:NXB, -2:NZB, NROT ),
     \   QCLW ( -2:NXB, -2:NZB, NROT ),
     \   QRAI ( -2:NXB, -2:NZB, NROT )
C
      DIMENSION
     \   AXU    ( -2:NZB ), AXV    ( -2:NZB ), AXW    ( -2:NZB ),
     \   AXTPOT ( -2:NZB ), AXMSE  ( -2:NZB ),
     \   AXQVAP ( -2:NZB ), AXQCLW ( -2:NZB ), AXQRAI ( -2:NZB )
C
      DIMENSION
     \   DENS0 ( -2:NZB ), TPOT0 ( -2:NZB ), TEMP0 ( -2:NZB ),
     \   PPAI0 ( -2:NZB ), QVAP0 ( -2:NZB ), ZGRID ( -2:NZB )
C
      DIMENSION
     \   FDZ ( -2:NZB ), FDZM ( -2:NZB )
C
C=====================================================================
C
      IF ( TIME .EQ. 0.0D0 ) THEN
         TIOLD = 0.0D0
      CTHKIN = 0.0D0
      CLATHR = 0.0D0
      CPWKIN = 0.0D0
      DEKVIS = 0.0D0
      DEKNLV = 0.0D0
      DPWFAL = 0.0D0
      SETHER = 0.0D0
      SELATN = 0.0D0
      SEPOTW = 0.0D0
      END IF
C
C----------------------------------------------------------------------
C     Horizontal averages of prognostic variables.
C----------------------------------------------------------------------
C
      DO 11 IZ = 0, NZ
C
         AXU   (IZ) = 0.0
         AXV   (IZ) = 0.0
         AXW   (IZ) = 0.0
         AXTPOT(IZ) = 0.0
         AXQVAP(IZ) = 0.0
         AXQCLW(IZ) = 0.0
         AXQRAI(IZ) = 0.0
         AXMSE (IZ) = 0.0
C
         DO 12 IX = 1, NX
            AXU   (IZ) = AXU   (IZ) + U   (IX,IZ,ICL)
            AXV   (IZ) = AXV   (IZ) + V   (IX,IZ,ICL)
            AXW   (IZ) = AXW   (IZ) + W   (IX,IZ,ICL)
            AXTPOT(IZ) = AXTPOT(IZ) + TPOT(IX,IZ,ICL)
            AXQVAP(IZ) = AXQVAP(IZ) + QVAP(IX,IZ,ICL)
            AXQCLW(IZ) = AXQCLW(IZ) + QCLW(IX,IZ,ICL)
            AXQRAI(IZ) = AXQRAI(IZ) + QRAI(IX,IZ,ICL)
   12    CONTINUE
C
         AXU   (IZ) = AXU   (IZ) / DBLE(NX)
         AXV   (IZ) = AXV   (IZ) / DBLE(NX)
         AXW   (IZ) = AXW   (IZ) / DBLE(NX)
         AXTPOT(IZ) = AXTPOT(IZ) / DBLE(NX)
         AXQVAP(IZ) = AXQVAP(IZ) / DBLE(NX)
         AXQCLW(IZ) = AXQCLW(IZ) / DBLE(NX)
         AXQRAI(IZ) = AXQRAI(IZ) / DBLE(NX)
C
   11 CONTINUE
C
      WRITE(6,*)'--------------- HORIZONTAL MEAN ---------------------'
      WRITE(6,*)'TIME=',TIME
      WRITE(6,*)
     \  '    U       V       W       TPOT    QVAP    QCLW    QRAI'
      DO 15 IZ = 0, NZ-1
         WRITE(6,601) IZ, AXU(IZ), AXV(IZ), AXW(IZ), AXTPOT(IZ),
     \              AXQVAP(IZ), AXQCLW(IZ), AXQRAI(IZ)
  601 FORMAT(I4,7E15.7)
   15 CONTINUE
C
C---------------------------------------------------------------------
C     Thermal energy ( Enthalpy ).
C---------------------------------------------------------------------
C
      ETHERM= 0.0D0
C
      DO 21 IZ = 0, NZ-1
         ETHERM = ETHERM +
     \      CPDRY * FDZ(IZ) * DX**2 * DENS0(IZ)
     \    * NX    * AXTPOT(IZ) * PPAI0(IZ)
   21 CONTINUE
C
C---------------------------------------------------------------------
C     Latent energy
C---------------------------------------------------------------------
C
      ELATNT = 0.0D0
C
      DO 22 IZ = 0, NZ-1
         ELATNT = ELATNT +
     \      ALATNT * FDZ(IZ) * DX**2 * DENS0(IZ) * AXQVAP(IZ) * NX
   22 CONTINUE
C
C---------------------------------------------------------------------
C     Potential energy of water substances.
C---------------------------------------------------------------------
C
      ZREF = 3.0D+4
C
      EPOTW  = 0.0D0
C
      DO 23 IZ = 0, NZ-1
         EPOTW  = EPOTW  +
     \      FDZ(IZ) * DX**2 * DENS0(IZ) * G * ( ZGRID(IZ) - ZREF )
     \    * ( - (1.0D0/RMVAP - 1.0D0 ) * AXQVAP(IZ) )
         DO 231 IX = 1, NX
            EPOTW = EPOTW +
     \        FDZ(IZ) * DX**2 * DENS0(IZ) * G *  ZGRID(IZ)
     \      * (   MAX ( 0.0D0, QCLW(IX,IZ,ICL) )
     \          + MAX ( 0.0D0, QRAI(IX,IZ,ICL) )  )
  231    CONTINUE
   23 CONTINUE
C
C---------------------------------------------------------------------
C     Kinetic energy
C---------------------------------------------------------------------
C
      EKINET= 0.0D0
C
      DO 31 IZ = 0, NZ-1
      DO 31 IX = 1, NX
         EKINET = EKINET
     \    +   DENS0(IZ)
     \      * FDZ(IZ) * DX**2
     \      * ( U(IX,IZ,ICL) ** 2 + V(IX,IZ,ICL) ** 2 ) / 2.0D0
   31 CONTINUE
C
      DO 32 IZ = 1, NZ-1
      DO 32 IX = 1, NX
         EKINET = EKINET
     \    +   ( DENS0(IZ-1) + DENS0(IZ) ) / 2.0D0
     \      * FDZM(IZ) * DX**2
     \      * W(IX,IZ,ICL) ** 2 / 2.0D0
   32 CONTINUE
C
C---------------------------------------------------------------------
C     Total energy
C---------------------------------------------------------------------
C
      ETOTAL = ETHERM + EKINET + ELATNT + EPOTW
C
C---------------------------------------------------------------------
C
      WRITE(6,*) '------------- Volume integral of energy -----------'
C
      WRITE(6,*) 'Thermal energy                      =', ETHERM
      WRITE(6,*) 'Kinetic energy                      =', EKINET
      WRITE(6,*) 'Latent energy                       =', ELATNT
      WRITE(6,*) 'Potential energy of water substance =', EPOTW
      WRITE(6,*) 'Total energy                        =', ETOTAL
C
C---------------------------------------------------------------------
C
      WRITE(6,*) '----- Volume integral of energy transfer terms -----'
      WRITE(6,*) 'from T=',TIOLD,'to T=', TIME
C
      WRITE(6,*) 'Thermal to Kinetic                  =', CTHKIN
      WRITE(6,*) 'Latent  to Thermal                  =', CLATHR
      WRITE(6,*) 'Potential ( water ) to Kinetic      =', CPWKIN
C
      WRITE(6,*) '----- Volume integral of energy source terms -------'
      WRITE(6,*) 'from T=',TIOLD,'to T=', TIME
C
      WRITE(6,*) 'Viscous dissipation                 =', DEKVIS
      WRITE(6,*) 'Dissipation via numerical viscosity =', DEKNLV
      WRITE(6,*) 'Dissipation via falling of rain     =', DPWFAL
      WRITE(6,*) 'External source of thermal energy   =', SETHER
      WRITE(6,*) 'External source of latent energy    =', SELATN
      WRITE(6,*) 'Ext.& Int. sources of pot.ener.water=', SEPOTW
C
C---------------------------------------------------------------------
C
      TIOLD = TIME
C
      CTHKIN = 0.0D0
      CLATHR = 0.0D0
      CPWKIN = 0.0D0
      DEKVIS = 0.0D0
      DEKNLV = 0.0D0
      DPWFAL = 0.0D0
      SETHER = 0.0D0
      SELATN = 0.0D0
      SEPOTW = 0.0D0
C
C=====================================================================
C
      RETURN
      END
