C*********************************************************************
C     SUBROUTINE CLRAD
C
C     $BF|JQ2=7W;;MQ(B
C
C     $BMzNr(B  1999/02/02  $B>.9b@5;L(B
C
C*********************************************************************
C
      SUBROUTINE CLRAD2
     I   ( TPOT,
     I     ICRAD, TIME,
     O     DTPRAD,
     W     TPMEAN, ALMEAN, ALDEVI, COOLZ,
     B     TPOT0, TEMP0, ZGRID,
     D     NX, NZ, NXB, NZB, NROT  )
C
C*********************************************************************
      IMPLICIT REAL*8 ( A-H, O-Z )
C*********************************************************************
C
      DIMENSION
     \   TPOT  ( -2:NXB, -2:NZB, NROT ),
     \   DTPRAD( -2:NXB, -2:NZB )
C
      DIMENSION
     \   TPOT0 ( -2:NZB ), TEMP0( -2:NZB ), ZGRID( -2:NZB )
C
      DIMENSION
     \   ALMEAN ( -2:NZB ), ALDEVI ( -2:NZB ),
     \   TPMEAN ( -2:NZB ), COOLZ  ( -2:NZB )
C
C=====================================================================
C
C *** TIME DEPENDENT BODY HEATING/COOLING ***
C
C
      PI = 3.141592D0

      DO 11 IZ = 0, NZ-1

         if ( zgrid(iz) .lt. 5000.0d0 ) then
            clz = -1.0d0
         else
            clz = 0.0d0
         end if

         COOLZ(iz)  = clz * ( 1.0D+2 * exp( -zgrid(iz) / 200.0d0 ) 
     \                        + 10.0d0 )
     \                    * sin( 2.0d0 * PI * TIME / 8.64d+4 )
     \                    * ( TPOT0(IZ) / TEMP0(IZ) ) / 8.64D+4

c         COOLZ(iz)  = clz * ( TPOT0(IZ) / TEMP0(IZ) ) / 8.64D+4

   11 CONTINUE
C
C *** NEWTONIAN COOLING ( HORIZONTALLY HOMOGENEOUS PART ) ***
C
      ALPHA = 0.0D0
C
      DO 12 IZ = 0, NZ-1
         ALMEAN(IZ) = ALPHA / 8.64D+4
   12 CONTINUE
C
C *** NEWTONIAN COOLING ( FOR WAVE DAMPING IN THE UPPER LAYER ) ***
C
      ALDAMP = 1.0D+2
      ZC3 = 15000.
      ZC4 = 17500.
C
      DO 13 IZ = 0, NZ-1
         ALDEVI(IZ) = ALDAMP / 8.64D+4
     \     * MAX( 0.0D0 , MIN( 1.0D0 ,
     \         ( ( ZGRID(IZ) - ZC3 ) / ( ZC4 - ZC3 ) )   ))
   13 CONTINUE
C
C--------------------------------------------------------------------
C
      DO 21 IZ = 0, NZ-1
         TPMEAN(IZ) = 0.0
         DO 22 IX = 1, NX
            TPMEAN(IZ) = TPMEAN(IZ) + TPOT(IX,IZ,ICRAD)
   22    CONTINUE
         TPMEAN(IZ) = TPMEAN(IZ) / NX
   21 CONTINUE
C
C
      DO 31 IZ = 0, NZ-1
      DO 31 IX = 1, NX
        DTPRAD(IX,IZ)
     \  =  - COOLZ (IZ)
     \     - ALMEAN(IZ) * TPMEAN(IZ)
     \     - ALDEVI(IZ) * ( TPOT(IX,IZ,ICRAD) - TPMEAN(IZ) )
   31 CONTINUE
C
C
      CALL BOUND ( DTPRAD, NX, NZ, NXB, NZB, 1, 1, 1, 1 )
C
C=====================================================================
C
      RETURN
      E N D
