!=========================================================================
! Bulk Richardson number Calculation Subroutine
!
! History 1998/07/13  Masatsugu Odaka
!         1999/01/20  Masatsugu Odaka
!=========================================================================

      SUBROUTINE CLRICH
     I   ( TPOT, TPOT0,  U  , V  , URMIN,
     I     ICL, 
     C     GRAV, TSFC , HIGHT,
     O     RICHD,
     D     NX, NXB, NZB, NROT )

!*************************************************************************
      IMPLICIT REAL*8 ( A-H, O-Z )
!*************************************************************************

      DIMENSION
     \     U   ( -2:NXB, -2:NZB, NROT ),
     \     V   ( -2:NXB, -2:NZB, NROT ),
     \     TPOT( -2:NXB, -2:NZB, NROT )
      
      DIMENSION
     \     TPOT0( -2:NZB )

      DIMENSION
     \     TSFC ( -2:NXB ),
     \     RICHD( -2:NXB )

!*************************************************************************
! Initiallization
!*************************************************************************

      DO IX = 0, NX
         RICHD ( IX ) = 0.0D0
      END DO

!*************************************************************************
! Calculation of Horizontally Averaged Potential Temperature
!*************************************************************************

      TPOTM = 0.0D0
      
      DO IX = 0, NX
         TPOTM = TPOTM + TPOT( IX, 0, ICL )
      END DO
      
      TPOTM = TPOTM / NX + TPOT0( 0 )

!*************************************************************************
! Calculation of Bulk Richardson Number
!*************************************************************************

      DO IX = 0, NX
         UABS = U( IX, 0, ICL )**2 + V( IX, 0, ICL )**2

         RICHD( IX ) = GRAV * HIGHT * 
     \        ( TPOT( IX, 0, ICL ) + TPOT0( 0 ) - TSFC( IX ) )
     \        / TPOTM / MAX( UABS, URMIN )
      END DO

      RETURN
      END 
